/*	FILE:		FGETSS.C
 *	DATE WRITTEN:	 6-Sep-85	BY: SRMc
 *	DATE MODIFIED:	14-Feb-86	BY: SRMc - reformat & edit comments
 *			24-Feb-87	    SRMc - remove call to index()
 *
 *	FUNCTIONS:		fgetss
 */
#include <stdio.h>
extern char *fgets();

/************************************************************************
 * NAME
 *    fgetss
 * ARGUMENTS
 *    s      - pointer to input buffer
 *    n      - size of input buffer
 *    stream - input FILE pointer
 * DESCRIPTION
 *    Get a line from a stream, removing the trailing newline.  This is
 *    just like fgets(), except it treats newlines the same as gets().
 *    (This is a DECUS C function.)
 * RETURN VALUE
 *    pointer to the input buffer (original value of `s') if valid input
 *    NULL if input is not valid (EOF, etc)
 */
char *fgetss(s, n, stream)
char *s;
int n;
FILE *stream;
{
register char *p;

if (fgets(s, n, stream) != NULL)
    {
    for (p = s ; *p != '\0' ; ++p)
	{
	if (*p == '\n')
	    {
	    *p = '\0';		/* remove trailing newline */
	    break;
	    }
	}
    return(s);
    }
else
    return(NULL);
}
