/* RSTCMP.C
 *	 4-Sep-86	SRMc
 *	31-Mar-87	SRMc - reformat for consistency
 *	17-Jan-91	SRMc - use <strings.h>/<string.h>
 *
 *	FUNCTIONS:	rstcmp - as developed for CADA
 */
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifndef NULL
#define NULL (char *)0
#endif
#define NUL '\0'
#ifndef TRUE
#define TRUE (1)
#define FALSE (0)
#endif

#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif

int rstcmp P((char *s, char *t));
#undef P

/************************************************************************
 * NAME
 *    rstcmp
 * ARGUMENTS
 *    s - pointer to the first string
 *    t - pointer to the second string
 * DESCRIPTION
 *    Compare the second string against the end of the first string
 * RETURN VALUE
 *    nonzero if the second string matches the end of the first string,
 *    zero otherwise
 */
int rstcmp(s,t)
char *s, *t;
{
register char *s1, *t1;

if ((t == NULL) || (*t == NUL))
    return(TRUE);		/* null string matches any string */
if ((s == NULL) || (*s == NUL))
    return(FALSE);		/* nothing else matches a null string */
s1 = s + strlen(s);
t1 = t + strlen(t);
while ((s1 > s) && (t1 > t))
    {
    if (*--s1 != *--t1)
	return(FALSE);
    }
return(t1 == t);
}
