;;
;;
;;      Title : mksp  
;;
;;      Function : UNIX level command to compile a set of spelling rules
;;
;;      Author :  Alan W Black  November 1985
;;                Dept of Artificial Intelligence
;;                University of Edinburgh
;;
;;      Copyright Graeme Ritchie, Alan Black,
;;                Steve Pulman and Graham Russell  1987
;;
;;         ---------------------------------------------
;;         |    Not to be used for military purposes   |
;;         ---------------------------------------------
;;
;;      Description :
;;         This is designed as a UNIX level command, although written
;;         in lisp the user should be unaware of that fact.  For
;;         details of use see the the laatest version of the user document
;;         "Dictionary and Morphological Analyser"  or type
;;            man mksp  
;;
;;         This command has the same basic function as the the lisp
;;         function D-MakeSpRules
;;         
;;
;;      Parameters :
;;         filename:  the filename (without .sp extension) containing
;;             the spelling rules description
;;      Returns :
;;             0 if all ok
;;             1 if error found
;;      Side Effect :
;;             writes the file  <filename>.sp.ma
;;
;;      External references :
;;
;;      System functions used :
;;        Name     type      Args #  type                 Comment
;;
;;      Restrictions :
;;        For version 38.75 of Franz (for vax) you have to change the quoting
;;        of "usemap" to 'usemap
;;
;;

(declare
   (special
      $ldprint
      rcode)
)

(princ "Loading spelling rule compiler")
(terpri)

(include "keywords")

(let ( (usemap (assoc (DK-USEMAP) environment)) )
   (cond
      ((null usemap)   ;;  usemap variable not set
	 nil
      )
      (t               ;; add usemap to search path
         (eval (list 'sstatus 'load-search-path
                   (append
	              (list (cdr usemap))
	              (status load-search-path))))
      )
   )
)
(include "maload.l")  
(defun top-level ()
(setq $ldprint nil)   ;; no loading info
(sstatus translink on)   
(allocate 'list 1000)
(allocate 'symbol 200)
(allocate 'fixnum 50)
   (setq rcode
   (errset
      (let ()
         (cond
            ((eq (argv -1) 4)  ;; if one param is given its the name of the file
	       (d-maloadcomp)  ;; load the compiler and initialise
	       (princ "Starting compilation of ")
	       (princ (argv 3))
	       (terpri)
               (D-MakeSpRules (argv 3))
	       0                      ;; return code
            )
            (t                ;; zero or more than 1 param then wrong number of
                              ;; params             
               (princ "mksp: error: should be only one parameter")
               (terpri)
        (princ "usage:  mksp <name>  where <name>.sp is the spelling rule file")
               (terpri)
               1                ;; exit with error code 
            )
         )
      )
   ))
   (cond
      ((equal (car rcode) 0)
         (exit)             ;; exit with 0 retrun code
      )
      (t                    ;; must have been some error
         (exit 1)
      )
   )
)

(reset)
