
; FILE:       /u2/thnet/data/arcs/fables70
; PURPOSE:    test retrieval using fables (numbers 64-73)
; PROGRAMMER: Greg Nelson
; CREATED:    7-23-88
; UPDATED:    

(defun lfa70 () (load "//tinman/ucla/psych/emelz/ARCS/fables70"))
(defun makeloaded nil
  (defvar structures_loaded nil "Keep a list of all of the make_strucs done."))
(setq structures_loaded (append structures_loaded '(fable64 fable65 fable66 fable67 fable68 fable69 fable70 fable71 fable72 fable73)))

; FABLE 64:  How the Tortoise Got Its Shell
; COMMENTS:  A little like #41, about the city mouse and the country mouse

(defun make_fable64 nil
  (make_struc 'fable64 'fable
	    '(story ((god (obj-zeus) true f64-1)
		     (marry (obj-zeus obj-wife) true f64-2)
		     (celebrate (obj-zeus f64-2) true f64-3)
		     (feast (obj-feast) true f64-4)
		     (cause (f64-3 f64-4) true f64-5)
		     (animals (obj-animals) true f64-6)
		     (tortoise (obj-tortoise) true f64-7)
		     (partake-of (obj-animals obj-feast) true f64-8)
		     (present-at (obj-tortoise obj-feast) false f64-9)
		     (ask-why (obj-zeus obj-tortoise f64-9) true f64-10)
		     (home-of (obj-home obj-tortoise) true f64-11)
		     (prefer (obj-tortoise obj-home obj-feast) true f64-12)
		     (say-to (obj-tortoise f64-12 obj-zeus) true f64-13)
		     (anger (f64-13 obj-zeus) true f64-14)
		     (decree-that (obj-zeus (f64-16 true)) true f64-15)
		     (carry (obj-tortoise obj-home) true f64-16)
		     (cause (f64-14 f64-15) true f64-17)
		     (conjoin-event (f64-1 f64-15) true f64-18)
		     (cause (f64-18 f64-16) true f64-19)
		    )
	     )
	    '(moral ((man (obj-man) true m64-1)
		     (home-of (obj-home obj-man) true m64-2)
		     (food (obj-plain-food) true m64-3)
		     (plain (obj-plain-food) true m64-4)
		     (home-of (obj-others-home obj-others) true m64-5)
		     (food (obj-fancy-food) true m64-6)
		     (fancy (obj-fancy-food) true m64-7)
		     (prefer (obj-man obj-home obj-others-home) true m64-8)
		     (prefer (obj-man obj-plain-food obj-fancy-food) true m64-9)
		     (cause (m64-8 m64-9) true m64-10)
		     (occurs-often (m64-8) true m64-11)
		    )
             )
))

; FABLE 65:  A Waste Of Good Counsel

(defun make_fable65 nil
  (make_struc 'fable65 'fable
	    '(story ((tortoise (obj-tortoise) true f65-1)
		     (eagle (obj-eagle) true f65-2)
		     (request (obj-tortoise (f65-8 true) obj-eagle) true f65-3)
		     (impossible ((f65-12 true)) true f65-4)
		     (tell (obj-eagle obj-tortoise f65-4) true f65-5)
		     (continue (f65-3) true f65-6)
		     (even-though (f65-5 f65-6) true f65-7)
		     (teach-how (obj-eagle obj-tortoise (f65-12 true)) false f65-8)
		     (lift-up (obj-eagle obj-tortoise) true f65-9)
		     (fly (obj-eagle) true f65-10)
		     (drop (obj-eagle obj-tortoise) true f65-11)
		     (fly (obj-tortoise) false f65-12)
		     (cause (f65-8 f65-12) true f65-13)
		     (cause (f65-4 f65-8) true f65-14)
		     (fall (obj-tortoise) true f65-15)
		     (die (obj-tortoise) true f65-16)
		     (conjoin-event (f65-11 f65-12) true f65-17)
		     (cause (f65-17 f65-15) true f65-18)
		     (cause (f65-15 f65-16) true f65-19)
		    )
	     )
	    '(moral ((rivalry (conc-rivalry) true m65-1)
		     (men (obj-men) true m65-2)
		     (wiser (obj-wiser obj-men) true m65-3)
		     (advice (conc-advice) true m65-4)
		     (give-to (obj-wiser conc-advice obj-men) true m65-5)
		     (disregard (obj-men conc-advice) true m65-6)
		     (cause (m65-1 m65-6) true m65-7)
		     (die (obj-men) true m65-8)
		     (cause (m65-6 m65-8) true m65-9)
		    )
             )
))

; FABLE 66:  Slow But Sure (or, The Tortoise and The Hare)

(defun make_fable66 nil
  (make_struc 'fable66 'fable
	    '(story ((tortoise (obj-tortoise) true f66-1)
		     (hare (obj-hare) true f66-2)
		     (swifter (obj-hare obj-tortoise) true f66-3)
		     (argue-about (obj-hare obj-tortoise f66-3) true f66-4)
		     (race (obj-race) true f66-5)
		     (participate-in (obj-hare obj-race) true f66-6)
		     (participate-in (obj-tortoise obj-race) true f66-7)
		     (sleep (obj-hare) true f66-8)
		     (cause (f66-3 f66-8) true f66-9)
		     (win (obj-tortoise obj-race) true f66-10)
		     (cause (f66-8 f66-10) true f66-11)
		    )
	     )
	    '(moral ((man (obj-man) true m66-1)
		     (gifted (obj-man) true m66-2)
		     (gifted (obj-plodder) false m66-3)
		     (task (obj-task) true m66-4)
		     (ignore (obj-man obj-task) true m66-5)
		     (ignore (obj-plodder obj-task) false m66-6)
		     (accomplish (obj-plodder obj-task) true m66-7)
		     (cause (m66-6 m66-7) true m66-8)
		     (occur-often (m66-7) true m66-9)
		    )
             )
))

; FABLE 67:  The Reward of the Wicked
; COMMENTS:  Some details had to be sacrificed.  This really shows how much
;            information is contained in even a short story like this.  Think,
;            for example, of the obvious fact that the eagle's nest is high
;            up, and that A FOX CAN'T FLY.  I'm sure I've never thought that
;            particular thought before, but somehow I am sure of it.  There
;            are all kinds of things like that that the story expects us to
;            deduce.

(defun make_fable67 nil
  (make_struc 'fable67 'fable
	    '(story ((eagle (obj-eagle) true f67-1)
		     (vixen (obj-vixen) true f67-2)
		     (friends (obj-eagle obj-vixen) true f67-3)
		     (cubs (obj-cubs) true f67-4)
		     (children-of (obj-cubs obj-vixen) true f67-5)
		     (eaglets (obj-eaglets) true f67-6)
		     (children-of (obj-eaglets obj-eaglet) true f67-7)
		     (hungry (obj-eagle) true f67-8)
		     (eat (obj-eagle obj-cubs) true f67-9)
		     (punish-for (obj-vixen obj-eagle f67-9) false f67-10)
		     (desire (obj-vixen (f67-10 true)) true f67-11)
		     (impossible ((f67-10 true)) true f67-12)
		     (goat (obj-goat) true f67-13)
		     (burning (obj-goat) true f67-14)
		     (steal (obj-eagle obj-goat) true f67-15)
		     (nest (obj-nest) true f67-16)
		     (burn (obj-nest) true f67-17)
		     (fall-from (obj-eaglets obj-nest) true f67-18)
		     (eat (obj-vixen obj-eaglets) true f67-19)
		     (avenge (obj-vixen f67-9) true f67-20)
		     (cause (f67-14 f67-17) true f67-21)
		     (cause (f67-17 f67-18) true f67-22)
		     (cause (f67-18 f67-19) true f67-23)
		     (cause (f67-19 f67-20) true f67-24)
		     (cause (f67-9 f67-11) true f67-25)
		    )
	     )
	    '(moral ((friends (obj-breaker obj-wronged) true m67-1)
		     (wrong (obj-breaker obj-wronged) true m67-2)
		     (avenge (obj-wronged m67-2) unknown m67-3)
		     (powerless (obj-wronged) true m67-4)
		     (cause (m67-4 m67-3) true m67-5)
		     (desire (obj-wronged (m67-3 true)) true m67-6)
		     (heaven (obj-heaven) true m67-7)
		     (avenge (obj-heaven m67-2) true m67-8)
		     (become-true (m67-3) true m67-9)
		     (cause (m67-8 m67-9) true m67-10)
		     (even-though (m67-4 m67-9) true m67-11)
		    )
             )
))

; FABLE 68:  Repayment in Kind
; COMMENTS:  Aww... That's a NICE story.  No moral written.

(defun make_fable68 nil
  (make_struc 'fable68 'fable
	    '(story ((farmer (obj-farmer) true f68-1)
		     (eagle (obj-eagle) true f68-2)
		     (snare (obj-snare) true f68-3)
		     (caught-in (obj-eagle obj-snare) true f68-4)
		     (beautiful (obj-eagle) true f68-5)
		     (release-from (obj-farmer obj-eagle obj-snare) true f68-6)
		     (cause (f68-5 f68-6) true f68-7)
		     (wall (obj-wall) true f68-8)
		     (crumbling (obj-wall) true f68-9)
		     (headband (obj-headband) true f68-10)
		     (wear (obj-farmer obj-headband) true f68-11)
		     (snatch-from (obj-eagle obj-headband obj-farmer) true f68-12)
		     (pursue (obj-farmer obj-eagle) true f68-13)
		     (drop (obj-eagle obj-headband) true f68-14)
		     (pick-up (obj-farmer obj-headband) true f68-15)
		     (go-to (obj-farmer obj-wall) true f68-16)
		     (collapsed (obj-wall) true f68-17)
		     (see (obj-farmer f68-17) true f68-18)
		     (alive (obj-farmer) true f68-19)
		     (cause (f68-12 f68-13) true f68-20)
		     (cause (f68-13 f68-19) true f68-21)
		     (cause (f68-9 f68-12) true f68-22)
		    )
	     )
))

; FABLE 69:  The Jackdaw Who Would Be An Eagle

(defun make_fable69 nil
  (make_struc 'fable69 'fable
	    '(story ((eagle (obj-eagle) true f69-1)
		     (lamb (obj-lamb) true f69-2)
		     (jackdaw (obj-jackdaw) true f69-3)
		     (seize (obj-eagle obj-lamb) true f69-4)
		     (envy (obj-jackdaw obj-eagle) true f69-5)
		     (cause (f69-4 f69-5) true f69-6)
		     (ram (obj-ram) true f69-7)
		     (attempt-to (obj-jackdaw (f69-9 true)) true f69-8)
		     (pick-up (obj-jackdaw obj-ram) false f69-9)
		     (fleece-of (obj-fleece obj-ram) true f69-10)
		     (caught-in (obj-jackdaw obj-fleece) true f69-11)
		     (shepherd (obj-shepherd) true f69-12)
		     (catch (obj-shepherd obj-jackdaw) true f69-13)
		     (maim (obj-shepherd obj-jackdaw) true f69-14)
		     (laugh-at (obj-shepherd obj-jackdaw) true f69-15)
		     (cause (f69-8 f69-11) true f69-16)
		     (cause (f69-11 f69-13) true f69-17)
		    )
	     )
	    '(moral ((stronger (obj-stronger obj-you) true m69-1)
		     (compete-with (obj-you obj-stronger) unknown m69-2)
		     (efforts (conc-efforts) true m69-3)
		     (waste (obj-you conc-efforts) unknown m69-4)
		     (laugh-at (obj-others obj-you) unknown m69-5)
		     (if ((m69-2 true) (m69-4 true)) true m69-6)
		     (if ((m69-2 true) (m69-5 true)) true m69-7)
		    )
             )
))

; FABLE 70:  Hope Deferred
; COMMENTS:  What a silly title...  There is no moral to this story, unless
;            we take what the fox says to be such.

(defun make_fable70 nil
  (make_struc 'fable70 'fable
	    '(story ((jackdaw (obj-jackdaw) true f70-1)
		     (tree (obj-tree) true f70-2)
		     (figs (obj-figs) true f70-3)
		     (produce (obj-tree obj-figs) true f70-4)
		     (ripe (obj-figs) false f70-5)
		     (wait-until (obj-jackdaw (f70-5 true)) true f70-6)
		     (fox (obj-fox) true f70-7)
		     (see (obj-fox f70-6) true f70-8)
		     (hope (conc-hope) true f70-9)
		     (engross (conc-hope obj-jackdaw) true f70-10)
		     (mistake (f70-10) true f70-11)
		     (say-to (obj-fox f70-11 obj-jackdaw) true f70-12)
		     (delude (conc-hope obj-jackdaw) true f70-13)
		     (say-to (obj-fox f70-13 obj-jackdaw) true f70-14)
		     (feed (conc-hope obj-jackdaw) false f70-15)
		     (say-to (obj-fox f70-15 obj-jackdaw) true f70-16)
		    )
	     )
))

; FABLE 71:  Getting the Worst of Both Worlds

(defun make_fable71 nil
  (make_struc 'fable71 'fable
	    '(story ((jackdaw (obj-jackdaw) true f71-1)
		     (jackdaws (obj-other-jackdaws) true f71-2)
		     (bigger (obj-jackdaw obj-other-jackdaws) true f71-3)
		     (crows (obj-crows) true f71-4)
		     (join (obj-jackdaw obj-crows) unknown f71-5)
		     (request-of (obj-jackdaw (f71-5 true) obj-crows) true f71-6)
		     (crow (obj-jackdaw) false f71-7)
		     (dislike (obj-crows obj-jackdaw) true f71-8)
		     (cause (f71-7 f71-8) true f71-9)
		     (reject (obj-crows obj-jackdaw) true f71-10)
		     (cause (f71-8 f71-10) true f71-11)
		     (become-false (f71-5) true f71-12)
		     (cause (f71-10 f71-12) true f71-13)
		     (rejoin (obj-jackdaw obj-other-jackdaws) false f71-14)
		     (dislike (obj-other-jackdaws obj-jackdaw) true f71-15)
		     (cause (f71-15 f71-14) true f71-16)
		     (cause (f71-6 f71-15) true f71-17)
		    )
	     )
	    '(moral ((men (obj-men) true m71-1)
		     (country-of (obj-country obj-men) true m71-2)
		     (country (obj-other-country) true m71-3)
		     (prefer (obj-men obj-other-country obj-country) true m71-4)
		     (leave (obj-men obj-country) true m71-5)
		     (cause (m71-4 m71-5) true m71-6)
		     (foreign-to (obj-men obj-other-country) true m71-7)
		     (honor (conc-honor) true m71-8)
		     (have (obj-men obj-honor) false m71-9)
		     (cause (m71-7 m71-9) true m71-10)
		     (country-of (obj-country obj-countrymen) true m71-11)
		     (dislike (obj-countrymen obj-men) true m71-12)
		     (cause (m71-4 m71-12) true m71-13)
		    )
             )
))

; FABLE 72:  Borrowed Plumes
; COMMENTS:  Although it is not explicitly stated, one might conclude that
;            Zeus never nominates anyone as king... I'll leave this out, though

(defun make_fable72 nil
  (make_struc 'fable72 'fable
	    '(story ((god (obj-zeus) true f72-1)
		     (birds (obj-birds) true f72-2)
		     (desire (obj-zeus (f72-20 true)) true f72-3)
		     (jackdaw (obj-jackdaw) true f72-4)
		     (river (obj-river) true f72-5)
		     (clean-in (obj-birds obj-birds obj-river) true f72-6)
		     (feathers (obj-feathers) true f72-7)
		     (lose (obj-birds obj-feathers) true f72-8)
		     (collect (obj-jackdaw obj-feathers) true f72-9)
		     (fasten-to (obj-jackdaw obj-feathers obj-jackdaw) true f72-10)
		     (beautiful (obj-jackdaw) true f72-11)
		     (cause (f72-10 f72-11) true f72-12)
		     (throne (obj-throne) true f72-13)
		     (give-to (obj-zeus obj-throne obj-jackdaw) false f72-14)
		     (almost ((f72-14 true)) true f72-15)
		     (take-from (obj-birds obj-feathers obj-jackdaw) true f72-16)
		     (see (obj-zeus f72-16) true f72-17)
		     (cause (f72-17 f72-14) true f72-18)
		    )
	     )
	    '(moral ((men (obj-men) true m72-1)
		     (debtors (obj-men) true m72-2)
		     (rich (obj-men) false m72-3)
		     (appear-that ((m72-3 true)) true m72-4)
		     (creditors (obj-creditors) true m72-5)
		     (pay (obj-men obj-creditors) unknown m72-6)
		     (end (m72-4) unknown m72-7)
		     (if ((m72-6 true) (m72-7 true)) true m72-8)
		    )
             )
))

; FABLE 73:  A Bird In The Hand II [The Sequel]
; UGH!  This says:   If the hawk chases other prey, he will lose the
; nightingale, and the combination of this fact with the fact that he does
; not see other prey causes him not to chase other prey.  Very circular,
; but very human....

(defun make_fable73 nil
  (make_struc 'fable73 'fable
	    '(story ((nightingale (obj-night) true f73-1)
		     (hawk (obj-hawk) true f73-2)
		     (bird (obj-bigger) true f73-3)
		     (catch (obj-hawk obj-night) true f73-4)
		     (bigger (obj-bigger obj-night) true f73-5)
		     (chase (obj-hawk obj-bigger) unknown f73-6)
		     (tell-to-do (obj-night obj-hawk (f73-6 true)) true f73-7)
		     (lose (obj-hawk obj-night) unknown f73-8)
		     (see (obj-hawk obj-bigger) false f73-9)
		     (if ((f73-6 true) (f73-8 true)) true f73-10)
		     (conjoin-event (f73-9 f73-10) true f73-11)
		     (become-false (f73-6) true f73-12)
		     (cause (f73-11 f73-12) true f73-13)
		    )
	     )
	    '(moral ((human (obj-human) true m73-1)
		     (prize (obj-greater) true m73-2)
		     (greater (obj-greater obj-lesser) true m73-3)
		     (tempt (obj-greater obj-human m73-5) true m73-4)
		     (release (obj-human obj-lesser) unknown m73-5)
		     (senseless (obj-human) unknown m73-6)
		     (if ((m73-5 true) (m73-6 true)) true m73-7)
		    )
             )
))
