
/**********************************************************************
 *		   Copyright 1992 by Drew van Camp,
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for any  purpose  is hereby  granted without
 * fee, provided that the above copyright notice appears in all copies
 * and  that  both  the  copyright  notice and  this permission notice
 * appear in supporting  documentation, and that the  name of Drew van
 * Camp  not  be  used  in  advertising  or  publicity  pertaining  to
 * distribution  of  the  software  without  specific,  written  prior
 * permission.  Drew  van  Camp makes  no  representations  about  the
 * suitability  of this software for any  purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * DREW  VAN  CAMP  DISCLAIMS  ALL  WARRANTIES  WITH  REGARD  TO  THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF  MERCHANTABILITY  AND
 * FITNESS, IN NO EVENT SHALL DREW VAN CAMP BE LIABLE FOR ANY SPECIAL,
 * INDIRECT  OR   CONSEQUENTIAL  DAMAGES  OR  ANY  DAMAGES  WHATSOEVER
 * RESULTING FROM LOSS OF  USE, DATA  OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 **********************************************************************/

#ifndef __sim_h
#define __sim_h
/********************************************************************/

/********************************************************************
 * The network parameters
 ********************************************************************/
#define NUM_INPUT	4	/* number of input units  */
#define NUM_HIDDEN	3	/* number of hidden units */
#define NUM_OUTPUT	4	/* number of output units */
#define NUM_BIAS	1	/* number of bias units   */

#define STEP_SIZE	0.5	    /* step size for updating weights */
#define COST(x)		(0.001*(x)) /* cost of a weight */

/********************************************************************
 * Network data structures: Unit, Net
 ********************************************************************/
typedef struct Unit {
  double	input ;		/* total input */
  double	output ;	/* total output (input through fn)  */
  double	target ;	/* target output (for output units) */

  double	beta ;		/* error derivative (backpropagated)*/
} Unit ;
/********************************************************************/
typedef struct Net {
  Unit		input[NUM_INPUT] ;	/* layer of input units	 */
  Unit		hidden[NUM_HIDDEN] ;	/* layer of hidden units */
  Unit		output[NUM_OUTPUT] ;	/* layer of output units */
  Unit		bias[NUM_BIAS] ;	/* layer of bias units	 */
 
  /* Connections between layers (NOTE ORDER OF INDICES) */
  double	i2h[NUM_HIDDEN][NUM_INPUT] ;  /* input  -> hidden */
  double	h2o[NUM_OUTPUT][NUM_HIDDEN] ; /* hidden -> output */
  
  double	b2h[NUM_HIDDEN][NUM_BIAS] ;   /* bias -> hidden   */
  double	b2o[NUM_OUTPUT][NUM_BIAS] ;   /* bias -> output   */

  FILE		*fpPatterns ;	/* circular file of patterns */

  double	error ;		/* network error */
} Net ;
/********************************************************************/

/********************************************************************
 * Useful macros: sigmoid(Derivative), random, square
 ********************************************************************/
#define sigmoid(x)		(1.0 / (1.0 + exp(-(double)(x))))
#define sigmoidDerivative(x)	((double)(x)*(1.0 - (x)))
#define random(x)		((double)rand()/(RAND_MAX))
#define square(x)		((x)*(x))

/********************************************************************/
#endif				/* __sim_h */
