/************************************************************************
 *                                                                      *
 *      Copyright (c) 1992 Systems Engineering and Design Automation    *
 *      Laboratory (SEDAL), University of Sydney, Australia.            *
 *                                                                      *
 ************************************************************************/

#ifndef INCLUDE_PM2525
#define INCLUDE_PM2525


#ifndef TRUE
#define TRUE				1
#endif

#ifndef FALSE
#define FALSE				0
#endif

#define PM2525_PAUSE			"pause"
#define PM2525_SEPARATOR		'\n'



#define PM2525_GOTO_LOCAL		"\0331"
#define PM2525_GOTO_REMOTE		"\0332"
#define PM2525_GOTO_LOCAL_UNLOCK	"\0333"
#define PM2525_CLEAR_DEVICE		"\0334"
#define PM2525_LOCAL_LOCK		"\0335"


#define PM2525_SEPARATOR_LF		"SPR \012"
#define PM2525_SEPARATOR_LF_CR		"SPR \012,\015"

#define PM2525_ID			"ID ?"
#define PM2525_INTERFACE_TEST		"TSI \252"
#define PM2525_INTERFACE_TEST_SERVICE	"TSI U"

#define PM2525_FUNC_VOLT_DC		"FNC VDC"
#define PM2525_FUNC_VOLT_AC		"FNC VAC"
#define PM2525_FUNC_VOLT_RMS		"FNC VRM"
#define PM2525_FUNC_VOLT_PEAK_TO_PEAK	"FNC VPP"
#define PM2525_FUNC_VOLT_PEAK_POS	"FNC VPU"
#define PM2525_FUNC_VOLT_PEAK_NEG	"FNC VPL"
#define PM2525_FUNC_RES_2W		"FNC RTW"
#define PM2525_FUNC_RES_4W		"FNC RFW"
#define PM2525_FUNC_AMP_DC		"FNC IDC"
#define PM2525_FUNC_AMP_AC		"FNC IAC"
#define PM2525_FUNC_TEMP_CELCIUS	"FNC TDC"
#define PM2525_FUNC_CONTINUITY		"FNC CON"
#define PM2525_FUNC_DIODE		"FNC DIO"
#define PM2525_FUNC_CAPACITANCE		"FNC CAP"
#define PM2525_FUNC_FREQ		"FNC FRQ"
#define PM2525_FUNC_TRIG_POS_THEN_POS	"FNC TPP"
#define PM2525_FUNC_TRIG_POS_THEN_NEG	"FNC TPN"
#define PM2525_FUNC_TRIG_NEG_THEN_POS	"FNC TNP"
#define PM2525_FUNC_TRIG_NEG_THEN_NEG	"FNC TNN"
#define PM2525_FUNC_WHAT		"FNC ?"

#define PM2525_RANGE_AUTO		"RNG AUTO"
#define PM2525_RANGE			"RNG "
#define PM2525_RANGE_WHAT		"RNG ?"

#define PM2525_SPEED_LOW		"MSP 1"
#define PM2525_SPEED_MEDIUM		"MSP 2"
#define PM2525_SPEED_HIGH		"MSP 3"
#define PM2525_SPEED_WHAT		"MSP ?"

#define PM2525_RESOLUTION_4		"RSL 4"
#define PM2525_RESOLUTION_6		"RSL 6"
#define PM2525_RESOLUTION_WHAT		"RSL ?"

#define PM2525_ZERO_ON			"ZER ON"
#define PM2525_ZERO_OFF			"ZER OFF"
#define PM2525_ZERO_MEASURE		"ZER MEAS"
#define PM2525_ZERO_WHAT		"ZER ?"

#define PM2525_DB_ON			"DBM ON"
#define PM2525_DB_OFF			"DBM OFF"
#define PM2525_DB_WHAT			"DBM ?"

#define PM2525_REG_MIN			"MIN"
#define PM2525_REG_MAX			"MAX"
#define PM2525_REG_CLEAR		"CLM"

#define PM2525_TRIGGER_INTERNAL		"TRG I"
#define PM2525_TRIGGER_BUS		"TRG B"
#define PM2525_TRIGGER_EITHER		"TRG E"
#define PM2525_TRIGGER_WHAT		"TRG ?"

#define PM2525_START			"X [1]"
#define PM2525_GET			"\0338"

#define PM2525_OUT_STRING		"OUT S"
#define PM2525_OUT_NUMBER		"OUT N"
#define PM2525_OUT_WHAT			"OUT ?"

#define PM2525_DUMP			"DMP"

#define PM2525_MEASURE_OUTPUT_AUTO	"EMO AUTO"
#define PM2525_MEASURE_OUTPUT		"EMO"

#define PM2525_STATUS			"\0337"

#define PM2525_STATUS_EXTENSION		0x80
#define PM2525_STATUS_REQUEST_SERVICE	0x40
#define PM2525_STATUS_ABNORMAL		0x20
#define PM2525_STATUS_BUSY		0x10
#define PM2525_STATUS_EF3		0x08
#define PM2525_STATUS_EF2		0x04
#define PM2525_STATUS_EF1		0x02
#define PM2525_STATUS_EF0		0x01

#define PM2525_STATUS_ISABNORMAL(x)	((x) & PM2525_STATUS_ABNORMAL)
#define PM2525_STATUS_ISREQ_SERVICE(x)	((x) & PM2525_STATUS_REQUEST_SERVICE)
#define PM2525_STATUS_ISEXTENSION(x)	((x) & PM2525_STATUS_EXTENSION)
#define PM2525_STATUS_ISBUSY(x)		((x) & PM2525_STATUS_BUSY)
#define PM2525_STATUS_ISEF3(x)		((x) & PM2525_STATUS_EF3)
#define PM2525_STATUS_ISEF2(x)		((x) & PM2525_STATUS_EF2)
#define PM2525_STATUS_ISEF1(x)		((x) & PM2525_STATUS_EF1)
#define PM2525_STATUS_ISEF0(x)		((x) & PM2525_STATUS_EF0)

#define PM2525_STATUS_IDLE(x) \
		(!PM2525_STATUS_ISABNORMAL(x) && !PM2525_STATUS_ISBUSY(x) \
		  && !PM2525_STATUS_ISEF0(x))

#define PM2525_STATUS_BUSY_NODATA(x) \
		(!PM2525_STATUS_ISABNORMAL(x) && PM2525_STATUS_ISBUSY(x) \
		  && !PM2525_STATUS_ISEF0(x))

#define PM2525_STATUS_HOLD(x) \
		(!PM2525_STATUS_ISABNORMAL(x) && PM2525_STATUS_ISEF1(x))

#define PM2525_STATUS_TRIGGERABLE(x) \
		(!PM2525_STATUS_ISABNORMAL(x) && PM2525_STATUS_ISEF0(x))

#define PM2525_STATUS_ERROR_PROG(x) \
		(PM2525_STATUS_ISABNORMAL(x) && PM2525_STATUS_ISEF0(x))

#define PM2525_STATUS_ERROR_INTERNAL(x) \
		(PM2525_STATUS_ISABNORMAL(x) && PM2525_STATUS_ISEF1(x))

#define PM2525_STATUS_ERROR_MEASURE(x) \
		(PM2525_STATUS_ISABNORMAL(x) && PM2525_STATUS_ISEF2(x))

int m_init();
void m_close();
void m_send();
char *m_recv();
char *m_dump();
double m_read();
int m_checkstatus();
void m_printerr();

#endif /* INCLUDE_PM2525 */
