/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       nnsys.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef NNSYS_H
#define NNSYS_H

#include "net.h"
#include "MAP.h"

#define  LISTTOKEN        "list"

typedef struct nn_list_rec {
    struct nn_list_rec *r_next;
    char *Name;			/* list name */
    nnp_t  *list;		/* pointers to nets */
} list_t;

typedef struct nnsys_rec {
    char    *Name;		/* name of system */
    nn_t    *Nets;		/* list of nets */
    nn_class_t *proc;		/* system wide procedures */
    int     NumNets;		/* number of nets */
    map_t   *Maps;		/* list of maps */
    list_t  *Lists;		/* lists of nets */
    int     Iter;		/* number of max iteration  */
    int	    CurIter;	        /* current iteration count */
    int	    NumPattern;         /* min number of patterns in ENV modules */
    int	    CurPattern;         /* current pattern number */
    int     Ofreq;		/* frequency of logging information */
    char    *Lfile;		/* log file */
    FILE    *lfp;		/* file ptr */
    int     DoingWhat;		/* mode: TRAINING, OPERATE, or TESTING */
    double  Conv;		/* convergence criteria */
    long    Seed;		/* seed for weight initialisation */
    double   MSE;		/* system mse */
} nnsys_t;

#endif /* NNSYS_H */



