/*----------------------------------------------------------------------------
|
|       Copyright (C) 1992 by SEDAL,
|       Sydney University Electrical Engineering
|       The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       (%M%): version %I%
|       Author(s): Marwan Jabri, Laurens Leerink
|       delta date %E% %U%
|       obtained %D% %T%
|       Synopsis: general front end library for interfacing to mmnn
|
|___________________________________________________________________________*/
#ifndef mmUtils_H
#define mmUtils_H

#define PRIVATE(net, type) ((type *)(net->Private))
#define MAXINT    (1<<30)
#define PRINTIN     1
#define PRINTTARGET 2
#define PRINTOUT    4

#define min(a, b) ((a) < (b) ? (a) : (b))

typedef struct exp_rec {
    char   *ename;
    int    debug;
    int    print;
    int    verbose;
    int    operate;
    int    test;
    int    follow_up;
    int    confusion;
    int    batch;
    int    lp;
    int    olp;
    int    xofy;
    char   *Private;
} exp_t;

extern CommonUsage();
extern PrintCommonPrgInfo();
extern ParseCommonArg();
extern CommonGetMode();
extern CommonCheckLists();
extern CommonForwardSystem();
extern CommonComputeSystemMSE();
extern CommonUpdateWeights();
extern SetModeSystem();
extern FindNumPattern();
extern CommonTest();

#endif	/* mmUtils_H */
