/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       defs.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef DEFS_H
#define DEFS_H

#define PRINTCLASSHDR(name, class) fprintf(where, "#-------------------------- Net %s - Class %s -------------------------\n#\tPrivate fields\n", (name), (class))

#define MAXNUMOFCLASSES 256
#define WEIGHTEXT ".wgt"

#define SYSTEMCLASS       "system"
#define ENVCLASS          "env"	

/* data files type */
#define ASCTYPE             1
#define NITYPE              2
#define TMTYPE              3

/* Doing what? */
#define TRAINING            1
#define OPERATE             2
#define TESTING             3
#define FOLLOWUP            4

#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (1)
#endif

#define	kronker(i,j)	  ((i) == (j) ? 1.0 : 0.0)

#define RCERROR3(a, b, c)  RCError3(FunName, a, b, c)
#define RCERROR2(a, b)  RCError2(FunName, a, b)
#define RCERROR1(a)  RCError1(FunName, a)
#define RCERROR(a, b)  RCError(FunName, a, b)
#define RCBOMB(a, b)   RCBomb(FunName, a, b)
#define RCBOMB1(a)     RCBomb1(FunName, a)
#define RCBOMB2(a, b)  RCBomb2(FunName, a, b)
#define IFEQS(a, b)    if (! strcmp(a, b))
#define EFEQS(a, b)    else IFEQS(a,b)
#define WARN           MMNNWarn
#define FORALL(p,l)    for((p)=(l);(p)!=NULL;(p)=(p)->r_next)
#define LAST(p,l)      for((p)=(l);(p->r_next)!=NULL;(p)=(p)->r_next) ;
#define NELTS(x)        (sizeof((x)) / sizeof(((x)[0])))
#define EQS(a, b) (! strcmp((a), (b)))


/* default values */
#define DFLT_WEIGHT	1.0
#define DFLT_FIXWGHT	1.0
#define DFLT_ETA	0.1
#define DFLT_OFREQ	100
#define DFLT_BIAS	1.0
#define DFLT_ALPHA	0.0
#define DFLT_CONV	0.00001
#define DFLT_SEED	1992
#define DFLT_RANGE	0.3
#define DFLT_MARGIN	0.3
#define DFLT_ITER	1000


typedef double (*FFunction)();
typedef unsigned char byte;

#define ZEROARRAY(a,s) memset ((char *)(a), 0, (s)*sizeof(*(a)));
#define CPYARRAY(a,b,s) memcpy ((char *)(a), (char *)(b), (s)*sizeof(*(a)));

#endif /* DEFS_H */
