/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       SRNP.h (%M%): version %I%            
|       Author(s): Laurens Leerink
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef SRNP_H
#define SRNP_H

/*tokens*/
#define SIZETOKEN          "size"
#define EPOCHTOKEN         "epoch"
#define ENTROPYTOKEN       "entropy"
#define JACOBSTOKEN        "jacobs"
#define WRAPTOKEN          "wrapcontext"
#define ONLINETOKEN        "onlineep"
#define MMUNFOLDTOKEN      "mmunfold"

/*
 * NOTE
 * the naming of variables are exactly the same as in the paper
 * by Werbos
 */

typedef struct srn_rec {
    int   m,                  /* # of inputs */
	  N,                  /* # of hidden nodes + # of inputs */
	  n,                  /* # of outputs */
	  t,                  /* epoch count */
	  T,                  /* epoch size */
          entropy,	      /* use the entropy cost function ? */
	  jacobs,	      /* use jacobs lr adaptation ? */
	  wrap,		      /* reset/wrap context units @ end of epoch ? */
	  onlineEP,	      /* online logging of error & performance */
	  mmunfold;	      /* being used in mmunfold ? */

    double **W,               /* weights */
	  **x,                /* node values x[t][node] */
	  **F_W,              /* dE/dWij */
	  **avgF_W,           /* average dW */
	  **lrF_W,            /* value of this weight's learning rate */
	  **F_x,              /* dE/dx   : node delta's */
	  *F_net,             /* dE/dnet : weight delta's */
	  *F_net1;            /* dE/dnet : weight delta's */
} srn_t;



#endif /* SRNP_H */
