/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       CGRD.h (%M%): version %I%            
|       Author(s): Edward Tinker
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef OPTP_H
#define OPTP_H

#define FUNCTOKEN     "nfun"
#define OPTTOKEN      "opt"
#define TOLTOKEN      "tol"
#define ITMAXTOKEN    "itmax"
#define STCRITTOKEN   "st_crit"
#define ORTHCRITTOKEN "orth_crit"
#define MMERRFC(net)  ((((opt_t *)((net)->Private))->ERRFC)(net))

#define CGRD_FUNC 0
#define VFSR_FUNC 1

#define MINOPT -10
#define MAXOPT  10

typedef struct optimization_rec {
    double **W;               /* weights */
    double **Dw;              /* Weight updates */
    double *X;                /* weights for cgrd routine*/
    double *Dx;               /* delta weights for cgrd routine*/
    int *ParamType;        /* used by VFSR */
    double *ParamMin;         /* used by VFSR */
    double *ParamMax;         /* used by VFSR */
    double *Tangent;          /* used by VFSR */
    double *Curve;            /* used by VFSR */
    int   OptFunc;            /* optimization function (CGRD,VFSR)*/
    int   nconn;              /* number of weights */
    int   Nlayers;            /* number of layers */
    int   *Layers;            /* number of neurons in layers */
    double Tol;               /* tollerance for cgrd */
    int   *Idl;               /* index of 1st neuron in layers */    
    double Precision;         /* Precision used in prediction */
    int   UseMargin;          /* flag whether to use margin during MSE comp */
    int Func;                 /* Neuron function type */
    int ITMax;                /*maximum line search iterations*/
    double StCrit;            
    double OrthCrit;
    double (*ERRFC)();        /*routine to compute err and new Dw*/
} opt_t;

#endif /* OPTP_H */
