/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       NetClass.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef NETCLASS_H
#define NETCLASS_H

#include "defs.h"
#include "nnclass.h"

#include "MAP.h"
#include "../Classes/LMW/LPUTIL.h"
#include "../Classes/ENV/ENV.h"
#include "../Classes/MLP/MLP.h"
#include "../Classes/LMW/LMW.h"
#include "../Classes/FREC/FREC.h"
#include "../Classes/WTA/WTA.h"
#include "../Classes/KAKADU/KAKADU.h"
#include "../Classes/SRN/SRN.h"
#include "../Classes/WZ/WZ.h"
#include "../Classes/XOFY/XOFY.h"
#include "../Classes/RBPTT/RBPTT.h"
#include "../Classes/DC/DC.h"
#include "../Classes/EM/EM.h"
#include "../Classes/LOGIT/LOGIT.h"
#include "../Classes/LIFO/LIFO.h"

#define DUMMYCLASS "dummy"
#define DUMMYTYPE  0

static void DUMMY_PROC()
{
}
static nn_class_t InitNetClasses[] = {
    {DUMMYCLASS, DUMMY_PROC, DUMMY_PROC, DUMMY_PROC,
	 DUMMY_PROC, DUMMY_PROC, DUMMY_PROC,
	 DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, DUMMY_PROC,
	 DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, DUMMY_PROC,
	 DUMMY_PROC, DUMMY_PROC, DUMMY_PROC
     }
    ,{ENVCLASS , RCReadENV,  PrintENVRec, OrganiseENV, 
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, 
	  RelaxENV, PropENVErr, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, ComputeENVMSE, ResetENVErrors, ResetENVXtraIn,
	  AccENVXtraIn, GetENVXtraErr, DUMMY_PROC
	  }
#ifdef MAP_H
    ,{MAPCLASS , RCReadMAP, PrintMAPRec, OrganiseMAP,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, 
	  RelaxMAP, PropMAPErr, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC
	  }
#endif
#ifdef MLP_H   
    ,{MLPCLASS , RCReadMLP,  PrintMLPRec, OrganiseMLP, 
	  InitMLPState, ReadMLPState, SaveMLPState,
	  RelaxMLP, PropMLPErr, AccMLPDw, UpdateMLPWeights,
	  ResetMLPDw, ComputeMLPMSE, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, Die
	  }
#endif
#ifdef LMW_H   
    ,{LMWCLASS , RCReadLMW,  PrintLMWRec, OrganiseLMW, 
	  InitLPState, ReadLPState, SaveLPState,
	  RelaxLMW, PropLPErr, ComputeLPDw, DUMMY_PROC,
	  DUMMY_PROC, ComputeLPMSE, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, Die
	  }
#endif
#ifdef KAKADU_H
    ,{KAKADUCLASS , RCReadKAKADU,  PrintLPRec, OrganiseKAKADU, 
	  InitLPState, ReadLPState, SaveLPState,
	  RelaxKAKADU, PropLPErr, ComputeLPDw, DUMMY_PROC,
	  DUMMY_PROC, ComputeLPMSE, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, Die
	  }
#endif
#ifdef FREC_H
    ,{FRECCLASS , RCReadFREC,  PrintFRECRec, OrganiseFREC, 
	  InitFRECState, ReadFRECState, WriteFRECState,
	  RelaxFREC, PropFRECErr, ComputeFRECDw, UpdateFRECWeights,
	  ResetFRECDw, ComputeFRECMSE, DUMMY_PROC, DUMMY_PROC,
	  AccFRECXtraIn, GetFRECXtraErr, FRECDie
	  }
#endif
#ifdef WTA_H
    ,{WTACLASS , RCReadWTA, PrintWTARec, OrganiseWTA,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, 
	  RelaxWTA, PropWTAErr, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, DUMMY_PROC, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, DUMMY_PROC
	  }
#endif
#ifdef WZ_H
    ,{WZCLASS,   RCReadWZ,   PrintWZRec,  OrganiseWZ,
	  InitWZState, ReadWZState, SaveWZState,
	  RelaxWZ, PropWZErr, AccWZDw, UpdateWZWeights,
	  ResetWZDw, ComputeWZMSE, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, Die
	  }
#endif
#ifdef SRN_H   
    ,{SRNCLASS , RCReadSRN,  PrintSRNRec, OrganiseSRN, 
	  InitSRNState, ReadSRNState, SaveSRNState,
	  RelaxSRN, PropSRNErr, ComputeSRNDw, UpdateSRNWeights,
	  ResetSRNDw, ComputeSRNMSE, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, Die
	  }
#endif
#ifdef XOFY_H
    ,{XOFYCLASS , RCReadXOFY, PrintXOFYRec, OrganiseXOFY,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, 
	  RelaxXOFY, PropXOFYErr, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, DUMMY_PROC, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, DUMMY_PROC
	  }
#endif
#ifdef RBPTT_H
    ,{RBPTTCLASS,   RCReadRBPTT,   PrintRBPTTRec,  OrganiseRBPTT,
	  InitRBPTTState, ReadRBPTTState, SaveRBPTTState,
	  RelaxRBPTT, PropRBPTTErr, AccRBPTTDw, UpdateRBPTTWeights,
	  ResetRBPTTDw, ComputeRBPTTMSE, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, Die
	  }
#endif
#ifdef DC_H
    ,{DCCLASS , RCReadDC, PrintDCRec, OrganiseDC,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, 
	  RelaxDC, PropDCErr, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, DUMMY_PROC, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, DUMMY_PROC
	  }
#endif
#ifdef EM_H
    ,{EMCLASS , RCReadEM, PrintEMRec, OrganiseEM,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, 
	  RelaxEM, PropEMErr, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, DUMMY_PROC, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, DUMMY_PROC
	  }
#endif
#ifdef LOGIT_H
    ,{LOGITCLASS , RCReadLOGIT, PrintLOGITRec, OrganiseLOGIT,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, 
	  RelaxLOGIT, PropLOGITErr, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, DUMMY_PROC, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, DUMMY_PROC
	  }
#endif
#ifdef LIFO_H
    ,{LIFOCLASS , RCReadLIFO, PrintLIFORec, OrganiseLIFO,
	  DUMMY_PROC, DUMMY_PROC, DUMMY_PROC, 
	  RelaxLIFO, PropLIFOErr, DUMMY_PROC, DUMMY_PROC,
	  DUMMY_PROC, DUMMY_PROC, ResetErrors, ResetXtraIn,
	  AccXtraIn, GetXtraErr, DUMMY_PROC
	  }
#endif
};

#endif /* NETCLASS_H */


