/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       MLPP.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef MLPP_H
#define MLPP_H

#define ALGTYPETOKEN "algtype"

#define BPTYPE 0 /* default */
#define WPTYPE 1
#define NPTYPE 2
#define SWNPTYPE 3

typedef struct mlp_rec {
    double **W;               /* weights */
    double **Dw;              /* Weight updates */
    double **Odw;             /* old Weight updates */
    double *SavePert;         /* temporary array */
    double Pert;              /* Perturbation value for WP */
    int   Nlayers;            /* number of layers */
    int   *Layers;            /* number of neurons in layers */
    int   *Idl;               /* index of 1st neuron in layers */
    double Gain;              /* neuron gain */
    double Precision;         /* Precision used in prediction */
    int   UseMargin;	      /* flag whether to use margin during MSE comp. */
    int   NPI;                /* node perturbated */
    int   Alg;                /* algorithm to be used */
    char  *AlgStr;            /* name of algorithm */
    int   UpdateImmediate;    /* if true then do immediate update of weights*/
} mlp_t;



#endif /* MLPP_H */
