/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       FRECP.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef FRECP_H
#define FRECP_H

/*tokens*/
#define SHADOWTOKEN        "useshadow"
#define PSEUDOERRTOKEN     "usepseudoerr"
#define SIZETOKEN          "size"
#define DEPTHTOKEN         "depth"
#define EPOCHTOKEN         "epoch"

typedef struct frec_rec {
    struct frec_rec *r_next;	/* for shadow net (OLBTT) */
    double **X;			/* archive old Outs */
    double **Sum;		/* archive old Ins */
    double **Inputs;		/* must store inputs */
    double **FeedBack;		/* must store feedbacks */
    int   RecDepth;             /* (t, ..., t-RecDepth) -> t+1 */
    int   EpochLen;             /* size of an epoch */
    int   t;			/* present time */
    int   NeedUpdate;		/* signify when to change W */
    int   UseShadow;		/* for a "Shadow" net */
    int   UsePseudoErr;		/* for giving pseudo Err out */
    int   UseMargin;
    double ***W;			/* weights [x][][] x=0: t->t; x=1: (t-1)->t; ..*/
    double ***Dw;		/* weight updates */
    double ***Mgrad;		/* gradient */
    double **Delta;		/* delta in each node */
    double **XDelta;		/* store the deltas in time */
    double Pert;                 /* Perturbation value for WP */
} frec_t;



#endif /* FRECP_H */
