#define  PI M_PI
#include <bool.h>
#include <GetOpt.h>
#include "arithmetic.h"
#include <double.Matrix.h>
#define  array  doubleArray
#define  matrix doubleMatrix

extern	int	  init_();
extern	int	 icset_();
extern	int	initac_();
extern	int	engdin_();
extern	int	aircac_();
extern	int	cgcalc_();
extern	int	engine_();
extern	int	instrm_();
extern	int	derivc_();
extern	int	instr2_();
extern	struct	{ doublereal	dc[30]; }			contrl_;
extern	struct	{ doublereal	dex, dax, drx, thrstx[4]; }	ctparm_;
extern	struct	{ doublereal	f[13], df[13], u[5]; }		drvinp_;
extern	struct	{ doublereal	f[13], df[13]; }		drvout_;
extern	struct	{ doublereal	thrust[4]; }			engstf_;
extern	struct	{ double	hi, hi2; }			ingdat_;
extern	struct	{ doublereal	obsvec[120]; }			observ_;
extern	struct	{ double	fic[13],dfic[13]; }		setics_;

doublereal	*const	DC	= contrl_.dc    -1;
doublereal	*const	THRSTX	= ctparm_.thrstx-1;
doublereal	*const	F	= drvout_.f     -1;
doublereal	*const	DF	= drvout_.df    -1;
doublereal	*const	THRUST	= engstf_.thrust-1;
doublereal	*const	OBSVEC	= observ_.obsvec-1;
double		*const	FIC	= setics_.fic   -1;
double		*const	DFIC	= setics_.dfic  -1;

#define   T     F[ 1]
#define   P     F[ 2]
#define   Q     F[ 3]
#define   R     F[ 4]
#define   V     F[ 5]
#define ALP     F[ 6]
#define BTA     F[ 7]
#define THA     F[ 8]
#define PSI     F[ 9]
#define PHI     F[10]
#define   H     F[11]
#define   X     F[12]
#define   Y     F[13]

#define   TSET  FIC[ 1]
#define   PSET  FIC[ 2]
#define   QSET  FIC[ 3]
#define   RSET  FIC[ 4]
#define   VSET  FIC[ 5]
#define ALPSET  FIC[ 6]
#define BTASET  FIC[ 7]
#define THASET  FIC[ 8]
#define PSISET  FIC[ 9]
#define PHISET  FIC[10]
#define   HSET  FIC[11]
#define   XSET  FIC[12]
#define   YSET  FIC[13]

#define   TDOT DF[ 1]
#define   PDOT DF[ 2]
#define   QDOT DF[ 3]
#define   RDOT DF[ 4]
#define   VDOT DF[ 5]
#define ALPDOT DF[ 6]
#define BTADOT DF[ 7]
#define THADOT DF[ 8]
#define PSIDOT DF[ 9]
#define PHIDOT DF[10]
#define   HDOT DF[11]
#define   XDOT DF[12]
#define   YDOT DF[13]

#define DA     DC[ 1]
#define DE     DC[ 5]
#define DT     DC[ 8]
#define DR     DC[ 9]
#define	HI     ingdat_.hi
#define	HI2    ingdat_.hi2

double	phimax	 =  PI;				// maximum bank angle
double	omega	 =  0.05;			// turn rate (radians/second)
double	final	 = 31.40;			// end of maneuver (seconds)
void initialize(int argc, char **argv) {
  double	angle	 =  90.0;		// desired turn angle (degrees)
  double	bound	 = 180.0;		// allowed bank angle (degrees)
  double	track	 =   0.0;		// initial heading    (degrees)
  double	delay	 =  16.0;		// before maneuver (seconds)
  double	radius	 =   4.0;		// desired turn radius (miles)
  int		verbose  = FALSE;		// verbose report
  GetOpt	getopt (argc, argv, "-a:b:h:p:r:v");	// don't permute argv
  getopt.opterr	 = 0;				// don't report errors

  int option;					// option flags
  while ((option = getopt()) != EOF)
    switch (option) {
      case 'a':					// desired turn angle
	angle	= atof(getopt.optarg);
	break;
      case 'b':					// allowed bank angle
	bound	= atof(getopt.optarg);
	break;
      case 'h':					// initial heading
	track	= atof(getopt.optarg);
	break;
      case 'p':					// before maneuver
	delay	= atof(getopt.optarg);
	break;
      case 'r':					// desired turn radius
	radius	= atof(getopt.optarg);
	break;
      case 'v':					// verbose report
	verbose	= TRUE;
	break;
      case '?':					// unrecognized option
	break;					// but don't complain
      };

  if (verbose)					// report options
    cerr	<< angle	<< " = angle, "
		<< bound	<< " = bound, "
		<< track	<< " = track, "
		<< delay	<< " = delay, "
		<< radius	<< " = radius\n";

  angle		*= PI/180.0;		// desired turn angle (radians)
  bound		*= PI/180.0;		// maximum bank angle (radians)
  track		*= PI/180.0;		// initial heading    (radians)
  radius	*= 5280.0;		// desired turn radius (feet)
  phimax	 = fabs(bound);		// maximum bank angle (radians)
    init_();				// INITIALIZE STATES
    TSET	 = -delay;		// initial time
  PSISET	 =  track;		// initial heading
  DFIC[12]	 =  VSET*cos(PSISET);	// airspeed north
  DFIC[13]	 =  VSET*sin(PSISET);	// airspeed east
  omega		 = (angle < 0.0) ? -VSET/radius : +VSET/radius;
					// desired turn rate
  final		 = angle/omega;		// end of maneuver
  initac_();				// INITIALIZE AIRCRAFT MODEL
  engdin_();				// INITIALIZE   ENGINE MODEL
  return;
  }

//doublereal	 flast[13];
//doublereal	dflast[13];
void emulate(void) {		// one time step
  int	i;
  for (i = 0; i < 13; i++)
    drvout_. f[i]	 =     drvinp_. f[i];
  for (i = 0; i < 13; i++)
    drvout_.df[i]	 =     drvinp_.df[i];
  DA		= drvinp_.u[0];		// aileron
  DE		= drvinp_.u[1];		// elevator (stablator)
  DT		= drvinp_.u[2];		// twist    (stablator)
  DR		= drvinp_.u[3];		// rudder
  THRSTX[1]	=			// engine 1
  THRSTX[2]	= drvinp_.u[4];		// engine 2
  aircac_();			// AIR DATA PARAMETERS.
  cgcalc_();			// AERODYNAMIC FORCES AND MOMENTS.
  engine_();			// ENGINE PARAMETERS.
  instrm_();			// OBSERVATION EQUATION.
  derivc_();			// STATE EQUATION.
  instr2_();			// TIME DERIVATIVE DEPENDENT VARIABLES.

  for (i = 0; i < 13; i++)
	drvout_. f[i]	+= HI*(1.75*drvout_.df[i] - 0.75*drvinp_.df[i]);
  for (i = 0; i < 13; i++)
	drvout_.df[i]	+=     0.5*(drvout_.df[i] -      drvinp_.df[i]);

  return;
  }

double bearing(double t) {		// aircraft flight direction
  return PSISET + omega*((t < 0.0) ? 0.0 : (t < final) ? t : final);
  }
/*
void reference(array& r) {		// reference model
  for (int i = 0; i < r.m(); i++) {	// straight and level
    r[i][0]	 = 0.0;
    }
  return;
  }

void desired(array& d) {		// desired state
  d[ 4][0]	 =   VSET;		// straight and level
  d[10][0]	 =   HSET;
  d[24][0]	 =   VSET;
  return;
  }
*/
const	double	dt	 = 1.0;		// time interval
void reference(array& r) {		// reference model
  for (int i = 0; i < r.m(); i++) {	// coordinated turn
    r[i][0]	 = bearing(T + i*dt);
    }
  return;
  }

void desired(array& d) {		// desired state
  d[ 0][0]	 =   T;			// coordinated turn
  d[ 4][0]	 =   VSET;
  d[10][0]	 =   HSET;
//d[13][0]	 =   1.0;
  d[24][0]	 =   VSET*cos(bearing(T));
  d[25][0]	 =   VSET*sin(bearing(T));
  return;
  }

void reset(void) {			// reset to initial condition
  icset_();
  }

int permitted(void) {			// state variables within limits?
  return -phimax < PHI && PHI < phimax;
  }

const	double	DGR	= 180.0/M_PI;
void display(char* home) {		// SUBROUTINE TO OUTPUT SIMULATION DATA 
  cout	<< home;			// home cursor
  cout	<< form("  TIME = %10.4f\n", (double) T);
  cout	<< "  \n";
  cout	<< form("  P     = %10.2f  ", (double) P*DGR)
	<< form("  Q     = %10.2f  ", (double) Q*DGR)
	<< form("  R     = %10.2f\n", (double) R*DGR);
  cout	<< form("  V     = %10.2f  ", (double) V    )
	<< form("  ALP   = %10.2f  ", (double) ALP*DGR)
	<< form("  BTA   = %10.2f\n", (double) BTA*DGR);
  cout	<< form("  THA   = %10.2f  ", (double) THA*DGR)
	<< form("  PSI   = %10.2f  ", (double) PSI*DGR)
	<< form("  PHI   = %10.2f\n", (double) PHI*DGR);
  cout	<< form("  X     = %10.2f  ", (double) X)
	<< form("  Y     = %10.2f  ", (double) Y)
	<< form("  H     = %10.2f\n", (double) H);
  cout	<< "  \n";
  cout	<< form("  DE        = %10.2f\n", (double) DE*DGR)
	<< form("  DA        = %10.2f\n", (double) DA*DGR)
	<< form("  DT        = %10.2f\n", (double) DT*DGR)
	<< form("  DR        = %10.2f\n", (double) DR*DGR);
  cout	<< form("  PLA LEFT  = %10.2f  ", (double) THRSTX[1])
	<< form("  PLA RIGHT = %10.2f\n", (double) THRSTX[2]);
  cout	<< form("  THR LEFT  = %10.2f  ", (double) THRUST[1])
	<< form("  THR RIGHT = %10.2f\n", (double) THRUST[2]);
  cout	<< form("  PDOT      = %10.2f  ", (double) PDOT*DGR)
	<< form("  QDOT      = %10.2f  ", (double) QDOT*DGR)
	<< form("  RDOT      = %10.2f  ", (double) RDOT*DGR);
  cout	<< "  \n";
/*
  cout	<< "  *** OBSVEC VARIABLES ***\n";
  cout	<< form("  AN    = %10.2f  ", OBSVEC[31])
	<< form("  HDOT  = %10.2f\n", OBSVEC[22]);
  cout	<< form("  H     = %10.2f  ", OBSVEC[10])
	<< form("  HDDOT = %10.2f\n", OBSVEC[50]);
  cout	<< form("  P     = %10.2f  ", OBSVEC[ 1]*DGR)
	<< form("  PHI   = %10.2f\n", OBSVEC[ 9]*DGR);
  cout	<< form("  MACH  = %10.2f  ", OBSVEC[35])
	<< form("  VCAS  = %10.2f\n", OBSVEC[92]);
*/
  cout.flush();
  return;
  }
