#include "arithmetic.h"
#include <double.Matrix.h>
#define  matrix doubleMatrix
#define  array  doubleArray
extern	void	initialize(int, char **);
extern	void	reference(array&);
extern	void	emulate(void);
extern	void	desired(array&);
extern	void	display(char*);
extern	void	reset(void);
extern	int	permitted(void);

extern "C"	{				// termcap library functions
  int	tgetent(char*, char*);			// get termcap entry
  char*	tgetstr(char*, char**);			// get control sequence
  }

int		patient	 = TRUE;		// signal graceful termination
void user_signal2_handler (int sig
/*, int code, struct sigcontext* scp, char* addr*/) { patient = FALSE; }

int		corrupt	 = FALSE;		// signal clear display
void user_signal3_handler (int sig
/*, int code, struct sigcontext* scp, char* addr*/) { corrupt = TRUE; }

inline	array	row(const array& a) {		// reference array a
  return array(1, a.m()*a.l(), a.x());		// as a long row vector
  }

inline	array	diag(const array& a) {		// reference diagonal elements
  return array(1+a.l(), a.m(), 1, a.x());	// of a as a column vector
  }
						// kronecker product
matrix	kronecker(const array& a, const array& b) {
  matrix	r(a.m()*b.m(), a.n()*b.n());
  for (int i = 0; i < a.m(); i++)
    for (int j = 0; j < a.n(); j++)
      for (int p = 0; p < b.m(); p++)
        for (int q = 0; q < b.n(); q++)
          r[i*b.m()+p][j*b.n()+q]	 = a[i][j]*b[p][q];
  return r;
  }
						// row sum
matrix	row_sum(const array& a) {
  matrix	r(a.m(), 1);
  for (int i = 0; i < a.m(); i++) {
    r[i][0]	 = a[i][0];
    for (int j = 1; j < a.n(); j++)
      r[i][0]	+= a[i][j];
    };
  return r;
  }

extern	struct	{ doublereal x[n], u[k]; }	drvinp_;
#ifdef	LEARNING
array	X(n+k, 1+n+k, (double*)drvinp_.x[0]);	// Derivative Arithmetic
array	x(X.s(0, n, 0, 1));			// State Vector @ time t
array	u(X.s(n, k, 0, 1));			// Control Vector
array	I(X.s(0, n+k, 1));			// Initial Derivatives
#else
array	x(n, 1, &drvinp_.x[0]);			// State Vector @ time t
array	u(k, 1, &drvinp_.u[0]);			// Control Vector
#endif

extern	struct	{ doublereal f[n]; }		drvout_;
#ifdef  LEARNING
array	F(  n, 1+n+k, (double*)drvout_.f[0]);	// Derivative Arithmetic
array	f(F.s(0, n, 0,   1));			// State Vector @ time t+1
array	A(F.s(0, n, 1,   n));			// State Matrix
array	B(F.s(0, n, 1+n, k));			// Control Matrix
#else 
array   f(n, 1, &drvout_.f[0]);			// State Vector @ time t+1
#endif 
