C
      SUBROUTINE VCAL                                                           
C                                                                               
C.... ROUTINE TO COMPUTED CALIBRATED AIRSPEED AS A FUNCTION                     
C     OF MACH AND IMPACT PRESSURE.                                              
C                                                                               
C.... WRITTEN 1/28/76                                                           
C     A MYERS NASA/FRC                                                          
C                                                                               
C                    
      INTEGER I
C
c     REAL ASL, PASL, QPASL1, VCASS
      REAL ASL, PASL
      REAL QPASL1, VCASS
C                                                           
c     INCLUDE 'include.h'
      INCLUDE 'simout.h'
      INCLUDE 'lll021.h'
C                                                                               
      DATA PASL   / 2116.22 /                                                   
      DATA ASL    /  661.48 /                                                   
C                                                                               
C.... COMPUTE CALIBRATED AIRSPEED.                                              
C                                                                               
      QPASL1=QC      /PASL  +  1.0                                              
      VCAS  =1479.116*SQRT  (QPASL1**0.285714-  1.0 )                          
C                                                                               
      IF(QC    .LT. 1889.64) RETURN                                             
C                                                                               
C.... VCAS FOUND BY ITERATION.                                                  
C                                                                               
      DO 1 I=1,5                                                                
C
      VCASS = VCAS
C                                                                               
      VCAS  =582.95174*SQRT  (QPASL1*( 1.0  - 1.0 /( 7.0 *                     
     .                (VCASS /ASL   )**2))**2.5)                                
C                                                                               
      IF(ABS(VCAS  -VCASS ).LT. 1.0D-3) RETURN                                 
C                                                                               
    1 CONTINUE                                                                  
C                                                                               
      RETURN                                                                    
      END                                                                       
