C
      SUBROUTINE ENGTLU
C
C.... ROUTINE TO DO TABLE LOOK UP FOR ENGINE MODEL.
C
C.... WRITTEN AUG. 3, 1978
C     LEE DUKE NASA/DFRC
C
      REAL T,      P,      Q,      R,    V,    ALP,    BTA,
     .     THA,    PSI,    PHI,    H,    X,    Y,
     .     TDOT,   PDOT,   QDOT,   RDOT, VDOT, ALPDOT, BTADOT,
     .     THADOT, PSIDOT, PHIDOT, HDOT, XDOT, YDOT
C
      REAL FLIMIT
C
c     INCLUDE 'include.h'
      INCLUDE 'drvout.h'
      INCLUDE 'simout.h'
C
      REAL AMCHA, ALTA, AMCHC, ALTB
      REAL TIDL,TMIL,TMIN,TMAX,FIDL,FMIL,FMIN,FMAX
C
      INTEGER IDXMC1,IDXMC2
      REAL RATOMC,RATMC1
      INTEGER IDXHB1,IDXHB2
      REAL RATOHB,RATHB1
C
      REAL C03PA(4),C03NA(4),C07DAT(24),B03PA(4),
     .     B03NA(4),B07DAT(36),
     .     FIDLAX(108),FMILAX(168),FMAXAX(168),
     .     TIDLA(108),TMILA(168),TMAXA(168),
     .     FIDLA(108),FMILA(168),FMAXA(168)
      REAL C03RTN,C03RTP,C05F1K,C06LMN,C06LMP,B02LMN,B02LMP,
     .     B03RTN,B03RTP,B04F1K,B06F1E,B06F1K
      INTEGER I, IDXMA1, IDXMA2, IDXMB1, IDXMB2, IDXMC1, IDXMC2
      INTEGER IDXHA1, IDXHA2, IDXHB1, IDXHB2
      INTEGER INDXA1, INDXA2, INDXA3, INDXA4
      INTEGER INDXB1, INDXB2, INDXB3, INDXB4
      INTEGER INDXC1, INDXC2, INDXC3, INDXC4
      REAL BMCH, CMCH, BH
      REAL RATOMA, RATMA1,  RATOMB, RATMB1, RATOMC, RATMC1, 
     .     RATOHA, RATHA1,  RATOHB, RATHB1
      REAL TIDLA1, TIDLA2, FIDLA1, FIDLA2
      REAL TMILA1, TMILA2, FMILA1, FMILA2
      REAL TMAXA1, TMAXA2, FMAXA1, FMAXA2
      REAL C03PA1, C03PA2, C03RTP, C03NA1, C03NA2, C03RTN
      REAL B03PA1, B03PA2, B03RTP, B03NA1, B03NA2, B03RTN
C
      DIMENSION AMCHA (14)
      DIMENSION ALTA  (12)
      DIMENSION AMCHC ( 2)
      DIMENSION ALTB  ( 2)
      COMMON /TLUENG/ TIDL,TMIL,TMIN,TMAX,FIDL,FMIL,FMIN,FMAX
      COMMON /ENGIDX/ IDXMC1,IDXMC2,RATOMC,RATMC1,
     .                IDXHB1,IDXHB2,RATOHB,RATHB1
      COMMON /ENGTAB/ C03PA(4),C03NA(4),C07DAT(24),B03PA(4),
     .                B03NA(4),B07DAT(36),
     .                FIDLAX(108),FMILAX(168),FMAXAX(168),
     .                TIDLA(108),TMILA(168),TMAXA(168),
     .                FIDLA(108),FMILA(168),FMAXA(168)
      COMMON /ENGVAR/ C03RTN,C03RTP,C05F1K,C06LMN,C06LMP,B02LMN,B02LMP,
     .                B03RTN,B03RTP,B04F1K,B06F1E,B06F1K
C
      EQUIVALENCE(T     , F( 1)),
     .           (P     , F( 2)),(Q     , F( 3)),(R     , F( 4)),
     .           (V     , F( 5)),(ALP   , F( 6)),(BTA   , F( 7)),
     .           (THA   , F( 8)),(PSI   , F( 9)),(PHI   , F(10)),
     .           (H     , F(11)),(X     , F(12)),(Y     , F(13)),
     .           (TDOT  ,DF( 1)),
     .           (PDOT  ,DF( 2)),(QDOT  ,DF( 3)),(RDOT  ,DF( 4)),
     .           (VDOT  ,DF( 5)),(ALPDOT,DF( 6)),(BTADOT,DF( 7)),
     .           (THADOT,DF( 8)),(PSIDOT,DF( 9)),(PHIDOT,DF(10)),
     .           (HDOT  ,DF(11)),(XDOT  ,DF(12)),(YDOT  ,DF(13))
      DATA AMCHA  /     0.0,    0.2,    0.4,    0.6,    0.8,    0.9,
     .                  1.0,    1.2,    1.4,    1.6,    1.8,    2.0,
     .                  2.2,    2.4/
      DATA ALTA   /     0.0,10000.0,20000.0,30000.0,35000.0,40000.0,
     .              45000.0,50000.0,55000.0,60000.0,65000.0,70000.0/
      DATA AMCHC  /     0.4,    1.0/
      DATA ALTB   / 10000.0,30000.0/
C
C.... DETERMINE INDICES INTO ARRAYS.
C
      IDXMA1=1
      DO 1 I=2,13
      IF(AMCH  .GE.AMCHA (I)) IDXMA1=I
    1 CONTINUE
      IDXMA2=IDXMA1+1
C
      IDXMB1=IDXMA1
      IF(IDXMB1.GT. 8) IDXMB1= 8
      IDXMB2=IDXMB1+1
C
      IDXMC1=1
      IDXMC2=IDXMC1+1
C
      IDXHA1=1
      DO 2 I=2,11
      IF(H     .GE.ALTA  (I)) IDXHA1=I
    2 CONTINUE
      IDXHA2=IDXHA1+1
C
      IDXHB1=1
      IDXHB2=IDXHB1+1
C
      INDXA1=IDXMA1+14*(IDXHA1-1)
      INDXA2=INDXA1+1
      INDXA3=INDXA1+14
      INDXA4=INDXA2+14
C
      INDXB1=IDXMB1+ 9*(IDXHA1-1)
      INDXB2=INDXB1+1
      INDXB3=INDXB1+9
      INDXB4=INDXB2+9
C
      INDXC1=IDXHB1+ 2*(IDXMC1- 1)
      INDXC2=INDXC1+ 1
      INDXC3=INDXC1+ 2
      INDXC4=INDXC2+ 2
C
C
C.... CALCULATE INTERPOLATION RATIOS.
C
C
      BMCH  =AMCH
      IF(AMCH  .GT.1.4) BMCH  =1.4
      CMCH  =FLIMIT(AMCH  ,    0.4,    1.0)
      BH    =FLIMIT(H     ,10000.0,30000.0)
C
      RATOMA=(AMCH  -AMCHA (IDXMA1))/(AMCHA (IDXMA2)-AMCHA (IDXMA1))
      RATOMB=(BMCH  -AMCHA (IDXMB1))/(AMCHA (IDXMB2)-AMCHA (IDXMB1))
      RATOMC=(CMCH  -AMCHC (IDXMC1))/(AMCHC (IDXMC2)-AMCHC (IDXMC1))
      RATOHA=(H     -ALTA  (IDXHA1))/(ALTA  (IDXHA2)-ALTA  (IDXHA1))
      RATOHB=(BH    -ALTB  (IDXHB1))/(ALTB  (IDXHB2)-ALTB  (IDXHB1))
C
      RATMA1=1.0-RATOMA
      RATMB1=1.0-RATOMB
      RATMC1=1.0-RATOMC
      RATHA1=1.0-RATOHA
      RATHB1=1.0-RATOHB
C
C.... TABLE LOOK UP.
C
      TIDLA1=RATOMB*TIDLA (INDXB2)+TIDLA (INDXB1)*RATMB1
      TIDLA2=RATOMB*TIDLA (INDXB4)+TIDLA (INDXB3)*RATMB1
      TIDL  =RATOHA*TIDLA2        +TIDLA1        *RATHA1
C
      FIDLA1=RATOMB*FIDLA (INDXB2)+FIDLA (INDXB1)*RATMB1
      FIDLA2=RATOMB*FIDLA (INDXB4)+FIDLA (INDXB3)*RATMB1
      FIDL  =RATOHA*FIDLA2        +FIDLA1        *RATHA1
C
      TMILA1=RATOMA*TMILA (INDXA2)+TMILA (INDXA1)*RATMA1
      TMILA2=RATOMA*TMILA (INDXA4)+TMILA (INDXA3)*RATMA1
      TMIL  =RATOHA*TMILA2        +TMILA1        *RATHA1
C
C.... JOES TMIN
C
      TMIN = TMIL
C
      FMILA1=RATOMA*FMILA (INDXA2)+FMILA (INDXA1)*RATMA1
      FMILA2=RATOMA*FMILA (INDXA4)+FMILA (INDXA3)*RATMA1
      FMIL  =RATOHA*FMILA2        +FMILA1        *RATHA1
C
C.... JOES FMIN
C
      FMIN = FMIL
C
      TMAXA1=RATOMA*TMAXA (INDXA2)+TMAXA (INDXA1)*RATMA1
      TMAXA2=RATOMA*TMAXA (INDXA4)+TMAXA (INDXA3)*RATMA1
      TMAX  =RATOHA*TMAXA2        +TMAXA1        *RATHA1
C
      FMAXA1=RATOMA*FMAXA (INDXA2)+FMAXA (INDXA1)*RATMA1
      FMAXA2=RATOMA*FMAXA (INDXA4)+FMAXA (INDXA3)*RATMA1
      FMAX  =RATOHA*FMAXA2        +FMAXA1        *RATHA1
C
      C03PA1=RATOHB*C03PA (INDXC2)+C03PA (INDXC1)*RATHB1
      C03PA2=RATOHB*C03PA (INDXC4)+C03PA (INDXC3)*RATHB1
      C03RTP=RATOMC*C03PA2        +C03PA1        *RATMC1
C
      C03NA1=RATOHB*C03NA (INDXC2)+C03NA (INDXC1)*RATHB1
      C03NA2=RATOHB*C03NA (INDXC4)+C03NA (INDXC3)*RATHB1
      C03RTN=RATOMC*C03NA2        +C03NA1        *RATMC1
C
      B03PA1=RATOHB*B03PA (INDXC2)+B03PA (INDXC1)*RATHB1
      B03PA2=RATOHB*B03PA (INDXC4)+B03PA (INDXC3)*RATHB1
      B03RTP=RATOMC*B03PA2        +B03PA1        *RATMC1
C
      B03NA1=RATOHB*B03NA (INDXC2)+B03NA (INDXC1)*RATHB1
      B03NA2=RATOHB*B03NA (INDXC4)+B03NA (INDXC3)*RATHB1
      B03RTN=RATOMC*B03NA2        +B03NA1        *RATMC1
C
      RETURN
      END
