C
      SUBROUTINE ENGMDL
C
C.... ROUTINE TO IMPLEMENT FIRST ORDER ENGINE MODEL.
C
C.... WRITTEN AUG. 2, 1978
C     LEE DUKE NASA/DFRC
C
c     INCLUDE 'include.h'
      INCLUDE 'contrl.h'
      INCLUDE 'ctparm.h'
c     INCLUDE 'zzcom.h'
      INCLUDE 'conpos.h'
C
c     REAL FUEL,FLOW,D,SINETA,COSETA
c     LOGICAL FOUT,NOWC
c     REAL POSNZL,POSNZR,RPML  ,RPMR  ,TEMPL ,TEMPR ,
c    .     FFLOWL,FFLOWR,FQNTY
      REAL C03RTN,C03RTP,C05F1K,C06LMN,C06LMP,B02LMN,B02LMP,
     .     B03RTN,B03RTP,B04F1K,B06F1E,B06F1K
      REAL TIDL,TMIL,TMIN,TMAX,FIDL,FMIL,FMIN,FMAX
      REAL CORMIN,CORMAX,CORDIS,AUGMIN,AUGMAX,AUGDIS 
      REAL G0,FMSSIC
      REAL B04IN2,B04OT2,B06IN2,B06OT2,B14IN2,B14OT2,B16IN2,B16OT2 
      REAL C05IN2,C05OT2,C06OT2,C07OT2,C15IN2,C15OT2,C16OT2,C17OT2 
C
      REAL CIN01,BIN01
      REAL C02JN1,C03IN1,C03OT1,C04IN1,C04MLT,C04OT1,C05IN1,C05IN2,
     .     C05OT1,C05OT2,C06IN1,C06OT1,C06OT2,C07IN1,C07OT1,C07OT2,
     .     COUT1C
      REAL B01JN1,B02IN1,B02OT1,B03IN1,B03OT1,B04IN1,B04IN2,B04OT1,
     .     B04OT2,B05OT1,B06IN1,B06IN2,B06OT1,B06OT2,B07IN1,B07OT1,
     .     B08IN1,B08OT1,BOUT1C,BOUT2C
      REAL CIN11,BIN11
      REAL C12JN1,C13IN1,C13OT1,C14IN1,C14MLT,C14OT1,C15IN1,C15IN2,
     .     C15OT1,C15OT2,C16IN1,C16OT1,C16OT2,C17IN1,C17OT1,C17OT2,
     .     COUT2C
      REAL B11JN1,B12IN1,B12OT1,B13IN1,B13OT1,B14IN1,B14IN2,B14OT1,
     .     B14OT2,B15OT1,B16IN1,B16IN2,B16OT1,B16OT2,B17IN1,B17OT1,
     .     B18IN1,B18OT1,BOUT3C,BOUT4C
      REAL COROTR,COROTL,AUGOTR,AUGOTL,AUGPLR,AUGPLL
      REAL FLOWL,FLOWR,PLAL,PLAR
C     
      REAL DEDBND,FLIMIT,RLIMNP,B05FCN,B07SDL,B08FCN,C07SDL
C
c     COMMON /ENGINF/ FUEL,FLOW,D,FOUT,NOWC,SINETA,COSETA
c     COMMON /ENGDSP/ POSNZL,POSNZR,RPML  ,RPMR  ,TEMPL ,TEMPR ,
c    .                FFLOWL,FFLOWR,FQNTY
      COMMON /ENGVAR/ C03RTN,C03RTP,C05F1K,C06LMN,C06LMP,B02LMN,B02LMP,
     .                B03RTN,B03RTP,B04F1K,B06F1E,B06F1K
      COMMON /TLUENG/ TIDL,TMIL,TMIN,TMAX,FIDL,FMIL,FMIN,FMAX
C
      DATA CORMIN,CORMAX,CORDIS / 20.0, 82.9, 63.0/
      DATA AUGMIN,AUGMAX,AUGDIS / 83.1,127.0, 44.0/
      DATA FMSSIC     /0.0/
      DATA B04IN2,B04OT2,B06IN2,B06OT2  / 0.0,0.0,0.0,0.0 /
      DATA B14IN2,B14OT2,B16IN2,B16OT2  / 0.0,0.0,0.0,0.0 /
      DATA C05IN2,C05OT2,C06OT2,C07OT2  / 0.0,0.0,0.0,0.0 /
      DATA C15IN2,C15OT2,C16OT2,C17OT2  / 0.0,0.0,0.0,0.0 /
C
C.... FIND THRUST AND FUEL FLOW FOR PRESENT MACH/ALTITUDE CONDITION.
C
      CALL ENGTLU
C
C.... ENGINE COMMAND INPUTS
C
      PLAPL = THRSTX(1)
      PLAPR = THRSTX(2)
C
C.... RIGHT ENGINE CALCULATIONS
C
C
C.... DETERMINE INPUTS TO CORE AND AUGMENTOR MODELS.
C
      CIN01 = (PLAPR - CORMIN)/CORDIS
      CIN01 =FLIMIT(CIN01 ,   0.0,   1.0)
      BIN01 = (PLAPR - AUGMIN)/AUGDIS
      BIN01 =FLIMIT(BIN01 ,   0.0,   1.0)
C
C.... CORE TO AUGMENTOR SWITCHING LOGIC.
C
      IF((PLAPR.LT.CORMAX).AND.(PLAPR.GT.AUGMIN)) CIN01= 1.0
      IF((PLAPR.GT.AUGMIN).AND.(PLAPR.LT.CORMAX)) BIN01= 0.0
C
C.... FIRST ORDER CORE ENGINE MODEL.
C
      C02JN1=CIN01 -C06OT2
      C03IN1=C02JN1
      C03OT1=RLIMNP(C03IN1,C03RTN,C03RTP)
      C04IN1=C03OT1
      C04MLT=C07OT2
      C04OT1=C04IN1*C04MLT
      C05IN1=C04OT1
      C05OT1=C05OT2+C05F1K*(C05IN1+C05IN2)
      C05OT1=CIN01
      C06IN1=C05OT1
      C06OT1=FLIMIT(C06IN1,C06LMN,C06LMP)
      C07IN1=C05OT1
      C07OT1=C07SDL(C07IN1)
      COUT1C=C06OT1
C
C.... SIMPLE AUGMENTOR MODEL.
C
      B01JN1=BIN01 -B04OT2
      B02IN1=B01JN1
      B02OT1=DEDBND(B02IN1,B02LMN,B02LMP)
      B03IN1=B02OT1
      B03OT1=RLIMNP(B03IN1,B03RTN,B03RTP)
      B05OT1 = B05FCN(B03OT1,B04OT2)
      B04IN1=B05OT1
      B04OT1=B04OT2+B04F1K*(B04IN1+B04IN2)
      B06IN1=B04OT1
      B06OT1=B06OT2*B06F1E+B06F1K*(B06IN1+B06IN2)
      B06OT1=BIN01
      B07IN1=B06OT1
      B07OT1=B07SDL(B07IN1)
      B08IN1=B07OT1
      B08OT1=B08FCN(B08IN1)
      BOUT1C=B08OT1
      BOUT2C=B07OT1
C
C.... OUTPUTS.
C
      COROTR = COUT1C
      AUGOTR = BOUT1C
      AUGPLR = BOUT2C
C
C.... UPDATE FOR NEXT FRAME
C
      C05OT2 = C05OT1
      C05IN2 = C05IN1
      C06OT2 = C06OT1
      C07OT2 = C07OT1
      B04OT2 = B04OT1
      B04IN2 = B04IN1
      B06OT2 = B06OT1
      B06IN2 = B06IN1
C
C
C.... LEFT ENGINE CALCULATIONS
C
C
C.... DETERMINE INPUTS TO CORE AND AUGMENTOR MODELS
C
      CIN11 = (PLAPL - CORMIN)/CORDIS
      CIN11 = FLIMIT(CIN11,0.0,1.0)
      BIN11 = (PLAPL - AUGMIN)/AUGDIS
      BIN11 = FLIMIT(BIN11,0.0,1.0)
C
C.... CORE TO AUGMENTOR SWITCHING LOGIC
C
      IF((PLAPL.LT.CORMAX).AND.(PLAPL.GT.AUGMIN)) CIN11=1.0
      IF((PLAPL.GT.AUGMIN).AND.(PLAPL.LT.CORMAX)) BIN11=0.0
C
C.... FIRST ORDER CORE ENGINE MODEL
C
      C12JN1 = CIN11-C16OT2
      C13IN1 = C12JN1
      C13OT1 = RLIMNP(C13IN1,C03RTN,C03RTP)
      C14IN1 = C13OT1
      C14MLT = C17OT2
      C14OT1 = C14IN1*C14MLT
      C15IN1 = C14OT1
      C15OT1 = C15OT2+C05F1K*(C15IN1+C15IN2)
      C15OT1 = CIN11
      C16IN1 = C15OT1
      C16OT1 = FLIMIT(C16IN1,C06LMN,C06LMP)
      C17IN1 = C15OT1
      C17OT1 = C07SDL(C17IN1)
      COUT2C = C16OT1
C
C.... SIMPLE AUGMENTOR MODEL
C
      B11JN1 = BIN11-B14OT2
      B12IN1 = B11JN1
      B12OT1 = DEDBND(B12IN1,B02LMN,B02LMP)
      B13IN1 = B12OT1
      B13OT1 = RLIMNP(B13IN1,B03RTN,B03RTP)
      B15OT1 = B05FCN(B13OT1,B14OT2)
      B14IN1 = B15OT1
      B14OT1 = B14OT2+B04F1K*(B14IN1+B14IN2)
      B16IN1 = B14OT1
      B16OT1 = B16OT2*B06F1E+B06F1K*(B16IN1+B16IN2)
      B16OT1 = BIN11
      B17IN1 = B16OT1
      B17OT1 = B07SDL(B17IN1)
      B18IN1 = B17OT1
      B18OT1 = B08FCN(B18IN1)
      BOUT3C = B18OT1
      BOUT4C = B17OT1
C
C.... OUTPUTS
C
      COROTL = COUT2C
      AUGOTL = BOUT3C
      AUGPLL = BOUT4C
C
C.... UPDATE FOR NEXT FRAME
C
      C15OT2 = C15OT1
      C15IN2 = C15IN1
      C16OT2 = C16OT1
      C17OT2 = C17OT1
      B14OT2 = B14OT1
      B14IN2 = B14IN1
      B16OT2 = B16OT1
      B16IN2 = B16IN1
C
C.... COMPUTE ENGINE MODEL OUTPUTS.
C
      PLAR = COROTR*CORDIS+AUGPLR*AUGDIS+CORMIN
      FLOWR = (FMAX-FMIL)*AUGOTR+(FMIL-FIDL)*COROTR+FIDL
      THSR= (TMAX-TMIL)*AUGOTR+(TMIL-TIDL)*COROTR+TIDL
C
      PLAL = COROTL*CORDIS+AUGPLL*AUGDIS+CORMIN
      FLOWL = (FMAX-FMIL)*AUGOTL+(FMIL-FIDL)*COROTL+FIDL
      THSL= (TMAX-TMIL)*AUGOTL+(TMIL-TIDL)*COROTL+TIDL
C
C.... STORE IN COMMON 
C
      DC(11) = 0.97*THSR
      DC(12) = 1.02*THSL     
C
      RETURN
      END
