C
      SUBROUTINE ENGINE
C
C.... ROUTINE TO COMPUTE EFFECTS OF ENGINE(S).
C
C.... WRITTEN FEBRUARY 1,1983
C     LEE DUKE NASA/DFRF
C
C.... MODIFIED FOR DIFFERENT ANGLE DEFINITION JUNE, 1985
C     JOE PAHLE  NASA/DFRF
C
C
      DIMENSION XTHRST(4),YTHRST(4),ZTHRST(4)
      DIMENSION HENGIN(4,3),GYRO(3),AINRTA(3,3)
      DIMENSION TORQUE(3)
      DIMENSION TVECLC(4,3)
      DIMENSION CSANXY(4),SNANXY(4),CSANXZ(4),SNANXZ(4)
C
C.... THE COMMON BLOCKS /ENGSTF/ AND /LLL015/ ARE THE MAIN I/O
C     COMMON BLOCKS FOR THIS ROUTINE. THE VARIABLES IN /ENGSTF/
C     ARE DEFINED IN THE USER SUPPLIED ROUTINE UENGIN. THIS
C     ROUTINE COMPUTES THE VALUES OF THE VARIABLES IN /LLL015/
C     AND SUPPLIES THEM TO OTHER ROUTINES.
C
C     THE VARIABLES IN THESE COMMON BLOCKS ARE:
C
C     /ENGSTF/
C
C		THRUST(I)	THE TOTAL THRUST OF THE I-TH
C				ENGINE (LBS)
C		TLOCAT(I,J)	THE DISPLACEMENT OF THE I-TH ENGINE
C                               FROM THE AIRCRAFT REFERENCE C.G. (FEET),
C          			WHERE
C					J=1 CORRESPONDS TO THE
C					    THE X-BODY AXIS
C					    COORDINATE OF THE
C 					    I-TH ENGINE	
C					J=2 CORRESPONDS TO THE
C					    THE Y-BODY AXIS
C					    COORDINATE OF THE
C 					    I-TH ENGINE	
C					J=3 CORRESPONDS TO THE
C					    THE Z-BODY AXIS
C					    COORDINATE OF THE
C 					    I-TH ENGINE	
C		XYANGL(I)	THE ANGLE IN THE X-Y BODY AXIS
C				PLANE FROM THE X-BODY AXIS TO
C                               THE PROJECTION OF THE I-TH ENGINE
C                               AXIS ONTO THE X-Y PLANE. (DEG)
C		XZANGL(I)       THE ANGLE BETWEEN THE X-Y BODY AXIS
C                               PLANE AND THE I-TH ENGINE AXIS
C                               PROJECTED ON THE X-Z' BODY/ENGINE AXIS
C		EIX(I)		THE MOMENT OF INERTIA ABOUT THE
C				X-ENGINE AXIS OF THE I-TH ENGINE
C                               (SLUG-FT**2).
C		AMSENG(I)	THE MASS OF THE ROTATING MACHINERY
C                               IN THE I-TH ENGINE (SLUGS)
C		ENGOMG(I) 	THE ROTATIONAL VELOCITY OF THE
C                               I-TH ENGINE. POSITIVE ROTATION IS
C                               MEASURED USING THE R.H.R. ABOUT THE
C                               X-ENGINE AXIS. (RAD/SEC)
C		TVANXY(I)       THE ANGLE IN THE X-Y ENGINE AXIS
C				PLANE FROM THE X-ENGINE AXIS TO
C                               THE PROJECTION OF THE I-TH THRUST VECTOR
C                               ONTO THE X-Y ENGINE PLANE. (DEG)
C		TVANXZ(I)       THE ANGLE BETWEEN THE X-Y ENGINE AXIS
C                               PLANE AND THE I-TH THRUST VECTOR
C                               PROJECTED ON THE X-Z' ENGINE/THRUST AXIS
C               DXTHRS(I)       THE DISTANCE BETWEEN THE C.G. OF THE
C                               ENGINE AND THE THRUST POINT MEASURED
C                               POSITIVE IN THE NEGATIVE ENGINE X-AXIS
C                               DIRECTION
C
C	/LLL015/
C
C		FPX		TOTAL THRUST IN THE X-BODY AXIS
C		FPY		TOTAL THRUST IN THE Y-BODY AXIS
C		FPZ		TOTAL THRUST IN THE Z-BODY AXIS
C               DCM             TOTAL PITCHING MOMENT INCREMENT
C                               DUE TO ENGINES
C               DCL             TOTAL ROLLING MOMENT INCREMENT
C                               DUE TO ENGINES
C               DCN             TOTAL YAWING MOMENT INCREMENT
C                               DUE TO ENGINES
C
C
      INTEGER I, J
C
      REAL T,      P,      Q,      R,    V,    ALP,    BTA,
     .     THA,    PSI,    PHI,    H,    X,    Y,
     .     TDOT,   PDOT,   QDOT,   RDOT, VDOT, ALPDOT, BTADOT,
     .     THADOT, PSIDOT, PHIDOT, HDOT, XDOT, YDOT
      REAL ANGLXZ, ANGLXY, CSANXZ, CSANXY, CSTAXY, CSTAXZ
      REAL SNANXZ, SNANXY, SNTAXZ, SNTAXY, TANGXZ, TANGXY
      REAL XTHRST, YTHRST, ZTHRST, XTHRSI, YTHRSI, ZTHRSI
      REAL HENGIN, TVECLC, TORQUE, GYRO
      REAL EIXE, EX, EY, EZ, OMEGX, OMEGY, OMEGZ, AINRTA
C
c     INCLUDE 'include.h'
      INCLUDE 'drvout.h'
      INCLUDE 'engstf.h'
      INCLUDE 'lll015.h'
      INCLUDE 'parameter.h'
C
      EQUIVALENCE (T      , F( 1)),
     .            (P      , F( 2)),(Q     , F( 3)),(R     , F( 4)),
     .            (V      , F( 5)),(ALP   , F( 6)),(BTA   , F( 7)),
     .            (THA    , F( 8)),(PSI   , F( 9)),(PHI   , F(10)),
     .            (H      , F(11)),(X     , F(12)),(Y     , F(13)),
     .            (TDOT   ,DF( 1)),
     .            (PDOT   ,DF( 2)),(QDOT  ,DF( 3)),(RDOT  ,DF( 4)),
     .            (VDOT   ,DF( 5)),(ALPDOT,DF( 6)),(BTADOT,DF( 7)),
     .            (THADOT ,DF( 8)),(PSIDOT,DF( 9)),(PHIDOT,DF(10)),
     .            (HDOT   ,DF(11)),(XDOT  ,DF(12)),(YDOT  ,DF(13))
C
C
C.... CALL USER ENGINE MODEL INTERFACE ROUTINE
C
      CALL UENGIN
C
C.... COMPUTE COMPONENTS OF THRUST.
C
      DO 1 I=1,4
C
         ANGLXZ = XZANGL(I)/DGR
         ANGLXY = XYANGL(I)/DGR
C
         CSANXZ(I) = COS(ANGLXZ)
         SNANXZ(I) = SIN(ANGLXZ)
         CSANXY(I) = COS(ANGLXY)
         SNANXY(I) = SIN(ANGLXY)
C
         TANGXY = TVANXY(I)/DGR
         TANGXZ = TVANXZ(I)/DGR
C
         CSTAXY = COS(TANGXY)
         SNTAXY = SIN(TANGXY)
         CSTAXZ = COS(TANGXZ)
         SNTAXZ = SIN(TANGXZ)
C
         XTHRSI =  THRUST(I) * CSTAXZ * CSTAXY
         YTHRSI =  THRUST(I) * CSTAXZ * SNTAXY
         ZTHRSI = -THRUST(I) * SNTAXZ
C
         XTHRST(I) = XTHRSI * CSANXZ(I) * CSANXY(I) -
     .        YTHRSI * SNANXY(I)             +
     .        ZTHRSI * SNANXZ(I) * CSANXY(I)
         YTHRST(I) = XTHRSI * CSANXZ(I) * SNANXY(I) +
     .        YTHRSI * CSANXY(I)             +
     .        ZTHRSI * SNANXZ(I) * CSANXY(I)
         ZTHRST(I) =-XTHRSI * SNANXZ(I)             +
     .        ZTHRSI * CSANXZ(I)
C
    1 CONTINUE
C
C.... COMPUTE TOTAL X-AXIS AND Z-AXIS THRUST.
C
      FPX   = 0.0
      FPY   = 0.0
      FPZ   = 0.0
C
      DO 2 I=1,4
C
         FPX   = FPX   + XTHRST(I)
         FPY   = FPY   + YTHRST(I)
         FPZ   = FPZ   + ZTHRST(I)
C
    2 CONTINUE
C
C.... COMPUTE ROTATIONAL EFFECTS (TORQUE) DUE TO ENGINE OFFSET FROM
C     CENTERLINE, AND THRUST VECTORING .
C
      TORQUE(1) = 0.0
      TORQUE(2) = 0.0
      TORQUE(3) = 0.0
C
      DO 3 I=1,4
C
         TVECLC(I,1) = TLOCAT(I,1) - DXTHRS(I) * CSANXZ(I) * CSANXY(I)
         TVECLC(I,2) = TLOCAT(I,2) - DXTHRS(I) * CSANXZ(I) * SNANXY(I)
         TVECLC(I,3) = TLOCAT(I,3) + DXTHRS(I) * SNANXZ(I)
C
         TORQUE(1) = TORQUE(1)
     .        +ZTHRST(I)*TVECLC(I,2)-YTHRST(I)*TVECLC(I,3)
         TORQUE(2) = TORQUE(2)
     .        +XTHRST(I)*TVECLC(I,3)-ZTHRST(I)*TVECLC(I,1)
         TORQUE(3) = TORQUE(3)
     .        +YTHRST(I)*TVECLC(I,1)-XTHRST(I)*TVECLC(I,2)
C
    3 CONTINUE
C
C.... COMPUTE ANGULAR MOMENTUM OF ENGINES
C
      DO 5 I=1,4
C
         OMEGX =  ENGOMG(I) * CSANXZ(I) * CSANXY(I)
         OMEGY =  ENGOMG(I) * CSANXZ(I) * SNANXY(I)
         OMEGZ = -ENGOMG(I) * SNANXZ(I)
C
         EIXE       = EIX(I)
         EX         = TLOCAT(I,1)
         EY         = TLOCAT(I,2)
         EZ         = TLOCAT(I,3)
C
C.... COMPUTE THE INERTIA TENSOR OF THE I-TH ENGINE
C     ABOUT THE AIRCRAFT REFERENCE C.G.
C
         AINRTA(1,1) =   EIXE*CSANXZ(I)*CSANXZ(I)*CSANXY(I)*CSANXY(I)
         AINRTA(1,2) =   EIXE*CSANXZ(I)*CSANXZ(I)*SNANXY(I)*CSANXY(I)
         AINRTA(1,3) = - EIXE*CSANXZ(I)*SNANXZ(I)*CSANXY(I)
         AINRTA(2,1) =   AINRTA(1,2)
         AINRTA(2,2) =   EIXE*SNANXY(I)*SNANXY(I)*CSANXZ(I)*CSANXZ(I)
         AINRTA(2,3) = - EIXE*SNANXZ(I)*CSANXZ(I)*SNANXY(I)
         AINRTA(3,1) =   AINRTA(1,3)
         AINRTA(3,2) =   AINRTA(2,3)
         AINRTA(3,3) =   EIXE*SNANXZ(I)*SNANXZ(I)
C
         DO 4 J=1,3
C
            HENGIN(I,J) =  OMEGX*AINRTA(J,1) + OMEGY*AINRTA(J,2)
     .           + OMEGZ*AINRTA(J,3)
C
 4       CONTINUE
C
    5 CONTINUE
C
C.... COMPUTE GYROSCOPIC EFFECTS.
C
      GYRO  (1)= 0.0
      GYRO  (2)= 0.0
      GYRO  (3)= 0.0
C
      DO 6 I=1,4
C
         GYRO  (1)=GYRO  (1) + Q     *HENGIN(I,3)
     .        - R     *HENGIN(I,2)
         GYRO  (2)=GYRO  (2) + R     *HENGIN(I,1)
     .        - P     *HENGIN(I,3)
         GYRO  (3)=GYRO  (3) + P     *HENGIN(I,2)
     .        - Q     *HENGIN(I,1)
C
    6 CONTINUE
C
C.... COMPUTE TOTAL MOMENT INCREMENT DUE TO ENGINES.
C
      DCL   = GYRO  (1) + TORQUE(1)
      DCM   = GYRO  (2) + TORQUE(2)
      DCN   = GYRO  (3) + TORQUE(3)
C
      RETURN
      END
