C
      SUBROUTINE ALTFN                                                          
C                                                                               
C.... ROUTINE PROVIDES BY TABLE LOOK UP                                         
C         VELOCITY OF SOUND            A - (FT/SEC)                             
C         ACCELERATION DUE TO GRAVITY  G - (FT/SEC**2)                          
C         AIR DENSITY                RHO - (SLUGS/FT**3)                        
C         AMBIENT STATIC PRESSURE     PA - (PSF)                                
C         AMBIENT AIR TEMPERATURE   TMPR - (DEG RANKIN)                         
C                                                                               
C.... AS A FUNCTION OF ALTITUDE, H (FT)                                         
C.... BREAK POINTS ON H ARE 3280.84 FT (1000.0 M)                               
C                                                                               
C.... INPUT  IS THRU COMMON /DRVOUT/ F,DF  (H IS F(11))                         
C.... OUTPUT IS THRU COMMON /ALTFUN/ A,RHO,G,PA,TMPR                            
C                                                                               
C.... WRITTEN 11/9/72 A MYERS  NASA FRC                                         
C.... TMPR ADDED   1 MAY 78   L SCHILLING   NASA/DFRC                           
C                                                                               
C
      INTEGER I1, I2
C
c     REAL AA, GA, H, PAA, RHOA, TMPRA
      REAL H
      REAL AA, GA, PAA, RHOA, TMPRA, FTBP
      REAL RBP, XI, R
c     REAL FTBP, RBP, XI, R
C                                                                               
      DIMENSION TMPRA(81)                                                       
      DIMENSION AA(81),RHOA(81),GA(81),PAA(81)                                  
C
c     INCLUDE 'include.h'
      INCLUDE 'altfun.h'
      INCLUDE 'drvout.h'
      INCLUDE 'lll032.h'
C
      EQUIVALENCE (H,F(11))                                                     
      DATA AA/1116.45,1103.79,1090.98,1078.03,1064.92,1051.66,1038.23,          
     .        1024.63,1010.84, 996.88, 982.72, 968.07, 968.07, 968.07,          
     .         968.07, 968.07, 968.07, 968.07, 968.07, 968.07, 968.07,          
     .         970.15, 972.37, 974.57, 976.77, 978.97, 981.15, 983.34,          
     .         985.52, 987.69, 989.86, 992.02, 994.28, 999.56,1005.54,          
     .        1011.48,1017.39,1023.25,1029.08,1034.88,1040.65,1046.38,          
     .        1052.07,1057.74,1063.37,1068.97,1074.54,1082.02,1082.02,          
     .        1082.02,1082.02,1082.02,1082.02,1079.77,1075.82,1071.86,          
     .        1067.89,1063.90,1059.90,1055.89,1051.86,1047.81,1042.09,          
     .        1033.92,1025.68,1017.39,1009.02,1000.59, 992.08, 983.51,          
     .         974.87, 966.15, 957.35, 948.47, 939.52, 930.48, 921.36,          
     .         912.14, 902.82, 893.44, 883.99/                                  
      DATA RHOA/                                                                
     .    .23769D-2,.21571D-2,.19531D-2,.17642D-2,.15898D-2,.14289D-2,          
     .    .12808D-2,.11448D-2,.10202D-2,.90625D-3,.80234D-3,.70783D-3,          
     .    .60526D-3,.51729D-3,.44212D-3,.37788D-3,.32301D-3,.27611D-3,          
     .    .23604D-3,.20179D-3,.17251D-3,.14691D-3,.12517D-3,.10673D-3,          
     .    .91075D-4,.77776D-4,.66470D-4,.56848D-4,.48655D-4,.41674D-4,          
     .    .35721D-4,.30642D-4,.26301D-4,.22455D-4,.19185D-4,.16422D-4,          
     .    .14083D-4,.12099D-4,.10413D-4,.89773D-5,.77529D-5,.67065D-5,          
     .    .58109D-5,.50427D-5,.43830D-5,.38153D-5,.33259D-5,.29037D-5,          
     .    .25548D-5,.22562D-5,.19925D-5,.17597D-5,.15541D-5,.13782D-5,          
     .    .12251D-5,.10880D-5,.96554D-6,.85609D-6,.75839D-6,.67123D-6,          
     .    .59358D-6,.52443D-6,.46434D-6,.41236D-6,.36554D-6,.32335D-6,          
     .    .28548D-6,.25154D-6,.22118D-6,.19403D-6,.16985D-6,.14823D-6,          
     .    .12921D-6,.11228D-6,.97309D-7,.84113D-7,.72490D-7,.62284D-7,          
     .    .53359D-7,.45578D-7,.38787D-7/                                        
      DATA GA/32.174,32.164,32.154,32.144,32.134,32.123,32.114,32.103,          
     .        32.093,32.083,32.073,32.063,32.053,32.043,32.033,32.023,          
     .        32.013,32.003,31.992,31.983,31.972,31.963,31.952,31.943,          
     .        31.932,31.923,31.912,31.903,31.892,31.883,31.872,31.863,          
     .        31.852,31.843,31.833,31.823,31.813,31.803,31.793,31.783,          
     .        31.773,31.763,31.753,31.743,31.733,31.723,31.713,31.703,          
     .        31.694,31.684,31.674,31.664,31.654,31.644,31.634,31.624,          
     .        31.615,31.605,31.595,31.585,31.575,31.565,31.555,31.546,          
     .        31.536,31.526,31.516,31.506,31.496,31.487,31.477,31.467,          
     .        31.457,31.448,31.438,31.427,31.417,31.407,31.398,31.388,          
     .        31.378/                                                           
      DATA PAA/                                                                 
     .     .211622D+4,.187711D+4,.166042D+4,.146451D+4,.128781D+4,              
     .     .112882D+4,.986161D+3,.858503D+3,.744600D+3,.643286D+3,              
     .     .553461D+3,.474097D+3,.405167D+3,.346272D+3,.295953D+3,              
     .     .252961D+3,.216223D+3,.184830D+3,.158003D+3,.135076D+3,              
     .     .115482D+3,.987659D+2,.845338D+2,.724070D+2,.620662D+2,              
     .     .532416D+2,.457051D+2,.392640D+2,.337551D+2,.290396D+2,              
     .     .250005D+2,.215383D+2,.185685D+2,.160256D+2,.138557D+2,              
     .     .120006D+2,.104118D+2,.904857D+1,.787671D+1,.686758D+1,              
     .     .599712D+1,.524502D+1,.459412D+1,.402987D+1,.354002D+1,              
     .     .311404D+1,.274311D+1,.241960D+1,.213649D+1,.188672D+1,              
     .     .166622D+1,.147155D+1,.129967D+1,.114774D+1,.101277D+1,              
     .     .892889D+0,.786488D+0,.692138D+0,.608547D+0,.534546D+0,              
     .     .469102D+0,.411271D+0,.360183D+0,.314857D+0,.274653D+0,              
     .     .239062D+0,.207616D+0,.179888D+0,.155489D+0,.134066D+0,              
     .     .115298D+0,.988932D-1,.845889D-1,.721470D-1,.613526D-1,              
     .     .520117D-1,.439533D-1,.370199D-1,.310722D-1,.259855D-1,              
     .     .216500D-1/                                                          
      DATA TMPRA / 518.670, 506.972, 495.277, 483.586, 471.899,                 
     .             460.217, 448.537, 436.860, 425.187, 413.159,                 
     .             401.854, 390.193, 389.970, 389.970, 389.970,                 
     .             389.970, 389.970, 389.970, 389.970, 389.970,                 
     .             389.970, 391.646, 393.433, 395.221, 397.008,                 
     .             398.794, 400.579, 402.365, 404.149, 405.932,                 
     .             407.716, 409.500, 411.282, 415.751, 420.737,                 
     .             425.723, 430.708, 435.690, 440.672, 445.651,                 
     .             450.630, 455.605, 460.580, 465.554, 470.525,                 
     .             475.495, 480.465, 485.431, 487.170, 487.170,                 
     .             487.170, 487.170, 487.170, 485.149, 481.608,                 
     .             478.069, 474.530, 470.993, 467.458, 463.923,                 
     .             460.390, 456.858, 451.883, 444.821, 437.764,                 
     .             430.708, 423.653, 416.603, 409.552, 402.505,                 
     .             395.460, 388.418, 381.377, 374.339, 367.303,                 
     .             360.270, 353.232, 346.212, 339.174, 332.154,                 
     .             325.170/                                                     
      DATA FTBP /3280.84/                                                       
      IF(H.LE.     0.0) GO TO 1                                                 
      IF(H.GE.262467.2) GO TO 2                                                 
C                                                                               
      RBP=H/FTBP                                                                
      XI=RBP+1.001                                                              
      I1=XI                                                                     
      I2=I1+1                                                                   
      XI=I1                                                                     
      R=RBP-XI+1.                                                               
      A  =R*(AA(I2)-AA(I1))+AA(I1)                                              
      RHO=R*(RHOA(I2)-RHOA(I1))+RHOA(I1)                                        
      G  =R*(GA(I2)-GA(I1))+GA(I1)                                              
      PA=R*(PAA(I2)-PAA(I1)) + PAA(I1)                                          
      TMPR=R*(TMPRA(I2)-TMPRA(I1))+TMPRA(I1)                                    
C                                                                               
C.... EQUATION FOR VISCOSITY (VMU) IS ACCURATE UP TO 90 KM ONLY.                
C                                                                               
      VMU = ( ( 7.3025D-07 ) * ( TMPR ) ** ( 1.5 ) ) / ( TMPR + 198.72 )        
C                                                                               
      RETURN                                                                    
C                                                                               
    1 A  =AA(1)                                                                 
      RHO=RHOA(1)                                                               
      G  =GA(1)                                                                 
      PA=PAA(1)                                                                 
      TMPR=TMPRA( 1)                                                            
C                                                                               
C.... EQUATION FOR VISCOSITY (VMU) IS ACCURATE UP TO 90 KM ONLY.                
C                                                                               
      VMU = ( ( 7.3025D-07 ) * ( TMPR ) ** ( 1.5 ) ) / ( TMPR + 198.72 )        
C                                                                               
      RETURN                                                                    
    2 A  =AA(81)                                                                
C                                                                               
      RHO=RHOA(81)                                                              
      G  =GA(81)                                                                
      PA=PAA(81)                                                                
      TMPR=TMPRA(81)                                                            
C                                                                               
C.... VISCOSITY ABOVE 90 KM SET AT 90 KM VALUE                                  
C                                                                               
      VMU = 8.32627D-06                                                         
C                                                                               
      RETURN                                                                    
      END                                                                       
