C
      SUBROUTINE AIRCAC                                                         
C                                                                               
C.... ROUTINE TO CALCULATE AIR DATA PARAMETERS.                                 
C                                                                               
C.... WRITTEN MAY 13, 1981                                                      
C     LEE DUKE NASA/DFRC                                                        
C
C
      REAL V
C
c     INCLUDE 'include.h'
      INCLUDE 'altfun.h'
      INCLUDE 'drvout.h'
      INCLUDE 'simout.h'
      INCLUDE 'lll021.h'
C     
      EQUIVALENCE (V      ,F     ( 5))                                          
C                                                                               
C.... INVOKE ATMOSPHERIC MODEL.                                                 
C                                                                               
      CALL ALTFN                                                                
C                                                                               
C.... COMPUTE MACH.                                                             
C                                                                               
      AMCH  =V     /A                                                           
C                                                                               
C.... COMPUTE DYNAMIC PRESSURE.                                                 
C                                                                               
      QBAR  =RHO   *V     **2/  2.0                                             
C                                                                               
C.... COMPUTE IMPACT PRESSURE.                                                  
C                                                                               
      IF(AMCH  .LE.  1.0 ) QC    =((  1.0 +  0.2 *AMCH  **2)**3.5               
     .                                    -  1.0 )*PA                           
C                                                                               
      IF(AMCH  .GT.  1.0 ) QC    =((       166.9 *AMCH  **2)/                   
     .                            ((  7.0 -  1.0 /AMCH  **2)**2.5)              
     .                                    -  1.0 )*PA                           
C                                                                               
C.... COMPUTE EQUIVALENT AIRSPEED.                                              
C                                                                               
      VEAS  = 17.17*SQRT  (QBAR  )                                             
C                                                                               
C.... COMPUTE CALIBRATED AIRSPEED.                                              
C                                                                               
      CALL VCAL                                                                 
C                                                                               
      RETURN                                                                    
      END                                                                       
