/* engine.f -- translated by f2c (version of 22 July 1992  22:54:52).
   You must link the resulting object file with the libraries:
	-lF77 -lI77 -lm -lc   (in that order)
*/

#ifdef __cplusplus
//extern "C" {
#endif
#include "f2c.h"

/* Common Block Declarations */

Extern struct {
    doublereal f[13], df[13];
} drvout_;

#define drvout_1 drvout_

Extern struct {
    doublereal fpx, fpy, fpz, dcm, dcl, dcn;
} lll015_;

#define lll015_1 lll015_

Extern struct {
    doublereal thrust[4];
    double tlocat[12]	/* was [4][3] */, xyangl[4], xzangl[4],
	    tvanxy[4], tvanxz[4], dxthrs[4], eix[4], amseng[4], engomg[4];
} engstf_;

#define engstf_1 engstf_

/* Subroutine */ int engine_()
{
    /* Local variables */
#define t      ((doublereal *)&drvout_1     )
#define p      ((doublereal *)&drvout_1 +  1)
#define q      ((doublereal *)&drvout_1 +  2)
#define r      ((doublereal *)&drvout_1 +  3)
#define v      ((doublereal *)&drvout_1 +  4)
#define bta    ((doublereal *)&drvout_1 +  6)
#define alp    ((doublereal *)&drvout_1 +  5)
#define tha    ((doublereal *)&drvout_1 +  7)
#define psi    ((doublereal *)&drvout_1 +  8)
#define phi    ((doublereal *)&drvout_1 +  9)
#define h      ((doublereal *)&drvout_1 + 10)
#define x      ((doublereal *)&drvout_1 + 11)
#define y      ((doublereal *)&drvout_1 + 12)
#define pdot   ((doublereal *)&drvout_1 + 14)
#define qdot   ((doublereal *)&drvout_1 + 15)
#define tdot   ((doublereal *)&drvout_1 + 13)
#define rdot   ((doublereal *)&drvout_1 + 16)
#define vdot   ((doublereal *)&drvout_1 + 17)
#define alpdot ((doublereal *)&drvout_1 + 18)
#define btadot ((doublereal *)&drvout_1 + 19)
#define thadot ((doublereal *)&drvout_1 + 20)
#define psidot ((doublereal *)&drvout_1 + 21)
#define phidot ((doublereal *)&drvout_1 + 22)
#define hdot   ((doublereal *)&drvout_1 + 23)
#define xdot   ((doublereal *)&drvout_1 + 24)
#define ydot   ((doublereal *)&drvout_1 + 25)

    extern /* Subroutine */ int uengin_();
    static integer i, j;
    static double anglxz, anglxy, csanxz[4], csanxy[4], cstaxz, cstaxy;
    static double snanxz[4], snanxy[4], sntaxz, sntaxy, tangxz, tangxy;
    static doublereal xthrst[4], ythrst[4], zthrst[4], xthrsi, ythrsi, zthrsi;
    static double hengin[12] /* was [4][3] */, tveclc[12] /* was [4][3] */;
    static doublereal torque[3], gyro[3];
    static double eixe, ex, ey, ez, omegx, omegy, omegz,
	ainrta[9] /* was [3][3] */;

/* .... ROUTINE TO COMPUTE EFFECTS OF ENGINE(S). */

/* .... WRITTEN FEBRUARY 1,1983 */
/*     LEE DUKE NASA/DFRF */

/* .... MODIFIED FOR DIFFERENT ANGLE DEFINITION JUNE, 1985 */
/*     JOE PAHLE  NASA/DFRF */



/* .... THE COMMON BLOCKS /ENGSTF/ AND /LLL015/ ARE THE MAIN I/O */
/*     COMMON BLOCKS FOR THIS ROUTINE. THE VARIABLES IN /ENGSTF/ */
/*     ARE DEFINED IN THE USER SUPPLIED ROUTINE UENGIN. THIS */
/*     ROUTINE COMPUTES THE VALUES OF THE VARIABLES IN /LLL015/ */
/*     AND SUPPLIES THEM TO OTHER ROUTINES. */

/*     THE VARIABLES IN THESE COMMON BLOCKS ARE: */

/*     /ENGSTF/ */

/* 		THRUST(I)	THE TOTAL THRUST OF THE I-TH */
/* 				ENGINE (LBS) */
/* 		TLOCAT(I,J)	THE DISPLACEMENT OF THE I-TH ENGINE */
/*                               FROM THE AIRCRAFT REFERENCE C.G. (FEET), 
*/
/*          			WHERE */
/* 					J=1 CORRESPONDS TO THE */
/* 					    THE X-BODY AXIS */
/* 					    COORDINATE OF THE */
/* 					    I-TH ENGINE */
/* 					J=2 CORRESPONDS TO THE */
/* 					    THE Y-BODY AXIS */
/* 					    COORDINATE OF THE */
/* 					    I-TH ENGINE */
/* 					J=3 CORRESPONDS TO THE */
/* 					    THE Z-BODY AXIS */
/* 					    COORDINATE OF THE */
/* 					    I-TH ENGINE */
/* 		XYANGL(I)	THE ANGLE IN THE X-Y BODY AXIS */
/* 				PLANE FROM THE X-BODY AXIS TO */
/*                               THE PROJECTION OF THE I-TH ENGINE */
/*                               AXIS ONTO THE X-Y PLANE. (DEG) */
/* 		XZANGL(I)       THE ANGLE BETWEEN THE X-Y BODY AXIS */
/*                               PLANE AND THE I-TH ENGINE AXIS */
/*                               PROJECTED ON THE X-Z' BODY/ENGINE AXIS */

/* 		EIX(I)		THE MOMENT OF INERTIA ABOUT THE */
/* 				X-ENGINE AXIS OF THE I-TH ENGINE */
/*                               (SLUG-FT**2). */
/* 		AMSENG(I)	THE MASS OF THE ROTATING MACHINERY */
/*                               IN THE I-TH ENGINE (SLUGS) */
/* 		ENGOMG(I) 	THE ROTATIONAL VELOCITY OF THE */
/*                               I-TH ENGINE. POSITIVE ROTATION IS */
/*                               MEASURED USING THE R.H.R. ABOUT THE */
/*                               X-ENGINE AXIS. (RAD/SEC) */
/* 		TVANXY(I)       THE ANGLE IN THE X-Y ENGINE AXIS */
/* 				PLANE FROM THE X-ENGINE AXIS TO */
/*                               THE PROJECTION OF THE I-TH THRUST VECTOR 
*/
/*                               ONTO THE X-Y ENGINE PLANE. (DEG) */
/* 		TVANXZ(I)       THE ANGLE BETWEEN THE X-Y ENGINE AXIS */
/*                               PLANE AND THE I-TH THRUST VECTOR */
/*                               PROJECTED ON THE X-Z' ENGINE/THRUST AXIS 
*/
/*               DXTHRS(I)       THE DISTANCE BETWEEN THE C.G. OF THE */
/*                               ENGINE AND THE THRUST POINT MEASURED */
/*                               POSITIVE IN THE NEGATIVE ENGINE X-AXIS */

/*                               DIRECTION */

/* 	/LLL015/ */

/* 		FPX		TOTAL THRUST IN THE X-BODY AXIS */
/* 		FPY		TOTAL THRUST IN THE Y-BODY AXIS */
/* 		FPZ		TOTAL THRUST IN THE Z-BODY AXIS */
/*               DCM             TOTAL PITCHING MOMENT INCREMENT */
/*                               DUE TO ENGINES */
/*               DCL             TOTAL ROLLING MOMENT INCREMENT */
/*                               DUE TO ENGINES */
/*               DCN             TOTAL YAWING MOMENT INCREMENT */
/*                               DUE TO ENGINES */




/*     INCLUDE 'include.h' */
/*     engine and uengin only */
/*     derivc, engine and instrm only */



/* .... CALL USER ENGINE MODEL INTERFACE ROUTINE */

    uengin_();

/* .... COMPUTE COMPONENTS OF THRUST. */

    for (i = 1; i <= 4; ++i) {

	anglxz = engstf_1.xzangl[i-1]/57.29578;
	anglxy = engstf_1.xyangl[i-1]/57.29578;

	csanxz[i-1] = cos(anglxz);
	snanxz[i-1] = sin(anglxz);
	csanxy[i-1] = cos(anglxy);
	snanxy[i-1] = sin(anglxy);

	tangxy = engstf_1.tvanxy[i-1]/57.29578;
	tangxz = engstf_1.tvanxz[i-1]/57.29578;

	cstaxy = cos(tangxy);
	sntaxy = sin(tangxy);
	cstaxz = cos(tangxz);
	sntaxz = sin(tangxz);

	xthrsi =  engstf_1.thrust[i-1]*cstaxz*cstaxy;
	ythrsi =  engstf_1.thrust[i-1]*cstaxz*sntaxy;
	zthrsi = -engstf_1.thrust[i-1]*sntaxz;

	xthrst[i-1] =  xthrsi*csanxz[i-1]*csanxy[i-1] - ythrsi*snanxy[i-1]
	    + zthrsi*snanxz[i-1]*csanxy[i-1];
	ythrst[i-1] =  xthrsi*csanxz[i-1]*snanxy[i-1] + ythrsi*csanxy[i-1]
	    + zthrsi*snanxz[i-1]*csanxy[i-1];
	zthrst[i-1] = -xthrsi*snanxz[i-1] + zthrsi*csanxz[i-1];

/* L1: */
    }

/* .... COMPUTE TOTAL X-AXIS AND Z-AXIS THRUST. */

    lll015_1.fpx = 0.;
    lll015_1.fpy = 0.;
    lll015_1.fpz = 0.;

    for (i = 1; i <= 4; ++i) {

	lll015_1.fpx += xthrst[i-1];
	lll015_1.fpy += ythrst[i-1];
	lll015_1.fpz += zthrst[i-1];

/* L2: */
    }

/* .... COMPUTE ROTATIONAL EFFECTS (TORQUE) DUE TO ENGINE OFFSET FROM */
/*     CENTERLINE, AND THRUST VECTORING . */

    torque[0] = 0.;
    torque[1] = 0.;
    torque[2] = 0.;

    for (i = 1; i <= 4; ++i) {

	tveclc[i-1] = engstf_1.tlocat[i-1]
		- engstf_1.dxthrs[i-1]*csanxz[i-1]*csanxy[i-1];
	tveclc[i+3] = engstf_1.tlocat[i+3]
		- engstf_1.dxthrs[i-1]*csanxz[i-1]*snanxy[i-1];
	tveclc[i+7] = engstf_1.tlocat[i+7]
		+ engstf_1.dxthrs[i-1]*snanxz[i-1];

	torque[0] = torque[0] + zthrst[i-1]*tveclc[i+3]
		- ythrst[i-1]*tveclc[i+7];
	torque[1] = torque[1] + xthrst[i-1]*tveclc[i+7]
		- zthrst[i-1]*tveclc[i-1];
	torque[2] = torque[2] + ythrst[i-1]*tveclc[i-1]
		- xthrst[i-1]*tveclc[i+3];

/* L3: */
    }

/* .... COMPUTE ANGULAR MOMENTUM OF ENGINES */

    for (i = 1; i <= 4; ++i) {

	omegx =  engstf_1.engomg[i-1]*csanxz[i-1]*csanxy[i-1];
	omegy =  engstf_1.engomg[i-1]*csanxz[i-1]*snanxy[i-1];
	omegz = -engstf_1.engomg[i-1]*snanxz[i-1];

	eixe = engstf_1.eix[i-1];
	ex   = engstf_1.tlocat[i-1];
	ey   = engstf_1.tlocat[i+3];
	ez   = engstf_1.tlocat[i+7];

/* .... COMPUTE THE INERTIA TENSOR OF THE I-TH ENGINE */
/*     ABOUT THE AIRCRAFT REFERENCE C.G. */

	ainrta[0] =  eixe*csanxz[i-1]*csanxz[i-1]*csanxy[i-1]*csanxy[i-1];
	ainrta[3] =  eixe*csanxz[i-1]*csanxz[i-1]*snanxy[i-1]*csanxy[i-1];
	ainrta[6] = -eixe*csanxz[i-1]*snanxz[i-1]*csanxy[i-1];
	ainrta[1] = ainrta[3];
	ainrta[4] =  eixe*snanxy[i-1]*snanxy[i-1]*csanxz[i-1]*csanxz[i-1];
	ainrta[7] = -eixe*snanxz[i-1]*csanxz[i-1]*snanxy[i-1];
	ainrta[2] = ainrta[6];
	ainrta[5] = ainrta[7];
	ainrta[8] =  eixe*snanxz[i-1]*snanxz[i-1];

	for (j = 1; j <= 3; ++j) {

	    hengin[i+(j<<2)-5] = omegx*ainrta[j-1] + omegy*ainrta[j+2]
		+ omegz*ainrta[j+5];

/* L4: */
	}

/* L5: */
    }

/* .... COMPUTE GYROSCOPIC EFFECTS. */

    gyro[0] = 0.;
    gyro[1] = 0.;
    gyro[2] = 0.;

    for (i = 1; i <= 4; ++i) {

	gyro[0] = gyro[0] + *q*hengin[i+7] - *r*hengin[i+3];
	gyro[1] = gyro[1] + *r*hengin[i-1] - *p*hengin[i+7];
	gyro[2] = gyro[2] + *p*hengin[i+3] - *q*hengin[i-1];

/* L6: */
    }

/* .... COMPUTE TOTAL MOMENT INCREMENT DUE TO ENGINES. */

    lll015_1.dcl = gyro[0] + torque[0];
    lll015_1.dcm = gyro[1] + torque[1];
    lll015_1.dcn = gyro[2] + torque[2];

    return 0;
} /* engine_ */

#undef psidot
#undef phidot
#undef thadot
#undef alpdot
#undef btadot
#undef ydot
#undef xdot
#undef vdot
#undef tdot
#undef rdot
#undef qdot
#undef pdot
#undef hdot
#undef psi
#undef phi
#undef tha
#undef alp
#undef bta
#undef y
#undef x
#undef v
#undef t
#undef r
#undef q
#undef p
#undef h


#ifdef __cplusplus
//	}
#endif
