/*
 *    Objekt definitios:   util.h
 *
 */
#ifndef __UTIL_H
#define __UTIL_H        1

#define TRUE            1
#define FALSE           0

#define S_UDEC           0 /* Marker fur alle im typ n.n. fix. Datenobj */
#define S_CONST          1 /* Konstante                                 */
#define S_LCONST         2 /* lokale Konstante                          */
#define S_PROC           5 /* definierte Prozedur oder Vergleich        */
#define S_UPROC          6 /* undefinierte Prozedur                     */
#define S_ARR            8 /* ist ARRAY und daher ggf implizit  VARPAR  */
#define S_STRING         9 /* ist ARRAY und daher ggf implizit  VARPAR  */
#define S_UNIT          13 /* pointer to UNIT                           */
#define S_USEL          14 /* pointer to UnitSelection (bzw. UnitSize)  */
#define S_NET           15
#define S_WSEL          16
#define S_PTR           17 /* pointer der allgemeinen art */
#define S_VPROC         21 /* Vector-wertige procedure    */
#define S_VECT          22 /* Vector                      */
#define S_UVEC          23 /* { USEL }:component          */
#define S_REC           31 /* record oder overlay         */
#define S_INT           32
#define S_REAL          33
#define S_ENUM          34
#define S_BOOL          35
#define S_CHAR          36
#define S_EXPR          41
#define S_FLD           20      /* FieldSize - kein objekt             */
#define S_ENQ           99      /* Id nicht eintragen nur Typ abfragen */
#define S_TYPE          51

#define L_NETLAY         1
#define L_SUBLAY         2
#define L_ENQ            3

#define MAXNEST         32    /* geschachtelte ProcedureCall's       */
#define MAXFDIM          8     /* maximale Dimensionen eines Fields */
#define MAXUSEL         12
#define MAXINC          12

#define V_ADD            2
#define V_SUB            3
#define V_MUL            4

typedef char * STRING;
typedef short BOOL;

typedef struct s_reflist
        {
            BOOL              ref;
            struct s_reflist *sr_next;
        } S_REFLIST;

typedef struct str_chain
        {
            STRING           s,
                             s_us;
            struct str_chain *str_next;
            short            str_typ;
        } STR_CHAIN;

typedef struct st_object
        {
            short  st_type;                   /* welcher typ? */
            struct st_object *st_next;
            STRING st_typid;                 /* typidentifier */
            union
            {
                struct s_object  *s_symb;   /* bei records/arrays... */
                struct st_object *st_desc;
            } symt;
        } ST_OBJECT;

typedef struct s_object
        {
            STRING     s_name;
            ST_OBJECT *s_type;
            union
            {
                struct
                {
                    int anzpar;
                    S_REFLIST *refi;
                    struct s_object *local_symbols;
                } funct;
                struct
                {
                    struct l_object *net_descriptor;
                    STRING s_dim[MAXFDIM];
                } netw;
            } s_descriptor;
            struct s_object *s_next;
        } S_OBJECT;

typedef struct s_chain
        {
            S_OBJECT       *s_next;
            struct s_chain *sc_next;
        } S_CHAIN;

typedef struct  l_object
        {
            STRING  l_name;
            STRING  l_dim[MAXFDIM];
            int     l_descflg;  /* TRUE => 1. Union FALSE => 2. Union */
            union
            {
                struct {
                    STRING  l_poolsiz;
                    STRING  l_poolunit;
                    STRING  l_fielddim[MAXFDIM];
                    STRING  l_fieldunit;
                    struct  l_object *l_sublay;
                } l_desc1;
                struct l_object *l_ptr;
            } l_desc;
            struct l_object *l_next;        /* weitere Objekte in der l- liste ? */
        } L_OBJECT;

typedef struct rnge
        {
            STRING       from,
                         to;
            struct rnge *r_next;
        } RANGE;

typedef struct cexp
        {
            STRING expr;
            STRING lastid;
            union
            {
                RANGE     *rlist;
                STR_CHAIN *str_next;
            } val;
            short xflg;
            ST_OBJECT *exprtyp;
        } CEXP;

typedef struct ctyp {
            STRING ctxt;
            STRING arrext;
            short ptr_dim;
            union {
                ST_OBJECT *typ_ptr;
                int typfl;
            } obj;
        } CTYP;

void       init_symtab    (void                        );
ST_OBJECT* st_ptr         (int                         );
ST_OBJECT* s_getp_type    (ST_OBJECT*                  );
ST_OBJECT* st_lookup      (STRING,    ST_OBJECT*       );
ST_OBJECT* s_lookup       (STRING,    int              );
void       s_updatetyp    (short,     ST_OBJECT*, short);
void       s_append       (S_OBJECT*, BOOL, short      );
BOOL       s_search_chain (           STRING           );
void       s_cleanup      (S_OBJECT*                   );
L_OBJECT*  in_netlay      (L_OBJECT*, STRING           );
BOOL       in_upper_lay   (STRING                      );
BOOL       dupl_lay       (STRING                      );

void out (STRING);

STRING strsave (STRING                                        );
STRING strcat2 (STRING, STRING                                );
STRING strcat3 (STRING, STRING, STRING                        );
STRING strcat4 (STRING, STRING, STRING, STRING                );
STRING strcat5 (STRING, STRING, STRING, STRING, STRING        );
STRING strcat6 (STRING, STRING, STRING, STRING, STRING, STRING);

int yylex  (void  );
int yyparse(void  );
int yyerror(STRING);

void      pushp          (S_OBJECT **, S_REFLIST **      );
void      popp           (S_OBJECT **, S_REFLIST **      );
void      free_all_range (RANGE *                        );
STRING    indimlst       (STRING, STRING                 );
STRING    init_zero      (STRING                         );
STRING    make_varp      (STRING, short                  );
void      del_para       (STRING                         );
RANGE*    rangesave      (RANGE                          );
L_OBJECT* l_lookup       (STRING, short                  );
RANGE     append_range   (RANGE *, RANGE *               );
STRING    upstr          (STRING                         );
BOOL      in_chain       (STRING                         );
void      ins_str_chain  (STRING                         );
void      def_top        (L_OBJECT *                     );
void      allo_nsub_fld  (STRING, L_OBJECT *, short, int );
void      allo_ntop      (STRING, STRING, STRING *, short, int);
BOOL      cre_top        (STRING, STRING *, int          );
void      print_usp      (STR_CHAIN  *                   );
BOOL      unit_check     (L_OBJECT*, short               );
void      complex_ass    (CEXP, CEXP, short              );
CEXP      complex_vec_eq (CEXP, CEXP, short              );
CEXP      vec_neg        (CEXP                           );
CEXP      compute_vect   (short, CEXP, CEXP              );

#endif
