%{

/*
 *        Compiler-Generater: condela.y
 *
 */

#define __CONDELA_Y 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "util.h"
#include "error.h"

#define NO_CONST        if (sr_actual && sr_actual->ref && !rec_var) \
                        {                                           \
                           Error(11);                               \
                           YYERROR;                                 \
                        }

#define SNET              0
#define LNET              1
#define CNET              2

#define IS_KNOWN(x)       (x->st_type != 0     )
#define IS_PTR(x)         (x->st_type == S_PTR )
#define IS_RECORD(x)      (x->st_type == S_REC )
#define IS_VEC(x)         (x->st_type == S_VECT)
#define IS_EXPR(x)        (x->st_type == S_EXPR)
#define IS_USEL(x)        (x->st_type == S_USEL)
#define IS_NET(x)         (x->st_type == S_NET )
#define IS_REC(x)         (x->st_type == S_REC )
#define IS_UNIT(x)        (x->st_type == S_UNIT)
#define IS_ARRAY(x)       (x->st_type == S_ARR    || x->st_type == S_STRING)
#define IS_PROC(x)        (x->st_type == S_PROC   || x->st_type == S_UPROC)
#define IS_CONST(x)       (x->st_type == S_CONST  || x->st_type == S_LCONST)
#define IS_VAL(x)         (x->st_type == S_PROC   || x->st_type == S_UPROC  || \
                           x->st_type == S_BOOL   || x->st_type == S_INT    || \
                           x->st_type == S_EXPR   || x->st_type == S_CONST  || \
                           x->st_type == S_LCONST || x->st_type == S_REAL   || \
                           x->st_type == S_UDEC                              \
                          )
#define IS_POINTER_TYPE(x)(x->st_type == S_USEL || x->st_type == S_NET ||  \
                           x->st_type == S_UNIT ||                         \
                             (                                             \
                                x->st_type == S_PTR &&                       \
                                (st_actual?(st_actual->st_type!= S_TYPE):1))\
                             )
#define BLOCKED(x)        (                                               \
                           x->st_type == S_NET    || x->st_type == S_UNIT  || \
                           x->st_type == S_USEL   || x->st_type == S_VECT     \
                          )

#define L_ACTUAL(x)     if (x>= MAXNEST)  Error(300+x); else
#define CREDIM(x)       if (x>= MAXFDIM)  Error(400+x); else
#define USEL_STK(x) if (x>= MAXUSEL)      Error(500+x); else

#define ALLOC(typ) (typ *)calloc(1,sizeof(typ))

extern FILE      *yyin,
                 *yyout;
extern int       yynerrs, sourcesp;
extern FILE      *sourcefp[MAXINC];
extern short     l_aptr;
extern S_CHAIN   *s_chain_root;
extern S_OBJECT  *s_root;
extern STRING    yysource[MAXINC];
extern L_OBJECT  *l_root,
                 *l_actual[MAXNEST];

BOOL      reset      = FALSE,
          ldim_used  = FALSE,
          conn       = FALSE,
          block_lu   = FALSE,
          no_u_ident = FALSE,
          rec_var    = FALSE;
short     in_record  = 0,
          inloop     = 0,
          s_sp       = 0,
          vec_cnt    = 0,
          dim_ptr    = 0,
          usel_ptr   = 0,
          idx_cnt    = 0,
          range_cnt  = 0,
          varscn     = 0,
          curl_lay   = 0,
          ii;
char      lcnt     [8],
          c_buf    [700],
          cw_buf   [700],
          clos_buf [16][52],
          uscs = 'i';
STRING    credim[MAXFDIM];
ST_OBJECT *st_actual;
S_OBJECT  *s_pdecl_start = 0,
          *s_actual      = 0,
          *current_proc  = 0;
S_REFLIST *sr_actual     = 0,
          *sr_dummy;
L_OBJECT  *usel_stk[MAXUSEL],
          *lay_ref = 0;

%}

%token AND APPLY ARRAY BEGN BOOLCONST BOOLEAN BY CHAR CHARCONST CONNECT CONST
%token CONTINUE CREATE DO ELSE END ENUM EXITLOOP EXTEND FIELD FLOATCONST FOR ELSIF
%token FOREVER FROM IDENT INTCONST STRINGCONST INIT INTEGER INTERSECT IS IF IN CASE
%token JOIN LAYER LESS LOOP MOD MODULE NIL NETWORK NODUPLICATE NOT NUL OF OR POINTER
%token OVERLAY POOL PROCEDURE REAL RECORD REPEAT RETURN STRNG THEN TIMES TO ARROW VBAR
%token TOPOLOGY TYPE U_IDENT UNIT UNTIL USEL VAR VECT WEIGHT WHILE COLON PERIOD ASGN
%token LBRCK RBRCK LCURL RCURL LPAR RPAR DOT COMMA SEMI EQ LT GT LE GE NE ADD SUB MUL DIV
%token LOAD SAVE ADROF

%left NOT
%nonassoc EQ LT LE GT GE NE
%left ADD SUB OR
%left MUL DIV MOD AND
%left UMINUS
%left ADROF

%union { BOOL byref; RANGE range; CEXP cexp; CTYP ctyp; STR_CHAIN usp; }

%type <byref>FieldDef   PoolDef         LayerDefs       NetSelection    OptionalVar

%type <range>Range      RangeList       OptUpperRange

%type <cexp>Expr        Factor          OptionalExpr    OptionalExt     Value
%type <cexp>OptionalInc ParamList       ProcedureCall   SimpleExpr
%type <cexp>Times       Variable        IDENT           OptionalWeight  OptionalCompo
%type <cexp>PoolId      FieldId         UnitIdent       LayerIdent      UnitOp
%type <cexp>INTCONST    BOOLCONST       FLOATCONST      STRINGCONST     CHARCONST
%type <cexp>Target      U_IDENT

%type <ctyp>ArrayType   EnumType        FDimList        FormalParam     OptionalType
%type <ctyp>IdentList   OptionalResult  OverlayType     RecordType      LayerStruct
%type <ctyp>SimpleType  Type            VarDeclaration  VarDecls        LDimList
%type <ctyp>OptionalDup PointerType

%type <usp>UnitSets     UnitSelection   ToUnitSelection

%start CompilationUnit

%%

CompilationUnit :
    ModuleId DefaultUnit DefaultWeight
    {
        init_symtab();
        out("#include \"condela.h\"\n");
    }
    DDeclarations PDeclarations
  ;

ModuleId:
  | MODULE IDENT SEMI
  ;

DefaultUnit:
  | UNIT IS IDENT SEMI
    {
        fprintf(yyout, "#define UNIT %s\n",$<cexp.expr>3);
        yyerrok;
    }
  ;

DefaultWeight:
  | WEIGHT IS IDENT SEMI
    {
        fprintf(yyout, "#define WEIGHT %s\n",$<cexp.expr>3);
        yyerrok;
    }
  ;

DDeclarations:
  | DDeclarations DataDeclaration  { yyerrok; }
  | DDeclarations StrucDeclaration { yyerrok; }
  | DDeclarations error
  ;

PDeclarations:
  | PDeclarations ProcDeclaration { yyerrok; }
  | PDeclarations error
  ;

DataDeclaration :
    CONST ConstDecls
  | TYPE  TypeDecls
  | VAR   VarDecls  { fprintf(yyout,"%s\n", $<ctyp.ctxt>2); }
  ;

ConstDecls:
    ConstDeclaration
  | ConstDecls ConstDeclaration
  | error
  ;

TypeDecls:
    TypeDeclaration
  | TypeDecls TypeDeclaration
  | error
  ;

VarDecls:
    VarDeclaration
  | VarDecls VarDeclaration
    {     $<ctyp.ctxt>$ = strcat2 ($<ctyp.ctxt>1, $<ctyp.ctxt>2); }
  | error
    {     $<ctyp.ctxt>$ = strsave("");                             }
  ;

ConstDeclaration:
    IDENT EQ Expr SEMI
    {
        if (!s_pdecl_start)
        {
            if (s_lookup($<cexp.expr>1,S_CONST)->st_type)
                Warning(4);
        }
        else if (s_lookup($<cexp.expr>1,S_LCONST)->st_type)
        {
            Error(7);
            YYERROR;
        }
        fprintf(yyout,"#define %s (%s)\n",$<cexp.expr>1,$<cexp.expr>3);
        vec_cnt = 0;
    }
  ;

TypeDeclaration:
    IDENT EQ Type SEMI
    {
        st_actual = 0;

        if (st_lookup($<cexp.expr>1,$<ctyp.obj.typ_ptr>3))
        {
             Error(7);
             YYERROR;
        }
        else if (IS_NET($<ctyp.obj.typ_ptr>3))
        {
            Error(21);
            break;
        }

        if (IS_POINTER_TYPE($<ctyp.obj.typ_ptr>3))
            $<cexp.expr>1 = make_varp($<cexp.expr>1, 0);

        fprintf(
            yyout,
            "typedef %s %s%s;\n",
            $<ctyp.ctxt>3,
            $<cexp.expr>1,
            $<ctyp.arrext>3 ? $<ctyp.arrext>3 : ""
        );
    }
  ;

VarDeclaration:
    IdentList COLON Type SEMI
    {
        if (
            (
               IS_NET                  ($<ctyp.obj.typ_ptr>3) ||
               IS_UNIT                 ($<ctyp.obj.typ_ptr>3) ||
               IS_USEL                 ($<ctyp.obj.typ_ptr>3) ||
               IS_POINTER_TYPE ($<ctyp.obj.typ_ptr>3)
              ) && ++dim_ptr>0
        )
        {
            do
                $<ctyp.ctxt>1 = make_varp($<ctyp.ctxt>1,0);
            while (--dim_ptr>0);
        }

        dim_ptr   = 0;
        st_actual = 0;

        if (IS_USEL($<ctyp.obj.typ_ptr>3))
            $<ctyp.ctxt>1 = init_zero($<ctyp.ctxt>1);

        $<ctyp.ctxt>1 = indimlst($<ctyp.ctxt>1, $<ctyp.arrext>3);
        $<ctyp.ctxt>$ = strcat4($<ctyp.ctxt>3, " ", $<ctyp.ctxt>1, ";\n");

        s_updatetyp($<ctyp.obj.typfl>1,$<ctyp.obj.typ_ptr>3,0);
    }
  ;

Type:
    SimpleType
  | ArrayType
  | OverlayType
  | RecordType
  | EnumType
  | PointerType
  | NETWORK { dim_ptr = 0; } LDimList OF IDENT
    {
        if (!l_lookup($<cexp.expr>5,L_ENQ))
            Error(14);
        else if (in_record)
            Error(22);

        $<ctyp.ctxt>$        = upstr($<cexp.expr>5);
        $<ctyp.arrext>$      = 0;
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_NET);
    }
  ;

SimpleType:
    BOOLEAN
    {
        $<ctyp.ctxt>$        = strsave("short");
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_BOOL);
        $<ctyp.arrext>$      = 0;
    }
  | CHAR
    {
        $<ctyp.ctxt>$        = strsave("char");
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_CHAR);
        $<ctyp.arrext>$      = 0;
    }
  | STRNG
    {
        $<ctyp.ctxt>$        = strsave("STRING");
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_STRING);
        $<ctyp.arrext>$      = 0;
    }
  | INTEGER
    {
        $<ctyp.ctxt>$        = strsave("int");
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_INT);
        $<ctyp.arrext>$      = 0;
    }
  | REAL
    {
        $<ctyp.ctxt>$        = strsave("float");
        $<ctyp.arrext>$      = 0;
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_REAL);
    }
  | VECT
    {   $<ctyp.ctxt>$        = strsave("VECTOR");
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_VECT);
        $<ctyp.arrext>$      = 0;
    }
  | USEL
    {
        $<ctyp.ctxt>$        = strsave("USEL");
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_USEL);
        $<ctyp.arrext>$      = 0;
    }
  | IDENT
    {
        st_actual            = 0;
        $<ctyp.obj.typ_ptr>$ = st_lookup ($<cexp.expr>1,(ST_OBJECT *)S_UDEC);

        if (!$<ctyp.obj.typ_ptr>$)
        {
            Warning(5);
            $<ctyp.obj.typ_ptr>$ = st_ptr(S_UDEC);
        }
        $<ctyp.ctxt>$   = strsave ($<cexp.expr>1);
        $<ctyp.arrext>$ = 0;
    }
  | UNIT OptionalType
    {
        $<ctyp.ctxt>$        = strsave ($<cexp.expr>2);
        $<ctyp.obj.typ_ptr>$ = st_ptr (S_UNIT       );
        $<ctyp.arrext>$      = 0;
    }
  ;

ArrayType:
    ARRAY FDimList OF Type
    {
        ST_OBJECT *aux = ALLOC(ST_OBJECT),
                  *a,
                  *b;

        if (!aux)
            FatalError (ERR_MEMORY);

        aux->st_type     = S_ARR;
        aux->symt.s_symb = 0;

        a =
        b = aux;

        while (--($<ctyp.obj.typfl)>2)
        {
            a = ALLOC(ST_OBJECT);

            if (!a)
                FatalError (ERR_MEMORY);

            b->st_next     = a;
            a->st_type     = S_ARR;
            a->symt.s_symb = 0;
            b              = a;
        }

        a->st_next           = $<ctyp.obj.typ_ptr>4;
        $<ctyp.obj.typ_ptr>$ = aux;
        $<ctyp.ctxt>$        = strsave ($<ctyp.ctxt>4);

        if (IS_NET($<ctyp.obj.typ_ptr>4))
            Error(21);

         $<ctyp.arrext>$ = strcat2(
                              $<ctyp.ctxt>2,
                              $<ctyp.arrext>4 ? $<ctyp.arrext>4 : ""
                          );
    }
  ;

RecordType:
    RECORD
    {
       in_record++;
       pushp(&s_root,&sr_dummy);
    }
    VarDecls
    END
    {
        ST_OBJECT *aux = ALLOC(ST_OBJECT);

        if (!aux)
            FatalError (ERR_MEMORY);

        aux->st_type     = S_REC;
        aux->st_next     = 0;
        aux->symt.s_symb = s_root; popp(&s_root,&sr_dummy);

        $<ctyp.ctxt>$        = strcat3("struct{",$<ctyp.ctxt>3,"}");
        $<ctyp.arrext>$      = 0;
        $<ctyp.obj.typ_ptr>$ = aux;

        in_record--;
    }
  ;

OverlayType:
    OVERLAY
    {
       in_record++;
       pushp(&s_root,&sr_dummy);
    }
    VarDecls
    END
    {
        ST_OBJECT *aux = ALLOC(ST_OBJECT);

        if (!aux)
            FatalError (ERR_MEMORY);

        aux->symt.s_symb = s_root;
        aux->st_type     = S_REC;
        aux->st_next     = 0;

        popp(&s_root,&sr_dummy);

        $<ctyp.ctxt>$        = strcat3("union{", $<ctyp.ctxt>3, "}");
        $<ctyp.arrext>$      = 0;
        $<ctyp.obj.typ_ptr>$ = aux;

        in_record--;
    }
  ;

EnumType:
    ENUM
    IdentList
    END
    {
        ST_OBJECT *aux = ALLOC(ST_OBJECT);

        if (!aux)
            FatalError (ERR_MEMORY);

        aux->st_type     = S_ENUM;
        aux->symt.s_symb = 0;
        aux->st_next     = 0;

        $<ctyp.ctxt>$        = strcat3("enum{",$<ctyp.ctxt>2,"}");
        $<ctyp.arrext>$      = 0;
        $<ctyp.obj.typ_ptr>$ = aux;

        s_updatetyp ($<ctyp.obj.typfl>2, st_ptr(S_INT), 0);
    }
  ;

PointerType:
    POINTER TO SimpleType
    {
        $<ctyp.obj.typ_ptr>$ = ALLOC(ST_OBJECT);

        if (!$<ctyp.obj.typ_ptr>$)
            FatalError (ERR_MEMORY);

        $<ctyp.arrext>$               = 0;
        $<ctyp.ctxt>$                 = strsave ($<ctyp.ctxt>3);
        $<ctyp.obj.typ_ptr>$->st_next = $<ctyp.obj.typ_ptr>3;
        $<ctyp.obj.typ_ptr>$->st_type = S_PTR;
    }
  ;

StrucDeclaration:
    TOPOLOGY NDeclarations
    {
        if (!yynerrs)
            def_top(l_root);
    }
  ;

NDeclarations:
    NetDeclaration
  | NDeclarations NetDeclaration
  ;

NetDeclaration:
    IDENT
    {
        l_aptr++;
        if (l_lookup($<cexp.expr>1,L_NETLAY))
        {
            Error(7);
            YYERROR;
        }
    }
    OptionalNetSel
    {
        L_ACTUAL(l_aptr);
        l_actual[l_aptr--]->l_descflg = TRUE;
    }
  | error
  ;

OptionalNetSel:
    SEMI
    {
        L_ACTUAL(l_aptr);
        l_actual[l_aptr]->l_desc.l_desc1.l_poolsiz = strsave("0");
        l_actual[l_aptr]->l_desc.l_desc1.l_poolunit = strsave("UNIT");
    }
  | EQ NetSelection
    {
        if (!$<byref>2)
            Error(19);
    }
  ;

NetSelection:
    FieldDef PoolDef LayerDefs
    {
        $<byref>$ = $<byref>1 || $<byref>2 || $<byref>3;
    }
  ;

FieldDef:
    {
        $<byref>$ = FALSE;
    }
  | FIELD FDimList OptionalType SEMI
    {
        $<byref>$ = TRUE;
        L_ACTUAL(l_aptr);
        l_actual[l_aptr]->l_desc.l_desc1.l_fieldunit = strsave($<ctyp.ctxt>3);
    }
  ;

PoolDef:
    {
        L_ACTUAL(l_aptr);
        l_actual[l_aptr]->l_desc.l_desc1.l_poolsiz  = 0;
        l_actual[l_aptr]->l_desc.l_desc1.l_poolunit = strsave("UNIT");

        $<byref>$ = FALSE;
    }
  | POOL LPAR SimpleExpr RPAR OptionalType SEMI
    {
        if (BLOCKED($<cexp.exprtyp>3))
            Error(2);

        L_ACTUAL(l_aptr);
        l_actual[l_aptr]->l_desc.l_desc1.l_poolsiz  = strsave ($<cexp.expr>3);
        l_actual[l_aptr]->l_desc.l_desc1.l_poolunit = strsave ($<ctyp.ctxt>5);

        $<byref>$ = TRUE;
    }
  ;

OptionalType:
    {
        $<ctyp.ctxt>$ = strsave("UNIT");
    }
  | OF IDENT
    {
        $<ctyp.ctxt>$ = strsave ($<cexp.expr>2);
    }
  ;

LayerDefs:
    {
        $<byref>$ = FALSE;
    }
  | LayerDefs LayerDef
    {
        $<byref>$ = TRUE;
    }
  ;

LayerDef:
    LAYER IDENT
    {
        if (dupl_lay($<cexp.expr>2) || l_lookup($<cexp.expr>2,L_SUBLAY))
            Error(7);
        else if (in_upper_lay($<cexp.expr>2))
            Error(20);

        l_aptr++;
        dim_ptr = 0;
    }
    LDimList OF LayerStruct SEMI
    {
       l_aptr--;
    }
  ;

LayerStruct:
    NetSelection END
    {
        L_ACTUAL(l_aptr);
        l_actual[l_aptr]->l_descflg = TRUE;
    }
  | IDENT
    {
        L_ACTUAL(l_aptr);
        l_actual[l_aptr]->l_descflg = FALSE;

        l_actual[l_aptr]->l_desc.l_ptr = l_lookup($<cexp.expr>1,L_ENQ);

        if (!l_actual[l_aptr]->l_desc.l_ptr)
           Error(18);
        else if (in_upper_lay($<cexp.expr>1))
           Error(20);
    }
  ;

FDimList:
    LBRCK SimpleExpr RBRCK
    {
        $<ctyp.ctxt>$ = strcat3("[",$<cexp.expr>2,"]");
        $<ctyp.obj.typfl>$ = 1;

        if (BLOCKED($<cexp.exprtyp>2))
            Error(2);

        L_ACTUAL(l_aptr);

        if (l_actual[l_aptr])
        {
            dim_ptr = 0;
            l_actual[l_aptr]->
                l_desc.l_desc1.l_fielddim[dim_ptr] = strsave($<cexp.expr>2);
        }
    }
  | FDimList LBRCK SimpleExpr RBRCK
    {
        $<ctyp.ctxt>$ = strcat4($<cexp.expr>1,"[",$<cexp.expr>3,"]");
        $<ctyp.obj.typfl>$ = $<ctyp.obj.typfl>1+1;

        if (BLOCKED($<cexp.exprtyp>3))
            Error(2);

        L_ACTUAL(l_aptr);

        if (l_actual[l_aptr])
        {
            dim_ptr++;

            l_actual[l_aptr]->
                l_desc.l_desc1.l_fielddim[dim_ptr] = strsave ($<cexp.expr>3);
        }
    }
  ;

LDimList:
    {
        $<ctyp.ctxt>$ = strsave("");
        ldim_used     = FALSE;
    }
  | LDimList LT SimpleExpr GT
    {
        L_ACTUAL(l_aptr);

        if (l_aptr>1 && l_actual[l_aptr])
        {
            l_actual[l_aptr]->l_dim[dim_ptr++] = $<cexp.expr>3;

            if (!IS_CONST($<cexp.exprtyp>3))
                Error(24);
        }
        else
        {
            if (BLOCKED($<cexp.exprtyp>3))
                Error(2);

            CREDIM(dim_ptr);
            credim[dim_ptr++] = strsave ($<cexp.expr>3);
        }

        $<ctyp.ctxt>$ = strcat4($<ctyp.ctxt>1,"[",$<cexp.expr>3,"]");
        ldim_used = TRUE;
    }
  ;

ProcDeclaration:
    PROCEDURE IDENT
    {
        if (s_lookup($<cexp.expr>2,S_PROC)->st_type)
            Error(6);

        s_pdecl_start = s_root;

        pushp (&s_root, &sr_dummy);
    }
    LPAR FormalParam RPAR OptionalResult SEMI
    {
        fprintf(
            yyout,
            "\n%s %s(%s)\n%s\n{\n",
            $<ctyp.ctxt>7,
            $<cexp.expr>2,
            $<ctyp.arrext>5,
            $<ctyp.ctxt>5
        );

        if (IS_VEC($<ctyp.obj.typ_ptr>7))
            s_actual->s_type = st_ptr(S_VPROC);
    }
    DDeclarations
    {     /* definition of local types are not allowed  */
        current_proc                               =
        s_actual->s_descriptor.funct.local_symbols = s_root;

        popp(&s_root, &sr_dummy);
    }
    BEGN StatementSeq END SEMI
    {
        out       ("}\n"       );
        s_cleanup (current_proc);

        current_proc = 0;
    }
  ;

FormalParam:
    {
        $<ctyp.ctxt>$                       = strsave("");
        $<ctyp.arrext>$                     = strsave("");
        s_chain_root                        = 0;
        s_actual->s_descriptor.funct.anzpar = 0;
        s_actual->s_descriptor.funct.refi   = 0;
    }
  | OptionalVar IdentList COLON SimpleType
    {
        ST_OBJECT *aux = $<ctyp.obj.typ_ptr>4;

        if ($<byref>1 || IS_POINTER_TYPE($<ctyp.obj.typ_ptr>4))
            $<ctyp.ctxt>2 = make_varp($<ctyp.ctxt>2, aux->st_type);

        $<ctyp.ctxt>$   = strcat4 ($<ctyp.ctxt>4," ", $<ctyp.ctxt>2,";");
        $<ctyp.arrext>$ = strsave  ($<ctyp.ctxt>2                       );

        s_updatetyp($<ctyp.obj.typfl>2,$<ctyp.obj.typ_ptr>4,$<byref>1);

        s_actual->s_descriptor.funct.anzpar += $<ctyp.obj.typfl>2;

        s_append(s_actual, IS_ARRAY(aux) ? 0 : $<byref>1, $<ctyp.obj.typfl>2);
    }
  | FormalParam SEMI OptionalVar IdentList COLON SimpleType
    {
        ST_OBJECT *aux = $<ctyp.obj.typ_ptr>6;

        if (($<byref>3 || IS_POINTER_TYPE($<ctyp.obj.typ_ptr>6)))
            $<ctyp.ctxt>4 = make_varp($<ctyp.ctxt>4, aux->st_type);

        $<ctyp.ctxt>$ = strcat5(
                           $<ctyp.ctxt>1,
                           $<ctyp.ctxt>6,
                           " ",
                           $<ctyp.ctxt>4,
                           ";"
                        );

        $<ctyp.arrext>$ = strcat3($<ctyp.arrext>1,",",$<ctyp.ctxt>4);

        s_updatetyp($<ctyp.obj.typfl>4,$<ctyp.obj.typ_ptr>6,$<byref>3);

        s_actual->s_descriptor.funct.anzpar += $<ctyp.obj.typfl>1+$<ctyp.obj.typfl>4;
        s_append (s_actual, IS_ARRAY(aux) ? 0: $<byref>3, $<ctyp.obj.typfl>4);
    }
  ;

OptionalVar:
    {
        $<byref>$ = FALSE;
    }
  | VAR
    {
       $<byref>$ = TRUE;
    }
  ;

OptionalResult:
    {
        $<ctyp.ctxt>$        = strsave("void");
        $<ctyp.obj.typ_ptr>$ = st_ptr(S_UDEC);
    }
  | COLON SimpleType
    {
        $$ = $2;
    }
  ;

StatementSeq:
  | Statement SEMI StatementSeq
  ;

Statement:
    EXITLOOP
    {
        if (!inloop)
        {
            Error(3);
            YYERROR;
        }
        out("break;");
    }
  | CONTINUE
    {
        if (!inloop)
        {
           Error(3);
           YYERROR;
        }
        out("continue;");
    }
  | FOR Variable FROM
    {
        for (; varscn; varscn--)
            popp(&s_root, &sr_dummy);
    }
    Expr TO Expr OptionalInc
    {
        if (reset)
            fprintf(yyout,"reset_rng();");

        fprintf(
            yyout,
            "for(%s = %s;%s%s<= %s;%s+= %s){\n",
            $<cexp.expr>2,
            $<cexp.expr>5,
            reset ? "reset_rng(), ":"",
            $<cexp.expr>2,
            $<cexp.expr>7,
            $<cexp.expr>2,
            $<cexp.expr>8
        );
        inloop++;
        vec_cnt = 0;
        reset   = FALSE;
    }
    DO StatementSeq END
    {
       out("}");
       inloop--;
    }
  | FOR Variable
    {
        if (!IS_UNIT ($<cexp.exprtyp>2))
            Error(29);

        uscs = (char)((short)'a'+inloop);
    }
    IN UnitSelection
    {
        fprintf(
            yyout,
            "{USEL *us%c = %s;",
            uscs,
            $<usp.str_typ>5 == S_NET ? "0" : $<cexp.expr>2
        );

        if ($<usp.str_typ>5 == S_NET)
            print_usp(&$<usp>5);

        fprintf(
            yyout,
            "for(%s = us%c->p;%s;",
            $<cexp.expr>2,
            uscs,
            $<cexp.expr>2
        );

        if ($<usp.str_typ>5 == S_NET)
            fprintf(yyout, "free(us%c),", uscs);

        fprintf(
            yyout,
            "us%c = us%c->u_next,%s = us%c?us%c->p:0){\n",
            uscs,
            uscs,
            $<cexp.expr>2,
            uscs,
            uscs
        );

        uscs = 'i';
        inloop++;
    }
    DO StatementSeq END
    {
        inloop--;
        out("}}");
    }
  | IF Expr
    {
        if (reset) fprintf(yyout,"reset_rng();");
            fprintf(yyout,"if (%s){\n",$<cexp.expr>2);

        vec_cnt = 0;
        reset   = FALSE;
    }
    THEN StatementSeq OptionalElsIf OptionalElse END
    {
      out("}");
    }
  | CASE Expr OF
    {
        fprintf(yyout, "switch(%s){", $<cexp.expr>2);
    }
    Cases OptionalElseCase END
    {
        out("}");
    }
  | LOOP Times {  inloop++;} StatementSeq END
    {
        inloop--;
        if ($<cexp.xflg>2)
            out("}}");
        else
            out("}");
    }
  | REPEAT
    {
        inloop++;
        out("do{");
    }
    StatementSeq UNTIL Expr
    {
        if (reset)
            fprintf(yyout,"reset_rng();");

        fprintf(yyout,"} while (!(%s));\n",$<cexp.expr>5);

        inloop--;

        vec_cnt = 0;
        reset   = FALSE;
    }
  | WHILE Expr DO
    {
        inloop++;
        fprintf(yyout,"while (%s%s)\n{\n",reset?"reset_rng(),":"",$<cexp.expr>2);
        vec_cnt = 0; reset = FALSE;
    }
    StatementSeq END
    {
        out("}");
        inloop--;
    }
  | RETURN OptionalExpr
    {
        fprintf(
            yyout,
            "%sreturn %s;\n",
            reset ? "reset_rng(); " : "",
            $<cexp.expr>2 ? $<cexp.expr>2 : ""
        );
        vec_cnt = 0;
        reset = FALSE;
    }
  | Assignment
  | ProcedureCall
    {
        fprintf(yyout,"%s;\n",$<cexp.expr>1);
    }
  | APPLY ProcedureCall
    {
        uscs = 's';
        fprintf(yyout,"{USEL *uss = 0,*ust = 0;\n");
    }
    TO UnitSelection ToUnitSelection
    {
        if ($<usp.str_typ>5 == S_NET)
            print_usp(&$<usp>5);

        if ($<usp.str_typ>6 == S_NET)
            print_usp(&$<usp>6);

        *($<cexp.expr>2+strlen($<cexp.expr>2)-1) = 0;

        fprintf(yyout,"%s%s", $<cexp.expr>2, $<cexp.xflg>2 ? "," : "");
        fprintf(yyout,"%s", $<usp.str_typ>5 == S_USEL ? $<usp.s>5 : "uss");

        if ($<usp.str_typ>6!= S_UDEC)
            fprintf(yyout,",%s", $<usp.str_typ>6 == S_USEL ? $<usp.s>6 : "ust");

        fprintf(
            yyout,
            ");%s%s}\n",
            $<usp.str_typ>5 == S_NET ? "free_all_usel(uss);" : "",
            $<usp.str_typ>6 == S_NET ? "free_all_usel(ust);" : ""
        );
        uscs = 'i';
    }
  | CONNECT
    {
        uscs = 's';
        fprintf(yyout,"{USEL *uss = 0,*ust = 0;\n");
    }
    UnitSelection TO
    { uscs = 't'; }
    UnitSelection OptionalWeight INIT Expr OptionalDup
    {
        BOOL bProc;

        if ($<usp.str_typ>3 == S_NET)
            print_usp(&$<usp>3);

        if ($<usp.str_typ>6 == S_NET)
            print_usp(&$<usp>6);

        if (IS_PROC($<cexp.exprtyp>9))
        {
            del_para($<cexp.expr>9);
            if ($<cexp.xflg>9)
                Warning(30);
        }

        bProc = IS_PROC($<cexp.exprtyp>9);

        fprintf(
            yyout,
            "connect(%s,%s,\"%s\",%s,%s,%d,%d);\n",
            $<usp.str_typ>3 == S_NET ? "uss" : $<usp.s>3,
            $<usp.str_typ>6 == S_NET ? "ust" : $<usp.s>6,
            $<cexp.expr>7,
             bProc ? $<cexp.expr>9 : "0",
            !bProc ? $<cexp.expr>9 : "0",
            bProc,
            $<ctyp.obj.typfl>10
        );
        fprintf(
            yyout,
            "%s%s}\n",
            $<usp.str_typ>3 == S_NET ? "free_all_usel(uss);" : "",
            $<usp.str_typ>6 == S_NET ? "free_all_usel(ust);" : ""
        );
        uscs = 'i';
    }

  | SAVE IDENT { dim_ptr = 0; } LDimList TO STRINGCONST
    {
        if (s_lookup($<cexp.expr>2, S_ENQ)->st_type != S_NET)
        {
            Error(25);
            YYERROR;
        }

        if (!yynerrs) {
            fprintf(yyout,"{ FILE *fdsc;\n");
            fprintf(yyout,"  fdsc = fopen(%s,\"w\");\n",$<cexp.expr>6);
            if (!cre_top($<cexp.expr>2, credim, SNET))
            {
                Error(23);
                YYERROR;
            }
            fprintf(yyout,"  fclose(fdsc);\n}\n");
        }

        for(dim_ptr = 0;dim_ptr<MAXFDIM;dim_ptr++)
        {
            CREDIM(dim_ptr);

            if (credim[dim_ptr])
                free(credim[dim_ptr]);

            credim[dim_ptr] = 0;
        }
        dim_ptr = 0;
    }

  | LOAD IDENT { dim_ptr = 0; } LDimList FROM STRINGCONST
    {
        if (s_lookup($<cexp.expr>2, S_ENQ)->st_type != S_NET)
        {
            Error(25);
            YYERROR;
        }

        if (!yynerrs) {
            fprintf(yyout,"{ FILE *fdsc;\n");
            fprintf(yyout,"  fdsc = fopen(%s,\"r\");\n",$<cexp.expr>6);
            if (!cre_top($<cexp.expr>2, credim, LNET))
            {
                Error(23);
                YYERROR;
            }
            fprintf(yyout,"  fclose(fdsc);\n}\n");   
        }

        for(dim_ptr = 0;dim_ptr<MAXFDIM;dim_ptr++)
        {
            CREDIM(dim_ptr);

            if (credim[dim_ptr])
                free(credim[dim_ptr]);

            credim[dim_ptr] = 0;
        }
        dim_ptr = 0;
    }
        

  | CREATE IDENT { dim_ptr = 0; } LDimList
    {
        if (s_lookup($<cexp.expr>2, S_ENQ)->st_type != S_NET)
        {
            Error(25);
            YYERROR;
        }

        if (!yynerrs)
            if (!cre_top($<cexp.expr>2, credim, CNET))
            {
                Error(23);
                YYERROR;
            }

        for(dim_ptr = 0;dim_ptr<MAXFDIM;dim_ptr++)
        {
            CREDIM(dim_ptr);

            if (credim[dim_ptr])
                free(credim[dim_ptr]);

            credim[dim_ptr] = 0;
        }
        dim_ptr = 0;
    }
  | EXTEND IDENT
    {
        if ((s_lookup($<cexp.expr>2,S_ENQ)->st_type)!= S_NET)
        {
            Error(25);
            YYERROR;
        }
        else
        {
            usel_ptr           = 0;
            usel_stk[usel_ptr] = s_actual->s_descriptor.netw.net_descriptor;
            lay_ref            = 0;
            reset              = TRUE;
            idx_cnt            = 0;
            range_cnt          = 0;
            *c_buf             = 0;
        }
    }
    LayerIdent BY Size
    {   if ($<cexp.xflg>6 == S_UNIT)
        {
            fprintf(
                yyout,
                "{%s *ex = %s%s->pool;re_connect(&ex,%s,%s+%s));\n",
                usel_stk[usel_ptr]->l_desc.l_desc1.l_poolunit,
                $<cexp.expr>2, c_buf,
                usel_stk[usel_ptr]->l_desc.l_desc1.l_poolsiz,
                usel_stk[usel_ptr]->l_desc.l_desc1.l_poolsiz,
                $<cexp.expr>6
            );
            fprintf(yyout,"free(ex);}\n");
        }
        Warning(35);
    }
  | error
  ;

OptionalElseCase:
  | ELSE
    {
        out("default:");
    }
    StatementSeq
  | error
  ;

Cases:
    Case
  | Cases VBAR Case
  | error
  ;

Case:
  | ExprList COLON StatementSeq
    {
        out("break;");
    }
  ;

ExprList:
    Expr
    {
        if (!IS_CONST($<cexp.exprtyp>1))
            Error(24);

        fprintf(yyout, "case %s:", $<cexp.expr>1);
    }
  | ExprList COMMA Expr
    {
        if (!IS_CONST($<cexp.exprtyp>3))
            Error(24);

        fprintf(yyout, "case %s:", $<cexp.expr>3);
    }
  ;

ToUnitSelection:
    {
        $<usp.str_typ>$ = S_UDEC;
    }
  | TO
    {
        uscs = 't';
    }
    UnitSelection
    {
        $$ = $3;
    }
  ;

UnitSelection:
    LCURL
    {
        no_u_ident = TRUE;
    } UnitSets RCURL
    {
      $$ = $3;
      no_u_ident = FALSE;
    }
  | U_IDENT
    {
        $<usp.s>$       = strsave ($<cexp.expr>1);
        $<usp.str_typ>$ = S_USEL;
    }
  ;

UnitSets:
    IDENT
    {
        short us_type = s_lookup($<cexp.expr>1,S_ENQ)->st_type;

        if (us_type == S_USEL)
        {
            Error(41);
            sprintf(c_buf,"join_usc(&us%c,%s", uscs, $<cexp.expr>1);
            block_lu = TRUE;
        }
        else if (us_type == S_NET)
        {
            usel_ptr           = 0;
            usel_stk[usel_ptr] = s_actual->s_descriptor.netw.net_descriptor;
            lay_ref            = 0;
            reset              = TRUE;
            idx_cnt            = 0;
            range_cnt          = 0;
            block_lu           = FALSE;

            sprintf(c_buf,"ins_usc(&us%c,&%s", uscs, $<cexp.expr>1);
        }
        else
        {
            Error(25);
            YYERROR;
        }
    }
    LayerIdent UnitIdent
    {
        STRING usb = malloc(300),
               cp  = usb;

        USEL_STK(usel_ptr);

        if (!unit_check(usel_stk[usel_ptr],$<cexp.xflg>4))
        {
            if (!block_lu)
                Error(32);
            else
            {
                $<usp.str_typ>$ = S_USEL;
                $<usp.s_us>$    = $<cexp.expr>1;
            }
        }
        else
            $<usp.str_typ>$ = S_NET;

        *usb = '\0';

        while (curl_lay--)
        {
            if (curl_lay>= 16)
                Error(200+curl_lay);

            else
                sprintf(cp,clos_buf[curl_lay]);

            cp = usb+strlen(usb);
        }

        $<usp.s>$        = strcat4(cw_buf,c_buf,");",usb);
        $<usp.str_next>$ = 0;

        free(usb);

        curl_lay = 0;
        *c_buf   = 0;
        *cw_buf  = 0;
        block_lu = FALSE;
    }
  | UnitSets UnitOp IDENT
    {
        if ((s_lookup($<cexp.expr>3,S_ENQ)->st_type) == S_USEL)
        {
            Error(41);
            sprintf(c_buf,"join_usc(&us%c,%s", uscs, $<cexp.expr>3);
            block_lu = TRUE;
        }
        else if ((s_lookup($<cexp.expr>3,S_ENQ)->st_type) == S_NET)
        {
            usel_stk[usel_ptr = 0] = s_actual->s_descriptor.netw.net_descriptor;
            lay_ref = 0;
            reset = TRUE;
            idx_cnt = 0;
            range_cnt = 0;
            switch ($<cexp.xflg>2)
            {
              case 0:
              case 1:
                sprintf(c_buf,"ins_usc(&us%c,&%s", uscs, $<cexp.expr>3);
                break;

              case 2:
                sprintf(c_buf,"less_usc(&us%c,&%s", uscs, $<cexp.expr>3);
                break;
            }
        }
        else
        {
            Error(25);
            YYERROR;
        }
    }
    LayerIdent UnitIdent
    {
        STRING     usb  = malloc(300),
                   cp   = usb;
        STR_CHAIN *news = ALLOC(STR_CHAIN),
                  *auxs;

        if (!usb || !news)
            FatalError (ERR_MEMORY);

        USEL_STK(usel_ptr);

        if (!unit_check(usel_stk[usel_ptr],$<cexp.xflg>6))
            if (!block_lu)
                Error(32);
            /* else ? */

        *usb = 0;

        while(curl_lay--)
        {
            if (curl_lay>= 16)
                Error(200+curl_lay);
            else
                sprintf (cp, clos_buf [curl_lay]);

            cp = usb+strlen(usb);
        }

        news->s = strcat4(cw_buf,c_buf,");",usb);

        free(usb);

        news->str_next = 0;

        for (auxs = (&$<usp>1); auxs->str_next; auxs = auxs->str_next);

        auxs->str_next = news;

        $<usp>$ = $<usp>1;

        $<usp.str_typ>$ = S_NET;
        curl_lay = 0;
        *c_buf   = 0;
        *cw_buf  = 0;
        block_lu = FALSE;
    }
  ;

LayerIdent:
    {
        $<cexp.xflg>$ = 0;
    }
  | LayerIdent DOT IDENT
    {
        usel_ptr++;

        if (block_lu)
        {
           Error(34);
           YYERROR;
        }

        USEL_STK (usel_ptr);
        USEL_STK (usel_ptr-1);

        if (!(usel_stk[usel_ptr] = in_netlay(usel_stk[usel_ptr-1]->l_desc.l_desc1.l_sublay,$<cexp.expr>3)))
        {
            Error(18);
            YYERROR;
        }
        if (!usel_stk[usel_ptr]->l_descflg)
        {
            lay_ref = usel_stk[usel_ptr];
            usel_stk[usel_ptr] = usel_stk[usel_ptr]->l_desc.l_ptr;
        }
        else
            lay_ref = 0;

        strcat(c_buf,strcat2("->",$<cexp.expr>3));

        $<cexp.xflg>$ = 0;
    }
  | LayerIdent LT
    {
       conn = TRUE;
    }
    RangeList  GT
    {
        short ii;
        STRING p = c_buf+strlen(c_buf);

        if (block_lu)
        {
            Error(34);
            YYERROR;
        }

        if (lay_ref)
            for (ii = 0; lay_ref->l_dim[ii]; ii++);

        else
        {
            USEL_STK(usel_ptr);
            for (ii = 0; usel_stk[usel_ptr]->l_dim[ii]; ii++);
        }

        $<cexp.xflg>$ = $<cexp.xflg>1+1;

        if (!ii)
        {
            Error(26);
            YYERROR;
        }
        if ($<cexp.xflg>$>ii)
        {
            Error(33);
            YYERROR;
        }

        sprintf(p,"[idx[%d]]", idx_cnt);
        p = cw_buf+strlen(cw_buf);
        sprintf(p,"rflag[%d] = 1;init_idx(%d);do{\n", idx_cnt, idx_cnt);

        if (curl_lay>= 16)
            Error(200+curl_lay);
        else
            sprintf (clos_buf[curl_lay], "}\nwhile(!next_idx(%d));\n", idx_cnt);

        idx_cnt++;
        curl_lay++;

        range_cnt = 0;
        conn      = FALSE;
    }
  ;

UnitIdent:
    FieldId
  | PoolId
  ;

FieldId:
    LBRCK
    {
        conn = TRUE;
    }
    RangeList RBRCK
    {
        STRING p = c_buf+strlen(c_buf);

        if (block_lu)
        {
            Error(34);
            YYERROR;
        }

        USEL_STK(usel_ptr);
        if (!usel_stk[usel_ptr]->l_desc.l_desc1.l_fielddim[0])
        {
            Error(28);
            YYERROR;
        }

        sprintf(p,"->fld[idx[%d]]", idx_cnt);

        p = cw_buf+strlen(cw_buf);

        sprintf(p,"rflag[%d] = 1;init_idx(%d);do{\n", idx_cnt, idx_cnt);

        if (curl_lay>= 16)
            Error(200+curl_lay);
        else
            sprintf(clos_buf[curl_lay],"}\nwhile(!next_idx(%d));\n", idx_cnt);

        idx_cnt++;
        curl_lay++;
        range_cnt = 0;
        conn      = FALSE;
        $<cexp.xflg>$ = 1;
    }
  | FieldId LBRCK
    {
        conn = TRUE;
    }
    RangeList RBRCK
    {
        STRING p = c_buf+strlen(c_buf);
        USEL_STK(usel_ptr);
        if (!usel_stk[usel_ptr]->l_desc.l_desc1.l_fielddim[$<cexp.xflg>1])
        {
            Error(28);
           YYERROR;
        }

        sprintf(p,"[idx[%d]]", idx_cnt);
        p = cw_buf+strlen(cw_buf);

        sprintf(p,"rflag[%d] = 1;init_idx(%d);do{\n", idx_cnt, idx_cnt);

        if (curl_lay>= 16)
            Error(200+curl_lay);
        else
            sprintf(clos_buf[curl_lay],"}\nwhile(!next_idx(%d));\n",idx_cnt);

        idx_cnt  ++;
        curl_lay ++;

        range_cnt     = 0;
        conn          = FALSE;
        $<cexp.xflg>$ = $<cexp.xflg>1+1;
    }
  ;

PoolId:
    {
        $<cexp.xflg>$ = 0;
    }
  | LPAR SimpleExpr RPAR
    {
        STRING p = c_buf+strlen(c_buf);

        if (block_lu)
        {
            Error(34);
            YYERROR;
        }

        USEL_STK(usel_ptr);

        if (!usel_stk[usel_ptr]->l_desc.l_desc1.l_poolsiz)
        {
            Error(27);
            YYERROR;
        }

        sprintf(p,"->pool[ip]");
        p = cw_buf+strlen(cw_buf);
        sprintf(
            p,
            "{short ip;while((ip = rnd_p(%s,%s))>= 0)\n",
            $<cexp.expr>2,
            usel_stk[usel_ptr]->l_desc.l_desc1.l_poolsiz
        );

        if (curl_lay>= 16)
            Error(200+curl_lay);
        else
            sprintf(clos_buf[curl_lay],"}");

        $<cexp.xflg>$ = -1;
        curl_lay++;
    }
  ;

UnitOp:
    JOIN
    {
        $<cexp.xflg>$ = 0;
    }
  | LESS
    {
        $<cexp.xflg>$ = 2;
    }
  ;

OptionalWeight:
    {
        $<cexp.expr>$ = strsave("default");
    }
  | TYPE IDENT
    {
        $<cexp.expr>$ = strsave($<cexp.expr>2);
    }
  ;

OptionalDup:
    {
        $<ctyp.obj.typfl>$ = TRUE;
    }
  | NODUPLICATE
    {
        $<ctyp.obj.typfl>$ = FALSE;
    }
  ;

RangeList:
    Range
    {
        STRING p;

        $<range>$ = *rangesave($<range>1);

        if (conn)
        {
            p = cw_buf+strlen(cw_buf);
            sprintf(
                p,
                "%srng[%d][%d].lb = %s;rng[%d][%d].ub = %s;\n",
                reset ? reset = FALSE, "reset_rng();" : "",
                idx_cnt,
                range_cnt,
                $<range.from>1,
                idx_cnt,
                range_cnt,
                $<range.to>1
            );
            range_cnt++;
       }
    }
  | RangeList COMMA Range
    {
        $<range>$ = append_range(&$<range>1,&$<range>3);
        if (conn)
        {
            STRING p = cw_buf+strlen(cw_buf);
            sprintf(
                p,
                "rng[%d][%d].lb = %s;rng[%d][%d].ub = %s;\n",
                idx_cnt,
                range_cnt,
                $<range.from>3,
                idx_cnt,
                range_cnt,
                $<range.to>3
            );
            range_cnt++;
        }
    }
  ;

Range:
    SimpleExpr OptUpperRange
    {
        $<range.from>$   = strsave ($<cexp.expr>1);
        $<range.to>$     = $<range.to>2 ? $<range.to>2 : $<cexp.expr>1;
        $<range.r_next>$ = 0;
    }
  ;

OptUpperRange:
    {
        $<range.to>$ = 0;
    }
  | PERIOD SimpleExpr
    {
        $<range.to>$ = strsave ($<cexp.expr>2);
    }
  ;

Size:
    FieldSize
  | PoolSize
  ;

FieldSize:
    LBRCK SimpleExpr RBRCK
    {
        $<cexp.expr>$ = strsave ($<cexp.expr>2);
        $<cexp.val.str_next>$ = 0;
        $<cexp.xflg>$ = S_FLD;
    }
  | FieldSize LBRCK SimpleExpr RBRCK
    {
        STR_CHAIN *aux;
        YYSTYPE   *snd = ALLOC(YYSTYPE);

        if (!snd)
            FatalError (ERR_MEMORY);

        $<cexp>$ = $<cexp>1;

        for (aux = (STR_CHAIN*)&$<cexp>1; aux->str_next; aux = aux->str_next);

        snd->cexp.val.str_next = 0;
        snd->cexp.expr         = strsave($<cexp.expr>3);
        aux->str_next          = (STR_CHAIN*)snd;
    }
  ;

PoolSize:
    LPAR SimpleExpr RPAR
    {
        $<cexp.expr>$ = strsave($<cexp.expr>2);
        $<cexp.xflg>$ = S_UNIT;
    }
  ;

OptionalInc:
    {
        $<cexp.expr>$ = strsave("1");
    }
  | BY Expr
    {
        $$ = $2;
    }
  ;

OptionalElsIf:
  | OptionalElsIf ELSIF Expr THEN
    {
        if (reset)
            fprintf(yyout,"reset_rng();");

        fprintf(yyout,"}else if (%s){\n",$<cexp.expr>3);

        vec_cnt = 0;
        reset   = FALSE;
    }
    StatementSeq
  ;

OptionalElse:
  | ELSE
    {
        out("}else{");
    }
    StatementSeq
  ;

Times:
    FOREVER
    {
        out("for(;;){\n");
        $<cexp.xflg>$ = 0;
    }
  | Expr TIMES
    {
        sprintf(lcnt, "li%d",inloop);
        fprintf(yyout,"{int %s;for(%s = 1;%s<= ",lcnt,lcnt,lcnt);
        fprintf(yyout,"%s;%s++){\n",$<cexp.expr>1,lcnt);

        $<cexp.xflg>$ = 1;
    }
  ;

OptionalExpr:
    { $<cexp.expr>$ = 0; }
  | Expr
  ;

Target:
    Variable
    {
        for (; varscn; varscn--)
            popp(&s_root, &sr_dummy);
    }
  | U_IDENT
    {
        $<cexp.expr>$    = strsave ($<cexp.expr>1);
        $<cexp.exprtyp>$ = st_ptr (S_USEL       );
        $<cexp.xflg>$    = S_USEL;
    }
  ;

Assignment:
    Target ASGN Value
    {
        if (IS_CONST($<cexp.exprtyp>1))
        {
            Error(16);
            YYERROR;
        }

        if (IS_VEC($<cexp.exprtyp>1))
        {
            if (IS_VEC($<cexp.exprtyp>3))
            {
                if (!$<cexp.val.rlist>1 && !$<cexp.val.rlist>3)
                {
                    if (reset)
                        fprintf(yyout, "reset_rng();");

                    fprintf(
                        yyout,
                        "vec_asgn(&%s,%s,%d);\n",
                        $<cexp.expr>1,
                        $<cexp.expr>3,
                        $<cexp.xflg>3
                    );

                    vec_cnt = 0;
                    reset   = FALSE;
                    break;
                }
                else
                {
                    complex_ass($<cexp>1, $<cexp>3, $<cexp.xflg>3);
                    vec_cnt = 0;
                    reset   = FALSE;
                    break;
                }
            }
            else if (IS_USEL($<cexp.exprtyp>3) || IS_NET($<cexp.exprtyp>3))
            {
                if (!$<cexp.lastid>3)
                    Error(9);  /* vec: = { p.hid[1] }; */

                else if ($<cexp.val.rlist>1 == 0)
                {
                    YYSTYPE loc; /* vec: = ( { p.hid[1] } | u ) :net; */
                    BOOL    s_net = IS_NET($<cexp.exprtyp>3);

                    fprintf(
                        yyout,
                        "{USEL *usi = %s; short vi = 0;",
                        s_net ? "0" : $<cexp.expr>3
                    );

                    if (s_net)
                    {
                        loc.usp.s        = strsave ($<cexp.expr>3);
                        loc.usp.str_next = $<cexp.val.str_next>3;
                        print_usp ((STR_CHAIN*)&loc);
                    }

                    fprintf(
                        yyout,
                        "while(usi && vi<%s.vlen)\n{\n",
                        $<cexp.expr>1
                    );
                    fprintf(
                        yyout,
                        "%s.vloc[vi++] = usi->p->%s;",
                        $<cexp.expr>1,
                        $<cexp.lastid>3
                    );
                    fprintf(
                        yyout,
                        "%susi = usi->u_next;}}\n",
                        s_net ? "free(usi);" : ""
                    );

                    if ($<cexp.xflg>3)
                        fprintf(
                            yyout,
                            "if (vi<%s.vlen) clear_vec(%s,vi);",
                            $<cexp.expr>1,
                            $<cexp.expr>1
                        );
                    break;
                }
                else
                {
                    /* vec[1,2..3] : = { p.hid[1] } : net; */

                    BOOL   s_net = IS_NET($<cexp.exprtyp>3);
                    RANGE *aux;
                    int    i;

                    fprintf(
                        yyout,
                        "{USEL *usi = %s;short i = 0,ml = %s.vlen,nt;",
                        s_net ? "0" : $<cexp.expr>3,
                        $<cexp.expr>1
                    );

                    fprintf(yyout, "rflag[%d] = 1;",vec_cnt);

                    for (
                        aux = $<cexp.val.rlist>1, i = 0;
                        aux;
                        aux = aux->r_next, i++
                    )
                    {
                        fprintf(
                            yyout,
                            "rng[%d][%d].lb = %s;",
                            vec_cnt,
                            i,
                            aux->from
                        );

                        if (aux->from == aux->to)
                            fprintf(
                                yyout,
                                "rng[%d][%d].ub = rng[%d][%d].lb;\n",
                                vec_cnt,
                                i,
                                vec_cnt,
                                i
                            );
                        else
                            fprintf(
                                yyout,
                                "rng[%d][%d].ub = %s;\n",
                                vec_cnt,
                                i,
                                aux->to
                            );
                    }

                    free_all_range($<cexp.val.rlist>1);

                    fprintf (yyout, "init_idx(%d);", vec_cnt);
                    fprintf (
                        yyout,
                        "for(;;){%s.vloc[idx[%d]] = usi->p->%s;%s",
                        $<cexp.expr>1,
                        vec_cnt,
                        $<cexp.lastid>3,
                        s_net ? "free(usi);" : ""
                    );
                    fprintf(yyout, "usi = usi->u_next;");
                    fprintf(
                        yyout,
                        "nt = next_idx(%d);if (nt||!usi)break;}}",
                        vec_cnt
                    );

                    if ($<cexp.xflg>3)
                        Warning(40);

                    vec_cnt = 0;
                    reset   = FALSE;
                    break;
                }
            }
            else if (IS_VAL($<cexp.exprtyp>3))
            {
                if ($<cexp.val.rlist>1 == 0)
                {
                    fprintf(
                        yyout,
                        "{short av;for(av = 0;av<%s.vlen;av++)%s.vloc[av] = %s;}\n",
                        $<cexp.expr>1,
                        $<cexp.expr>1,
                        $<cexp.expr>3
                    );
                    break;
                }
                else
                {
                    RANGE *aux;
                    int    i;

                    fprintf(yyout, "rflag[%d] = 1;",vec_cnt);

                    for (
                        i = 0, aux = $<cexp.val.rlist>1;
                        aux;
                        i++, aux = aux->r_next
                    )
                    {
                        fprintf(
                            yyout,
                            "rng[%d][%d].lb = %s;",
                            vec_cnt,
                            i,
                            aux->from
                        );

                        if (aux->from == aux->to)
                            fprintf(
                                yyout,
                                "rng[%d][%d].ub = rng[%d][%d].lb;\n",
                                vec_cnt,
                                i,
                                vec_cnt,
                                i
                            );
                        else
                            fprintf(
                                yyout,
                                "rng[%d][%d].ub = %s;\n",
                                vec_cnt,
                                i,
                                aux->to
                            );
                    }
                    free_all_range($<cexp.val.rlist>1);
                    fprintf(yyout, "init_idx(%d);", vec_cnt);
                    fprintf(
                        yyout,
                        "cmplx_vec_init(&%s,%d,%s);\n",
                        $<cexp.expr>1,
                        vec_cnt,
                        $<cexp.expr>3
                    );

                    vec_cnt = 0;
                    reset   = FALSE; break;
                }
            }
            else
                Error(9);

        }
        else if (IS_USEL($<cexp.exprtyp>1))
        {
            if (IS_USEL($<cexp.exprtyp>3) || IS_NET($<cexp.exprtyp>3))
            {
                if ($<cexp.lastid>3)
                {
                    Error(9);  /* u_sel : = { ? } : net */
                }
                else
                {
                    fprintf(yyout, "free_all_usel(%s);", $<cexp.expr>1);

                    if (IS_NET($<cexp.exprtyp>3))
                    {
                        YYSTYPE loc;

                        fprintf(yyout, "{USEL *usi = 0;");

                        loc.usp.s        = strsave ($<cexp.expr>3);
                        loc.usp.str_next = $<cexp.val.str_next>3;

                        print_usp((STR_CHAIN*)&loc);

                        fprintf(yyout, "%s = usi;}\n", $<cexp.expr>1);

                        break;
                    }
                }
            }
            else if (!IS_CONST($<cexp.exprtyp>3))
                Error(9);

        }

        fprintf(yyout, "%s = %s;\n", $<cexp.expr>1, $<cexp.expr>3);

        vec_cnt = 0;
        reset   = FALSE;
    }
  | UnitSelection COLON IDENT ASGN Expr OptionalExt
    {
        ST_OBJECT *aux    = $<cexp.exprtyp>5;
        BOOL       s_usel = $<usp.str_typ>1 == S_USEL;

        fprintf(
            yyout,
            "{USEL *usi = %s;int i; VECTOR tmp;\n",
            s_usel ? $<usp.s>1 : "0"
        );

        if (!s_usel) print_usp(&$<usp>1);
            switch(aux->st_type)
            {
              case S_VECT:
                if ($<cexp.val.rlist>5 == 0)
                {
                    fprintf(
                        yyout,
                        "for(i = 0;usi && i<%s.vlen;i++,%susi = usi->u_next){\n",
                        $<cexp.expr>5,
                        s_usel ? "" : "free(usi),"
                    );
                    fprintf(
                        yyout,
                        "usi->p->%s = %s.vloc[i];}}\n",
                        $<cexp.expr>3,
                        $<cexp.expr>5
                    );

                    if ($<cexp.xflg>6)
                        fprintf(
                            yyout,
                            "if (i<%s.vlen) clear_vec(%s,i);",
                            $<cexp.expr>5,
                            $<cexp.expr>5
                        );
                }
                else
                {
                    short  i;
                    RANGE *aux;

                    if (reset)
                    {
                        fprintf (yyout,"reset_rng();");
                        reset = FALSE;
                    }

                    for (aux = $<cexp.val.rlist>5, i = 0; aux; aux = aux->r_next, i++)
                    {
                        fprintf(yyout,"rng[%d][%d].lb = %s;",vec_cnt,i,aux->from);

                        if (aux->from == aux->to)
                            fprintf(
                                yyout,
                                "rng[%d][%d].ub = rng[%d][%d].lb;\n",
                                vec_cnt,
                                i,
                                vec_cnt,
                                i
                            );
                        else
                            fprintf(
                                yyout,
                                "rng[%d][%d].ub = %s;\n",
                                vec_cnt,
                                i,
                                aux->to
                            );
                    }

                    free_all_range($<cexp.val.rlist>5);

                    fprintf (yyout, "rflag[%d] = 1;",  vec_cnt);
                    fprintf (yyout, "init_idx(%d);", vec_cnt);
                    fprintf (
                        yyout,
                        "while(usi)\n{\nusi->p->%s = %s.vloc[idx[%d]];",
                        $<cexp.expr>3,
                        $<cexp.expr>5,
                        vec_cnt
                    );
                    fprintf(
                        yyout,
                        "%susi = usi->u_next;",
                        s_usel ? "free(usi);" : ""
                    );
                    fprintf(yyout,"if (next_idx(%d))break;}", vec_cnt);
                    vec_cnt++;
                }
                break;

              case S_VPROC:
                fprintf(
                    yyout,
                    "tmp = %s;for(i = 0;usi && i<tmp.vlen;i++,%susi = usi->u_next){\n",
                    $<cexp.expr>5, s_usel ? "" : "free(usi);"
                );
                fprintf(
                    yyout,
                    "usi->p->%s = tmp.vloc[i];}}\n",
                    $<cexp.expr>3
                );
                break;

              default:
                fprintf(
                    yyout,
                    "while(usi)\n{\nusi->p->%s = %s;%s",
                    $<cexp.expr>3,
                    $<cexp.expr>5,
                    s_usel ? "" : "free(usi);"
                 );
                 fprintf(yyout,"usi = usi->u_next;}}\n");
            }

        if ($<cexp.xflg>6)
            fprintf(
                yyout,
                "while(usi)\n{\nusi->p->%s = 0;%susi = usi->u_next;\n}\n}\n",
                $<cexp.expr>3,
                s_usel ? "free(usi);" : ""
            );
    }
  ;

Value:
    Expr OptionalExt
    {
        $$ = $1;
        $<cexp.xflg>$ = $<cexp.xflg>2;
    }
  | UnitSelection OptionalCompo
    {
        $<cexp.expr>$         = strsave ($<usp.s>1    );
        $<cexp.lastid>$       = strsave ($<cexp.expr>2);
        $<cexp.val.str_next>$ = $<usp.str_next>1;
        $<cexp.exprtyp>$      = st_ptr ($<usp.str_typ>1);
        $<cexp.xflg>$         = FALSE;
    }
  ;

OptionalCompo:
    {
        $<cexp.expr>$ = 0;
    }
  | COLON IDENT
    {
        $<cexp.expr>$ = strsave ($<cexp.expr>2);
    }
  ;

Variable:
    IDENT
    {
        $<cexp.exprtyp>$ = s_lookup($<cexp.expr>1,S_ENQ);

        if (IS_VEC($<cexp.exprtyp>$))
            $<cexp.val.rlist>$ = 0;

        if (IS_PROC($<cexp.exprtyp>$))
            Warning(42);

        if (s_search_chain($<cexp.expr>1)) /* Parameter of current procedure? */
            if (sr_actual && sr_actual->ref)
            {
                $<cexp.expr>$ = strsave ($<cexp.expr>1);
                break;
            }
            else
            {
                $<cexp.expr>$ = strcat3("(*",$<cexp.expr>1,")");
                break;
            }

        else if (sr_actual && sr_actual->ref)        /* New ref */
        {
            if (!rec_var)
            {
                $<cexp.expr>$ = strcat2("&",$<cexp.expr>1);
                rec_var       = TRUE;
            }

            if (
                IS_CONST ($<cexp.exprtyp>$) ||
                IS_PROC  ($<cexp.exprtyp>$) ||
                IS_EXPR  ($<cexp.exprtyp>$)
            )
            {
                Error(11);
                YYERROR;
            }
            break;
        }

        $<cexp.lastid>$ = strsave ($<cexp.expr>1);
        $<cexp.expr>$   = strsave ($<cexp.expr>1);
        $<cexp.xflg>$   = 0;
    }
  | ADROF IDENT
    {
        $<cexp.exprtyp>$ = ALLOC(ST_OBJECT);

        if (!$<cexp.exprtyp>$)
            FatalError (ERR_MEMORY);

        $<cexp.exprtyp>$->st_type = S_PTR;
        $<cexp.exprtyp>$->st_next = s_lookup ($<cexp.expr>2, S_ENQ);

        if (sr_actual && sr_actual->ref && !rec_var)        /* New ref */
        {
            $<cexp.expr>$ = strcat2("&",$<cexp.expr>2);
            rec_var       = TRUE;
            break;
        }

        $<cexp.lastid>$ = strcat2 ("&", $<cexp.expr>2);
        $<cexp.expr>$   = strcat2 ("&", $<cexp.expr>2);
        $<cexp.xflg>$   = 0;
    }
  | Variable DOT IDENT
    {
        if (IS_UNIT($<cexp.exprtyp>1))
            $<cexp.expr>$ = strcat3($<cexp.expr>1,"->",$<cexp.expr>3);
        else
            $<cexp.expr>$ = strcat3($<cexp.expr>1,".",$<cexp.expr>3);

        if (IS_VEC($<cexp.exprtyp>1))
        {
            if (!strcmp($<cexp.expr>3,"vlen"))
                $<cexp.exprtyp>$ = st_ptr(S_INT);

            else
            {
                if (!strcmp($<cexp.expr>3,"vloc"))
                    $<cexp.exprtyp>$ = st_ptr(S_UDEC);
                else
                {
                    Error(10);
                    for (; varscn; varscn--)
                        popp(&s_root, &sr_dummy);

                    YYERROR;
                }
            }
        }
        else
        {
            if (IS_KNOWN($<cexp.exprtyp>1) && !IS_UNIT($<cexp.exprtyp>1))
            {
                if (!IS_REC($<cexp.exprtyp>1))
                {
                    Error(13);
                    for (; varscn; varscn--)
                        popp(&s_root, &sr_dummy);

                    YYERROR;
                } /* not a record/overlay */
                else
                {
                    S_OBJECT *aux;

                    aux = s_lookup($<cexp.expr>1,S_ENQ)->symt.s_symb;

                    pushp(&s_root,&sr_dummy);
                    s_root = aux;
                    varscn++;
                    $<cexp.exprtyp>$ = s_lookup($<cexp.expr>3, S_ENQ);
                }
            }
            else
            {
                if (!IS_UNIT($<cexp.exprtyp>1))
                    Warning(13);

                $<cexp.exprtyp>$ = st_ptr(S_UDEC);
            }
        }

        $<cexp.lastid>$    = strsave ($<cexp.expr>3);
        $<cexp.xflg>$      = 0;
        $<cexp.val.rlist>$ = 0;

    }
  | Variable LBRCK RangeList RBRCK
    {
        $<cexp.xflg>$ = $<cexp.xflg>1+1;
        if (IS_VEC($<cexp.exprtyp>1))
        {
            if (!strcmp ($<range.from>3, $<range.to>3) && !$<range.r_next>3)
            {
                $<cexp.exprtyp>$   = st_ptr(S_REAL);
                $<cexp.val.rlist>$ = 0;
                $<cexp.expr>$      = strcat4(
                                        $<cexp.expr>1,
                                        ".vloc [",
                                        $<range.from>3,
                                        "]"
                                     );
                break;
            }
            else
            {
                $$                 = $1;
                reset              = TRUE;
                $<cexp.val.rlist>$ = rangesave($<range>3);
                break;
            }
        }
        else
            if (IS_KNOWN($<cexp.exprtyp>1))
                if (IS_ARRAY($<cexp.exprtyp>1))
                {
                    if (!strcmp ($<range.from>3, $<range.to>3) && !$<range.r_next>3)
                    {
                        short i;

                        $<cexp.exprtyp>$ = s_lookup($<cexp.lastid>1,S_ENQ);

                        for (i = $<cexp.xflg>$; i; i--)
                            $<cexp.exprtyp>$ = $<cexp.exprtyp>$->st_next;
                    }
                    else
                    {
                        Error(12);

                        for (; varscn; varscn--)
                            popp(&s_root, &sr_dummy);

                        YYERROR;
                    }
                }
                else if (IS_PTR($<cexp.exprtyp>1))
                    $<cexp.exprtyp>$ = st_ptr(S_UDEC);

                else
                {
                    Error(15);

                    for (; varscn; varscn--)
                        popp(&s_root, &sr_dummy);

                    YYERROR;
                } /* not an array */
            else
            {
                $<cexp.exprtyp>$ = st_ptr(S_UDEC);
            } /* maybe something unknown */

        $<cexp.expr>$      = strcat4($<cexp.expr>1,"[",$<cexp.expr>3,"]");
        $<cexp.lastid>$    = strsave ($<cexp.lastid>1                    );
        $<cexp.val.rlist>$ = 0;
    }
  | Variable ARROW IDENT
    {
        if (!strcmp($<cexp.expr>3,"value"))
            $<cexp.expr>$ = strcat2("*", $<cexp.expr>1);
        else
            $<cexp.expr>$ = strcat3($<cexp.expr>1,"->",$<cexp.expr>3);

        $<cexp.lastid>$    = strsave ($<cexp.expr>3);
        $<cexp.xflg>$      = 0;
        $<cexp.val.rlist>$ = 0;
        $<cexp.exprtyp>$   = s_getp_type($<cexp.exprtyp>1);

        if (IS_RECORD($<cexp.exprtyp>$))
        {
              pushp(&s_root, &sr_dummy);

              s_root           = $<cexp.exprtyp>$->symt.s_symb;
              $<cexp.exprtyp>$ = s_lookup ($<cexp.expr>3, S_ENQ);

              popp(&s_root, &sr_dummy);
        }
    }
  ;

OptionalExt:
    {
        $<cexp.xflg>$ = FALSE;
    }
  | COLON NUL
    {
        $<cexp.xflg>$ = TRUE;
    }
  | COLON NIL
    {
        $<cexp.xflg>$ = FALSE;
    }
  ;

IdentList:
    IDENT
    {
        if (s_lookup($<cexp.expr>1,S_UDEC)->st_type)
            Error(7);

        $<ctyp.ctxt>$      = strsave($<cexp.expr>1);
        $<ctyp.obj.typfl>$ = 1;
    }
  | IdentList COMMA IDENT
    {
        if (s_lookup($<cexp.expr>3,S_UDEC)->st_type)
            Error(7);

        $<ctyp.ctxt>$      = strcat3($<ctyp.ctxt>1,",",$<cexp.expr>3);
        $<ctyp.obj.typfl>$ = $<ctyp.obj.typfl>1+1;
    }
  ;

ProcedureCall:
    IDENT
    {
        pushp    (&s_actual,&sr_actual  );
        s_lookup ($<cexp.expr>1,S_UPROC );

        sr_actual = s_actual ? s_actual->s_descriptor.funct.refi : 0;
    }
    LPAR ParamList RPAR
    {
        vec_cnt = 0;
        $<cexp.exprtyp>$ = s_actual ? s_actual->s_type : st_ptr(S_UPROC);
        $<cexp.expr>$ = strcat4($<cexp.expr>1,"(",$<cexp.expr>4,")");
        $<cexp.val.rlist>$ = 0;
        $<cexp.xflg>$ = $<cexp.xflg>4;

        if (
            s_actual &&
            s_actual->s_descriptor.funct.anzpar >= 0 &&
            s_actual->s_descriptor.funct.anzpar != $<cexp.xflg>4
        )
            Warning(8);

        popp(&s_actual,&sr_actual);
    }
  ;

ParamList:
    {
        $<cexp.expr>$ = strsave("");
        $<cexp.xflg>$ = 0;
    }
  | Expr
    {
        rec_var = FALSE;

        if (reset)
        {
            $<cexp.expr>$ = strcat3("(reset_rng(),",$<cexp.expr>1,")");
            reset = FALSE;
        }
        else
            $<cexp.expr>$ = strsave ($<cexp.expr>1);

        $<cexp.xflg>$ = 1;
        sr_actual     = sr_actual ? sr_actual->sr_next : 0;
    }
  | ParamList COMMA Expr
    {
        if (reset)
        {
            reset         = FALSE;
            $<cexp.expr>$ = strcat4(
                                $<cexp.expr>1,
                                ",(reset_rng(),",
                                $<cexp.expr>3,
                                ")"
                            );
        }
        else
            $<cexp.expr>$ = strcat3($<cexp.expr>1,",",$<cexp.expr>3);

        $<cexp.xflg>$ = $<cexp.xflg>1+1;
        sr_actual     = sr_actual ? sr_actual->sr_next : 0;
    }
  ;

Expr:
    Expr EQ Expr
    {
        if (IS_VEC($<cexp.exprtyp>1) && IS_VEC($<cexp.exprtyp>3))
        {
            if ($<cexp.val.rlist>1 == 0 && $<cexp.val.rlist>3 == 0)
                $<cexp.expr>$ = strcat5(
                                    "vec_eq(",
                                    $<cexp.expr>1,
                                    ",",
                                    $<cexp.expr>3,
                                    ")"
                                );
            else
            {
                if (!$<cexp.val.rlist>1)
                {
                    $<cexp.val.rlist>1 = ALLOC(RANGE);

                    if (!$<cexp.val.rlist>1)
                        FatalError (ERR_MEMORY);

                    $<cexp.val.rlist>1->r_next = 0;
                    $<cexp.val.rlist>1->from   = strsave("0");
                    $<cexp.val.rlist>1->to     = strcat2(
                                                    $<cexp.expr>1,
                                                    ".vlen-1"
                                                 );
                }

                if ($<cexp.val.rlist>3 == 0)
                {
                    if (($<cexp.val.rlist>3 = ALLOC(RANGE)) == 0)
                        FatalError (ERR_MEMORY);

                    $<cexp.val.rlist>3->from   = strsave("0");
                    $<cexp.val.rlist>3->to     = strcat2($<cexp.expr>3,".vlen-1");
                    $<cexp.val.rlist>3->r_next = 0;
                }

                $<cexp>$ = complex_vec_eq ($<cexp>1,$<cexp>3,0);
            }

        }
        else if (
               ( IS_VEC($<cexp.exprtyp>1) && !IS_VEC($<cexp.exprtyp>3)) ||
               (!IS_VEC($<cexp.exprtyp>1) &&  IS_VEC($<cexp.exprtyp>3))
             )
        {
            Error(1);
            YYERROR;
        }
        else
            $<cexp.expr>$ = strcat3($<cexp.expr>1," == ",$<cexp.expr>3);

        $<cexp.exprtyp>$ = st_ptr(S_EXPR);
        NO_CONST;
    }
  | Expr NE Expr
    {
        if (IS_VEC($<cexp.exprtyp>1) && IS_VEC($<cexp.exprtyp>3))
        {
            if (!$<cexp.val.rlist>1 && !$<cexp.val.rlist>3)
                $<cexp.expr>$ = strcat5(
                                    "!vec_eq(",
                                    $<cexp.expr>1,
                                    ",",
                                    $<cexp.expr>3,
                                    ")"
                                );
            else
            {
                if (!$<cexp.val.rlist>1)
                {
                    $<cexp.val.rlist>1 = ALLOC(RANGE);

                    if (!$<cexp.val.rlist>1)
                        FatalError (ERR_MEMORY);

                    $<cexp.val.rlist>1->r_next = 0;
                    $<cexp.val.rlist>1->from   = strsave("0");
                    $<cexp.val.rlist>1->to     = strcat2(
                                                     $<cexp.expr>1,
                                                     ".vlen-1"
                                                 );
                }

                if ($<cexp.val.rlist>3 == 0)
                {
                    $<cexp.val.rlist>3 = ALLOC(RANGE);

                    if (!$<cexp.val.rlist>3)
                        FatalError (ERR_MEMORY);

                    $<cexp.val.rlist>3->r_next = 0;
                    $<cexp.val.rlist>3->from   = strsave  ("0");
                    $<cexp.val.rlist>3->to     = strcat2 (
                                                     $<cexp.expr>3,
                                                     ".vlen-1"
                                                 );
                }

                $<cexp>$ = complex_vec_eq ($<cexp>1, $<cexp>3, 1);
            }
        } else if (
                  ( IS_VEC($<cexp.exprtyp>1) && !IS_VEC($<cexp.exprtyp>3)) ||
                  (!IS_VEC($<cexp.exprtyp>1) &&  IS_VEC($<cexp.exprtyp>3))
               )
        {
            Error(1);
            YYERROR;
        }
        else
            $<cexp.expr>$ = strcat3($<cexp.expr>1,"!= ",$<cexp.expr>3);

        $<cexp.exprtyp>$ = st_ptr(S_EXPR);

        NO_CONST;
    }
  | Expr LT Expr
    {
        if (IS_VEC($<cexp.exprtyp>1) || IS_VEC($<cexp.exprtyp>3))
        {
            Error(17);
            YYERROR;
        }
        $<cexp.expr>$    = strcat3 ($<cexp.expr>1, "<", $<cexp.expr>3);
        $<cexp.exprtyp>$ = st_ptr  (S_EXPR                           );

        NO_CONST;
    }
  | Expr GT Expr
    {
        if (IS_VEC($<cexp.exprtyp>1) || IS_VEC($<cexp.exprtyp>3))
        {
            Error(17);
            YYERROR;
        }

        $<cexp.expr>$    = strcat3 ($<cexp.expr>1,">",$<cexp.expr>3);
        $<cexp.exprtyp>$ = st_ptr  (S_EXPR                         );
            NO_CONST;
    }
  | Expr LE Expr
    {
        if (IS_VEC($<cexp.exprtyp>1) || IS_VEC($<cexp.exprtyp>3))
        {
            Error(17);
            YYERROR;
        }

        $<cexp.expr>$    = strcat3 ($<cexp.expr>1,"<= ",$<cexp.expr>3);
        $<cexp.exprtyp>$ = st_ptr  (S_EXPR                          );

        NO_CONST;
    }
  | Expr GE Expr
    {
        if (IS_VEC($<cexp.exprtyp>1) || IS_VEC($<cexp.exprtyp>3))
        {
            Error(17);
            YYERROR;
        }

        $<cexp.expr>$    = strcat3 ($<cexp.expr>1,">= ",$<cexp.expr>3);
        $<cexp.exprtyp>$ = st_ptr  (S_EXPR                          );
        NO_CONST;
    }
  | Expr AND Expr
    {
        if (IS_VEC($<cexp.exprtyp>1) || IS_VEC($<cexp.exprtyp>3))
        {
            Error(17);
            YYERROR;
        }

        $<cexp.expr>$    = strcat3 ($<cexp.expr>1,"&&",$<cexp.expr>3);
        $<cexp.exprtyp>$ = st_ptr  (S_EXPR                          );
        NO_CONST;
    }
  | Expr OR Expr
    {
        if (IS_VEC($<cexp.exprtyp>1) || IS_VEC($<cexp.exprtyp>3))
        {
           Error(17);
           YYERROR;
        }

        $<cexp.expr>$    = strcat3 ($<cexp.expr>1,"||",$<cexp.expr>3);
        $<cexp.exprtyp>$ = st_ptr  (S_EXPR                          );
        NO_CONST;
    }
  | NOT Expr
    {
        if (IS_VEC($<cexp.exprtyp>2))
        {
            Error(17);
            YYERROR;
        }

        $<cexp.expr>$    = strcat2 ("!",$<cexp.expr>2);
        $<cexp.exprtyp>$ = st_ptr  (S_EXPR           );
        NO_CONST;
    }
  | SimpleExpr
  ;

SimpleExpr:
    SimpleExpr ADD SimpleExpr
    {
        if (IS_VEC($<cexp.exprtyp>1) && IS_VEC($<cexp.exprtyp>3))
        {
           $<cexp>$ = compute_vect (V_ADD, $<cexp>1, $<cexp>3);
           break;
        }

        if (
            ( IS_VEC($<cexp.exprtyp>1) && !IS_VEC($<cexp.exprtyp>3)) ||
            (!IS_VEC($<cexp.exprtyp>1) &&  IS_VEC($<cexp.exprtyp>3))
        )
        {
            Error(1);
            YYERROR;
        }

        if (IS_CONST($<cexp.exprtyp>1) && IS_CONST($<cexp.exprtyp>3))
            $<cexp.exprtyp>$ = st_ptr(S_CONST);
        else
            $<cexp.exprtyp>$ = st_ptr(S_EXPR);

        $<cexp.expr>$      = strcat3($<cexp.expr>1,"+",$<cexp.expr>3);
        $<cexp.val.rlist>$ = 0;
        NO_CONST;
    }
  | SimpleExpr SUB SimpleExpr
    {
        if (IS_VEC($<cexp.exprtyp>1) && IS_VEC($<cexp.exprtyp>3))
        {
            $<cexp>$ = compute_vect(V_SUB, $<cexp>1, $<cexp>3);
            break;
        }

        if (
            ( IS_VEC($<cexp.exprtyp>1) && !IS_VEC($<cexp.exprtyp>3)) ||
            (!IS_VEC($<cexp.exprtyp>1) &&  IS_VEC($<cexp.exprtyp>3))
        )
        {
            Error(1);
            YYERROR;
        }

        if (IS_CONST($<cexp.exprtyp>1) && IS_CONST($<cexp.exprtyp>3))
            $<cexp.exprtyp>$ = st_ptr(S_CONST);
        else
            $<cexp.exprtyp>$ = st_ptr(S_EXPR);

         $<cexp.expr>$      = strcat3($<cexp.expr>1,"-",$<cexp.expr>3);
         $<cexp.val.rlist>$ = 0;
         NO_CONST;
    }
  | SimpleExpr MUL SimpleExpr
    {
        if (IS_VEC($<cexp.exprtyp>3))
        {
            $<cexp>$ = compute_vect (V_MUL, $<cexp>1, $<cexp>3);
            break;
        }

        if (IS_VEC($<cexp.exprtyp>1) && !IS_VEC($<cexp.exprtyp>3))
        {
            Error(1);
            YYERROR;
        }

        if (IS_CONST($<cexp.exprtyp>1) && IS_CONST($<cexp.exprtyp>3))
            $<cexp.exprtyp>$ = st_ptr(S_CONST);
        else
            $<cexp.exprtyp>$ = st_ptr(S_EXPR);

        $<cexp.expr>$      = strcat3($<cexp.expr>1,"*",$<cexp.expr>3);
        $<cexp.val.rlist>$ = 0;
        NO_CONST;
    }
  | SimpleExpr DIV SimpleExpr
    {
        if (IS_CONST($<cexp.exprtyp>1) && IS_CONST($<cexp.exprtyp>3))
            $<cexp.exprtyp>$ = st_ptr(S_CONST);
        else
            $<cexp.exprtyp>$ = st_ptr(S_EXPR);

        if (IS_VEC($<cexp.exprtyp>1) || IS_VEC($<cexp.exprtyp>3))
        {
            Error(17);
            YYERROR;
        }

        $<cexp.expr>$      = strcat3($<cexp.expr>1,"/",$<cexp.expr>3);
        $<cexp.val.rlist>$ = 0;
        NO_CONST;
    }
  | SimpleExpr MOD SimpleExpr
    {
        if (IS_CONST($<cexp.exprtyp>1) && IS_CONST($<cexp.exprtyp>3))
            $<cexp.exprtyp>$ = st_ptr(S_CONST);
        else
            $<cexp.exprtyp>$ = st_ptr(S_EXPR);

        if (IS_VEC($<cexp.exprtyp>1) || IS_VEC($<cexp.exprtyp>3))
        {
           Error(17);
           YYERROR;
        }
        $<cexp.expr>$      = strcat3($<cexp.expr>1,"%",$<cexp.expr>3);
        $<cexp.val.rlist>$ = 0;
        NO_CONST;
    }
  | SUB SimpleExpr %prec UMINUS
    {
        if (IS_VEC($<cexp.exprtyp>2))
        {
            $<cexp>$ = vec_neg($<cexp>2);
            break;
        }

        $<cexp.expr>$ = strcat2(" -",$<cexp.expr>2);

        if (IS_CONST($<cexp.exprtyp>2))
             $<cexp.exprtyp>$ = st_ptr(S_CONST);
        else
            $<cexp.exprtyp>$ = st_ptr(S_EXPR);

        $<cexp.val.rlist>$ = 0;
        NO_CONST;
    }
  | LPAR Expr RPAR
    {
        $<cexp.expr>$      = strcat3("(",$<cexp.expr>2,")");
        $<cexp.val.rlist>$ = $<cexp.val.rlist>2;
        $<cexp.exprtyp>$   = $<cexp.exprtyp>2;
    }
  | Factor
  ;

Factor:
    BOOLCONST
    {
        $$                 = $1;
        $<cexp.exprtyp>$   = st_ptr(S_CONST);
        NO_CONST;
        $<cexp.val.rlist>$ = 0;
    }
  | INTCONST
    {
        $$ = $1;
        $<cexp.exprtyp>$ = st_ptr(S_CONST);
        NO_CONST;
        $<cexp.val.rlist>$ = 0;
    }
  | FLOATCONST
    {
        $$ = $1;
        $<cexp.exprtyp>$ = st_ptr(S_CONST);
        NO_CONST;
        $<cexp.val.rlist>$ = 0;
    }
  | STRINGCONST
    {
        $$ = $1;
        $<cexp.exprtyp>$ = st_ptr(S_CONST);
        NO_CONST;
        $<cexp.val.rlist>$ = 0;
    }
  | CHARCONST
    {
        $$ = $1;
        $<cexp.exprtyp>$ = st_ptr(S_CONST);
        NO_CONST;
        $<cexp.val.rlist>$ = 0;
    }
  | Variable
    {
        for (; varscn; varscn--)
            popp(&s_root, &sr_dummy);
    }
  | ProcedureCall
  | error
    {
        $<cexp.expr>$    = strsave ("0"   );
        $<cexp.exprtyp>$ = st_ptr (S_UDEC);
    }
  ;

%%

void main (int argc, char *argv [])
{
    unsigned wFileName;
    STRING   pExt,
             pTarget;

    fprintf (stderr,"TU Vienna (R) Condela III PC-Version 1.05 Beta\n");
    fprintf (stderr,"Copyright (c) TU Vienna 1987-1991. "             );
    fprintf (stderr,"All rights reserved.\n\n"                        );

    if (argc!= 2)
    {
        fprintf (stderr,"Usage: %s <filename>[.con]\n", argv[0]);
        exit    (1                                             );
    }

    sourcesp  = 0;
    wFileName = strlen (argv[1]);

    yysource [sourcesp] = strcpy (malloc (wFileName+5), argv[1]);

    pExt = strchr (yysource [sourcesp], '.');

    if (!pExt)
        wFileName = strlen(strcat(yysource[sourcesp],".con"));

    pTarget   = strcpy (malloc(wFileName+3), yysource[sourcesp]);
    pExt      = strchr (pTarget, '.'                                                   );
    pExt [1]  = 'c';
    pExt [2]  = '\0';

    yyin                =
    sourcefp [sourcesp] = fopen(yysource[sourcesp],"r");

    if (!yyin)
    {
        fprintf (stderr,"%s: cannot read %s\n", argv[0], yysource[sourcesp]);
        exit    (2                                                         );
    }

    yyout = fopen (pTarget, "w");

    if (!yyout)
    {
        fprintf(stderr,"%s: cannot write %s\n", argv[0], pTarget);
        exit(3);
    }

    yyparse();

    free (pTarget            );
    free (yysource [sourcesp]);

    fclose (yyout);
    fclose (yyin );

    exit (yynerrs != 0);
}
