:- module(golem, [golem/1]).
:- op(700,fx,not).

:- (predicate_property(findall(_,_,_),built_in)-> true |
	use_module(findall,library(findall), [findall/3])).

:- use_module(strings,library(strings),[concat_atom/2]).
:- use_module(arg,library(arg),[genarg/3]).

:- use_module(environ,library(environ),[expanded_file_name/2,environ/2]).
:- use_module(hypernews,library(hypernews),[hn_show/1,hn_hide/1]).
:- use_module(itemspec,library(itemspec),[fact_prop/2,fact_ep/2,
	rule_prems/2,rule_concl/2]).
:- use_module(mobalpi,library(mobalpi),[mobal_get_fact/1,mobal_new_rule/1,mobal_msg/1]).


golem(Focus):-
	hn_show(stack('Golem')),
	expanded_file_name('/tmp/mobal2golem$$',CallFile),
	expanded_file_name('/tmp/mobal2golem$$.b',BackgroundFile),
	expanded_file_name('/tmp/mobal2golem$$.f',PosFactFile),
	expanded_file_name('/tmp/mobal2golem$$.n',NegFactFile),
	expanded_file_name('/tmp/mobal2golem$$.r',LearnedRulesFile),
	mobal_msg(['Generating Datafile ....',nl]),
	write_golem_files(Focus,BackgroundFile,PosFactFile,NegFactFile),
	mobal_msg(['Running Golem .....',nl]),
	run_golem(Focus,CallFile),
	mobal_msg(['Reading learned Rules ...',nl]),
	read_golem_file(LearnedRulesFile),
	mobal_msg(['Done.',nl]),
        hn_hide(stack('Golem')),
	!.
run_golem(_Focus,CallFile):-
%	open('File',write,S),
%	close(S),
	(environ('GOLEM',_)
           -> expanded_file_name('$GOLEM',GOLEM)
	   ;  expanded_file_name('$MOBALHOME/tools/bin/golem',GOLEM)),
	concat_atom([GOLEM,' ',CallFile],Command),
	(unix(system(Command))
        ;true).


read_golem_file(File):-
	!,
	open(File,read,FN),
	(get_rule(FN,Rule),
	 mobal_new_rule(Rule),
	 fail
	;true
	),
	close(FN).


get_rule(FN,rule(Vars,Premises,Concl,_,_,_,_)):-
	repeat,
	read(FN,Clause),
	(Clause = end_of_file -> 
	    !,
	    fail
	|   (Clause = (Concl :- Prems) ->
	    prems_to_list(Prems,Premises)
	|   Clause = Concl,
	    Premises = []
	)),
	instantiate_all_vars([Concl|Premises],0,Vars).

prems_to_list(','(P,Prems),[P|Premises]):-
	!,
	prems_to_list(Prems,Premises).
prems_to_list(P,[P]).

instantiate_all_vars([],_,[]).
instantiate_all_vars([Prop|Props],I,[Arg|V]):-
	genarg(_,Prop,Arg),
	var(Arg),
	concat_atom([x,I],Arg),
	NI is I+1,
	!,
	instantiate_all_vars([Prop|Props],NI,V).
instantiate_all_vars([_|Props],I,V):-
	instantiate_all_vars(Props,I,V).




write_golem_files(Focus,BackgroundFile,PosFactFile,NegFactFile):-
	open(BackgroundFile,write,BF),
	open(PosFactFile,write,PF),
	open(NegFactFile,write,NF),
	(mobal_get_fact(FactS),
	 fact_prop(FactS,Prop),
	 fact_ep(FactS,EP),
	 (EP = [1000,0],Fact = Prop
	 ;EP = [0,1000],Fact = not(Prop)
	 ),
	 writeq(BF,Fact),write(BF,'.'),nl(BF),
	 functor(Prop,Focus,_),
	 (EP = [1000,0],writeq(PF,Prop),write(PF,'.'),nl(PF)
	 ;EP = [0,1000],writeq(NF,Prop),write(NF,'.'),nl(NF)
	 ),
	 fail
	;true),
	close(BF),
	close(NF),
	close(PF).
