;;;____________________________________________________________________________________
;;;                              ANIMATE-COVERAGE-AND-WORK-WINDOW
;;;
;;;  Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;  This program may be freely copied, used, or modified provided that this
;;;  copyright notice is included in each copy of this code.  This program
;;;  may not be sold or incorporated into another product to be sold without
;;;  written permission from the Regents of the University of California.
;;;
;;;  This program was written by Clifford A. Brunk 07/24/91,
;;;  rewritten in CLOS to run under MACL 2.0b1 07/31/91
;;;
;;;  Problems:
;;;____________________________________________________________________________________

(in-package :user)

;;;____________________________________________________________________________________
;;;  setup-COVERAGE-AND-WORK-WINDOW


(defun setup-COVERAGE-AND-WORK-WINDOW ()
  (when (window-p *COVERAGE-AND-WORK-WINDOW*)
    (window-close *COVERAGE-AND-WORK-WINDOW*))
  (let* ((x0 3)
         (x1 20)
         (c1 75)
         (c2 175)
         (c3 275)

         (w1 150)
         (w2 220)
         (w3 290)

         (y 3)

         (display-font '("Chicago" 12 :SRCOR :PLAIN))
         (display-underline-font '("Chicago" 12 :SRCOR :UNDERLINE)))
    (setf *COVERAGE-AND-WORK-WINDOW*
          (make-instance 'dialog
                         :window-show nil
                         :window-type :document
                         :window-title "Coverage and Work"
                         :view-position '(:left 2)
                         :view-size #@(370 270)
                         :view-font display-font
                         :close-box-p t
                         :view-subviews
                         (list 
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x0 y) (make-point 60 14)
                                            "Status:" nil)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 60 y) (make-point 250 16)
                                            "idle" nil
                                            :view-nick-name :status)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 0 (incf y 16)) (make-point 400 16)
                                            "____________________________________________________________________" nil)


                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x0 (incf y 16)) (make-point 200 14)
                                            "Examples Covered:" nil)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 142 (incf y 5)) (make-point 120 14)
                                            "Not covered by" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 265 y) (make-point 100 14)
                                            "Covered by" nil)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 75 (incf y 15)) (make-point 100 14)
                                            "Total" nil :view-font display-underline-font)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 140 y) (make-point 120 14)
                                            "learned concept" nil :view-font display-underline-font)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 265 y) (make-point 100 14)
                                            "new clause" nil :view-font display-underline-font)

                          
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 20)) (make-point 50 14)
                                            "POS:" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point c1 y) (make-point 60 14)
                                            (format nil "~6@A" "-") nil
                                            :view-nick-name :uncovered-pos-initial)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point c2 y) (make-point 60 14)
                                            (format nil "~6@A" "-") nil
                                            :view-nick-name :uncovered-pos)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point c3 y) (make-point 60 14)
                                            (format nil "~6@A" "-") nil
                                            :view-nick-name :covered-pos)


                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 18)) (make-point 50 14)
                                            "NEG:" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point c1 y) (make-point 60 14)
                                            (format nil "~6@A" "-") nil
                                            :view-nick-name :uncovered-neg-initial)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point c2 y) (make-point 60 14)
                                            (format nil "~6@A" "-") nil
                                            :view-nick-name :uncovered-neg)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point c3 y) (make-point 60 14)
                                            (format nil "~6@A" "-") nil
                                            :view-nick-name :covered-neg)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 0 (incf y 14)) (make-point 400 16)
                                            "____________________________________________________________________" nil)


                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x0 (incf y 16)) (make-point 200 14)
                                            "Literals Tested:" nil)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 140 y) (make-point 75 14)
                                            "Literal" nil :view-font display-underline-font)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 210 y) (make-point 75 14)
                                            "Clause" nil :view-font display-underline-font)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point 280 y) (make-point 75 14)
                                            "Theory" nil :view-font display-underline-font)


                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 20)) (make-point 100 14)
                                            "Extensional" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w1 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :extensional-literal)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w2 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :extensional-clause)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w3 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :extensional-theory)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 18)) (make-point 100 14)
                                            "Builtin" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w1 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :builtin-literal)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w2 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :builtin-clause)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w3 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :builtin-theory)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 18)) (make-point 100 14)
                                            "Intensional" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w1 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :intensional-literal)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w2 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :intensional-clause)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w3 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :intensional-theory)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 18)) (make-point 100 14)
                                            "Determinate" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w1 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :determinate-literal)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w2 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :determinate-clause)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w3 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :determinate-theory)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 18)) (make-point 100 14)
                                            "Clich" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w1 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :cliche-literal)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w2 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :cliche-clause)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w3 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :cliche-theory)

                          (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 18)) (make-point 100 14)
                                            "EBL" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w1 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :ebl-literal)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w2 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :ebl-clause)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w3 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :ebl-theory)

                         (make-dialog-item 'static-text-dialog-item
                                            (make-point x1 (incf y 20)) (make-point 100 14)
                                            "TOTAL" nil)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w1 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :total-literal)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w2 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :total-clause)
                          (make-dialog-item 'static-text-dialog-item
                                            (make-point w3 y) (make-point 60 14)
                                            (format nil "~6@A" 0)  nil :view-nick-name :total-theory)
                          )))))

;;;____________________________________________________________________________________
;;;  display-status

(defun display-status (status)
  (when (window-p *COVERAGE-AND-WORK-WINDOW*)
    (set-dialog-item-text (view-named :status *COVERAGE-AND-WORK-WINDOW*)
                          (case status
                            (:paused "Paused")
                            (:finished "Finished")
                            (:extensional "Extensional Induction")
                            (:builtin "Builtin Induction")
                            (:intensional "Intensional Induction")
                            (:cliche "Clich Instantiation")
                            (:determinate "Determinate Addition")
                            (:ebl "Explanation Based Learning")
                            (:simplify-o "Simplifying Operationalization")
                            (:simplify-c "Simplifying Clause")
                            (t (format nil "~A" *status*))))
    (event-dispatch)
    ))


;;;____________________________________________________________________________________
;;;  display-initial-uncovered-examples

(defun display-initial-uncovered-examples (pos neg)
  (when (window-p *COVERAGE-AND-WORK-WINDOW*)
    (set-dialog-item-text (view-named :uncovered-pos-initial *COVERAGE-AND-WORK-WINDOW*)
                          (format nil "~6@A" pos))
    (set-dialog-item-text (view-named :uncovered-neg-initial *COVERAGE-AND-WORK-WINDOW*)
                          (format nil "~6@A" neg))
    (event-dispatch)
    ))

;;;____________________________________________________________________________________
;;;  display-uncovered-examples

(defun display-uncovered-examples (pos neg)
  (when (window-p *COVERAGE-AND-WORK-WINDOW*)
      (set-dialog-item-text (view-named :uncovered-pos *COVERAGE-AND-WORK-WINDOW*)
                            (format nil "~6@A" pos))
      (set-dialog-item-text (view-named :uncovered-neg *COVERAGE-AND-WORK-WINDOW*)
                            (format nil "~6@A" neg))
      (event-dispatch)
      ))

;;;____________________________________________________________________________________
;;;  display-covered-examples

(defun display-covered-examples (pos neg)
  (when (window-p *COVERAGE-AND-WORK-WINDOW*)
      (set-dialog-item-text (view-named :covered-pos *COVERAGE-AND-WORK-WINDOW*)
                            (format nil "~6@A" pos))
      (set-dialog-item-text (view-named :covered-neg *COVERAGE-AND-WORK-WINDOW*)
                            (format nil "~6@A" neg))
      (event-dispatch)
      ))

;;;____________________________________________________________________________________
;;;  display-work

(defun display-work (literal-work clause-work theory-work)
  (when (window-p *COVERAGE-AND-WORK-WINDOW*)
    (let ((window *COVERAGE-AND-WORK-WINDOW*))
      (set-dialog-item-text (view-named :extensional-literal window) (format nil "~6@A" (work-extensional literal-work)))
      (set-dialog-item-text (view-named :extensional-clause window) (format nil "~6@A" (work-extensional clause-work)))
      (set-dialog-item-text (view-named :extensional-theory window) (format nil "~6@A" (work-extensional theory-work)))
      
      (set-dialog-item-text (view-named :builtin-literal window) (format nil "~6@A" (work-builtin literal-work)))
      (set-dialog-item-text (view-named :builtin-clause window) (format nil "~6@A" (work-builtin clause-work)))
      (set-dialog-item-text (view-named :builtin-theory window) (format nil "~6@A" (work-builtin theory-work)))
      
      (set-dialog-item-text (view-named :intensional-literal window) (format nil "~6@A" (work-intensional literal-work)))
      (set-dialog-item-text (view-named :intensional-clause window) (format nil "~6@A" (work-intensional clause-work)))
      (set-dialog-item-text (view-named :intensional-theory window) (format nil "~6@A" (work-intensional theory-work)))
      
      (set-dialog-item-text (view-named :determinate-literal window) (format nil "~6@A" (work-determinate literal-work)))
      (set-dialog-item-text (view-named :determinate-clause window) (format nil "~6@A" (work-determinate clause-work)))
      (set-dialog-item-text (view-named :determinate-theory window) (format nil "~6@A" (work-determinate theory-work)))
      
      (set-dialog-item-text (view-named :cliche-literal window) (format nil "~6@A" (work-cliche literal-work)))
      (set-dialog-item-text (view-named :cliche-clause window) (format nil "~6@A" (work-cliche clause-work)))
      (set-dialog-item-text (view-named :cliche-theory window) (format nil "~6@A" (work-cliche theory-work)))
      
      (set-dialog-item-text (view-named :ebl-literal window) (format nil "~6@A" (work-ebl literal-work)))
      (set-dialog-item-text (view-named :ebl-clause window) (format nil "~6@A" (work-ebl clause-work)))
      (set-dialog-item-text (view-named :ebl-theory window) (format nil "~6@A" (work-ebl theory-work)))
      
      (set-dialog-item-text (view-named :total-literal window)
                            (format nil "~6@A" (+ (work-extensional literal-work)
                                                  (work-builtin literal-work)
                                                  (work-intensional literal-work)
                                                  (work-determinate literal-work)
                                                  (work-cliche literal-work)
                                                  (work-ebl literal-work))))
      (set-dialog-item-text (view-named :total-clause window)
                            (format nil "~6@A" (+ (work-extensional clause-work)
                                                  (work-builtin clause-work)
                                                  (work-intensional clause-work)
                                                  (work-determinate clause-work)
                                                  (work-cliche clause-work)
                                                  (work-ebl clause-work))))
      (set-dialog-item-text (view-named :total-theory window)
                            (format nil "~6@A" (+ (work-extensional theory-work)
                                                  (work-builtin theory-work)
                                                  (work-intensional theory-work)
                                                  (work-determinate theory-work)
                                                  (work-cliche theory-work)
                                                  (work-ebl theory-work))))
      (event-dispatch)
      )))


(provide :animate-coverage-and-work)




