
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

;;;  revisions
;;;  rv  who    date      reason
;;;  01  cliff  5/23/91   added grapher loading functions
;;;  02  cliff  6/02/91   combine FOCL and ES-FOCL loader display filename being loaded on mac
;;;  03  cliff  7/01/91   cleaned up(?)
;;;  04  mp     7/03/91   minor fix to mac-load (when no : in pathname)
;;;  05  cliff  7/01/91   cleaned up(?)

(in-package :user)

(defvar *LOADING-MESSAGE-BOX* nil)

#-:ccl (proclaim '(optimize (safety 0)(speed 3)))
#+:ccl (proclaim '(optimize (safety 3)(speed 0)))

#+:ccl (when (catch-cancel (y-or-n-dialog "Do you want your init file loaded" :position :centered))
         (load "ccl;init.lisp" :if-does-not-exist nil))


(defparameter *focl-core-files* '("globals" "loop" "macros" "cliche-macros" "structs"
                                  "cruel-compiler" "count" "focl" "find-literal" 
                                  "simplify"
                                  "builtin" "operationalize"
                                  "pruning" "variabilization-lists" "is" 
                                  "dt-mutator"
                                  "cliches" "cliche-restrictions" "cliches-predefined"
                                  ))

#+:ccl (defparameter *focl-es-files* '("globals"
                                       "macros"
                                       "structs"
                                       "loop"
                                       "cruel-compiler"
                                       "count"
                                       "interface"
                                       ))

#+:ccl (defparameter *focl-grapher-files* '("traps"
                                            "records"
                                            "scroll-bar-dialog-items"
                                            "grapher"
                                            ))

#+:ccl (defparameter *focl-animate-files* '("animate-learning"
                                            "animate-learned-definition"
                                            "animate-induction"
                                            "animate-operationalization"
                                            "animate-pause"
                                            "animate-coverage-and-work"
                                            "relations-and-cliches"))

(defparameter *focl-files* '("globals" "loop" "macros" "cliche-macros" "structs"
			     "cruel-compiler" "count" "focl" "find-literal" "summarize"
                             "simplify" "learning-curve"
                             "stopping" "REP"
			     "operationalize"
                             "builtin" "test-focl" "testing-illegal"
                             "pruning" "variabilization-lists" "is" 
                             "dt-mutator" "cliches" "cliche-restrictions"
                             "cliches-predefined"
			     "noisy-testing-illegal"
			     "noisy-testing-students"
                             ))
#|
;;  To Run noise Tests
(defparameter *focl-files* '("globals" "loop" "macros" "cliche-macros" "structs"
			     "cruel-compiler" "count" "focl" "find-literal"
                             ; "summarize"
                             "simplify" 
                             ; "learning-curve"
                             "stopping" "REP"
			     "operationalize"
                             "builtin"
                             ; "test-focl" "testing-illegal"
                             "pruning" "variabilization-lists" "is" 
                             ; "dt-mutator"
                             "cliches" "cliche-restrictions"
                             "cliches-predefined"
			     "noisy-testing-illegal"
			     ;"noisy-testing-students"
                             ))
|#

(defparameter *test-files* '("illegal" "illegal-200" "member" 
                             "loan" ; "bad-loan" this appears to be gone
                             "students" "chess-knight-and-rook"
                             "chess-domain" "test-numbers" 
                             "runtriangle"  "process-triangle"
                             "triangle-mutations"
                             "typed-students" "typed-loan" "test-hr" "test-is" ; builtin test
                             "triangle" "test-triangle" "test-triangle2" ; triangle test
                             "part-of-ourcup" "test-arithmetic-cliche" ; cliche-test
                             "test-hbp-ewbc-simp" "test-non-numeric" "recursive-member"
                             "recursive-length" 
                             "test-b=7" "test-string-lessp" ; equality and non-numeric builtin test
                             "trade-cases" "trade-dt" "trade-outcomes" ; trade negotiations test
))

(defparameter *test-prefix* "Test/")

#+:ccl (defparameter *mac-prefix* "home;")
#+:ccl (defparameter *mac-comp-prefix* "home;Compiled Folder:")
#+:ccl (defparameter *mac-test-prefix* "home;Test Folder:")
#+:ccl (defparameter *mac-comp-test-prefix* "home;Compiled Test Folder:")

;;;____________________________________________________________________________________
;;;  MACIFIED VERSION OF LOAD AND REQUIRE                                                     

;;;mp chnaged to look for ; if no :, might also want to set it to -1 if neither

#+:ccl (defun mac-load (file)
         (let ((display-name (subseq file (+ (or (position #\: file :test #'eql :from-end t)
                                                 (position #\; file :test #'eql :from-end t)) 1))))
           (cond
            ((ask *LOADING-MESSAGE-BOX* (ownp 'wptr))
             (display-loading-file display-name)
             (load file))
            (t
             (create-loading-message-box)
             (display-loading-file display-name)
             (load file)
             (dispose-loading-message-box)))))

;; Perhaps there should be a shadow of require which looks for thing in the appropriate place
;; and displays that they are being loaded         

(defun load-source-file (file)
  #+:ccl (mac-load (format nil "~a~a.lisp" *mac-prefix* file))
  #-:ccl (load (format nil "~a.lisp" file))
  )

(defun compile-source-file(file)
  #+:ccl (compile-file (format nil "~a~a.lisp" *mac-prefix* file)
                       :output-file (format nil "~a~a.fasl" *mac-comp-prefix* file))
  #-:ccl (compile-file (format nil "~a.lisp" file))
  )

(defun load-compiled-file(file)
  #+:ccl     (mac-load (format nil "~a~a.fasl" *mac-comp-prefix* file))
  #+:allegro (load (format nil "~a.fasl" file))
  #+:kcl     (load (format nil "~a.o" file))
  #+:lucid   (load (format nil "~a.sbin" file))
  )

(defun load-source-test-file (file)
  #+:ccl (mac-load (format nil "~a~a.lisp" *mac-test-prefix* file))
  #-:ccl (load (format nil "~a~a.lisp" *test-prefix* file))
  )

(defun compile-test-source-file(file)
  #+:ccl (compile-file (format nil "~a~a.lisp" *mac-test-prefix* file)
                       :output-file (format nil "~a~a.fasl" *mac-comp-test-prefix* file))
  #-:ccl (compile-file (format nil "~a~a.lisp" *test-prefix* file))
  )

(defun load-compiled-test-file(file)
  #+:ccl     (mac-load (format nil "~a~a.fasl" *mac-comp-test-prefix* file))
  #+:allegro (load (format nil "~a~a.fasl" *test-prefix* file))
  #+:kcl     (load (format nil "~a~a.o" *test-prefix* file))
  #+:lucid   (load (format nil "~a~a.sbin" *test-prefix* file))
  )

(defun load-source()
  #+:ccl (create-loading-message-box)
  (mapc #'load-source-file *focl-files*)
  #+:ccl (dispose-loading-message-box)
  )

(defun load-comp()
  #+:ccl (create-loading-message-box)
  (mapc #'load-compiled-file *focl-files*)
  #+:ccl (dispose-loading-message-box)
  #+:lucid (compiler-options :messages nil :warnings nil :undef-warnings nil)
  )

(defun compile-all (&optional (files *focl-files*))
  (mapc #'compile-source-file files))

(defun compile-all-tests (&optional (files *test-files*))
  (mapc #'compile-test-source-file files))



;;;____________________________________________________________________________________
;;;  Load Grapher                                                     

#+:ccl (defparameter *mac-mac-prefix* "home;Mac Folder:")

#+:ccl (defun load-mac-source-file (file)
         (mac-load (format nil "~a~a.lisp" *mac-mac-prefix* file)))

#+:ccl (defun compile-mac-source-file (file)
         (compile-file (format nil "~a~a.lisp" *mac-mac-prefix* file)
                       :output-file (format nil "~a~a.fasl" *mac-comp-prefix* file)))


;;;____________________________________________________________________________________
;;;  LOADING-MESSAGE-BOX

#+:ccl (defun create-loading-message-box ()
         (setf *LOADING-MESSAGE-BOX*
               (oneof *dialog*
                      :window-type :double-edge-box
                      :window-title "LOADING MESSAGE BOX"
                      :window-size (make-point 350 100)
                      :window-position :centered
                      :window-show t))
         (ask *LOADING-MESSAGE-BOX*
           (add-dialog-items 
            (oneof *static-text-dialog-item*
                   :dialog-item-nick-name :text
                   :dialog-item-text ""))))

#+:ccl (defun display-loading-file (filename)
         (let* ((display-text (format nil " Loading \"~A\" " filename))
                (text-width (* (length display-text) 7.5)))
           (ask *LOADING-MESSAGE-BOX*
             (ask-named-item :text
               (set-dialog-item-size (make-point (round text-width 1) 40))
               (set-dialog-item-position (make-point (round (- 350 text-width) 2) 40))
               (set-dialog-item-text display-text))
             (window-select)
             (event-dispatch))))

#+:ccl (defun dispose-loading-message-box ()
         (ask *LOADING-MESSAGE-BOX*
           (window-hide)
           (window-close))
         (setf *LOADING-MESSAGE-BOX* nil))


;;;____________________________________________________________________________________
;;; LOAD-FOCL 
;;;
;;;  Displays a dialog box with options for loading variants of FOCL on the MAC.

#+:ccl (defun load-focl ()
         (let* ((window-h 400)
                (window-v 160)
                (r-button-h 25)
                (offset 180)
                (LOAD-SELECTION-DIALOG-BOX (oneof *dialog*
                                                  :window-type :double-edge-box
                                                  :window-size (make-point window-h window-v)
                                                  :window-show nil
                                                  :window-position :centered)))

         (ask LOAD-SELECTION-DIALOG-BOX
           (add-dialog-items 
            (oneof *static-text-dialog-item*
                   :dialog-item-text "Select variant to be loaded:"
                   :dialog-item-size (make-point (- window-h r-button-h 10) 20)
                   :dialog-item-position (make-point r-button-h 5))
            
            (oneof *radio-button-dialog-item*
                   :dialog-item-text "FOCL-ES"
                   :dialog-item-position (make-point r-button-h 34)
                   :radio-button-cluster 0
                   :radio-button-pushed-p nil)
            
            (oneof *radio-button-dialog-item*
                   :dialog-item-text "FOCL Core"
                   :dialog-item-position (make-point r-button-h 50)
                   :radio-button-cluster 0
                   :radio-button-pushed-p nil)
            
            (oneof *radio-button-dialog-item*
                   :dialog-item-text "FOCL Complete"
                   :dialog-item-position (make-point r-button-h 66)
                   :radio-button-cluster 0
                   :radio-button-pushed-p nil)
            
             (oneof *radio-button-dialog-item*
                   :dialog-item-text "KR-FOCL Graphic Demo"
                   :dialog-item-position (make-point r-button-h 82)
                   :radio-button-cluster 0
                   :radio-button-pushed-p nil)
            
            (oneof *radio-button-dialog-item*
                   :dialog-item-text "KR-FOCL-ES"
                   :dialog-item-position (make-point r-button-h 98)
                   :radio-button-cluster 0
                   :radio-button-pushed-p t)
            
            (oneof *radio-button-dialog-item*
                   :dialog-item-text "Load Source"
                   :dialog-item-position (make-point (+ r-button-h offset) 34)
                   :radio-button-cluster 1
                   :radio-button-pushed-p nil)
            
            (oneof *radio-button-dialog-item*
                   :dialog-item-text "Load and Compile Source"
                   :dialog-item-position (make-point (+ r-button-h offset) 50)
                   :radio-button-cluster 1
                   :radio-button-pushed-p nil)
            
            (oneof *radio-button-dialog-item*
                   :dialog-item-text "Load Compiled"
                   :dialog-item-position (make-point (+ r-button-h offset) 66)
                   :radio-button-cluster 1
                   :radio-button-pushed-p t)
            
            (oneof *button-dialog-item*                      ;; Dialog Exit - Button Cluster
                   :dialog-item-text " LOAD "
                   :default-button t
                   :dialog-item-position (make-point (- window-h 145)  (- window-v 27))
                   :dialog-item-size (make-point 60 20)
                   :dialog-item-action
                   #'(lambda ()
                       (return-from-modal-dialog
                        (ask my-dialog
                          (cons (ask (pushed-radio-button 0) (dialog-item-text))
                                (ask (pushed-radio-button 1) (dialog-item-text)))))))
            
            (oneof *button-dialog-item*
                   :dialog-item-nick-name :Cancel
                   :dialog-item-text " Cancel "
                   :dialog-item-position (make-point (- window-h 70)  (- window-v 27))
                   :dialog-item-size (make-point 60 20)
                   :dialog-item-action #'(lambda () (return-from-modal-dialog :cancel)))
            ))
    
         (catch-cancel
           (let* ((message (modal-dialog LOAD-SELECTION-DIALOG-BOX t))
                  (files (car message))
                  (mode (cdr message)))
             
             (case files
               
               ("FOCL-ES"
                (create-loading-message-box)
                (case mode
                  ("Load Source"
                   (mapc #'load-source-file *focl-es-files*))
                  ("Load and Compile Source"
                   (mapc #'load-source-file *focl-es-files*)
                   (mapc #'compile-source-file *focl-es-files*))
                  ("Load Compiled"
                   (mapc #'load-compiled-file *focl-es-files*)))
                (dispose-loading-message-box)
                (setq *listener-window-position* (make-point 6 300))
                (setq *listener-window-size* (make-point 550 173))
                (format t "~%~%FOCL-ES loaded.~%~%")
                (ask *graph-goal-concept* (menu-item-enable))
                (es))
               

               ("FOCL Core"
                (create-loading-message-box)
                (case mode
                  
                  ("Load Source"
                   (mapc #'load-source-file *focl-core-files*))
                  
                  ("Load and Compile Source"
                   (mapc #'load-source-file *focl-core-files*)
                   (mapc #'compile-source-file *focl-core-files*))
                  
                  ("Load Compiled"
                   (mapc #'load-compiled-file *focl-core-files*)))
                
                (dispose-loading-message-box)
                (format t "~%~%FOCL core files loaded.~%~%"))
               
               
               ("FOCL Complete"
                (create-loading-message-box)
                (case mode

                  ("Load Source"   
                   (mapc #'load-source-file *focl-files*))

                  ("Load and Compile Source"
                   (mapc #'load-source-file *focl-files*)
                   (mapc #'compile-source-file *focl-files*))

                  ("Load Compiled" 
                   (mapc #'load-compiled-file *focl-files*)))

                (dispose-loading-message-box)
                (format t "~%~%FOCL files loaded.~%~%"))
               
               ("KR-FOCL Graphic Demo"
                (create-loading-message-box)
                (case mode
                  
                  ("Load Source"
                   (mapc #'load-source-file *focl-core-files*)
                   (mapc #'load-mac-source-file *focl-grapher-files*)
                   (mapc #'load-mac-source-file *focl-animate-files*)
                   (load-mac-source-file "KR-FOCL"))
                  
                  ("Load and Compile Source"
                   (mapc #'load-source-file *focl-core-files*)
                   (mapc #'load-mac-source-file *focl-grapher-files*)
                   (mapc #'load-mac-source-file *focl-animate-files*)
                   (load-mac-source-file "KR-FOCL")
                   (mapc #'compile-source-file *focl-core-files*)
                   (mapc #'compile-mac-source-file *focl-grapher-files*)
                   (mapc #'compile-mac-source-file *focl-animate-files*)
                   (compile-mac-source-file "KR-FOCL"))
                  
                  ("Load Compiled"
                   (mapc #'load-compiled-file *focl-core-files*)
                   (mapc #'load-compiled-file *focl-grapher-files*)
                   (mapc #'load-compiled-file *focl-animate-files*)
                   (load-compiled-file "KR-FOCL")))
                
                (dispose-loading-message-box)
                (ask *graph-menu* (menu-install))
                (ask *demo-menu* (menu-install))
                (ask *revise-menu* (menu-install))
                (format t "~%~%KR-FOCL Graphic Demo loaded.~%~%"))
               
               
               ("KR-FOCL-ES"
                (create-loading-message-box)
                (case mode
                  
                  ("Load Source"
                   (mapc #'load-source-file *focl-core-files*)
                   (mapc #'load-mac-source-file *focl-grapher-files*)
                   (mapc #'load-mac-source-file *focl-animate-files*)
                   (load-mac-source-file "KR-FOCL")
                   (load-mac-source-file "interface"))
                  
                  ("Load and Compile Source"
                   (mapc #'load-source-file *focl-core-files*)
                   (mapc #'load-mac-source-file *focl-grapher-files*)
                   (mapc #'load-mac-source-file *focl-animate-files*)
                   (load-mac-source-file "KR-FOCL")
                   (load-mac-source-file "interface")
                   (mapc #'compile-source-file *focl-core-files*)
                   (mapc #'compile-mac-source-file *focl-grapher-files*)
                   (mapc #'compile-mac-source-file *focl-animate-files*)
                   (compile-mac-source-file "KR-FOCL")
                   (compile-mac-source-file "interface"))
                  
                  ("Load Compiled"
                   (mapc #'load-compiled-file *focl-core-files*)
                   (mapc #'load-compiled-file *focl-grapher-files*)
                   (mapc #'load-compiled-file *focl-animate-files*)
                   (load-compiled-file "KR-FOCL")
                   (load-compiled-file "interface")))
                
                (dispose-loading-message-box)
                (es)
                (format t "~%~%KR-FOCL-ES loaded.~%~%"))
               )))
         ))


#+:ccl (load-focl)

