
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
(defun learning-curve-on-theory (theory allinstances instance-array classes
                                 &optional lc-trace (start 20) (step 20)
                                 &key (iterations-per-run 10) (old-vars '(?T ?A ?B ?C))
                                 (new-vars '(?0 ?1 ?2 ?3)) print-new-theories
                                 (max-new-variables 0) trace partial-dt-0-gain
                                 &aux n-instances remaining-instances new-theory
                                 (num-instances (length allinstances)) 
                                 run-data overall-data new-instance-array)
  (do* ((run start (+ run step))
        (n (min run num-instances) (min run num-instances)))
       ((>= run (+ num-instances step)) overall-data)
    (and lc-trace
         (format t "~% performing learning curve expt with ~A out of ~A instances" 
                 n num-instances))
    (setq run-data nil)
    (dotimes (i iterations-per-run)
      (multiple-value-setq 
       (n-instances remaining-instances)
       (generate-n-random-instances n allinstances))
      (setq new-instance-array (sort-instances n-instances classes))
      ; setup extensional pred defs to have the appropriate pos and neg examples
      (set-class-pred-pos-neg classes new-instance-array)
      (setq new-theory
            (run-focl-on-theory theory classes :vars new-vars :trace trace 
                                :partial-dt-0-gain partial-dt-0-gain 
                                :max-new-variables max-new-variables))
      (cond (print-new-theories
             (format t "~%new domain theory: ~%")
             (print-theory new-theory))
            (t nil))
      (and lc-trace 
           (progn (format t "~%New FOCL theory:~%")
                  (print-theory new-theory)))
      (setq run-data 
            (nconc 
             (list
              (list n
                    (domain-theory-accuracy theory classes allinstances instance-array old-vars)
                    (domain-theory-accuracy new-theory classes allinstances instance-array new-vars)))
             run-data)))
    (setq overall-data (nconc (list run-data) overall-data))))


(defun print-theory (theory)
  (dolist (class-info theory)
    (format t "~%~A:~%~A~%" (car class-info) (cdr class-info))))

(defun average-list (numbers)
  (coerce (/ (apply #'+ numbers) (length numbers)) 'float))


;;; the main work is done in learning-curve-on-theory this just collects and prints out summary 
;;; info as well as the info produced by learning-curve-on-theory

(defun process-theory (theory allinstances instance-array classes
                       &optional lc-trace (start 20) (step 20)
                       &key (iterations-per-run 10) (old-vars '(?T ?A ?B ?C))
                       (new-vars '(?0 ?1 ?2 ?3)) (print-old-theory t) print-new-theories
                       (max-new-variables 0) trace partial-dt-0-gain
                       &aux learning-curve-info summary-info)
  (cond (print-old-theory
         (format t "~%original domain theory: ~%")
         (print-theory theory))
        (t nil))
  (setq learning-curve-info
        (learning-curve-on-theory theory allinstances instance-array classes lc-trace start step
           :iterations-per-run iterations-per-run :old-vars old-vars :new-vars new-vars
           :max-new-variables max-new-variables :trace trace :partial-dt-0-gain partial-dt-0-gain
           :print-new-theories print-new-theories))
  (setq summary-info
        (mapcar 
         #'(lambda (run-info)
             (list (caar run-info) ; size of run
                   (average-list (mapcar #'second run-info)) ; original accuracy avg.
                   (average-list (mapcar #'third run-info)))) ; new focl theory accuracy avg.
         learning-curve-info))
  (format t "~%raw learning curve data: ~%~A~%" learning-curve-info)
  (format t "~%summary learning curve data: ~%~A~%" summary-info)
  (values summary-info learning-curve-info))


;;; run learning curve expts for a set number of mutations perform on a correct domain theory

(defun mutate-theory-and-run-lc-expts (correct-theory no-mutations allinstances instance-array 
                                       classes &optional lc-trace (start 20) (step 20)
                                       &key (number-mutated-theories 5) 
                                       (iterations-per-run 10) (old-vars '(?T ?A ?B ?C))
                                       (new-vars '(?0 ?1 ?2 ?3)) (print-old-theory t)
                                       print-new-theories
                                       (max-new-variables 0) trace partial-dt-0-gain
                                       &aux learning-curve-summary mutated-theory
                                       mutated-theories-info mutated-theories-summary
                                       mutations-performed actual-mutations learning-curve-info
                                       )
  (dotimes (i number-mutated-theories)
    (multiple-value-setq (mutated-theory mutations-performed actual-mutations)
      (mutate-class-theory correct-theory no-mutations))
    (format t "~%mutations performed: ~% ~A" mutations-performed)
    (multiple-value-setq 
      (learning-curve-summary learning-curve-info)
      (process-theory mutated-theory allinstances instance-array classes lc-trace start step
           :iterations-per-run iterations-per-run :old-vars old-vars :new-vars new-vars
           :max-new-variables max-new-variables :trace trace :partial-dt-0-gain partial-dt-0-gain
           :print-old-theory print-old-theory :print-new-theories print-new-theories))
    (setq mutated-theories-info 
          (nconc (list (cons no-mutations learning-curve-summary)) mutated-theories-info)))
  (setq mutated-theories-summary nil)
  (dotimes (i (1- (length (car mutated-theories-info))))
    (setq mutated-theories-summary
          (cons 
           (cons (caar mutated-theories-info) 
                 (list (car (nth (1+ i) (car mutated-theories-info))) 
                       (average-list 
                        (mapcar #'(lambda (list) (second (nth (1+ i) list))) mutated-theories-info))
                       (average-list 
                        (mapcar #'(lambda (list) (third (nth (1+ i) list))) mutated-theories-info))))
           mutated-theories-summary)))
  (format t "~% raw mutated theory data: ~%~A~%" mutated-theories-info)
  (format t "~% summary mutated theory data: ~%~A~%" mutated-theories-summary)
  (values mutated-theories-summary mutated-theories-info))

(defun average-over-sets-of-lists (lists &aux results)
  (dotimes (i (1- (length (car lists))) results)
    (setq results 
          (cons 
           (cons (caar lists) 
                 (list (car (nth (1+ i) (car lists))) 
                       (average-list (mapcar #'(lambda (list) (second (nth (1+ i) list))) lists))
                       (average-list (mapcar #'(lambda (list) (third (nth (1+ i) list))) lists))))
           results))))
          
(defun run-overall-mutation-lc-expt (correct-theory allinstances instance-array classes 
                                     &optional lc-trace (start 20) (step 20) 
                                     (mutations-list '(1 2 3 4 5)) ; #s of mutations to perform
                                     &key (number-mutated-theories 5) 
                                     (iterations-per-run 10) (old-vars '(?T ?A ?B ?C))
                                     (new-vars '(?0 ?1 ?2 ?3)) (print-old-theory t)
                                     print-new-theories
                                     (max-new-variables 0) trace partial-dt-0-gain
                                     all-data)
  (setq all-data
        (mapcar 
         #'(lambda (no-mutations)
             (format t "~%Processing theories with ~A mutations~%" no-mutations)
             (mutate-theory-and-run-lc-expts correct-theory no-mutations allinstances instance-array 
                                             classes lc-trace start step :iterations-per-run iterations-per-run 
                                             :number-mutated-theories number-mutated-theories
                                             :old-vars old-vars :new-vars new-vars :max-new-variables max-new-variables 
                                             :trace trace :partial-dt-0-gain partial-dt-0-gain :print-old-theory 
                                             print-old-theory :print-new-theories print-new-theories))
         mutations-list))
  (format t "~%all data (for all mutated theories): ~%~A" all-data))
  

(defun load-data-and-run-overall-lc-expt (data-file correct-theory
                                         &optional lc-trace (start 20) (step 20) 
                                         (mutations-list '(1 2 3 4 5)) ; #s of mutations to perform
                                         &key (number-mutated-theories 5) 
                                         (iterations-per-run 10) (old-vars '(?T ?A ?B ?C))
                                         (new-vars '(?0 ?1 ?2 ?3)) (print-old-theory t)
                                         print-new-theories
                                         (max-new-variables 0) trace partial-dt-0-gain
                                         &aux allinstances instance-array classes)
  (multiple-value-setq 
     (allinstances instance-array classes)
     (process-triangle-input data-file))
  (run-overall-mutation-lc-expt correct-theory allinstances instance-array classes lc-trace
                start step mutations-list :iterations-per-run iterations-per-run 
                :number-mutated-theories number-mutated-theories
                :old-vars old-vars :new-vars new-vars :max-new-variables max-new-variables 
                :trace trace :partial-dt-0-gain partial-dt-0-gain :print-old-theory 
                print-old-theory :print-new-theories print-new-theories))
                       
  
           
;(load-data-and-run-overall-lc-expt "data:stest25" *correct-triangle-theory* nil 20 20 '(1 3)
;  :number-mutated-theories 2 :iterations-per-run 2 :partial-dt-0-gain t)
