
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
(defvar *covered-all-pos-tuples* nil)
(defvar *refinement* nil)
(defvar *all-types* nil)  ;all types
(defvar *batch* nil) ; don't ask the user questions 
(defparameter *occur-check* nil)  ; Performs an occur check if T
(defparameter *use-gensyms* t)  ; Uses gensym to create unique variables if T
                          ; otherwise uses copy-symbol


;; -- count ----------------------------------------
(defvar *extensional-preds* nil)  ;;alist of (name . pred-structure)
(defvar *intensional-preds* nil)  ;;alist of (name . rule-structure)

(defvar *print-deleted-literals* T) ;determines whether deleted literals should be skipped or printed

(defvar *predicate-being-learned* nil) ;set by focl, used by prolog to avoid extensional definition
                                       ;of predicate being learned

(defvar *init-slot-table-size* 10)
(defvar *slot-table-rehash-threshold* .9)
(defvar *slot-table-rehash-size* 1.5)

(defvar *builtin-preds* nil)


;; -- focl ----------------------------------------
(defvar *operationalize-constructive* t)
(defvar *simplify-clauses* t)
(defvar *constructive-induction* t)
(defvar *proof-vars-available* t)
(defvar *focl-trace-level* nil) ;a list
(defvar *variablizations-checked* 0)
(defvar *stopping-criteria-enabled* nil)
(defvar *print-warnings* nil)
(defvar *partial-dt-0-gain* nil) 
(defvar *simplify-operationalizations* nil)
(defvar *gain-function* nil)  ;only by opertaionalize for now.
(defvar *prefer-deletions* nil)  ;controls how ties are handled in operationalize
(defvar *prefer-children* t)   
(defvar *focl-batch-mode* nil) 
(defvar *save-examples* nil) 
(defvar *try-cliches-first* nil)
(defvar *try-all-conjunctions* nil)
(defvar *perform-pruning-III* nil)
(defvar *builtin-threshold-only* nil)
(defvar *use-relational-cliches* t)
(defvar *available-relational-cliches* nil)

(defvar *focl-trace-level* nil) ;a list
; :i information gain
; :c new clauses
; :l new literals
; :ct tuples for each clause
; :lt tuples for each literal
; :b bits
; :o operationalization

(defvar *graph-learning* nil)       ;; An MACL specific list (must be nil under other lisps)
; :learned-concept-description         Display the learned definition as each literal is added
; :induction                           Display the each literal/cliche-instantiation tested
; :ebl                                 Display the operationalization of the domain theory.
; :constructive-induction              Display the operationalization of induced literals.
; :coverage-work                       Display the # of examples (un)covered and # of literals tested.                                
; :pause                               Display a pause window.
; :pause-after-clause                  Display a pause window & pause after learning each clause.
; :relations                           Display an inspection window of all known relations
; :cliche                              Display an inspection window of all known relations

(defvar *theory-mode* t) ;;ebl prefered to induction

;; -- simplify-opzns ----------------------------------------

; for comparison of simplify algs
(defvar *total-deletions* nil) ; number of times optimal deletes one or more literals
(defvar *deletions-agree*) ; number of times optimal and greedy algs agree

; counts the variablizations checked during simplification
(defvar *ebl-variabilizations* 0) 

;; -- find-literal ----------------------------------------

;; -- cliches ----------------------------------------

(defvar *all-cliches* nil)

(defvar *cliche-variabilizations-checked* nil)


(defvar *cliches-to-be-named* nil)
(defvar *named-cliches* nil)
(defvar *anonymous-cliches* nil)
;; -- summarize ----------------------------------------

;; -- builtin ----------------------------------------

;; -- is ----------------------------------------

(defvar *builtin-fns* nil) ; we use this now

;; -- arith ----------------------------------------

(defvar *arithmetic-ops* nil)
(defvar *is-ops* nil)

;; -- testing-simp ----------------------------------------

