
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)


(defparameter *all-mutatables* 
  '(same-loc king-attack-king  rook-attack-king  king-not-between))

(defparameter *all-additions* '(between equal near))

(defun random-element(x)
  (when x
	(nth (random (length x)) x)))

(defun delete-random-clause (&optional (n 25) &aux e c)
  (cond((= n 0) (format t "Can't delete anything"))
       (t (setq e (random-element *all-mutatables*))
          (setq c (random-element (get-clause-bodies e)))
          (if (and c (cdr (get-clause-bodies e)))
	      (eval `(def-rule ,e  :type ,(get-type  e) 
			 :clauses ,(remove c (get-clause-bodies e))))
              (delete-random-clause (- n 1))))))

(defun get-clause-bodies(e)
  (mapcar #'cdr (get e 'brules)))
(defun get-type(e)
  (p-type (or (get e 'rule)(get e 'pred))))



(defun delete-random-term (&optional (n 20) &aux e c r)
  (cond((= n 0) (format t "Can't delete anything"))
       (t (setq e (random-element *all-mutatables*))
          (setq c (random-element (get-clause-bodies e)))
          
          (cond((cddr c) (setq r (remove (random-element (cdr c)) c))
                (eval `(def-rule ,e  :type ,(get-type  e) :clauses , (cons r (remove c (get-clause-bodies e))))))
              (t (delete-random-term (- n 1)))))))



(defun random-term(vars &aux head)
  (setq head (random-element *all-additions*))
  (cons head (mapcar #'(lambda(x) x (random-element vars))
                     (get-type head))))

(defun add-random-term (&aux e c r)
  (setq e (random-element *all-mutatables*))
  (setq c (random-element (get-clause-bodies e)))
  (setq r (cons (car c) (cons (random-term (cdr(car c))) (cdr c))))
  (if c 
      (eval `(def-rule ,e  :type ,(get-type  e) :clauses , 
	       (cons r (remove c (get-clause-bodies e)))))
    (add-random-term)))
  


(defun add-random-clause (&aux e c r v)
  r
  (setq e (random-element *all-mutatables*))
  (setq v (cdr (car(first (get-clause-bodies e)))))
  (setq c (random-terms v))
  (eval `(def-rule ,e :type ,(get-type  e) :clauses , 
        (cons (cons (cons e v) c) (get-clause-bodies e)))))


(defun random-terms(v)
  (if (> (random 100) 50)
    (list (random-term v))
    (cons (random-term v)(random-terms v))))
  





