
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

;;; cliches

(def-cliche threshold-comparator
  :pred-restrictions ((ext-pred (supports-new-var numeric-type)) (comp))
  :var-restrictions (((introduces-new-var numeric-type)) ((include-new-var 0 numeric-type)))
  :cache? named)


;;; consider adding compatable type for pred and possibly var-restrictions

(def-cliche partof
  :pred-restrictions (((include-pred partof)) (ext-pred))
  :var-restrictions (((introduces-new-var nil 0)) ((include-new-var 0)))
  :cache? named)

(def-cliche arithmetic
  :pred-restrictions ((arith-op (supports-new-var numeric-type)) (var-comp))
  :var-restrictions (((introduces-new-var numeric-type)) ((include-new-var 0 numeric-type)))
  :cache? anonymous)

;;  doesn't work yet need a way of introducing the constant - could have find-literal-builtin
;;  do it, but we only want it done when we do this cliche

;;; note may want to consider other non-numeric preds - consider adding constraints for 
;;; numeric and non-numeric comparators.

(def-cliche non-numeric-constant
  :pred-restrictions ((ext-pred (supports-new-var)) (comp (include-pred eql)))
  :var-restrictions (((introduces-new-var)) ((include-new-var 0 non-numeric-type))))

(def-cliche unconstrained
  :pred-restrictions ((pred) (pred))
  :var-restrictions (nil nil))

;;; first cut less constrained

(def-cliche recursive
  :pred-restrictions ((ext-pred (pred-class reduction-pred)) 
                      (ext-pred (pred-class recursive-pred)))
;  :var-restrictions (((include-old-var head) (introduces-new-var))
;                     ((use-same-vars head 1) (include-new-var 0)))
  :var-restrictions (((reduction-variabilization))
                     ((use-same-vars head 1) (include-new-var 0)))
  :cache? nil)

(def-cliche recursive2
  :pred-restrictions ((ext-pred (pred-class reduction-pred)) 
                      (ext-pred (pred-class reduction-pred)) 
                      (ext-pred (pred-class recursive-pred)))
  :var-restrictions (((reduction-variabilization))
                     ((reduction-variabilization))
                     ((include-new-var 0) (include-new-var 1)))
  :cache? nil)
