
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
;;; variabilization restriction code

;;  00  glenn  02/09/91   added to implement variabilization-restrictions for cliches
;;  01  glenn  05/05/91   updated to reflect changes in cliche implementation

(defun apply-variabilization-restrictions (pred restrictions variabilizations old-vars
                                           original-vars ; for recursive predicate
                                           instantiated-cliche position-in-cliche)
  (if (null restrictions)  
    variabilizations
    (remove-if-not
     #'(lambda (var-struct)
         (every #'(lambda (restriction) 
                    (variabilization-satisfies-restriction pred
                                                           restriction (variabilization-struct-variabilization var-struct)
                                                           old-vars original-vars instantiated-cliche position-in-cliche))
                restrictions))
     variabilizations)))

;;  00  glenn  05/05/91  hack to deal with restrictions for threshold builtins 
;; should tap into variabilization-satisfies-restriction but I need to figure out what to do 
;;  with the missing information as the pred is not yet know etc.

(defun apply-thresh-var-restrictions (restrictions variables instantiated-cliche)
  (let ((include-new-var-restr
         (car (membcar 'include-new-var restrictions))))
    (cond (include-new-var-restr
           (intersection (cliche-pred-new-vars-of-type instantiated-cliche 
                                                       (second include-new-var-restr)
                                                       (third include-new-var-restr))
                         variables :test #'var-eq))
          (t variables))))



;;  00  glenn  02/09/91   auxiliary function to apply-variabilization-restrictions, checks a 
;;     single restriction for a single variabilization

;;;  need to fix up so that it uses the cliche and can refer to variables in prior elements of
;;;  the cliche

;;;  functions supplied
;;;  (pred-new-vars cliche position) - retrieves new-vars of pred in position of cliche
;;;  (vars-satisfy-type type vars) - returns those vars that are of type type

(defun cliche-pred-new-vars (cliche position)
  (literal-info-new-vars (nth position cliche)))

(defun cliche-pred-new-types (cliche position)
  (literal-info-new-types (nth position cliche)))

(defun cliche-pred-vars (cliche position)
  (literal-info-vars (nth position cliche)))

;;;  restrictions supported
;;;  (include-new-var &opt type) - variabilizations must have at least one new var that
;;;    satisfies type (which is optional)

;;; accepts a cliche, a position, and optionally a type and returns those new vars that satisfy
;;; type or all new-vars if type is nil

(defun cliche-pred-new-vars-of-type (cliche position &optional type)
  (let ((new-vars (cliche-pred-new-vars cliche position))
        (new-types (cliche-pred-new-types cliche position)))
    (retrieve-vars-that-satisfy-type new-vars new-types type)))

(defun retrieve-vars-that-satisfy-type (vars &optional types target-type)
  (cond ((or (null target-type) (eql target-type :anything)) vars)
        ((eql target-type 'numeric-type)
         (remove-if #'null
                    (mapcar #'(lambda (var type) (if (number-type type) var)) vars types)))
        ((eql target-type 'non-numeric-type)
         (remove-if #'null
                    (mapcar #'(lambda (var type) (if (non-numeric-type type) var)) vars types)))
        (t
         (remove-if #'null
                    (mapcar #'(lambda (var type) (if (eql type target-type) var)) vars types)))))

;;;  returns true if type satisfie target-type
;;;  note this is used elsewhere (e.g. in builtins) and should maintain the same input and 
;;;  output behavior

(defun satisfies-type (type target-type)
  (cond ((or (null target-type) (eql target-type :anything)) t)
        ((eql target-type 'numeric-type) (number-type type))
        ((eql target-type 'non-numeric-type) (not (number-type type)))
        (t (eql type target-type))))

(defun var-types-satisfies-restriction (types target-type &optional (one? t))
  (if one?
    (some #'(lambda (type) (satisfies-type type target-type)) types)
    (every #'(lambda (type) (satisfies-type type target-type)) types)))

(defun compute-types (vars all-vars all-types)
  (mapcar #'(lambda (var) (nth (position var all-vars :test #'var-eq) all-types)) vars))

;;; target-varzn must have the same new vars in the same positions as source-varzn, if num-new-vars
;;; is bound, then exactly num-new-vars source variables can be substituted with new-variables
;;; if the keyword new-vars-optional is set then, less that num-new-vars substitions is ok, and
;;; if unordered is set, then use-same-vars becomes like an include-n-vars.  Note this is not
;;; yet implemented (include-n-vars isn't either)

;;; old way enforced substituted-vars to be new
;(defun varzns-use-same-vars (source-varzn target-varzn &optional num-new-vars 
;                                    &key new-vars-optional? unordered?)
;  (if (null num-new-vars)
;    (equalp source-varzn target-varzn)
;    (let ((missmatches (var-missmatches source-varzn target-varzn unordered?)))
;      (and (if new-vars-optional?
;             (<= (length missmatches) num-new-vars)
;             (= (length missmatches) num-new-vars))
;           (every #'new-var? missmatches)))))


;;; substituted vars can be new or old - use introduces-new-var restriction to get new vars

(defun varzns-use-same-vars (source-varzn target-varzn &optional num-subst-vars 
                                    &key subst-vars-optional? unordered?)
  (if (null num-subst-vars)
    (equalp source-varzn target-varzn)
    (let ((missmatches (var-missmatches source-varzn target-varzn unordered?)))
      (if subst-vars-optional?
             (<= (length missmatches) num-subst-vars)
             (= (length missmatches) num-subst-vars)))))

;;;  accepts two lists of vars and resturns the number of missmatches - if unordered? is true
;;;  then the lists are treated as sets

(defun var-missmatches (source-vars target-vars unordered?)
  (if unordered? 
    (intersection source-vars target-vars :test #'var-eq?)
    (let ((missmatches nil))
      (mapc #'(lambda (s-var t-var) (if (not (var-eq s-var t-var)) (push t-var missmatches)))
            source-vars target-vars)
      missmatches)))


;;;  (introduces-new-var &opt type position) variabilization contains at least 1 new-var
;;;  (include-new-vars pred-pos &opt type) - include at least 1 of pred in pred-pos's new-vars
;;;  of type type.
;;;  (include-one vars) - include at least one in the set of vars - typically this will only be used
;;;   as a recursive call from within
;;;  (include-one vars) - include all vars like - above typically this will only be used
;;;   as a recursive call from within
;;;  (use-head-vars &opt num-new-vars unordered? new-vars-optional?) - varzn must include the vars of 
;;;  the head of the clause with num-new-vars new variable substitions (substitions are mandatory 
;;;  unless new-vars-optional? is set).  unordered? allows treats the variabilizations as sets.
;;;  (use-same-vars pred-pos &opt num-new-vars unordered? new-vars-optional?) - varzn must include
;;;  the same variables as the predicate in position pred-pos of the cliche (note pred-pos should
;;;  be a predicate prior to the current one).  num-new-vars, unordered?, and new-vars-optional?
;;;  have the same effect as above

(defun variabilization-satisfies-restriction (pred restriction variabilization old-vars original-vars
                                              instantiated-cliche position-in-cliche)
  (case (car restriction)
    (introduces-new-var (if (third restriction)
                          (and (new-var? (nth (third restriction) variabilization))
                               (satisfies-type (nth (third restriction) (p-type pred))
                                               (second restriction)))
                          (some
                           #'(lambda (type)
                               (satisfies-type type (second restriction)))
                           (compute-types 
                            (compute-new-vars variabilization old-vars)
                            variabilization
                            (p-type pred)))))
   ; now obsolete but may want to consider it for learning
;    (use-head-vars (varzns-use-same-vars original-vars variabilization (second restriction)
;                                         :unordered? (third restriction)
;                                         :subst-vars-optional? (fourth restriction)))
    (use-same-vars (varzns-use-same-vars (if (eql (second restriction) 'head)
                                           original-vars
                                           (cliche-pred-vars instantiated-cliche (second restriction)))
                                         variabilization
                                         (third restriction)
                                         :unordered? (fourth restriction)
                                         :subst-vars-optional? (fifth restriction)))
    (include-old-var 
     (let ((vars-to-include
            (case (second restriction)
              (nil old-vars)
              (head original-vars)
              (t (cliche-pred-vars instantiated-cliche position-in-cliche)))))
       (if (third restriction)
         (member (nth (third restriction) variabilization) vars-to-include)
         (intersection variabilization vars-to-include :test #'var-eq))))
    (include-one (some #'(lambda (var) 
                           (member var variabilization :test #'var-eq))
                       (second restriction)))
    (include-all (every #'(lambda (var) 
                            (member var variabilization :test #'var-eq))
                        (second restriction)))
    (include-new-var 
     (variabilization-satisfies-restriction
                      pred 
                      `(include-one 
                             ,(cliche-pred-new-vars-of-type instantiated-cliche (second restriction)
                                                           (third restriction)))
                      variabilization old-vars original-vars instantiated-cliche
                      position-in-cliche))
    (old-var (if (eql (second restriction) '*)
               (intersection variabilization old-vars :test #'var-eq)
               (member (nth (second restriction) variabilization) old-vars :test #'var-eq)))
    (reduction-variabilization 
         (every #'(lambda (restriction) 
                    (variabilization-satisfies-restriction pred
                                                           restriction 
                                                           variabilization
                                                           old-vars
                                                           original-vars 
                                                           instantiated-cliche 
                                                           position-in-cliche))
                (reduction-pred-reduction-variabilization pred)))
    (t (error "~A is an unimplemented restriction" restriction))))

                                         
        
(defun pred-type-restriction-part-type (pred)
  (member (pred-name pred) '(handle bottom body support concavity)))

;;; predicate restrictions

;(defun get-pred-type-restr (restr)
;  (car (or (member 'pred restr) 
;           (member 'ext-pred restr)
;           (member 'comp restr))))

(defun get-pred-type-restr (restr)
  (some #'(lambda (r) (if (symbolp r) r)) restr))

(defun retrieve-consistent-reduction-preds ()
  (let* ((recursive-var-types (p-type (get-pstruct *predicate-being-learned*)))
        reduction-type)
    (remove-if-not 
     #'(lambda (pred) 
         (and (reduction-pred-p (cdr pred))
              (setq reduction-type (reduction-pred-reduction-type (cdr pred)))
              (some 
               #'(lambda (type)
                   (satisfies-type type reduction-type))
               recursive-var-types)))
     *extensional-preds*)))

;; note won't quite work for unconstrained cliche - first cut

(defun filter-pred-restrictions (restrictions max-new-vars)
  (let* ((pred-type (get-pred-type-restr restrictions))
         (preds 
          (case pred-type
            (pred (append *extensional-preds* *builtin-preds*))
            (ext-pred *extensional-preds*)
            (comp *builtin-preds*)
            (arith-op *is-ops*)
            (t nil))))
    (apply-pred-restrictions preds restrictions max-new-vars)))


;;; note pred is in alist form ((pred . struct) ...) like *extensional-preds* etc.

(defun apply-pred-restrictions (preds restrictions &optional max-new-vars)
  (remove-if-not
            #'(lambda (pred)
                (every #'(lambda (restriction) 
                           (pred-satisfies-restriction (p-info-struct pred)
                                                       restriction max-new-vars))
                       restrictions))
            (top-level-pred-restrictions preds restrictions)))

;;; get's p-struct from element of list like *extensional-preds* - done here for generality
;;; i.e., we can change the form of *extensional-preds* etc.
(defun p-info-struct (pred-info)
  (cdr pred-info))

(defun make-pred-info (pred-name)
  (list (cons pred-name (get-pstruct pred-name))))

;;; may want to make these non-exclusive
(defun top-level-pred-restrictions (preds pred-restr &aux include-restr class-restr)
  (cond ((setq include-restr (car (membcar 'include-pred pred-restr)))
         (let ((include-pred nil))
           (cond ((get-pstruct (setq include-pred (second include-restr))) ; predicate is defined
                  (make-pred-info include-pred))
                 (t nil))))
        ((eql (setq class-restr (second (car (membcar 'pred-class pred-restr)))) 'reduction-pred)
         (retrieve-consistent-reduction-preds))
        ((eql class-restr 'recursive-pred)
         ;(break "got recursive pred restr")
         (make-pred-info *predicate-being-learned*))
        (t preds)))

;;;  retrictions so far:

;;; (1) exclude-pred - removes pred from consideration
;;; (2) include-new-var (optional type) - include at least one new var of specified type
;;;    or of any type if type is unspecified
;;; (3) include-pred - opposite of 
(defun pred-satisfies-restriction (pred restriction max-new-vars)
  (if (listp restriction)
    (case (car restriction)
      (supports-new-var 
       (and max-new-vars ; builtins won't supply max-new-vars but should support new vars
            (> max-new-vars 0) 
            (if (second restriction)
              (var-types-satisfies-restriction (new-var-types pred) (second restriction))
              (new-var-types pred))))
      (exclude-pred (eql (p-name pred) (second restriction)))
      (t t))
      (case restriction
        (pred t)
        (ext-pred (pred-p pred))
        (comp (builtin-p pred))
        (t t))))

(defun new-var-types (pred)
  (let ((types (p-type pred))
        (mode (p-mode pred)))
    (if (null mode)
      types ; all variables can be new
      (remove-if #'null
                 (mapcar #'(lambda (m ty) (if (or (eql m :-) (eql m :?)) ty)) mode types)))))
