
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
;;; info gain computed only for last element of cliche via find-maximum-literal and 
;;; find-literal-builtin
(defmacro expand-last-cliche-pred (find-literal-call)
  `(multiple-value-bind
     (pred-with-max-gain 
      varzn-with-max-gain 
      pred-max-negated? 
      pred-max-gain 
      covered-all-pos-tuples)
     ,find-literal-call
     (if (and pred-with-max-gain 
              (not (eql pred-with-max-gain :fail))
              (>= pred-max-gain max-gain))
       (setq overall-pred-with-max-gain pred-with-max-gain
             overall-varzn-with-max-gain varzn-with-max-gain
             max-negated? pred-max-negated?
             max-gain pred-max-gain))))

;;; need to add more args
(defmacro process-cliche-variabilizations (negated? pred)
     ;; note need to compute new-vars and types and update variables and variable-types
     ;; might want to use transfer-literal-vars if there are new vars
  `(progn
     ,(if negated?
          `(setq all-vars variables 
                 all-types variable-types
                 literal-vars variabilization
                 new-vars nil)
          `(cond ((compute-new-vars variabilization variables)
                  (multiple-value-setq (literal-vars 
                                        new-vars 
                                        new-types 
                                        alist-ignore)
                                       (transfer-literal-vars variabilization 
                                          (p-type ,pred) variables (length variables)))
                  (setq all-vars  (append variables new-vars)
                        all-types (append variable-types new-types)))                       
                 (t 
                  (setq all-vars variables
                        all-types variable-types
                        literal-vars variabilization
                        new-vars nil))))
     (setq new-pos-tuples 
           (generalized-extend-tuples ,pred
                                      pos-tuples
                                      literal-vars
                                      max-negated?
                                      new-vars
                                      variables))
     (setq new-neg-tuples 
           (generalized-extend-tuples ,pred
                                      neg-tuples
                                      literal-vars
                                      max-negated?
                                      new-vars
                                      variables))
     (when (or new-pos-tuples *try-all-conjunctions*) ; make sure have at least one pos-tuple
       ; note update variables and variable-types for this call and below
       
       (update-literal-info current-literal-info-struct 
                            ,pred 
                            literal-vars 
                            pos-tuples 
                            neg-tuples 
                            max-negated? 
                            variables 
                            variable-types 
                            nil ; we're not computing here
                            new-pos-tuples 
                            new-neg-tuples 
                            new-vars 
                            new-types) 
       (multiple-value-setq 
        (current-instantiated-cliche pred-max-gain)
        (instantiate-cliche (cdr pred-restrictions) 
                            (cdr var-restrictions)
                            original-info 
                            predicate-being-learned 
                            all-vars
                            all-types
                            maximum-new-vars 
                            new-pos-tuples 
                            new-neg-tuples 
                            original-vars ; - ges 5/4 changed back from variables
                            use-hash-tables 
                            max-gain 
                            instantiated-cliche 
                            (1+ position-in-cliche)))
       (when (and current-instantiated-cliche 
                  (not (eql current-instantiated-cliche :fail))
                  (>= pred-max-gain max-gain))
         (setq best-instantiated-cliche
               (copy-cliche-info current-instantiated-cliche 
                                 best-instantiated-cliche))
        ;(format t "~%setting best-cliche in instantiate-cliche with gain ~a" pred-max-gain)
        ;(print-cliche best-instantiated-cliche)
         (setq max-gain pred-max-gain)))))

;;; this can probably be used in find-max-literal
(defmacro process-variabilizations (var-restr &rest body)
  `(do* ((variabilizations 
          (apply-variabilization-restrictions 
           pred
           ,var-restr
           (get-variabilizations pred maximum-new-vars variables 
                                 predicate-being-learned variable-types original-vars)
           variables
           original-vars
           instantiated-cliche
           position-in-cliche)
          (cdr variabilizations))
         (current-struct (car variabilizations) (car variabilizations)))
        
        ((null variabilizations))  ;exit when no more variabilizations              
     (setq variabilization 
           (variabilization-struct-variabilization current-struct))
     ,@body))

(defmacro push-last (e l)
  `(setf ,l (nconc ,l (list ,e))))

(defmacro push-list (l1 l2)
  `(progn
     (setf ,l2 (nconc ,l1 ,l2))
     (setf ,l1 nil)
     ,l2))
