;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold without
;;;; written permission from the Regents of the University of California.
;;;; The code contained in this file was written by Cliff Brunk.

(in-package :user)

;;;_________________________________________________________
;;;  learned-description-window

(defclass learning-window (window)
  ((default-top :initarg :default-top :initform 20 :accessor default-top)))

;;;_________________________________________________________
;;;  initialize-instance

(defmethod initialize-instance ((window learning-window) &rest initargs)
  (setf (getf initargs :color-p) t)
  (apply #'call-next-method window initargs )
  (set-view-scroll-position window 0 0)
  (set-view-font window *default-font*)
  (add-subviews 
   window
   (make-instance 'graph-scroller
                  :view-position #@(0 20)
                  :view-size (subtract-points (view-size window) #@(0 20))
                  :view-nick-name :graph-scroller))
  (let ((view (graph-view window)))
    (set-font-dependent-attributes view)
    (setf (default-top window) (round (- (point-v (view-size view)) (cell-height view)) 2))
    (reset-scroll-bars (graph-scroller window))))

;;;_________________________________________________________
;;;   set-view-size

(defmethod set-view-size ((window learning-window) h &optional (v nil))
  (let* ((scroller (graph-scroller window))
         (view (view-named :graph-view scroller)))
    (if (null v)
      (setf v (point-v h)
            h (point-h h)))
    (reset-view-size scroller h (- v 20))
    (setf (default-top window) (round (- (point-v (view-size view)) (cell-height view)) 2))
    (call-next-method)))

;;;_______________________________________
;;;   resize-window

(defmethod resize-window ((window learning-window) &optional (h nil) (v nil))
  (general-resize-window window h v 0 20))

;;;_______________________________________
;;;   grow-window-if-needed

(defmethod grow-window-if-needed ((window learning-window))
  (general-grow-window-if-needed window 0 20))

;;;_________________________________________________________
;;;   view-draw-contents

(defmethod view-draw-contents ((window learning-window))
  (with-focused-view window
    (call-next-method)
    (with-focused-view window
      (#_pensize 1 1)
      (#_penpat *black-pattern*)
      (with-fore-color *black-color*
        (#_moveto -1 19)
        (#_lineto 3000 19)))))

;;;_________________________________________________________
;;;   window-zoom-event-handler

(defmethod window-zoom-event-handler ((window learning-window) message)
  (declare (ignore message))
  (call-next-method)
  (reset-view-size (graph-scroller window) (subtract-points (view-size window) #@(0 20)))
  )

;;;_________________________________________________________
;;;   window-hardcopy

(defmethod window-hardcopy ((window learning-window) &optional (show-dialog? t))
  (declare (ignore show-dialog?))
  (hardcopy-graph-in-window window))

;;;_________________________________________________________
;; copy

(defmethod copy ((window learning-window))
  (copy-graph-to window))

;;;_______________________________________
;;;   window-close

(defmethod window-close ((window learning-window))
  (dispose-graph-view (graph-view window))
  (call-next-method))

;;;_______________________________________
;;;   view-key-event-handler

(defmethod view-key-event-handler ((window learning-window) char)
  (let ((view (graph-view window)))
    (case (char-code char)
      ((69 101) (if (fboundp 'edit-last-node-selected)          ;;; E e
                  (edit-last-node-selected view)))
      ((71 103) (redisplay-last-node-selected view))            ;;; G g
      ((72 104) (hide-antecedents-of-selected-cells view))      ;;; H h
      ((73 105) (inspect-last-node-selected view))              ;;; I i
      ((82 114) (force-graph-redraw view))                      ;;; R r
      ((83 115) (show-antecedents-of-selected-cells view))      ;;; S s
      ((84 116) (show-tuples-last-node-selected view))          ;;; T t
      (others nil))))

;;;_______________________________
;;;  display-caption

(defun display-caption (window source-string gain-string pos-string neg-string)
  (set-dialog-item-text (view-named :source window) source-string)
  (set-dialog-item-text (view-named :gain window) gain-string)
  (set-dialog-item-text (view-named :pos window) pos-string)
  (set-dialog-item-text (view-named :neg window) neg-string)
  (values))

;;;_______________________________
;;;  clear-caption

(defun clear-caption (window) (display-caption window "" "" "" ""))

