;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold without
;;;; written permission from the Regents of the University of California.
;;;; The code contained in this file was written by Cliff Brunk.

(in-package :user)

;;;_______________________________________
;;;  find-example-template

(defun find-example-template (relation-name) (find relation-name *example-templates* :key #'example-template-name))

;;;_______________________________________
;;;  save-example-template

(defun save-example-template (fact related-facts)
  (multiple-value-bind (fact-name example-vars template example-literals object-vars) (variablize-example fact related-facts)
    (let ((id 0)
          (new-literals (mapcan #'(lambda (l) (when (every #'(lambda (v) (or (equal v *filtered-indicator*)
                                                                             (member v example-vars :test #'var-eq))) (rest l))
                                                (list l))) example-literals))
          (object-literals (mapcan #'(lambda (l) (unless (every #'(lambda (v) (or (equal v *filtered-indicator*)
                                                                                  (member v example-vars :test #'var-eq))) (rest l))
                                                   (list l))) example-literals))
          (mapping (direct-mapping example-vars example-vars))
          new-object-var eq-c)
      (do ((eq-cs (find-object-var-equivolence-classes object-literals object-vars) (rest eq-cs)))
          ((null eq-cs))
        (setq eq-c (first eq-cs)
              new-object-var (make-pcvar :id (decf id))
              new-literals (nconc new-literals (partition-example-literals (subseq object-literals 
                                                                                   (position (first eq-c) object-literals :test #'equal)
                                                                                   (position (first (second eq-cs)) object-literals :test #'equal))
                                                                           eq-c mapping new-object-var))
              mapping (nconc mapping (mapcar #'(lambda (v) (list v new-object-var)) (rest eq-c))))
        )
      (setq new-literals (nreverse (delete-duplicates (nreverse new-literals) :test #'equal)))
      (if template
        (setf (example-template-facts template) (insert-literals-into-template new-literals (example-template-facts template) example-vars))
        (setq template (make-example-template :name fact-name 
                                              :vars example-vars
                                              :facts (insert-literals-into-template new-literals nil example-vars))
              *example-templates* (push template *example-templates*)))
      (update-templates))
    template))

;;;_______________________________________
;;;  variablize-example

(defun variablize-example (fact related-facts)
  (when (or (eq (first fact) '-) (eq (first fact) 'not)) (setf fact (second fact)))
  (let* ((fact-name (first fact))
         (example (rest fact))
         (template (find-example-template fact-name))
         (vars (if template (example-template-vars template) (make-old-vars (length example))))
         (mapping (direct-mapping example vars))
         (id 0)
         (variablized-fact nil)
         (variablized-related-facts (mapcar #'(lambda (f) (multiple-value-setq (variablized-fact id) (variablize-example-fact f mapping id)) variablized-fact) related-facts))
         (new-vars (make-new-vars (- id))))
    (values fact-name vars template variablized-related-facts new-vars)))

;;;_______________________________________
;;;  variablize-example-fact

(defun variablize-example-fact (fact mapping id)
  (when (or (eq (first fact) '-) (eq (first fact) 'not)) (setf fact (second fact)))
  (let* ((name (first fact))
         (r-struct (get-r-struct name))
         (types (when (r-p r-struct) (r-type r-struct)))
         type bucket var)
    (values (cons name (mapcar #'(lambda (parameter)
                                   (setq type (first types)
                                         types (rest types))
                                   (cond ((setq bucket (assoc parameter mapping :test 'equal))
                                          (second bucket))
                                         ((get type :OBJECT)
                                          (setq var (make-pcvar :id (decf id)))
                                          (nconc mapping (list (list parameter var)))
                                          var)
                                         (t *filtered-indicator*)))
                               (rest fact)))
            id)))

;;;_______________________________________
;;;  partition-example-literals

(defun partition-example-literals (example-literals equivolence-class mapping object-variable)
  (let* ((object-vars (reverse (rest equivolence-class)))
         (mapping (cons (list object-variable object-variable) mapping)))
    (mapcan #'(lambda (var)
                (rplaca (first mapping) var)
                (direct-substitute-args (mapcan #'(lambda (literal)
                                                    (when (contains? literal var) (list literal)))
                                                example-literals)
                                        mapping t))
            object-vars)))

;;;_______________________________________
;;;  find-object-var-equivolence-classes

(defun find-object-var-equivolence-classes (example-literals object-vars)
  (let ((equivolence-classes nil))
    (dolist (var object-vars)
      (let* ((defining-literal (find-if #'(lambda (literal) (contains? literal var)) example-literals))
             (equivolent-class (find-if #'(lambda (class) (create-new-var-mapping-from-a-to-b defining-literal (first class))) equivolence-classes)))
            (if equivolent-class
              (setf (rest equivolent-class) (cons var (rest equivolent-class)))
              (setq equivolence-classes (push (list defining-literal var) equivolence-classes)))))
    (nreverse equivolence-classes)))

;;;_______________________________________
;;;  insert-literals-into-template

(defun insert-literals-into-template (new-literals existing-literals example-vars)
  (dolist (literal new-literals)
    (unless (member literal existing-literals :test #'equal)
      (do* ((inserted? nil)
            (insert-now? nil nil)
            (literal-vars (rest literal))
            (all-bound nil)
            (bound-vars example-vars)
            (prev-cons nil current-cons)
            (current-cons existing-literals (rest current-cons))
            (current-literal (first current-cons) (first current-cons)))
           (inserted?)
        (setq all-bound (or all-bound
                            (null current-cons)
                            (every #'(lambda (v) (or (equal v *filtered-indicator*) (member v bound-vars :test #'equal))) literal-vars)))
        (dolist (var (rest current-literal))
          (unless (or (member var bound-vars :test #'var-eq)
                      (equal var *filtered-indicator*))
           (setq bound-vars (cons var bound-vars)
                 insert-now? t)))
        (when all-bound
          (cond ((null current-cons)
                 (setf existing-literals (nconc existing-literals (list literal))
                       inserted? t))
                ((or (universal< literal current-literal) insert-now?)
                 (if prev-cons
                   (rplacd prev-cons (cons literal current-cons))
                   (setf existing-literals (cons literal existing-literals)))
                 (setf inserted? t))
                (t nil))))))
  existing-literals)

;;;_______________________________________
;;;  return-template-literals

(defun return-template-literals (template vars types maximum-new-vars &optional (literals nil))
  (let ((template-vars (example-template-vars template))
        (template-literals (example-template-facts template))
        (new-vars (make-new-vars maximum-new-vars))
        r-struct source-vars source-types
        vzs-types vzs-modes)
    (dolist (template-literal template-literals)
      (setq r-struct (get-r-struct (first template-literal))
            source-vars (copy-list vars)
            source-types (copy-list types)
            vzs-types nil
            vzs-modes nil)
      (when (and (r-p r-struct)
                 (= (length (rest template-literal)) (length (r-type r-struct))))
        (do* ((vs (reverse (rest template-literal)) (rest vs))
              (ts (reverse (r-type r-struct)) (rest ts))
              (ms (reverse (r-mode r-struct)) (rest ms))
              (v (first vs) (first vs)))
             ((null vs))
          (cond ((member v template-vars :test #'var-eq)
                 (let ((var (nth (position v template-vars :test #'var-eq) vars)))
                   (unless (member var source-types :test #'var-eq)
                     (push var source-types)
                     (push var source-vars))
                   (push var vzs-types)
                   (push :+ vzs-modes)))
                ((eql v *filtered-indicator*)
                 (push (first ts) vzs-types)
                 (push (or (first ms) :?) vzs-modes))
                (t
                 (push (first ts) vzs-types)
                 (push (or (first ms) :?) vzs-modes))))
        (dolist (variablization (typed-and-moded-variablizations vzs-types vzs-modes source-vars source-types new-vars))
          (when (some #'(lambda (v) (member v source-vars :test #'var-eq)) variablization)
            (unless (some #'(lambda (r.v) (and (eq (first r.v) r-struct) (equal (rest r.v) variablization))) literals)
              (push (cons r-struct variablization) literals))))))
    literals))

;;;_______________________________________
;;;  return-templates-containing-speified-types

(defun return-templates-containing-speified-types (types)
  (let ((templates nil)
        (r-struct nil))
    (dolist (template *example-templates*)
      (when (r-p (setq r-struct (get-r-struct (example-template-name template))))
        (when (some #'(lambda (type) (member type types)) (r-type r-struct))
          (pushnew template templates))))
    templates))
          
;;;_______________________________________
;;;  return-literals-for-template-induction

(defun return-literals-for-template-induction (pred-being-learned vars types maximum-new-vars)
  (let ((template (find-example-template (r-name pred-being-learned)))
        (pred-type (r-type pred-being-learned))
        (types-to-look-for nil)
        (literals nil))
    (dolist (type types)
      (cond ((member type types-to-look-for) nil)
            ((and template (member type pred-type)) nil)
            (t (push type types-to-look-for))))
    (when template
      (setq literals (return-template-literals template vars types maximum-new-vars nil)))
    (dolist (template (return-templates-containing-speified-types types-to-look-for))
      (setq literals (return-template-literals template vars types maximum-new-vars literals)))
    literals))

;;;_______________________________________
;;;  find-literal-template

(defun find-literal-template (current-state-value 
                              predicate-being-learned
                              variables
                              variable-types
                              maximum-new-vars
                              pos-tuples
                              neg-tuples
                              original-vars
                              use-hash-tables
                              winners
                              )
  original-vars
  ;; might want to change :extensional to :template
  (let ((*determinate-rs-and-vars* nil))
    (find-maximum-literal-from-list current-state-value
                                    pos-tuples
                                    neg-tuples
                                    use-hash-tables
                                    (return-literals-for-template-induction predicate-being-learned variables variable-types maximum-new-vars)
                                    winners
                                    :extensional)
    (cond ((winners-new-winners winners)
           (dolist (winner (winners-new-winners winners))
             (create-winner-literal variables pos-tuples neg-tuples winner :extensional variable-types))
           (setf (winners-new-winners winners) nil))
          (t
           (create-non-discriminating-literals-if-needed variables variable-types pos-tuples neg-tuples winners))))
  winners)

;;;_______________________________________
;;;  return-example-facts

(defun return-example-facts (mapping facts defining-facts)
  (let ((output nil))
    (labels 
      ((return-facts (mapping facts defining-facts)
         (when facts
           (let* ((fact (first facts))
                  (name (first fact))
                  (pred (get-pred name))
                  (vars (rest fact))
                  (pattern (direct-substitute vars mapping t)))
             ;(format t "~%MAPPING : ~A     FACT : ~A   PATTERN : ~A" mapping fact pattern)
             (if (every #'(lambda (p) (eq p *filtered-indicator*)) pattern)
               (return-facts mapping (rest facts) (rest defining-facts))
               (let ((pos-data (nreverse (return-examples-matching-pattern (r-pos pred) pattern)))
                     (neg-data (nreverse (return-examples-matching-pattern (r-neg pred) pattern)))
                     literal)
                 (dolist (data pos-data)
                   (setq literal (cons name data))
                   (unless (member literal output :test #'equal)
                     (setq output (cons literal output))))
                 (dolist (data neg-data)
                   (setq literal (list 'not (cons name data)))
                   (unless (member literal output :test #'equal)
                     (setq output (cons literal output))))
                 (if (equal fact (first (first defining-facts)))
                   (if pos-data
                     (let* ((var (second (first defining-facts)))
                            (position (position var (first defining-facts) :test #'equal))
                            (mapping (cons (list nil nil) mapping)))
                       (dolist (data pos-data)
                         (rplaca (first mapping) var)
                         (rplaca (rest (first mapping)) (nth position data))
                         (return-facts mapping (rest facts) (rest defining-facts))))
                     (return-facts mapping (rest facts) (rest defining-facts)))
                   (return-facts mapping (rest facts) defining-facts))))))))
      (return-facts mapping facts defining-facts))
    output))


