
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

(in-package :user)
;;;  move the structure to structs.lisp

(defstruct cliche
  name
  pred-restrictions
  var-restrictions
  cache?)

(defstruct literal-info 
  pred
  variabilization
  negated?
  pos
  neg
  vars
  types
  gain
  new-pos
  new-neg
  new-vars
  new-types)

(defmacro def-cliche (name &key pred-restrictions var-restrictions (cache? 'named))
  `(let*  ((name ',name)
           (pred-restrictions ',pred-restrictions)
           (var-restrictions ',var-restrictions)
           (cache? ',cache?)
           (bucket (assoc name *all-cliches*))
           (cliche (make-cliche :name name 
                                :pred-restrictions pred-restrictions
                                :var-restrictions var-restrictions
                                :cache? cache?)))
     (setf (get name 'cliche) cliche)
     (if bucket 
       (setf (cdr bucket) cliche)
       (push (cons name cliche) *all-cliches*))
     (when (fboundp 'update-cliches) (update-cliches))  ;; CAB 11/20/92
     name)) ;; CAB 5/12/93

(defun get-cliche-struct (cliche-name) (get cliche-name 'cliche))

;;; runs through all *available-relational-cliches*

(defun find-literal-cliches (current-state-value 
                             predicate-being-learned 
                             variables 
                             variable-types
                             maximum-new-vars
                             pos-tuples 
                             neg-tuples
                             original-vars 
                             use-hash-tables
                             winners)
  (let ((cliche nil)
        (instantiated-cliche nil)
        (varzns-checked-before-cliches *variablizations-checked*))
    (do* ((cliche-names *available-relational-cliches* (cdr cliche-names))
          (cliche-name (car cliche-names) (car cliche-names)))
         ((null cliche-name))
      (declare (ignore maximum-new-vars))

      (setq cliche (get-cliche-struct cliche-name))
						; maybe can be a little smarted don't always have to deallocate
      (deallocate-literal-info-structs instantiated-cliche)
      (setq instantiated-cliche
            (make-literal-info-structs (length (cliche-pred-restrictions cliche))))
					
      ;; note figure out how to get covered-all-pos-tuples right (must make sure all pos-tuples are covered)
      (instantiate-cliche (cliche-pred-restrictions cliche) 
			  (cliche-var-restrictions cliche)
			  current-state-value predicate-being-learned variables variable-types 
			  maximum-new-vars pos-tuples
			  neg-tuples original-vars use-hash-tables winners
			  instantiated-cliche 0 cliche-name))	; added 5/17
    
    ;;;;;winners will be updated if any are good enough
    
    (incf *cliche-variabilizations-checked* 
	  (- *variablizations-checked* varzns-checked-before-cliches))
    (mapc #'(lambda(winner)
		   (create-literal-conjunction-from-structs winner (winner-source winner) ;cliche-name
							    variables))
	  (winners-new-winners winners))
    (setf (winners-new-winners winners) nil)
    winners))
                ; note cliche-max-gain should not be necessary

(defun inductive-builtins (preds)
  (remove-if-not #'(lambda(x) (r-induction (cdr x))) preds))

;;; return a list of num literal-info structs to be reused while instantiating cliches

(defun make-literal-info-structs (num)
  (let ((literal-info-structs nil))
    (dotimes (i num literal-info-structs)
      (push (allocate-literal-info-struct) literal-info-structs))))

; basically look at predicate restriction to decide whether to call 
; find-maximum-literal, find-literal-builtin, or both. also need to decide
; what predicates to pass to each (e.g., may pass arithmetic operators to
; implement arithmetic operator cliche, or = to implement non-numeric constant
; cliche.  Also need to be more careful about updating pos-tuples when 
; conjunctions are passed around.  Note can have conjunctions of arbitrary
; length.  Current thought is to accumulate necessary info in a list of lists
; and then and link the literals from the list.  Note need to be careful
; about updating the lists properly.  Important to complete each cliche and 
; measure info gain in a depth-first fashion so that we don't have a lot of
; junk lying around

(defun instantiate-cliche (pred-restrictions var-restrictions current-state-value
                           predicate-being-learned variables variable-types maximum-new-vars 
                           pos-tuples neg-tuples original-vars use-hash-tables winners 
                           instantiated-cliche position-in-cliche cliche-name)
                ; note cliche-max-gain should not be necessary)
  ;;;(format t "~%calling instantiate-cliche with vars ~a types ~a" variables variable-types)
  (let ((current-literal-info-struct (nth position-in-cliche instantiated-cliche))
        (max-negated? nil)
        (variabilization nil)
        (pred-restr (car pred-restrictions))
        (var-restr (car var-restrictions))
        negated?
        (pred-type-restr nil))
    (setq pred-type-restr (get-pred-type-restr pred-restr))
    (cond ((null pred-restrictions) nil)	; probably shouldn't get here
          ((null (cdr pred-restrictions))	; compute info gain only on last one
           ;;; compute
           
	   (when (or (eql 'ext-pred pred-type-restr) (eql 'pred pred-type-restr))
	     (find-maximum-literal current-state-value predicate-being-learned variables 
				   variable-types maximum-new-vars pos-tuples 
				   neg-tuples original-vars use-hash-tables 
				   *extensional-preds*  winners :cliche
				   :try-cliches t
				   :pred-restrictions pred-restr
				   :var-restrictions var-restr
				   :instantiated-cliche instantiated-cliche
				   :position-in-cliche position-in-cliche))
	   (when (or (eql 'pred pred-type-restr) (eql 'var-comp pred-type-restr))
	     (find-maximum-literal current-state-value predicate-being-learned variables 
				   variable-types maximum-new-vars pos-tuples 
				   neg-tuples original-vars use-hash-tables 
				   (inductive-builtins *builtin-preds*)
				   winners :cliche
				   :try-cliches t
				   :pred-restrictions pred-restr
				   :var-restrictions var-restr 
				   :instantiated-cliche instantiated-cliche
				   :position-in-cliche position-in-cliche))
	   (when (or (eql 'comp pred-type-restr) (eql 'pred pred-type-restr))
	     (find-literal-builtin-thresh current-state-value variables variable-types pos-tuples 
					  neg-tuples (inductive-builtins *builtin-preds*) winners 
					  :cliche
					  :pred-restrictions pred-restr
					  :var-restrictions var-restr
					  :instantiated-cliche instantiated-cliche
					  :position-in-cliche position-in-cliche))
	   (mapc #'(lambda (winner)
                     (let* ((copy (copy-cliche-info instantiated-cliche nil))
                            (prev (nth (- position-in-cliche 1) copy)))
                       (unless (winner-is-a-cliche? winner)
                         (update-literal-info (nth position-in-cliche copy) (winner-literal winner)
                                              (winner-vars winner)
                                              (literal-info-new-pos prev)
                                              (literal-info-new-neg prev)
                                              (winner-negated? winner) variables variable-types)
                         (setf (winner-source winner) cliche-name)
                         (setf (winner-literal winner) copy))))
                 (winners-new-winners winners))
	   )
          (t 
           (do* ((preds (filter-pred-restrictions pred-restr maximum-new-vars) (cdr preds))
                 (pred (cdr (car preds)) (cdr (car preds))))
                ((null preds)
		 (deallocate-literal-info-structs instantiated-cliche)
		 winners)
                 
             ;; handle positive variabilizations
             (setq max-negated? nil)
             (process-variabilizations 
	       var-restr pred maximum-new-vars variables
               variable-types original-vars predicate-being-learned
               instantiated-cliche position-in-cliche
               variabilization
	       (process-cliche-variabilizations nil pred variabilization max-negated? 
                                                current-literal-info-struct pred-restrictions 
                                                var-restrictions current-state-value
                                                predicate-being-learned variables variable-types 
                                                maximum-new-vars pos-tuples neg-tuples original-vars
                                                use-hash-tables winners instantiated-cliche 
                                                position-in-cliche cliche-name))	; 
             ;;; deal with threshold variabilizations equality constants
             (when (pred-type-restriction-supports-threshold pred-type-restr)
               (process-threshold-variabilizations
                 (relational-thresh-builtins preds)
                 var-restrictions
                 variables
                 variable-types
                 pos-tuples
                 neg-tuples
                 variabilization
                 pred
                 instantiated-cliche
                 nil
                 (process-cliche-variabilizations nil comp variabilization max-negated? 
                                                  current-literal-info-struct pred-restrictions 
                                                  var-restrictions current-state-value
                                                  predicate-being-learned variables variable-types 
                                                  maximum-new-vars pos-tuples neg-tuples original-vars
                                                  use-hash-tables winners instantiated-cliche 
                                                  position-in-cliche cliche-name) 
                 (process-cliche-variabilizations t comp variabilization max-negated? 
                                                  current-literal-info-struct pred-restrictions 
                                                  var-restrictions current-state-value
                                                  predicate-being-learned variables variable-types 
                                                  maximum-new-vars pos-tuples neg-tuples original-vars
                                                  use-hash-tables winners instantiated-cliche 
                                                  position-in-cliche cliche-name))
               (process-equality-constant-varzns
                 (equality-constant-builtins preds)
                 var-restrictions
                 variables
                 variable-types
                 pos-tuples
                 neg-tuples
                 variabilization
                 pred
                 negated?
                 instantiated-cliche
                 nil
                 (process-cliche-variabilizations negated? comp variabilization max-negated? 
                                                  current-literal-info-struct pred-restrictions 
                                                  var-restrictions current-state-value
                                                  predicate-being-learned variables variable-types 
                                                  maximum-new-vars pos-tuples neg-tuples original-vars
                                                  use-hash-tables winners instantiated-cliche 
                                                  position-in-cliche cliche-name))
               )				; do negative at the same time for thresholds
						; may want to handle this through varzn restrictions
             (when (process-neg-varzns-for-cliche? pred-restr)
               (setq max-negated? t)
               (process-variabilizations
                var-restr pred maximum-new-vars variables
                variable-types original-vars predicate-being-learned
                instantiated-cliche position-in-cliche
                variabilization
                (process-cliche-variabilizations t pred variabilization max-negated? 
                                                 current-literal-info-struct pred-restrictions 
                                                 var-restrictions current-state-value
                                                 predicate-being-learned variables variable-types 
                                                 maximum-new-vars pos-tuples neg-tuples original-vars
                                                 use-hash-tables winners instantiated-cliche 
                                                 position-in-cliche cliche-name))))))))


;;; need to add more args
#|
(defun process-cliche-variabilizations (negated? pred variabilization max-negated? 
                                        current-literal-info-struct pred-restrictions 
                                        var-restrictions current-state-value
                                        predicate-being-learned variables variable-types 
                                        maximum-new-vars pos-tuples neg-tuples original-vars
                                        use-hash-tables winners instantiated-cliche 
                                        position-in-cliche cliche-name)
  (let ((all-vars nil)
        (all-types nil)
        (literal-vars nil)
        (new-vars nil)
        (new-types nil)
        (new-pos-tuples nil)
        (new-neg-tuples nil))
    (cond ((some #'(lambda (var) (and (pcvar-p var) (not (member var variables :test #'var-eq)))) variabilization)
           (if negated?
             (multiple-value-setq (literal-vars new-vars new-types)
               (transfer-negated-literal-vars variabilization (r-type pred) variables))
             (multiple-value-setq (literal-vars new-vars new-types)
               (transfer-literal-vars variabilization (r-type pred) variables (length variables))))
           (setq all-vars (append variables new-vars)
                 all-types (append variable-types new-types)))
          (t
           (setq literal-vars variabilization
                 all-vars variables 
                 all-types variable-types
                 new-vars nil)))
     (setq new-pos-tuples (generalized-extend-tuples pred pos-tuples literal-vars max-negated? new-vars variables)
           new-neg-tuples (generalized-extend-tuples pred neg-tuples literal-vars max-negated? new-vars variables))
     (when (or (> (compute-max-possible-gain (length new-pos-tuples) current-state-value)
                  (if (winners-all-winners winners)
                    (winner-gain (car (winners-all-winners winners)))
                    0))
               *try-all-conjunctions*)
;       (or new-pos-tuples *try-all-conjunctions*) ; make sure have at least one pos-tuple
       ; note update variables and variable-types for this call and below
       
       (update-literal-info current-literal-info-struct 
                            pred 
                            literal-vars 
                            pos-tuples 
                            neg-tuples 
                            max-negated? 
                            variables 
                            variable-types 
                            new-pos-tuples 
                            new-neg-tuples 
                            new-vars 
                            new-types)
        (instantiate-cliche (cdr pred-restrictions) 
                            (cdr var-restrictions)
                            current-state-value 
                            predicate-being-learned 
                            all-vars
                            all-types
                            maximum-new-vars 
                            new-pos-tuples 
                            new-neg-tuples 
                            original-vars ; - ges 5/4 changed back from variables
                            use-hash-tables 
                            winners
                            instantiated-cliche 
                            (1+ position-in-cliche)
			    cliche-name))))
|#

(defun process-cliche-variabilizations (negated? pred variabilization max-negated? 
                                        current-literal-info-struct pred-restrictions 
                                        var-restrictions current-state-value
                                        predicate-being-learned variables variable-types 
                                        maximum-new-vars pos-tuples neg-tuples original-vars
                                        use-hash-tables winners instantiated-cliche 
                                        position-in-cliche cliche-name)
  (let ((all-vars nil)
        (all-types nil)
        (literal-vars nil)
        (new-vars nil)
        (new-types nil)
        (new-pos-tuples nil)
        (new-neg-tuples nil))
    (if (some #'(lambda (var) (and (pcvar-p var) (not (member var variables :test #'var-eq)))) variabilization)
      (if negated?
        (multiple-value-setq (literal-vars new-vars new-types)
          (transfer-negated-literal-vars variabilization (r-type pred) variables))
        (multiple-value-setq (literal-vars new-vars new-types)
          (transfer-literal-vars variabilization (r-type pred) variables (length variables))))
      (setq literal-vars variabilization))
    (setq new-pos-tuples (generalized-extend-tuples pred pos-tuples literal-vars max-negated? new-vars variables)
          new-neg-tuples (generalized-extend-tuples pred neg-tuples literal-vars max-negated? new-vars variables))
    (if (and new-vars (not negated?))
      (setq all-vars (append variables new-vars)
            all-types (append variable-types new-types))
      (setq all-vars variables 
            all-types variable-types
            new-vars nil
            new-types nil))

     (when (or (> (compute-max-possible-gain (length new-pos-tuples) current-state-value)
                  (if (winners-all-winners winners)
                    (winner-gain (car (winners-all-winners winners)))
                    0))
               *try-all-conjunctions*)
       ; (or new-pos-tuples *try-all-conjunctions*) ; make sure have at least one pos-tuple
       ; note update variables and variable-types for this call and below
       
       (update-literal-info current-literal-info-struct 
                            pred 
                            literal-vars 
                            pos-tuples 
                            neg-tuples 
                            max-negated? 
                            variables 
                            variable-types 
                            new-pos-tuples 
                            new-neg-tuples 
                            new-vars 
                            new-types)
        (instantiate-cliche (cdr pred-restrictions) 
                            (cdr var-restrictions)
                            current-state-value 
                            predicate-being-learned 
                            all-vars
                            all-types
                            maximum-new-vars 
                            new-pos-tuples 
                            new-neg-tuples 
                            original-vars ; - ges 5/4 changed back from variables
                            use-hash-tables 
                            winners
                            instantiated-cliche 
                            (1+ position-in-cliche)
			    cliche-name))))
       

;;; by default skip negatives unless explicitly stated
(defun process-neg-varzns-for-cliche? (pred-restr)
  (or *try-all-conjunctions* 
      (member 'negative-varzns pred-restr)))


(defun update-literal-info (literal-info pred literal-vars pos-tuples neg-tuples max-negated? 
                            vars types &optional new-pos-tuples new-neg-tuples new-vars new-types)

  (setf (literal-info-pred literal-info) pred)
  (setf (literal-info-variabilization literal-info) literal-vars)
  (setf (literal-info-negated? literal-info) max-negated?)
  (setf (literal-info-vars literal-info) vars)
  (setf (literal-info-types literal-info) types)
  (setf (literal-info-new-vars literal-info) new-vars)
  (setf (literal-info-new-types literal-info) new-types)
  (setf (literal-info-pos literal-info) pos-tuples)
  (setf (literal-info-neg literal-info) neg-tuples)
  (setf (literal-info-new-pos literal-info) new-pos-tuples)
  (setf (literal-info-new-neg literal-info) new-neg-tuples))

;;; computes the old-variables used in the instantiation of the cliche which will
;;; become the head vars of the cliche

(defun compute-cliche-head-vars (literal-conj old-vars)
  (let ((clause (convert-literals-to-prolog literal-conj)))
    (remove-if-not
     #'(lambda (var)
         (some 
          #'(lambda (lit)
              (member var lit :test #'var-eq))
          clause))
         old-vars)))




;;; creates a conjunction of literals from an instantiated cliche which is in the form
;;; of a list of literal info structs.

(defun create-literal-conjunction-from-structs (winner cliche-name old-vars)
  (let ((literal-info-structs (winner-literal winner))
	(conjunction nil)
        (literal nil)
        (last-literal nil)
        (new-vars nil)
        (new-types nil)
        (new-pos-tuples nil)
        (new-neg-tuples nil)
        (first-literal nil)
        (last-literal-vars nil)
        (last-literal-types nil))
    (do* ((li-structs literal-info-structs (cdr li-structs))
          (li-struct (car li-structs) (car li-structs)))
         ((null li-structs) conjunction)
      (setq literal
            (cond ((cdr li-structs)
                   (make-literal-from-literal-info li-struct))
                  (t (setq last-literal-vars (literal-info-vars li-struct))
                     (setq last-literal-types (literal-info-types li-struct))
                     (multiple-value-setq 
		       (last-literal new-vars new-types new-pos-tuples new-neg-tuples
				     )
		       (create-literal-from-literal-info li-struct))
                     last-literal)))
      (push-last literal conjunction))
    (setq first-literal (car conjunction))
    (create-literal-linked-list conjunction)
    (let ((first-vars (literal-info-vars (car literal-info-structs)))
          (all-new-vars nil)
          (all-new-types nil))
      (mapc #'(lambda (var type) 
		      (when (not (member var first-vars :test #'var-eq))
			(push-last var all-new-vars)
			(push-last type all-new-types)))
            last-literal-vars
            last-literal-types)
      (setq all-new-vars (nconc all-new-vars new-vars))
      (setq all-new-types (nconc all-new-types new-types))
      (setf (winner-vars winner) all-new-vars
	    (winner-literal winner) first-literal 
	    (winner-types winner) all-new-types
	    (winner-pos winner) new-pos-tuples
	    (winner-source winner) `(:cliche  ,cliche-name
				     ,@(compute-cliche-head-vars first-literal old-vars))
	    (winner-neg winner) new-neg-tuples)
      )))

(defun create-literal-linked-list (literal-list)
  (do* ((literals literal-list (cdr literals))
        (prev nil current)
        (current (car literals) next)
        (next (second literals) (second literals)))
       ((null current) (car literal-list))
    (setf (literal-prev current) prev)
    (setf current (last-literal current))
    (setf (literal-next current) next)))
#|
(defun create-literal-linked-list (literal-list)
  (do* ((literals literal-list (cdr literals))
        (prev nil current)
        (current (car literals) next)
        (next (second literals) (second literals)))
       ((null current) (car literal-list))
    (setf (literal-prev current) prev)
    (when next (setf (literal-next current) next))))
|#
              
(defvar *literal-info-structs* nil)

(defun make-literal-from-literal-info (literal-info)
  (let ((new-literal
         (conjoin-not-= (literal-info-types literal-info)
                        (literal-info-vars literal-info)
                        (literal-info-new-vars literal-info)
                        (literal-info-new-types literal-info)
                        (construct-literal (literal-info-negated? literal-info)
                                           (literal-info-pred literal-info)
                                           (literal-info-variabilization literal-info)
                                           :cliche)
                        (literal-info-new-pos literal-info)
                        (literal-info-new-neg literal-info)
                        :cliche
                        ))) 
    (when *save-examples*    
      (setf (literal-pos new-literal) (literal-info-pos literal-info))
      (setf (literal-neg new-literal) (literal-info-neg literal-info))
      (setf (literal-new-pos new-literal) (literal-info-new-pos literal-info))
      (setf (literal-new-neg new-literal) (literal-info-new-neg literal-info)))
    new-literal))

(defun create-literal-from-literal-info (literal-info)
  (create-literal (literal-info-pred literal-info)
                  (literal-info-variabilization literal-info)
                  (literal-info-negated? literal-info)
                  :cliche
                  (literal-info-vars literal-info)
                  (literal-info-pos literal-info)
                  (literal-info-neg literal-info)
                  (literal-info-types literal-info)))

(defun copy-cliche-info (from-cliche to-cliche)
  (if (null to-cliche)
    (setq to-cliche (make-literal-info-structs (length from-cliche))))
  (mapcar #' copy-literal-info-struct from-cliche to-cliche))

(defun copy-literal-info-struct (from-literal-info to-literal-info)
  (setf (literal-info-pred to-literal-info) (literal-info-pred from-literal-info))
  (setf (literal-info-variabilization to-literal-info) 
        (literal-info-variabilization from-literal-info))
  (setf (literal-info-negated? to-literal-info) (literal-info-negated? from-literal-info))
  (setf (literal-info-pos to-literal-info) (literal-info-pos from-literal-info))
  (setf (literal-info-neg to-literal-info) (literal-info-neg from-literal-info))
  (setf (literal-info-new-pos to-literal-info) (literal-info-new-pos from-literal-info))
  (setf (literal-info-new-neg to-literal-info) (literal-info-new-neg from-literal-info))
  (setf (literal-info-vars to-literal-info) (literal-info-vars from-literal-info))
  (setf (literal-info-types to-literal-info) (literal-info-types from-literal-info))
  (setf (literal-info-new-vars to-literal-info) (literal-info-new-vars from-literal-info))
  (setf (literal-info-new-types to-literal-info) (literal-info-new-types from-literal-info))
  to-literal-info)

(defun allocate-literal-info-struct ()
  (if *literal-info-structs*
    (pop *literal-info-structs*)
    (make-literal-info)))

(defun deallocate-literal-info-struct (struct)
  (pushnew struct *literal-info-structs*))

(defun deallocate-literal-info-structs (structs)
  (mapc #'deallocate-literal-info-struct structs))

;;; misc

(defun print-cliche (cliche &optional position)
  (terpri)
  (when cliche
    (if position 
      (dotimes (i position)
        (print-cliche-element (nth i cliche)))
      (dolist (l-i cliche)
        (print-cliche-element l-i)))))


(defun print-cliche-element (l-i)
  (if (literal-info-negated? l-i) (princ "~"))
  (if (literal-info-pred l-i)
    (format t "~a~a " (r-name (literal-info-pred l-i)) (literal-info-variabilization l-i))
    (format t "<Empty Pred> ")))


(defun create-pred-from-cliche (literal-conj cliche-name cliche-head-vars)
  (let* ((cliche (get-cliche-struct cliche-name))
         (cache? (cliche-cache? cliche)))
    (when (and cache? *create-preds-from-cliches*)
      (let* ((new-pred-name (gensym (format nil "~a-CLICHE" cliche-name)))
             (clauses (list (cons (cons new-pred-name cliche-head-vars)
                                  (convert-literals-to-prolog literal-conj))))
             (new-pred
              (eval `(def-rule ,new-pred-name
                       :clauses ,clauses
                       :from-cliche ,cliche-name))))
        (when (and *trace-learning?* (member :ci *focl-trace-level*))
          (format t "~%instantiated ~a cliche with clauses ~a" 
                  cliche-name clauses))
        (if (equal cache? 'named)
          (push new-pred *cliches-to-be-named*)
          (push new-pred *anonymous-cliches*))
        new-pred-name))))

(defun winner-is-a-cliche? (w)
  (when w
    (setq w (winner-literal w))
    (and (listp w)
	 (literal-info-p (car w)))))

(defun delete-cliche (cliche)
  (when (cliche-p cliche)
    (let* ((name (cliche-name cliche))
           (bucket (assoc name *all-cliches*)))
      (setf (get name 'cliche) nil
            *all-cliches* (delete bucket *all-cliches*)
            *available-relational-cliches* (delete name *available-relational-cliches*)
            (cliche-name cliche) nil
            (cliche-pred-restrictions cliche) nil
            (cliche-var-restrictions cliche) nil
            (cliche-cache? cliche) nil)
      (dolist (problem *focl-problems*)
        (when (getf (rest problem) :AVAILABLE-CLICHES)
          (setf (getf (rest problem) :AVAILABLE-CLICHES) (delete name (getf (rest problem) :AVAILABLE-CLICHES) :test #'equal)))))
    (when (fboundp 'update-cliches) (update-cliches))))