;;; accepts an r-struct and returns the type of predicate it represents

(defun get-pred-type (r)
  (cond ((pred-p r) 'ext-pred)
        ((builtin-p r) 'comp)
        ((rule-p r) 'int-pred)
        ((arithmetic-op-p r) 'arith-op)
        (t (warn "encountered an undefined type of pred ~a" r)
           'pred)))

(defun recognize-pred-restr-from-conjunction (conj)
  (mapcar #'recognize-pred-restr-for-literal conj))

(defun recognize-pred-restr-for-literal (literal)
  (let* ((r (get-r-struct (car literal)))
         (pred-type (get-pred-type r))
         (new-var-types (remove-duplicates (convert-types (new-var-types r))))
         (pred-restrictions (list pred-type (list 'include-pred (car literal)))))
    (dolist (nvt new-var-types pred-restrictions)
      (push (list 'supports-new-var nvt) pred-restrictions))))

(defun convert-types (types)
  (mapcar #'(lambda (type) 
              (if (number-type type)
                'numeric-type
                'non-numeric-type))
          types))

