
;;;======================================================
;;; FOCL Knowledge Base  (Relation Format)

; (reset-relations)

;;;______________________________________________________
;;; Types

(def-type (:CARD :OBJECT)
  2-C 3-C 4-C 5-C 6-C 7-C 8-C 9-C 10-C J-C Q-C K-C A-C
  2-D 3-D 4-D 5-D 6-D 7-D 8-D 9-D 10-D J-D Q-D K-D A-D
  2-H 3-H 4-H 5-H 6-H 7-H 8-H 9-H 10-H J-H Q-H K-H A-H
  2-S 3-S 4-S 5-S 6-S 7-S 8-S 9-S 10-S J-S Q-S K-S A-S)

(def-type :VALUE 2 3 4 5 6 7 8 8 9 10 J Q K A)

(def-type :SUIT C D H S)

(def-type (:HAND :OBJECT))
  

;;;______________________________________________________
;;; Predicates - Extensionally Defined Relations

(def-pred SUIT
  :vars  (?CARD ?SUIT)
  :type  (:CARD :SUIT)
  :mode  (:? :?)
  :pos ( (2-C C) (3-C C) (4-C C) (5-C C) (6-C C) (7-C C) (8-C C) (9-C C) (10-C C) (J-C C) 
         (Q-C C) (K-C C) (A-C C) (2-D D) (3-D D) (4-D D) (5-D D) (6-D D) (7-D D) (8-D D) 
         (9-D D) (10-D D) (J-D D) (Q-D D) (K-D D) (A-D D) (2-H H) (3-H H) (4-H H) (5-H H) 
         (6-H H) (7-H H) (8-H H) (9-H H) (10-H H) (J-H H) (Q-H H) (K-H H) (A-H H) (2-S S) 
         (3-S S) (4-S S) (5-S S) (6-S S) (7-S S) (8-S S) (9-S S) (10-S S) (J-S S) (Q-S S) 
         (K-S S) (A-S S) )
  :neg ( )
  :induction    T
  :constraint   NIL
  :commutative  NIL
   )

(def-pred VALUE
  :vars  (?CARD ?VALUE)
  :type  (:CARD :VALUE)
  :mode  (:? :?)
  :pos ( (2-C 2) (3-C 3) (4-C 4) (5-C 5) (6-C 6) (7-C 7) (8-C 8) (9-C 9) (10-C 10) (J-C J) 
         (Q-C Q) (K-C K) (A-C A) (2-D 2) (3-D 3) (4-D 4) (5-D 5) (6-D 6) (7-D 7) (8-D 8) 
         (9-D 9) (10-D 10) (J-D J) (Q-D Q) (K-D K) (A-D A) (2-H 2) (3-H 3) (4-H 4) (5-H 5) 
         (6-H 6) (7-H 7) (8-H 8) (9-H 9) (10-H 10) (J-H J) (Q-H Q) (K-H K) (A-H A) (2-S 2) 
         (3-S 3) (4-S 4) (5-S 5) (6-S 6) (7-S 7) (8-S 8) (9-S 9) (10-S 10) (J-S J) (Q-S Q) 
         (K-S K) (A-S A) )
  :neg ( )
  :induction    T
  :constraint   NIL
  :commutative  NIL
   )

(def-pred VALUE<
  :vars  (?VALUE1 ?VALUE2)
  :type  (:VALUE :VALUE)
  :mode  (:+ :+)
  :pos ( (2 3) (2 4) (2 5) (2 6) (2 7) (2 8) (2 9) (2 10) (2 J) (2 Q) (2 K) (2 A)
         (3 4) (3 5) (3 6) (3 7) (3 8) (3 9) (3 10) (3 J) (3 Q) (3 K) (3 A)
         (4 5) (4 6) (4 7) (4 8) (4 9) (4 10) (4 J) (4 Q) (4 K) (4 A)
         (5 6) (5 7) (5 8) (5 9) (5 10) (5 J) (5 Q) (5 K) (5 A) 
         (6 7) (6 8) (6 9) (6 10) (6 J) (6 Q) (6 K) (6 A)
         (7 8) (7 9) (7 10) (7 J) (7 Q) (7 K) (7 A)
         (8 9) (8 10) (8 J) (8 Q) (8 K) (8 A)
         (9 10) (9 J) (9 Q) (9 K) (9 A)
         (10 10) (10 J) (10 Q) (10 K) (10 A)
         (J Q) (J K) (J A)
         (Q K) (Q A)
         (K A) )
  :neg ( )
  :induction    T
  :constraint   NIL
  :commutative  NIL)

(def-pred VALUE-SUCC
  :vars  (?VALUE ?SUCCESSOR)
  :type  (:VALUE :VALUE)
  :mode  (:? :?)
  :pos ( (2 3) (3 4) (4 5) (5 6) (6 7) (7 8) (8 9) (9 10) (10 J) (J Q) (Q K) (K A) )
  :neg ( )
  :induction    T
  :constraint   NIL
  :commutative  NIL
   )

(def-pred ONE-PAIR-FACT
  :vars  (?HAND)
  :type  (:HAND)
  :mode  (:?)
  :pos ( (10) (9) (8) (7) (6) (5) (4) (3) (2) (1) )
  :neg ( (20) (19) (18) (17) (16) (15) (14) (13) (12) (11) )
  :induction    NIL
  :constraint   NIL
  :commutative  NIL
   )

(def-pred HAND-CONTAINS-CARD
  :vars  (?HAND ?CARD)
  :type  (:HAND :CARD)
  :mode  (:? :?)
  :pos ( (20 J-C) (20 6-C) (20 8-H) (20 5-C) (20 9-C)
         (19 Q-H) (19 10-H) (19 7-C) (19 3-H) (19 A-S)
         (18 10-H) (18 9-H) (18 Q-C) (18 3-H) (18 K-C)
         (17 7-S) (17 10-S) (17 2-D) (17 J-C) (17 6-D)
         (16 K-D) (16 8-C) (16 A-S) (16 9-H) (16 Q-S)
         (15 Q-S) (15 7-H) (15 J-S) (15 3-D) (15 5-C)
         (14 K-S) (14 J-C) (14 4-C) (14 6-S) (14 A-D)
         (13 2-S) (13 10-D) (13 7-C) (13 8-H) (13 9-H) 
         (12 Q-D) (12 9-S) (12 2-H) (12 5-S) (12 3-H)
         (11 2-H) (11 9-S) (11 3-D) (11 10-D) (11 8-C)
         (10 10-S) (10 2-D) (10 J-C) (10 6-C) (10 J-H)
         (9 J-C) (9 6-D) (9 6-H) (9 3-C) (9 Q-H)
         (8 5-D) (8 7-C) (8 A-H) (8 3-H) (8 5-C)
         (7 8-H) (7 K-C) (7 Q-C) (7 5-C) (7 K-H)
         (6 Q-S) (6 6-D) (6 10-D) (6 7-C) (6 10-C)
         (5 8-S) (5 4-S) (5 5-S) (5 3-S) (5 5-C) 
         (4 8-H) (4 2-H) (4 7-C) (4 A-S) (4 8-C)
         (3 K-C) (3 A-H) (3 4-C) (3 9-S) (3 A-D)
         (2 3-C) (2 5-H) (2 Q-D) (2 4-D) (2 4-S)
         (1 6-C) (1 A-D) (1 7-S) (1 2-D) (1 A-S) )
  :neg ( )
  :induction    T
  :constraint   NIL
  :commutative  NIL
  )


;;;______________________________________________________
;;; Learning Problem Specification and Parameter Settings

(def-focl-problem ONE-PAIR-FACT
  :MAX-NEW-VARIABLES 2
  :EXTENSIONAL-INDUCTION T
  :BUILTIN-INDUCTION T
  :SIMPLIFY-CLAUSES T
  :STOP-WHEN-ALL-POS-COVERED T
  :USE-CLICHES T
  :ALWAYS-TRY-CLICHES T
  :AVAILABLE-CLICHES (THRESHOLD-COMPARATOR PARTOF)
  :CLICHES-CAN-HAVE-NEGATED-COMPONENTS? T
  :MAX-NEW-CLICHE-VARS 2
  :ENABLE-DETERMINATE-LITERALS T
  :MAX-DETERMINACY 5
  :DETERMINATE-ADDITION-BOUND 5
  )