;;; -*- Mode:Common-Lisp; Package:user; Base:10 -*-

(in-package :user)

(proclaim '(optimize (speed 3) (compilation-speed 0)))

(defun sun-cal ()
  (compile-file "aux.lisp")
  (load "aux.sbin")
  (compile-file "def.lisp")
  (load "def.sbin")
  (compile-file "dtree.lisp")
  (load "dtree.sbin")
  (compile-file "kbm.lisp")
  (load "kbm.sbin")
  (compile-file "metric.lisp")
  (load "metric.sbin")
  (compile-file "aaa.lisp")
  (load "aaa.sbin")
  (compile-file "cc.lisp")
  (load "cc.sbin")  
  (compile-file "profile.lisp")
  (load "profile.sbin")
  (compile-file "expt.lisp")
  (load "expt.sbin")  
  )

(defun sun-load ()
  (load "aux.sbin")
  (load "def.sbin")
  (load "dtree.sbin")
  (load "kbm.sbin")
  (load "metric.sbin")
  (load "aaa.sbin")
  (load "cc.sbin")
  (load "profile.sbin")
  (load "expt.sbin")
  )

(defun load-pr-kb ()
  (load-kb "kb-pr.lisp"))

(defun load-pr-data ()
  (load "data-pr-train.lisp")
  (load "data-pr-test.lisp"))

(defun prep-pr ()
  (load-pr-kb)
  (load-pr-data))

(defun prep-brain ()
  (load-kb "kb-brain.lisp")
  (load "data-brain.lisp"))

(defun prep-adder ()
  (load-kb "kb-adder.lisp")
  (load "data-adder.lisp"))

(defun prep-tc ()
  (load-kb "kb-tc.lisp")
  (load "data-tc.lisp"))

(defun prep-wb ()
  (load-kb "kb-wb.lisp")
  (load "data-wb.lisp"))

(defun run-pr-all-exs ()
  (run-pr-train-exs)
  (run-pr-test-exs))

(defun run-pr-train-exs (&aux results)
  (mapcar #'(lambda (e a &aux time-e1-e2)
	      (format t "~%Running ~A...~%" (string e))
	      (setf time-e1-e2
		    (with-profiling (aaa::compute-label)
				    (aaa::abduce (eval e) (eval a))))
	      (push (cons (string e) (cons *inf-count* time-e1-e2))
		    results)
	      )
	  '(*e1* *e2* *e3* *e4* *e5* *e6* *e7* *e8*
		 *e9* *e10* *e11* *e12* *e13* *e14* *e15* *e16*
		 *e17* *e18* *e19* *e20* *e21* *e22* *e23* *e24* *e25*)
	  '(*a1* *a2* *a3* *a4* *a5* *a6* *a7* *a8*
		 *a9* *a10* *a11* *a12* *a13* *a14* *a15* *a16*
		 *a17* *a18* *a19* *a20* *a21* *a22* *a23* *a24* *a25*)
	  )
  (terpri)
  (dolist (result (reverse results))
    (format t "(~a  ~5d ~,2f  ~s  ~s)~%"
	    (first result) (second result) (third result)
	    (fourth result) (fifth result)))
  (format t "~%Averages:~%")
  (format t "Inference count = ~,2f~%"
	  (average (mapcar #'second results)))
  (format t "Run time = ~,2f minutes~%"
	  (average (mapcar #'third results)))
  (format t "Recall error rate = ~,2f~%"
	  (average (mapcar #'fourth results)))
  (format t "Precision error rate = ~,2f~%"
	  (average (mapcar #'fifth results)))
  (values))

(defun run-pr-test-exs (&aux results)
  (mapcar #'(lambda (e a &aux time-e1-e2)
	      (format t "~%Running ~A...~%" (string e))
	      (setf time-e1-e2
		    (with-profiling (aaa::compute-label)
				    (aaa::abduce (eval e) (eval a))))
	      (push (cons (string e) (cons *inf-count* time-e1-e2))
		    results)
	      )
	  '(*t1* *t2* *t3* *t4* *t5* *t6* *t7* *t8*
		 *t9* *t10* *t11* *t12* *t13* *t14* *t15* *t16*
		 *t17* *t18* *t19* *t20* *t21* *t22* *t23* *t24* *t25*)
	  '(*at1* *at2* *at3* *at4* *at5* *at6* *at7* *at8*
		 *at9* *at10* *at11* *at12* *at13* *at14* *at15* *at16*
		 *at17* *at18* *at19* *at20* *at21* *at22* *at23* *at24* *at25*)
	  )
  (terpri)
  (dolist (result (reverse results))
    (format t "(~a  ~5d ~,2f  ~s  ~s)~%"
	    (first result) (second result) (third result)
	    (fourth result) (fifth result)))
  (format t "~%Averages:~%")
  (format t "Inference count = ~,2f~%"
	  (average (mapcar #'second results)))
  (format t "Run time = ~,2f minutes~%"
	  (average (mapcar #'third results)))
  (format t "Recall error rate = ~,2f~%"
	  (average (mapcar #'fourth results)))
  (format t "Precision error rate = ~,2f~%"
	  (average (mapcar #'fifth results)))
  (values))

(defun run-brain-exs (&aux results)
  (mapcar #'(lambda (e a &aux time-e1-e2)
	      (format t "~%Running ~A...~%" (string e))
	      (setf time-e1-e2
		    (with-profiling (aaa::compute-label)
				    (aaa::abduce (eval e) (eval a))))
	      (push (cons (string e) (cons *inf-count* time-e1-e2))
		    results)
	      )
	  '(*p1* *p2* *p3* *p4* *p5* *p6* *p7* *p8*
		 *p9* *p10* *p11* *p12* *p13* *p14* *p15* *p16*
		 *p17* *p18* *p19* *p20* *p21* *p22* *p23* *p24* *p25*
		 *p26* *p27* *p28* *p29* *p30* *p31* *p32* *p33*
		 *p34* *p35* *p36* *p37* *p38* *p39* *p40* *p41*
		 *p42* *p43* *p44* *p45* *p46* *p47* *p48* *p49* *p50*)
	  '(*a1* *a2* *a3* *a4* *a5* *a6* *a7* *a8*
		 *a9* *a10* *a11* *a12* *a13* *a14* *a15* *a16*
		 *a17* *a18* *a19* *a20* *a21* *a22* *a23* *a24* *a25*
		 *a26* *a27* *a28* *a29* *a30* *a31* *a32* *a33*
		 *a34* *a35* *a36* *a37* *a38* *a39* *a40* *a41*
		 *a42* *a43* *a44* *a45* *a46* *a47* *a48* *a49* *a50*)
	  )
  (terpri)
  (dolist (result (reverse results))
    (format t "(~a  ~5d ~,2f  ~s  ~s)~%"
	    (first result) (second result) (third result)
	    (fourth result) (fifth result)))
  (format t "~%Averages:~%")
  (format t "Inference count = ~,2f~%"
	  (average (mapcar #'second results)))
  (format t "Run time = ~,2f minutes~%"
	  (average (mapcar #'third results)))
  (format t "Recall error rate = ~,2f~%"
	  (average (mapcar #'fourth results)))
  (format t "Precision error rate = ~,2f~%"
	  (average (mapcar #'fifth results)))
  (values))

(defun set-coh ()
  (setf *explanation-eval-metric* #'coherence-then-simplicity)
  (setf *compute-estimate-fn* #'pr-compute-estimate-coherence)
  (setf *combine-estimates-fn* #'pr-combine-estimates-coherence))

(defun set-simp ()
  (setf *explanation-eval-metric* #'simplicity-only)
  (setf *compute-estimate-fn* #'pr-compute-estimate-simplicity)
  (setf *combine-estimates-fn* #'pr-combine-estimates-simplicity))

(defun c ()
  (setf *caching* t))

(defun nc ()
  (setf *caching* nil))
