;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

(in-package 'user)

(export '(*brules* *facts*))

(setf *domain* 'qsim-diagnosis)

(setf *brules*
      '(
	(<- (qval ti ?m1 ?d1 ?t)   (norm s)
	                           (qval ti-ob ?m1 ?d1 ?t))
	(<- (qval ts ?m1 ?d1 ?t)   (norm k)
	                           (qval ts-ob ?m1 ?d1 ?t))
	(<- (qval e ?m3 ?d3 ?t)    (norm c1)
	                           (qval ts ?m1 ?d1 ?t) (qval ti ?m2 ?d2 ?t)
	                           (holds.- ts ti e ?m1 ?d1 ?m2 ?d2 ?m3 ?d3))
	(<- (qval a ?m2 ?d1 ?t)    (norm c2)
	                           (qval e ?m1 ?d1 ?t)
	                           (holds.m0+ e a ?m1 ?d1 ?m2 ?d1))
	(<- (qval p ?m3 ?d3 ?t)    (norm o)
	                           (qval p-ob ?m1 ?d1 ?t) (qval w ?m2 ?d2 ?t)
	                           (holds.* p-ob w p ?m1 ?d1 ?m2 ?d2 ?m3 ?d3))
	(<- (qval hfin ?m3 ?d3 ?t) (norm e)
	                           (qval a ?m1 ?d1 ?t) (qval p ?m2 ?d2 ?t)
	                           (holds.* a p hfin ?m1 ?d1 ?m2 ?d2 ?m3 ?d3))

	(<- (qval ti 0 std ?t)   (stuck-at-0-std s)
	                         (qval ti-ob ?m1 ?d1 ?t))
	(<- (qval ts 0 std ?t)   (stuck-at-0-std k)
	                         (qval ts-ob ?m1 ?d1 ?t))
	(<- (qval e 0 std ?t)    (stuck-at-0-std c1)
	                         (qval ts ?m1 ?d1 ?t) (qval ti ?m2 ?d2 ?t))
	(<- (qval a 0 std ?t)    (stuck-at-0-std c2)
	                         (qval e ?m1 ?d1 ?t))
	(<- (qval p 0 std ?t)    (stuck-at-0-std o)
	                         (qval p-ob ?m1 ?d1 ?t) (qval w ?m2 ?d2 ?t))
	(<- (qval hfin 0 std ?t) (stuck-at-0-std e)
	                         (qval a ?m1 ?d1 ?t) (qval p ?m2 ?d2 ?t))

	(<- (qval ti roomtemp std ?t) (stuck-at-roomtemp-std s)
	                              (qval ti-ob ?m1 ?d1 ?t)
				      (pos roomtemp))
	(<- (qval e ?m1 ?d1 ?t) (stuck-at-1st-in c1)
	                        (qval ts ?m1 ?d1 ?t) (qval ti ?m2 ?d2 ?t))
	(<- (qval e ?m2 ?d2 ?t) (stuck-at-2nd-in c1)
	                        (qval ts ?m1 ?d1 ?t) (qval ti ?m2 ?d2 ?t))
	(<- (qval p ?m1 ?d1 ?t) (stuck-at-1st-in o)
	                        (qval p-ob ?m1 ?d1 ?t) (qval w ?m2 ?d2 ?t))

	(<- (qval ti-ob ?m1 ?d1 ?t) (given-qval ti-ob ?m1 ?d1 ?t))
	(<- (qval ts-ob ?m1 ?d1 ?t) (given-qval ts-ob ?m1 ?d1 ?t))
	(<- (qval p-ob ?m1 ?d1 ?t) (given-qval p-ob ?m1 ?d1 ?t))
	(<- (qval w ?m1 ?d1 ?t) (given-qval w ?m1 ?d1 ?t))
	

	(<- (holds.m0+ ?f ?g ?m1 inc ?m2 inc)
	    (pos ?m1) (pos ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	(<- (holds.m0+ ?f ?g ?m1 std ?m2 std)
	    (pos ?m1) (pos ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	(<- (holds.m0+ ?f ?g ?m1 dec ?m2 dec)
	    (pos ?m1) (pos ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	
	(<- (holds.m0+ ?f ?g ?m1 inc ?m2 inc)
	    (neg ?m1) (neg ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	(<- (holds.m0+ ?f ?g ?m1 std ?m2 std)
	    (neg ?m1) (neg ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	(<- (holds.m0+ ?f ?g ?m1 dec ?m2 dec)
	    (neg ?m1) (neg ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))

	(<- (holds.- ?f ?g ?h ?m inc ?m inc 0 inc)
	    (corr-val.- ?f ?g ?h ?m inc ?m inc 0 inc))
	(<- (holds.- ?f ?g ?h ?m inc ?m inc 0 std)
	    (corr-val.- ?f ?g ?h ?m inc ?m inc 0 std))
	(<- (holds.- ?f ?g ?h ?m inc ?m inc 0 dec)
	    (corr-val.- ?f ?g ?h ?m inc ?m inc 0 dec))
	(<- (holds.- ?f ?g ?h ?m dec ?m dec 0 inc)
	    (corr-val.- ?f ?g ?h ?m dec ?m dec 0 inc))
	(<- (holds.- ?f ?g ?h ?m dec ?m dec 0 std)
	    (corr-val.- ?f ?g ?h ?m dec ?m dec 0 std))
	(<- (holds.- ?f ?g ?h ?m dec ?m dec 0 dec)
	    (corr-val.- ?f ?g ?h ?m dec ?m dec 0 dec))

	(<- (holds.- ?f ?g ?h ?m inc 0 inc ?m inc)
	    (corr-val.- ?f ?g ?h ?m inc 0 inc ?m inc))
	(<- (holds.- ?f ?g ?h ?m inc 0 inc ?m std)
	    (corr-val.- ?f ?g ?h ?m inc 0 inc ?m std))
	(<- (holds.- ?f ?g ?h ?m inc 0 inc ?m dec)
	    (corr-val.- ?f ?g ?h ?m inc 0 inc ?m dec))
	(<- (holds.- ?f ?g ?h ?m dec 0 dec ?m inc)
	    (corr-val.- ?f ?g ?h ?m dec 0 dec ?m inc))
	(<- (holds.- ?f ?g ?h ?m dec 0 dec ?m std)
	    (corr-val.- ?f ?g ?h ?m dec 0 dec ?m std))
	(<- (holds.- ?f ?g ?h ?m dec 0 dec ?m dec)
	    (corr-val.- ?f ?g ?h ?m dec 0 dec ?m dec))

	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))
	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))
	
	(<- (holds.* ?f ?g ?h 0 inc ?m inc 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 inc ?m std 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 inc ?m dec 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m inc 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m std 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m dec 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m inc 0 dec)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m std 0 dec)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m dec 0 dec)
	    (pos ?m))

	(<- (holds.* ?f ?g ?h 0 inc ?m inc 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 inc ?m std 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 inc ?m dec 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m inc 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m std 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m dec 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m inc 0 inc)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m std 0 inc)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m dec 0 inc)
	    (neg ?m))

	(<- (holds.* ?f ?g ?h ?m inc 0 inc 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m inc 0 std 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m inc 0 dec 0 dec)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 inc 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 std 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 dec 0 dec)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 inc 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 std 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 dec 0 dec)
	    (pos ?m))
	
	(<- (holds.* ?f ?g ?h ?m inc 0 inc 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m inc 0 std 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m inc 0 dec 0 inc)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 inc 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 std 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 dec 0 inc)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 inc 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 std 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 dec 0 inc)
	    (neg ?m))
	
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 inc ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 dec ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 std ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 inc ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 dec ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 std ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))
	
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))
	
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 std ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 std ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))


	(<- (holds./ ?f ?g ?h 0 inc ?m inc 0 inc)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 inc ?m std 0 inc)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 inc ?m dec 0 inc)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m inc 0 std)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m std 0 std)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m dec 0 std)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m inc 0 dec)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m std 0 dec)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m dec 0 dec)
	    (pos ?m))
	    
	(<- (holds./ ?f ?g ?h 0 inc ?m inc 0 dec)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 inc ?m std 0 dec)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 inc ?m dec 0 dec)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m inc 0 std)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m std 0 std)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m dec 0 std)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m inc 0 inc)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m std 0 inc)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m dec 0 inc)
	    (neg ?m))

	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))
	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 std ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 std ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))	
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 inc ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 dec ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 std ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))	
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 inc ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 dec ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))	
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 std ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))

	(<- (holds.d/dt ?f ?g ?m1 inc ?m2 inc)
	    (pos ?m2) (corr-val.d/dt ?f ?g ?m1 inc ?m2 inc))
	(<- (holds.d/dt ?f ?g ?m1 inc ?m2 std)
	    (pos ?m2) (corr-val.d/dt ?f ?g ?m1 inc ?m2 std))
	(<- (holds.d/dt ?f ?g ?m1 inc ?m2 dec)
	    (pos ?m2) (corr-val.d/dt ?f ?g ?m1 inc ?m2 dec))
	(<- (holds.d/dt ?f ?g ?m1 std 0 inc)
	    (corr-val.d/dt ?f ?g ?m1 std 0 inc))
	(<- (holds.d/dt ?f ?g ?m1 std 0 std)
	    (corr-val.d/dt ?f ?g ?m1 std 0 std))
	(<- (holds.d/dt ?f ?g ?m1 std 0 dec)
	    (corr-val.d/dt ?f ?g ?m1 std 0 dec))
	(<- (holds.d/dt ?f ?g ?m1 dec ?m2 inc)
	    (neg ?m2) (corr-val.d/dt ?f ?g ?m1 dec ?m2 inc))
	(<- (holds.d/dt ?f ?g ?m1 dec ?m2 std)
	    (neg ?m2) (corr-val.d/dt ?f ?g ?m1 dec ?m2 std))
	(<- (holds.d/dt ?f ?g ?m1 dec ?m2 dec)
	    (neg ?m2) (corr-val.d/dt ?f ?g ?m1 dec ?m2 dec))
	))

(setf *facts*
      '((holds.m0+ ?f ?g 0 inc 0 inc)
	(holds.m0+ ?f ?g 0 std 0 std)
	(holds.m0+ ?f ?g 0 dec 0 dec)
	
	(holds.- ?f ?g ?h ?m inc ?m std 0 inc)
	(holds.- ?f ?g ?h ?m inc ?m dec 0 inc)
	(holds.- ?f ?g ?h ?m std ?m inc 0 dec)
	(holds.- ?f ?g ?h ?m std ?m std 0 std)
	(holds.- ?f ?g ?h ?m std ?m dec 0 inc)
	(holds.- ?f ?g ?h ?m dec ?m inc 0 dec)
	(holds.- ?f ?g ?h ?m dec ?m std 0 dec)
	
	(holds.- ?f ?g ?h ?m inc 0 std ?m inc)
	(holds.- ?f ?g ?h ?m inc 0 dec ?m inc)
	(holds.- ?f ?g ?h ?m std 0 inc ?m dec)
	(holds.- ?f ?g ?h ?m std 0 std ?m std)
	(holds.- ?f ?g ?h ?m std 0 dec ?m inc)
	(holds.- ?f ?g ?h ?m dec 0 inc ?m dec)
	(holds.- ?f ?g ?h ?m dec 0 std ?m dec)
	
	(holds.* ?f ?g ?h 0 inc 0 inc 0 std)
	(holds.* ?f ?g ?h 0 inc 0 std 0 std)
	(holds.* ?f ?g ?h 0 inc 0 dec 0 std)
	(holds.* ?f ?g ?h 0 std 0 inc 0 std)
	(holds.* ?f ?g ?h 0 std 0 std 0 std)
	(holds.* ?f ?g ?h 0 std 0 dec 0 std)
	(holds.* ?f ?g ?h 0 dec 0 inc 0 std)
	(holds.* ?f ?g ?h 0 dec 0 std 0 std)
	(holds.* ?f ?g ?h 0 dec 0 dec 0 std)
	))

(setf *nogoods*
      '(((pos 0))
	((neg 0))
	((pos ?m) (neg ?m))

	((corr-val.- ?f ?g ?h ?m1 ?d1 ?m2 ?d2 0 ?d3) (<> ?m1 ?m2))
	((corr-mag.- ?f ?g ?h ?m1 ?m2 0) (<> ?m1 ?m2))
	((corr-val.- ?f ?g ?h ?m1 ?d1 0 ?d2 ?m3 ?d3) (<> ?m1 ?m3))
	((corr-mag.- ?f ?g ?h ?m1 0 ?m3) (<> ?m1 ?m3))

	((corr-val.- ?f ?g ?h ?m1 ?d1 ?m2 ?d2 ?m3 ?d3) (> ?m2 ?m1) (pos ?m3))
	((corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3) (> ?m2 ?m1) (pos ?m3))
	((corr-val.- ?f ?g ?h ?m1 ?d1 ?m2 ?d2 ?m3 ?d3) (> ?m1 ?m2) (neg ?m3))
	((corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3) (> ?m1 ?m2) (neg ?m3))
	
	((corr-val.- ?f ?g ?h 0 ?d1 ?m2 ?d2 ?m3 ?d3) (pos ?m2) (pos ?m3))
	((corr-mag.- ?f ?g ?h 0 ?m2 ?m3) (pos ?m2) (pos ?m3))
	((corr-val.- ?f ?g ?h 0 ?d1 ?m2 ?d2 ?m3 ?d3) (neg ?m2) (neg ?m3))
	((corr-mag.- ?f ?g ?h 0 ?m2 ?m3) (neg ?m2) (neg ?m3))
	))

(setf *assumption-nogoods* nil)

(setf *corr-mags* nil)

#|
; case specific observations for temp controller

(setf *tc-obs*
      '(
	(pos trm)
	(qval ti-ob trm dec t0)
	(qval ts-ob trm std t0)
	(pos psup)
	(qval p-ob psup std t0)
	(pos on)
	(qval w on std t0)

	(qval hfin 0 std t0)

	(pos cold)
	(> trm cold)
	(qval ti-ob cold std t1)
	(qval ts-ob trm std t1)
	(qval p-ob psup std t1)
	(qval w on std t1)
	
	(qval hfin 0 std t1)
	
	(qval ti 0 std t1)
	(qval a 0 std t1)
	(qval ts trm std t1)
	(qval e trm std t1)
	))
|#

(setf *inter-batch-beam-width* 40)
(setf *intra-batch-beam-width* 40)
(setf *bchain-depth* 6)
(setf *caching* t)
(setf *factoring* nil)
(setf *remove-superset?* nil)
(setf *explanation-eval-metric* #'diag-simplicity)
(setf *compute-estimate-fn* #'diag-compute-estimate)
(setf *combine-estimates-fn* #'diag-combine-estimates)

(setf *predicate-specific-abduction* t)
(setf *assumable-predicates*
      '(norm stuck-at-0-std stuck-at-1st-in stuck-at-2nd-in
	     stuck-at-roomtemp-std given-qval
	     pos neg corr-mag.m0+
	     corr-mag.- corr-val.- corr-mag.* corr-val.*
	     corr-mag./ corr-val./ corr-val.d/dt <> >))
(setf *free-assumption-predicates*
      '(norm given-qval
	     pos neg corr-mag.m0+
	     corr-mag.- corr-val.- corr-mag.* corr-val.*
	     corr-mag./ corr-val./ corr-val.d/dt <> >))
(setf *fault-mode-predicates*
      '(stuck-at-0-std stuck-at-1st-in
        stuck-at-2nd-in stuck-at-roomtemp-std))
(setf *components* '(s k c1 c2 o e))
