;;;
;;;   KNOWBEL knowledge representation system
;;;    
;;;    author: Bryan M. Kramer
;;;    
;;;    
;;; Copyright (c) 1990, 1991 University of Toronto, Toronto, ON
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all copies and
;;; supporting documentation.
;;;
;;; The University of Toronto provides this software "as is" without
;;; express or implied warranty.
;;;

;;;    
;;;    


;?	:f

;;;    
;;;    
(defmacro build-arith-ops (&rest ops)
  `(progn
     ,@(doloop (opp ops)
	:when (getd (car opp))
	:collect
	 (dlet* (((op inv inv2) opp))
	   `(setf (get ',op 'lisp-fn)
	      #'(lambda (atom sigma state belief clause theory)
		  (declare (ignore state belief clause theory))
		  (if (eq (car atom) 'not)
		    (dlet* (((o1 o2 r) (cdr (cadr atom))))
		      (cond ((and (numberp o1) (numberp o2))
			     (let ((val (,op o1 o2)))
			       (if (numberp r)
				 (if (= val r)
				   (values t nil)
				   (values nil nil))
				 (if (sigma-varp r)
				   (progn
				     (sigma-set r val sigma)
				     (values t nil))
				   (values nil nil))
				 )
			       ))
			    ((and (numberp o1) (numberp r) (sigma-varp o2))
			     (sigma-set o2 ,(if inv2 `(,inv2 o1 r) `(,inv r o1)) sigma)
			     (values t nil))
			    ((and (numberp o2) (numberp r) (sigma-varp o1))
			     (sigma-set o1 (,inv r o2) sigma)
			     (values t nil))
			    (t (values nil nil)))
		      )
		    (if (dlet* (((o1 o2 r) (cdr atom)))
			  (and (numberp o1) (numberp o2) (numberp r) (not (= (,op o1 o2) r)))
			  )
		      (values t nil (list 'arith))
		      (values nil nil)
		      )
		    )
		  )
	      )
	   )
	 )
     )
  )

(build-arith-ops (+ - nil) (- + -) (* / nil) (/ * /))


