;;;
;;;   KNOWBEL knowledge representation system
;;;    
;;;    author: Bryan M. Kramer
;;;    
;;;    
;;; Copyright (c) 1990, 1991 University of Toronto, Toronto, ON
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all copies and
;;; supporting documentation.
;;;
;;; The University of Toronto provides this software "as is" without
;;; express or implied warranty.
;;;

;;;    
;;;    


;? a replacement let macro for use in macros, intended to improve efficiency
;; will occassionaly rename variables that should not be renamed
;; probably not necessary if compiler optimizations used.



(provide 'pretools)
(defvar *backquote* (car '`(x)))
(defvar *backquote-comma* (caaadr '`(,x)))
(defvar *backquote-splice* (caaadr '`(,@x)))
(defvar *quote* (car ''(x)))

(defun mlet-sublis-backquote (alist expr)
  (cond ((null expr) nil)
	((not  (consp expr)) expr)
	(t
	 (cond ((eq (car expr) *backquote-comma*) (list *backquote-comma* (mlet-sublis alist (cadr expr))))
	       ((eq (car expr) *backquote-splice*) (list *backquote-splice* (mlet-sublis alist (cadr expr))))
	       ((eq (car expr) *quote*) (list *quote* (mlet-sublis-backquote alist (cadr expr))))
	       ((eq (car expr) *backquote*) (list *backquote* (mlet-sublis-backquote alist (cadr expr))))
	       (t (cons
		   (mlet-sublis-backquote alist (car expr))
		   (mlet-sublis-backquote alist (cdr expr))))
	       )))
  )

(defun mlet-sublis (alist expr)
  (cond ((null expr) nil)
	((not  (consp expr))
	 (let ((subst (assoc expr alist)))
	   (if subst (cdr subst) expr)))
	(t
	 (cond ((eq (car expr) *quote*) expr)
	       ((eq (car expr) *backquote*) (mlet-sublis-backquote alist expr))
	       (t (cons
		   (mlet-sublis alist (car expr))
		   (mlet-sublis alist (cdr expr))))
	       )))
  )



(defun mlet-star-subst (alist expr)
  (cond ((null expr) nil)
	((not (consp (car expr))) (cons (car expr) (mlet-star-subst alist (cdr expr))))
	(t (cons (cons (caar expr) (mlet-sublis alist (cdar expr)))
		 (mlet-star-subst alist (cdr expr)))))
  )



(defun mlet-vars (let-word let-vars body star-subst)
  (let ((subst nil)
	(vars nil))
    (do ((var-spec let-vars (cdr var-spec)))
	((null var-spec) `(,let-word ,vars ,@(mlet-sublis subst body)))
      (cond ((symbolp (car var-spec))
	     (let ((name (gensym (string (car var-spec)))))
	       (setf vars (append vars (list name)))
	       (push (cons (car var-spec) name) subst)
	       ))
	    ((and (consp (car var-spec)) (symbolp (caar var-spec)))
	     (if (and (cadar var-spec) (symbolp (cadar var-spec)))
	       (push (cons (caar var-spec) (cadar var-spec)) subst)
	       (let ((name (gensym (string (caar var-spec)))))
		 (setf vars (append vars (list (list name (if star-subst
							    (mlet-sublis subst (cadar var-spec))
							    (cadar var-spec))))))
		 (push (cons (caar var-spec) name) subst)
		 )))
	    (t (setf vars (append vars (list (car var-spec))))))
      ))
  )


;(defmacro mlet (vars &body body)  
;  (mlet-vars 'let vars body nil)
;  )

;(defmacro mlet* (vars &body body)
;  (mlet-vars 'let* vars body t)
;  )

(defmacro mlet (&rest args)
  `(let ,@args)
  )

(defmacro mlet* (&rest args)
  `(let* ,@args)
  )
