;;;
;;;   KNOWBEL knowledge representation system
;;;    
;;;    author: Bryan M. Kramer
;;;    
;;;    
;;; Copyright (c) 1990, 1991 University of Toronto, Toronto, ON
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all copies and
;;; supporting documentation.
;;;
;;; The University of Toronto provides this software "as is" without
;;; express or implied warranty.
;;;

;;;    
;;;    


;? a knowledge base dealing with airline flights between cities
;;;    



(time ( 1970 +))
(belief 1975 1977)

(local-time
    instance ((class))
    with (
	  ((necessary single)
	   (time integer)
	   (zone string)
	   ))
    )


(lt1
    instance ((local-time))
    with ((time (_ 3333)(_ 4444)))
    )


(belief)

(Flight-class
   instance ((M1-Class))
   with (
	 (attribute    
	  (international-path proposition)
	  (national-path proposition)
	  (airline string)
	  (airline-phone-no string)))
)


(Flight-parameter
   instance ((M1-Class))
)


(City
    instance ((Flight-parameter))
    with (
      (necessary 
        (country  string)
	(estimate-cost integer)
        (continent  string))
      (attribute
        (name string)
        (location list)
        (population  integer))
))




(Company
    instance ((Flight-parameter))
    with (
      ((necessary  single)
        (name string)
        (head-office  City))
      (attribute
        (regional-offices  City))
))


(TestCompany
     instance ((flight-parameter))
     isa ((company))
     with (
	   (attribute
	     (regional-offices FooCity))
	    )
     )

(TestOffice instance ((Company)))

(TestInst
     instance ((Company))
     with (
	   (name (_ "axaxaxax")
		  (_ "yayy"))
	   (head-office (_ TestOffice))
	   )
     )


(Toronto
   instance ((Token)  (City))
   with (
     (name 
           (_ Toronto))
     (country 
           (_ Canada))
     (continent 
           (_ North-America))
     (location
	   (latitude (43 north))
	   (longtitude (79 west)))
     (estimate-cost
           (vancouver 399)
	   (tokyo 1431)
           (hongkong 960)
	   (beijing 3064))
))


(vancouver
   instance ((Token)  (City))
   with (
     (country 
           (_ Canada))
     (continent 
           (_ North-America))
     (location
	   (latitude (49 north))
	   (longtitude (123 west)))
     (estimate-cost
	   (tokyo 3424)
	   (hongkong 3064)
	   (beijing 1254))
))

(Hongkong
   instance ((Token)  (City))
   with (
     (name 
           (_ Hong-Kong))
     (country 
           (_ Hongkong))
     (continent 
           (_ Asia))
     (location
	   (latitude (22 north))
	   (longtitude (114 east)))
     (estimate-cost
	   (tokyo 664)
	   (beijing 450))
))

(Tokyo
   instance ((Token)  (City))
   with (
     (name 
          (_ Tokyo))
     (country 
          (_ Japan))
     (continent 
          (_ Asia))
     (location
	   (latitude (35 north))
	   (longtitude (140 east)))
     (estimate-cost
	  (hongkong 664)
	  (beijing 705))
))

(Beijing
   instance ((Token)  (City))
   with (
     (name 
          (_ Beijing))
     (country 
          (_ China))
     (continent 
          (_ Asia))
     (location
	   (latitude (40 north))
	   (longtitude (116 east)))
     (estimate-cost
	  (hongkong 450)
	  (xian 110)
	  (chengdu 210))
))


(Chengdu
   instance ((Token)  (City))
   with (
     (name 
          (_ Chengdu))
     (country 
          (_ China))
     (continent 
          (_ Asia))
     (location
	   (latitude (31 north))
	   (longtitude (104 east)))

))


(Xian
   instance ((Token)  (City))
   with (
     (name 
          (_ Xian))
     (country 
          (_ China))
     (continent 
          (_ Asia))
     (estimate-cost
          (chengdu 80))
     (location
	   (latitude (34 north))
	   (longtitude (108 east)))
))

(New-york
   instance ((Token)  (City))
   with (
     (name 
          (_ New-York))
     (country 
          (_ USA))
     (continent 
          (_ North-America))
     (location
	   (latitude (35 north))
	   (longtitude (70 west)))
))







(Airplane 
    instance ((Flight-parameter))
    with (
      (necessary
        (name string)
        (manufacturer  string)
        (max-capacity  integer))
))






(BO747
   instance ((Token)  (Airplane))
   with (
     (name 
        (_ BO747))
     (manufacturer 
        (_ Boeing))
     (max-capacity 
        (_ 462))
))

(DH-6
  instance ((Token)  (Airplane))
   with (
     (name 
        (_ L211))
     (manufacturer 
        (_ Lockheed))
     (max-capacity 
        (_ 233))
))

(DC-9
   instance ((Token)  (Airplane))
   with (
     (name 
        (_ DC-9))
     (manufacturer 
        (_ McDonald-Douglas))
     (max-capacity 
        (_ 124))
))

(Flight-category
   instance ((Flight-parameter))
)




(Flight
   instance ((Flight-Class) (Flight-parameter))
   with
    (
     ((necessary single)
       (departure-time  integer)
       (airline  Company)
       (flight-number  string)
       (max-passengers  Integer)
       (available-seats  Integer))
     (necessary
       (arrival-time  integer)
       (airline-phone-no  string))
     (attribute
      (aircraft-type  Airplane))

     (deductive-rule
       (_ (=>
         (instance-of $flight Flight)
         (member-of $city1/city $flight origin)
	 (member-of $city2/city $flight destination)

         (directly-connected $flight $city1 $city2)))

        (_ (=>
         (instance-of $flight Flight)
         (directly-connected $flight $City1/city $City2/city)

         (connected $City1 $City2)))

        (_ (=>
         (instance-of $flight Flight)
         (directly-connected $flight $City1/city $City2/city)
         (connected $City2 $City3)

         (connected $City1 $City3)))

	(_ (=>
	 (forall $flight
	   (=> (instance-of $flight Flight)
	       (exists $price
		 (=> (member-of $price $flight price)
		     (> $price 1000)))))))
	)

     (integrity-constraint
       (toronto_departure-time 
       (forall ($flight $t1)
	(=> 
         (instance-of $flight Flight)
	 (member-of toronto $flight origin)
         (member-of $t1 $flight departure-time)
          
	 (and (> $t1 800) (< $t1 2300)))))

       (toronto_arrival_time 
       (forall ($flight $t1)
	(=> 
         (instance-of $flight Flight)
	 (member-of toronto $flight destination)
         (member-of $t1 $flight arrival-time)
         
	 (and (> $t1 800) (< $t1 2400))  ))))
	))
  

(International-flight
   isa ((Flight))
   instance ((Flight-class))
   with
     (
      (international-path
	 (origin City)
	 (destination City)
	 (price integer))
      (integrity-constraint
         (_ 
           (Forall $flight
           (=>
	   (instance-of $flight International-flight)
	   (member-of $o/city $flight origin)
	   (member-of $d/city $flight destination)
	   (member-of $coun1/string $o country)
	   (member-of $coun2/string $d country)

           (not (is $coun1 $coun2)) )))))

)

(National-flight
   isa ((Flight))
   instance ((flight-class))
   with
     (
      (national-path
	 (origin City)
	 (destination City)
	 (price integer))
      (integrity-constraint
       (_ (not (and  (attr |$x(national-flight)| $l "origin" $origin $p |$t(-,+)|)
		     (attr $x $l2 "destination" $origin $p2 $t))))
       (_
	(Forall $flight
		(=>
		 (instance-of $flight National-flight)
		 (member-of $o/city $flight origin)
		 (member-of $d/city $flight destination)
		 (member-of $coun1/string $o country)
		 (member-of $coun2/string $d country)

		 (is $coun1 $coun2) )))))
)

(Regional-flight
   isa ((National-flight))
   instance ((flight-class))
)

(Local-flight
   isa ((National-flight))
   instance ((flight-class))
)




(AC-Flight
    isa ((Flight-category))
    instance ((flight-class))
    with
      (
       (airline
          (_ Air-Canada))
       (airline-phone-no 
         (reservations  416-783-7645)
         (information  416-765-8790))

      (deductive-rule
	(_
        (Forall $flight 
          (=> 
	  (instance-of $flight AC-Flight)
	  (member-of $city1/city $flight origin)
	  (member-of $city2/city $flight destination)
	  (is $city1 toronto)
	  (is $city2 vancouver)
          (member-of 499 $flight price)
	))))
	)
)


(BA-Flight
    isa ((Flight-category))
    instance ((flight-class))
    with
     (
       (airline
          (_ British-Airways))
       (airline-phone-no 
         (reservations  202-654-4443)
         (information  765-212-4323))
 	)	
)


(AA-Flight
    isa ((Flight-category))
    instance ((flight-class))
    with (
       (airline
          (_ American-Airlines))
       (airline-phone-no 
         (reservations  303-684-2212)
         (information  908-333-2123))
	
      (integrity-constraint
	(_
        (Forall ($flight $city1)
          (=> 
	  (instance-of $flight AA-Flight)
	  (member-of $city1 $flight origin)
	  (member-of $country1 $city1 country)
          
	  (not (is $country1 Iran)) )))
	
	(_ 
        (Forall ($flight $city1)
          (=> 
	  (instance-of $flight AA-Flight)
	  (member-of $city1 $flight destination)
	  (member-of $country1 $city1 country)
          
	  (not (is $country1 Iran)) ))))

	)
)

(CAAC-Flight
    isa ((Flight-category))
    instance ((flight-class))
    with (
       (airline
          (_ CAAC))
       (airline-phone-no 
         (reservations  416-655-3331)
         (information  416-333-6544)))
)


(Flight3402
   instance ((Token)  (AC-Flight)  (International-flight))
   with (
       (flight-number 
          (_ 3402))
       (origin 
          (_ Toronto))
       (departure-time 
          (_ 1405 (before 1988))
          (_ 1505 (after 1988)))
       (max-passengers 
          (_ 256))
       (available-seats 
         (1st-class  10)
         (2nd-class  5))
       (destination
          (_  Tokyo (after 1986))
          (_  New-York (before 1986)))
       (arrival-time
           (_ 1500 (before 1986))
           (_ 1600 (after 1986)))

       (price
         (_  299 (before 1986))
         (_  1431 (after 1986))
	)
))

(Flight3403
   instance ((Token)  (AC-Flight)  (International-flight))
   with (
       (flight-number 
          (_ 3403))
       (origin 
          (_ Toronto))
       (departure-time 
          (_ 1000))
       (max-passengers 
          (_ 256))
       (available-seats 
         (1st-class  10)
         (2nd-class  5))
       (destination
          (_  Beijing))
	
       (arrival-time
           (_ 1600))

       (price
         (_  3064)
	)
))

(Flight3502
   instance ((Token)  (AA-Flight)  (International-flight))
   with (
       (flight-number 
          (_ 3502))
       (origin 
          (_ Toronto))
       (departure-time 
          (_ 1405 (before 1988))
          (_ 1505 (after 1988)))
       (max-passengers 
          (_ 256))
       (available-seats 
          (1st-class  10)
          (2nd-class  5))
       (destination
           (_ Hongkong (after 1988))
           (_ New-York (before 1988)))
       (arrival-time
           (_ 1800 (before 1988))
           (_ 1900 (after 1988)))
       (price
           (_  320 (before 1988))
           (_  960 (after 1988))
)))

(Flight775
   instance ((Token)  (AC-Flight)  (National-Flight))
   with (
       (flight-number 
          (_ 775))
       (origin 
          (_ Toronto))
       (departure-time 
          (_ 805))
       (max-passengers 
          (_ 256))
       (available-seats 
          (2nd-class  55))
       (destination
           (_ Vancouver ))
       (arrival-time
           (_ 1300 ))
       (price (_ 725))

))


(Flight1334
 instance ((Token)  (AC-Flight)  (National-Flight))
 with (
       (flight-number 
	(_ 1334))
       (origin 
	(_ Toronto))
       (departure-time 
	(_ 1005))
       (max-passengers 
	(_ 256))
       (available-seats 
	(2nd-class  85))
       (destination
	(_ Vancouver ))
       (arrival-time
	(_ 1400 ))
       (price (_ 836))
       ))

(Flight655
   instance ((Token)  (AC-Flight)  (International-Flight))
   with (
       (flight-number 
          (_ 655))
       (origin 
          (_ Vancouver))
       (departure-time 
          (_ 805))
       (max-passengers 
          (_ 256))
       (available-seats 
          (2nd-class  225))
       (destination
           (_ Hongkong))
       (arrival-time
           (_ 1900))
       (price
           (_ 3064))
))

(Flight657
   instance ((Token)  (AC-Flight)  (International-Flight))
   with (
       (flight-number 
          (_ 657))
       (origin 
          (_ Vancouver))
       (departure-time 
          (_ 705))
       (max-passengers 
          (_ 256))
       (available-seats 
          (2nd-class  105))
       (destination
           (_ Tokyo))
       (arrival-time
           (_ 1700))
       (price
           (_ 3424))
))


(Flight1025
   instance ((Token)  (CAAC-flight)  (International-Flight))
   with (
       (flight-number 
          (_ 1025))
       (origin 
          (_ Vancouver))
       (departure-time 
          (_ 735))
       (max-passengers 
          (_ 256))
       (available-seats 
          (2nd-class  95))
       (destination
           (_ Beijing))
       (arrival-time
           (_ 2000))
       (price
           (_ 1254))
))


(Flight1344
   instance ((Token)  (CAAC-flight)  (International-flight))
   with (
       (flight-number 
          (_ 7809))
       (origin 
          (_ Tokyo))
       (departure-time 
          (_ 900))
       (max-passengers 
          (_ 256))
       (available-seats 
          (2nd-class  100))
        (destination
           (_ Beijing))
       (arrival-time
           (_ 1210))
       (price
          (2nd-class  705))
       (aircraft-type  
          (_ DC-9))
))
      

(Flight7809
   instance ((Token)  (CAAC-flight)  (International-flight))
   with (
       (flight-number 
          (_ 7809))
       (origin 
          (_ Hongkong))
       (departure-time 
          (_ 1247))
       (max-passengers 
          (_ 124))
       (available-seats 
          (2nd-class  100))
        (destination
           (_ Tokyo))
       (arrival-time
           (_ 1445))
       (price
          (2nd-class  664))
       (aircraft-type  
          (_ DC-9))
))
      

(Flight7805
   instance ((Token)  (CAAC-flight)  (International-flight))
   with (
       (flight-number 
          (_ 7805))
       (origin 
          (_ Tokyo))
       (departure-time 
          (_ 1018))
       (max-passengers 
          (_ 124))
       (available-seats 
          (2nd-class  10))
        (destination
           (_ Hongkong))
       (arrival-time
           (_ 1345))
       (price
          (2nd-class  664))
       (aircraft-type  
          (_ DC-9))
))
      

(Flight3304
   instance ((Token)  (AA-flight)  (International-flight))
   with (
       (flight-number 
          (_ 3304))
       (origin 
          (_ Hongkong))
       (departure-time 
          (_ 905))
       (max-passengers 
          (_ 124))
       (available-seats 
          (2nd-class  100))
        (destination
           (_ Beijing))
       (arrival-time
           (_ 1145))
       (price
          (2nd-class  450))
       (aircraft-type  
          (_ DC-9))
))
      

(Flight7811
   instance ((Token)  (CAAC-flight)  (National-flight))
   with (
       (flight-number 
          (_ 7811))
       (origin 
          (_ Beijing))
       (departure-time 
          (_ 800))
       (max-passengers 
          (_ 105))
       (available-seats 
          (2nd-class  34))
        (destination
           (_ Xian))
       (arrival-time
           (_ 1105))
       (price
          (2nd-class  110))
))
      

(Flight7822
   instance ((Token)  (CAAC-flight)  (National-flight))
   with (
       (flight-number 
          (_ 7822))
       (origin 
          (_ Beijing))
       (departure-time 
          (_ 1000))
       (max-passengers 
          (_ 85))
       (available-seats 
          (2nd-class  50))
        (destination
           (_ Chengdu))
       (arrival-time
           (_ 1605))
       (price
          (2nd-class  210))
))
      

(Flight7840
   instance ((Token)  (CAAC-flight)  (National-flight))
   with (
       (flight-number 
          (_ 7840))
       (origin 
          (_ Xian))
       (departure-time 
          (_ 1400))
       (max-passengers 
          (_ 85))
       (available-seats 
          (2nd-class  25))
        (destination
           (_ Chengdu))
       (arrival-time
           (_ 1705))
       (price
          (2nd-class  80))
))
      






(Air-Canada
   instance ((Token)  (Company))
   with (
     (name 
          (_ Air-Canada))
     (head-office 
          (_ Toronto))
))

(American-airlines
   instance ((Token)  (Company))
   with (
     (name 
         (_ American-Airlines))
     (head-office 
         (_ New-York))
))

(CAAC
   instance ((Token)  (Company))
   with (
     (name 
         (_ China-Airline))
     (head-office 
         (_ Beijing))
))























(proto-Flight-path
   instance ((M1-Class))
   with
    ((attribute
      (from city)
      (flight flight)
      (to city)
      (cost number)
      (flight-gen flight
		  :with
		  (meta-rule
		   (flight-path-mr
		    (=> (varp $v)
			(time-of $h $ih)
			(instance-of $obj/flight flight $ih)
			(attr $proto * "from" $origin * $ih)
			(attr $obj * "origin" $origin * $ih)
			(attr $obj * "price" $price * $ih)
			(current-clause-value $state $current)
			(+ $current $price $new-val)
			(goal (attr $proto/proto-flight-path * "flight-gen" $v * $h) $state (sigma (val $v $obj))
			      (:value $new-val)))))
		  )
      (subpath proto-flight-path)))
    )

(null-flight-path
 instance ((proto-flight-path))
 )



(Flight-path
 instance ((M1-Class))
 isa ((proto-flight-path))
 with
 ((deductive-rule
   (path-recursive (=> 
		    (instance-of $p/proto-flight-path proto-flight-path $t@-^+)
		    (attr $p * "from" $origin * $t)
		    (attr $p * "to" $to * $t)
		    (attr $p * "flight-gen" $f/flight * $t)
		    (attr $f * "origin" $origin * $t)
		    (attr $f * "destination" $dest * $t)
		    (= $subpath/proto-flight-path #@((proto-flight-path)(("from" (_ $dest $t))
							    ("to" (_ $to $t))
							    ("flight" (_ $subflight $t))
							    ("cost" (_ $subcost $t))
							    ("subpath" (_ $sp $t)))))
		    (= $path-class flight-path)
		    (instance-of $subpath $path-class $t)
		    (attr $p * "subpath" $subpath * $t)
		    (attr $p * "flight" $f * $t)
		    (attr $f * "price" $price * $t)
		    (+ $price $subcost $cost)
		    (attr $p * "cost" $cost * $t)
		    (instance-of $p flight-path $t)))

   (path-base (=> (attr $p * "flight-gen" $f/flight * $t@-^+)
		  (attr $f * "origin" $origin * $t)
		  (attr $f * "destination" $dest * $t)
		  (instance-of $p/proto-flight-path proto-flight-path $t)
		  (attr $p * "from" $origin * $t)
		  (attr $p * "to" $dest * $t)
		  (attr $p * "subpath" null-flight-path * $t)
		  (attr $p * "flight" $f * $t)
		  (attr $f * "price" $price * $t)
		  (attr $p * "cost" $price * $t)
		  (instance-of $p flight-path $t)))
   )
  ))

(international-path 
   isa ((flight-path))
   instance ((M1-Class))
   with
    (
     (search-method
      (_ best-first)
    )))

(national-path 
   instance ((M1-Class))
   isa ((flight-path))
   )


(national-path-in-china
   instance ((M1-Class))
   isa ((national-path))
   with
    (
     (search-method
      (_ breadth-first)
    )))

(national-path-in-canada
   instance ((M1-Class))
   isa ((national-path))
   with
    (
     (search-method
      (_ best-first)
    )))
