;;; -*- Mode:Lisp -*-

(in-package 'user)
(provide 'doc-strings)

;;;  Provides documentation strings for Frob functions and variables.
;;;  Unfortunately, while most implementations make DOCUMENTATION setf'able,
;;;  not very many support the same functionality for ARGLIST...
;;;  NOTE : Do not compile this file but load it directly

;;; Global variables, or constants

(setf (documentation '*undefined* 'function)
  "A constant that holds the undefined value for single valued slots.")

;;; Predicates

(setf (documentation 'BOUND? 'function)
  "Predicate function that returs T if SLOT is bound, else it returns NIL. \
 If SLOT is a zero argument method simulating a slot method then BOUND? \
 returns T if the method returns a non NIL value.")

(setf (documentation 'CLASS-FROB? 'function)
  "Predicate function that returns T if ANY-FROB is a class frob.")

(setf (documentation 'FROB? 'function)
  "Predicate function that returns T if ANY-FROB is either an instance frob \
 or a class frob.")

(setf (documentation 'FROB-TYPE? 'function)
  "Returns T if ANY-FROB inherits from the class frob TYPE.")

(setf (documentation 'INSTANCE-FROB? 'function)
  "Predicate function that returns T if ANY-FROB is an instance frob.")

(setf (documentation 'SLOT? 'function)
  "Predicate function that returns T if CLASS-FROB has SLOT as a slot defined\
 over the class.")

;;; Functions

(setf (documentation 'RESET-SYSTEM 'function)
  "Undefines all of the frobs and methods in the system.")

(setf (documentation 'RESET-RULES 'function)
  "Undefines all of the rule in the system.")

;;(setf (arglist COPY-CLASS) ())
(setf (documentation 'COPY-CLASS 'function)
  "Creates the new frob NFROB from the source SFROB and appends it to the \
 parent(s) of SFROB. The inheritance of descendants of SFROB is not changed.")

(setf (documentation 'DEF-CLASS 'function)
  "Defines a new class")

(setf (documentation 'ASSERT-VAL 'function)
  "Will assert VALUE to SLOT of ANY-FROB. ASSERT-VAL fires daemons associa- \
 ted with the frob. ASSERT-VAl can be used on either single valued or mul- \
 tiple valued slots.")

(setf (documentation 'ASSERT-VALS 'function)
  "Will assert VALUE-LIST to SLOT of ANY-FROB. ASSERT-VAL fires daemons asso- \
 ciated with the frob for each value in the VALUE-LIST.")

(setf (documentation 'CALL-METHOD 'function)
  "Will funcall the method METHOD-NAME defind over the class name CLASS-NAME. \
 It invokes the method under the context of PARENT-NAME, using the with-frob \
 form.")

(setf (documentation 'ASK 'function)
  "Returns the value of a SLOT from a FROB. It uses inheritance if needed. \
 The inheritance mechanism used is determined by :USE-CONTEXT.             \
 If :USE-CONTEXT is NIL (default), then a breadth first search is used     \
 through the parents graphs. It returns *undefined* if the SLOT isn't found \
 or not bound.         							    \
 If :USE-CONTEXT is T then only parents of the class that are descendants  \
 of the current context are looked at.")

(setf (documentation 'ALL-FROBS 'function)
  "Returns a list of all of the frobs currently defined.")

(setf (documentation 'ALL-CLASS-FROBS 'function)
  "Returns a list of all of the class frobs currently defined.")

(setf (documentation 'ALL-CLASS-INSTANCES 'function)
  "Returns a list of all of the class descendants of a CLASS-FROB.")
  
(setf (documentation 'ALL-INSTANCE-FROBS 'function)
  "Returns a list of all of the instance frobs currently defined.")

(setf (documentation 'ALL-INSTANCES 'function)
  "Returns all of the instance descendants of a CLASS-FROB.")

(setf (documentation 'DEF-METHOD 'function)
  "Defines a method over a CLASS of objects. The CLASS must either be the \
 symbol name for the class or a class frob. The PRIV-SHOW list may contain :\

 :PRIVATE   -> the method private within the CLASS module.
 :SHOW      -> the method will be called when executing the system method\
               SHOW and the results of the call will be shown.\
 :ONLY      -> retroactive inheritance of this method is not done.\
 :IN-MODULE -> the method is defined inside a CLASS module and has access to\
               all of the private slots; otherwise it has access to the open\
               and generic slots.

 To access a method inside of a method one must do a (METHOD-NAME $self). The\
 $self parameter is implicit in the definition as the first parameter.")

(setf (documentation 'APPLY-METHOD-IN-CONTEXT 'function)
  "Will apply the method METHOD-NAME defind over the class name CLASS-NAME. \
 It invokes the method under the context of PARENT-NAME.")

(setf (documentation 'CALL-METHOD-IN-CONTEXT 'function)
  "Will funcall the method METHOD-NAME defind over the class name CLASS-NAME. \
 It invokes the method under the context of PARENT-NAME.")

(setf (documentation 'APPLY-METHOD 'function)
  "Will apply the method METHOD-NAME defind over the class name CLASS-NAME. \
 It invokes the method under the context of PARENT-NAME, using the with-frob \
 form.")

(setf (documentation 'CHECK-IN-FILE 'function)
  "Checks in a file of frobs that are instances of CLASS-FROB. If SAVE is \
 NIL no changes will be saved to the file.")

(setf (documentation 'CHECK-OUT-FILE 'function)
  "Checks out a file of frobs that are instances of CLASS-FROB.           \
 TYPE determines how the file is checked out (:LOCKED or :READ-ONLY), and \
 defaults to *default-type*.                                              \
 PAGE-VALUE determines how often the file will be paged out when the pager \
 is on. PAGE-VALUE defaults to 0, and the higher the value the less often  \
 the file will be paged out.                                               \
 When OVERRIDE is T, the file will be checked out, even it already is.")

(setf (documentation 'CLASS-INSTANCES 'function)
  "Returns the class children of a CLASS-FROB.")

(setf (documentation 'CLASS_NAME 'function)
  "Returns the CLASS-FROB name. This is equivalent to (frob-type CLASS-FROB).")

(setf (documentation 'CLASS-PARENT 'function)
  "If ANY-FROB is a class frob then a list of parents that the class frob \
 inherits from is returned. If the frob is an instance frob then the class \
 frob that the frob was defind from is returned.")

(setf (documentation 'ERASE 'function)
  "Makes the SLOT of ANY-FROB *undefinded*. If the SLOT is a multiple valued \
 slot the SLOT will be set to NIL.")

(setf (documentation 'FROB-TYPE 'function)
  "Returns the parent-class symbol name of an instance frob. If ANY-FROB is \
 a class frob then it will return its own symbol name.")

(setf (documentation 'GET-CLASS-FROB 'function)
  "Returns the class frob associated with the symbol NAME.")

(setf (documentation 'GET-FROB 'function)
  "Returns the instance frob associated with the symbol NAME, or if the frob \
 is a generic instance NAME will be a list.")
      
(setf (documentation 'INHERITS-FROM 'function)
  "Returns a list of class names theis frob inherits from.")

(setf (documentation 'INSTALL-DAEMON 'function)
  "Similar to DEFINE-DAEMON but it associates the function FUNCTION-NAME as \
 the daemon to be fired when SLOT is acessed at the time specified by TIME.")
      
(setf (documentation 'INSTANCES 'function)
  "Returns the instance frobs of a class frob.")

(setf (documentation 'INSTANCE-NAME 'function)
  "Returns the name of an instance frob. If the frob is a generic frob then \
 the result will be a list of the class-name and the generic instance number.")

(setf (documentation 'KILL-CLASS-FROB 'function)
  "Undefines a CLASS-FROB and removes it from the system.")

(setf (documentation 'KILL-FROB 'function)
  "Undefines an instance frob and removes it from the system.")

(setf (documentation 'KILL-INSTANCES 'function)
  "Undefines all of the instance frobs of some class.")

(setf (documentation 'KILL-INSTANCE-FROBS 'function)
  "Undefines all of the instance frobs in the system.")
 
(setf (documentation 'NEW-INSTANCE 'function)
  "Defines a new instance of PARENT frob. If the :NAME keyword is given then \
 the frob will be a named NAME, otherwise it will be a generic instance.     \
 The :INIT keyword is for giving initial values at creation time.           \
 If the :DEFAULT keyword is NIL (default T) then the frob will not be ini-  \
 tialized with the values from the values from the PARENT frob.            \
 Note that any instance frobs will be created at compile time. [MACRO]")

(setf (documentation 'NEW-INSTANCE* 'function)
  "Defines a new instance with name (eval NAME) of PARENT frob. \
 The :INIT keyword is for giving initial values at creation time. It is called\
 automatically by NEW-INSTANCE. [Called automatically]")

(setf (documentation 'NOT-ATOMIC 'function)
  "Evaluates its argument FORMS in a context where every assertion that can \
 cause a rule to fire will immediately fire. Without this FORM, the default-\
 behavior is that all assertions will wait until the last one is done before \
 any rules fire.")

(setf (documentation 'REMOVE-VAL 'function)
  "Removes some VALUES from a multiple valued SLOT. REMOVE-VAL fires daemons \
 associated with the frob. If the slot is single valued, then the SLOT will  \
 be unbound if VALUE is equal to the current slot value of the frob.")

(setf (documentation 'RUN-SUPER 'function)
  "Will call the first method named METHOD-NAME in the inheritance tree of  \
 the current method. The RUN-SUPER form should only appear within the de-   \
 finition of a method.")

(setf (documentation 'SET-CONFLICT-RESOLUTION-STRATEGY 'function)
  "Sets the current conflict resolution strategy. This must be one of :     \
 :DEPTH-FIRST   -> Rules are added to the front of the frobs::*queue*       \
 :BREADTH-FIRST -> Rules are added to the end of the frobs::*queue*         \
 :PAR-DEPTH-FIRST and :PAR-BREADTH-FIRST provide a pseudo parallel mode.     \
 or the name of the user-defined strategy.")

(setf (documentation 'SHOW 'function)
  "Shows off the slots of a frob. If the frob is shown inside of a class   \
 module then it also shows the private slot values. Show also shows any    \
 method that is showable. If method is showable it should not take any ar- \
 guments or perform any side effects.")

(setf (documentation 'STOP-FC 'function)
  "Stops the system from any further forward-chaining. The agenda queue is \
 emptied and no more rules will be fired.")

(setf (documentation 'WITH-FROB 'function)
  "Binds the current context to FROB-TYPE. FROB-TYPE must be the symbolname \
 of some class frob. The S-EXPRESSIONS are evaluated under this new context.\
 On exit, the context is rebound to be the context that was in effect before \
 the call. WITH-FROB uses unwind-protect so after an error or breck is exited\
 the context will be reset. [MACRO]")

(setf (documentation 'WITH-MODULE 'function)
  "Binds the current module to FROB-TYPE. FROB-TYPE must be the symbolname \
 of some class frob. If the module was locked with a key then the KEY para-\
 meter must be bound to the correct key. The KEY parameter is not evaluated.\
 The S-EXPRESSIONS are evaluated within this new context.                   \
 On exit, the current module is rebound to be the module that was in effect \
 before the call. WITH-FROB uses unwind-protect so after an error or breck \
 is exited the module  will be reset. [MACRO]")

(setf (documentation 'GET-GENERIC-FN 'function)
  "Returns the generic function NAME out of the CLASS-FROB.")

(setf (documentation 'PUT-FROB 'function)
  "Stores a FROB onto the frob hash NAME. [Called automatically]")

(setf (documentation 'PUT-CLASS-FROB 'function)
  "Stores a CLASS-FROB onto the frob hash NAME. [Called automatically]")

(setf (documentation 'INSTANCE-NAME 'function)
  "Returns the name of an instance FROB.")

(setf (documentation 'BEFORE-METHODS 'function)
  "Used to do some misc things during class definition in DEF-CLASS, DEF-\
 CLASS2 or COPY-CLASS. [Called automatically]")

(setf (documentation 'AFTER-METHODS 'function)
  "Used to do some misc things during class definition in DEF-CLASS, DEF-\
 CLASS2 or COPY-CLASS. [Called automatically]")

(setf (documentation 'CLOSE-CLASS 'function)
  "Closes a frob class. If the KEY is given then the class is locked with that\
 key. [MACRO]")

;;; Functions concerning the rule-system

(setf (documentation 'DEF-RULE 'function)
  "Defines a forward chaining rule. The name will be RULE-NAME. Note that var-\
 iables used in :TYPE or :LOCAL are named as ?<name_of_variable>.\

 :TYPE  -> List which is used to type the frob variables used in the premise.\
           It is of the form : ((var type) ... (var2 type2))
 :MV    -> List of multiple valued slots treated in the premise.\
 :LOCAL -> List of the local variables used for value binding in the premise\
           which are not already declared in :TYPE.\
 :PREM  -> Premise of the rule. This will be a list of rule-clauses.\
 :CONC  -> Conclusion of the rule. Will be executed if the :PREM is true.\
 :VALUE -> Value of the rule. Rues with higher values will be considered be-\
           fore rules with lower values. Default is 0.\

 Clause form : (slot frob value) where slot is a variable, a method or a spe-\
 cial clause like EVAL, EVALP, KNOWN, NOT and BIND. {Manual p. 37ff}")

(setf (documentation 'INSTALL-RULE 'function)
  "Function is called by DEF-RULE.")

(setf (documentation 'KILL-RULE 'function)
  "Undefines the rule named RULE-NAME from the rule-system.")

(setf (documentation 'KILL-RULE 'function)
  "User interface for returning the value of the rule named RULENAME.")

(setf (documentation 'ATOMIC 'function)
  "Used in the-rules.l; but no comment was given.")

(setf (documentation 'CHANGE-RULE-VALUE 'function)
  "User interface for changing the VALUE of the rule named RULENAME.")

(setf (documentation 'BREADTH-FIRST 'function)
  "Used in SET-CONFLICT-RESOLUTION-STRATEGY to determine the way conflict re-\
 solution works.")

(setf (documentation 'PAR-BREADTH-FIRST 'function)
  "Used in SET-CONFLICT-RESOLUTION-STRATEGY to determine the way conflict re-\
 solution works.")

(setf (documentation 'DEPTH-FIRST 'function)
  "Used in SET-CONFLICT-RESOLUTION-STRATEGY to determine the way conflict re-\
 solution works.")

(setf (documentation 'PAR-DEPTH-FIRST 'function)
  "Used in SET-CONFLICT-RESOLUTION-STRATEGY to determine the way conflict re-\
 solution works.")

;;; Function concerning daemons

(setf (documentation 'DEFINE-INIT-DAEMON 'function)
  "Defines the class INIT-DAEMON. [Called automatically]")

(setf (documentation 'DEFINE-DAEMON 'function)
  "Defines a daemon over CLASS. The daemon will have the name NAME and will be\
 activated by changes to the slot(s) contained in SLOT. SLOT must be a list of\
 slots or a single slot name. The daemon will fire at one of the following \
 times :\

 :BEFORE-ASK    -> run before a value is asked for, $value bound to NIL\
 :AFTER-ASK     -> run after a value is asked for, $value bound to the value\
                   returned by ASK\
 :BEFORE-ASSERT -> run before value assertion, $value bond to value about to\
                   be asserted\
 :AFTER-ASSERT  -> run after value assertion, $value bound to asserted value\
 :BEFORE-REMOVE -> run before removing value, $value bound to value about to\
                   be removed\
 :AFTER-REMOVE  -> run after removing value, $value bound to removed value.")


(setf (documentation '%%INIT-DAEMON 'function)
"No doc. [Called automatically]")

(setf (documentation 'SET-%%INIT-DAEMON 'function)
"No doc. [Called automatically]")

(setf (documentation 'SET-BEFORE-ASK 'function)
"No doc. [Called automatically]")

(setf (documentation 'SET-BEFORE-ASSERT 'function)
"No doc. [Called automatically]")

(setf (documentation 'SET-BEFORE-REMOVE 'function)
"No doc. [Called automatically]")

(setf (documentation 'BEFORE-ASK 'function)
  "Used in DEFINE-DAEMON to determine the type of the daemon.")

(setf (documentation 'BEFORE-REMOVE 'function)
  "Used in DEFINE-DAEMON to determine the type of the daemon.")

(setf (documentation 'BEFORE-ASSERT 'function)
  "Used in DEFINE-DAEMON to determine the type of the daemon.")

(setf (documentation 'AFTER-ASK 'function)
  "Used in DEFINE-DAEMON to determine the type of the daemon.")

(setf (documentation 'AFTER-REMOVE 'function)
  "Used in DEFINE-DAEMON to determine the type of the daemon.")

(setf (documentation 'AFTER-ASSERT 'function)
  "Used in DEFINE-DAEMON to determine the type of the daemon.")

(setf (documentation 'REMOVE-DAEMON 'function)
  "Removes all the daemon associated with by SLOT and TIME, defined over \
 CLASS-FROB.")
