// select.cc

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// All the common code for selections of a gp

// Version 0.40 27 February 1994 apf
// Version 0.30 October 1993 apf

// RECENT IMPROVEMENTS

// Select is now simply real best and random selection every other selection
// is made throught SelectParents and SelectBestAndWorst, which can use different
// methods depending which module you link in...


#include "gpmain.hpp"
// for random number generator
#include "gprand.hpp"


// MAIN CODE

// Select a random member of the family....................................
// Version 0.40 simple random select function as the population is now in consecutive blocks
GP* Population::Select()
{
// select random member in range 0 -> population size
	int randgp = gp_rand() % PopulationSize;

// select this member .. simlified as population is concurrent in memory
	return (pgpHeader + randgp);
}

// Returns the best of the generation for this family. The actual best not
//   a value of some weird probability............       APF 16/06/93
// Also this function searches for the shortest best GP rather than just
// stopping at the first value it founds....
// taken out error found by Nils L...... (??) of allocating to a ptr not yet created
// a really stupid embarassing mistake really...........
GP* Population::Best()
{
	GP *pgp = pgpHeader, *pgpBest = pgpHeader;
	unsigned int pop = PopulationSize;
	unsigned int iBest = 0;

// loop through the population
	while ( pop-- )
	{
// if this fitness is greater from best so far.....
		if ( pgp->iFitness >= iBest )
		{

// this next component searches for shorter gps (my form of editing..APF )
// if the two fitnesses are equal then.
			if ( pgp->iFitness == iBest )
      {
// if this is shorter then the best so far  let them swap....................
				if ( pgp->iLength < pgpBest->iLength )  pgpBest = pgp;
			}
// else swap as the new one must be better...................................
			else
			{
				pgpBest = pgp;
				iBest = pgp->iFitness;
			}
		}
// move to next GP...........................................................
		pgp++;
	}
// return the best value and hopefully shortest value......................
	return pgpBest;
}


// Returns actual worst value in the pot. You will probably find that you
// have a lot of gps with a zero value so it chooses the first of these.
//  This function actually isn't used within the code as it stands and is
// only coded up because of hearing a seminar by Dave Cliff (of Sussex University)
//  who in discussing general GA research noted that no data was give on worst
//  members in the population hence this function...
GP* Population::Worst()
{
	GP *pgp = pgpHeader, *pgpWorst = pgpHeader;
	unsigned int pop = PopulationSize;
	unsigned int iWorst = MaximumFitness;

	while ( pop-- )
	{
		if ( pgp->iFitness < iWorst )
		{
			pgpWorst = pgp;
			iWorst = pgp->iFitness;
		}
		pgp++;
	}
	return pgpWorst;
}

// select.cc
