// population.hpp

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Population class definitions -> defined in pop.cc

#ifndef __POP

#define __POP

#include "gpv.hpp"

class Population : public GPVariables
{
	GP *pgpHeader;
	unsigned long uliFitness,                 // fitness of total pop
		      uliLength,                  // total length of pop
		      uliDepth;                   // total depth not used

	friend ostream& operator << ( ostream&, Population* );

public:

	Population( int = 500, int = 51 );                      // defined in pop.cpp
	~Population();
	unsigned long TotalFitness();
	unsigned long TotalLength();
	unsigned long TotalDepth();
	unsigned int Compare( GP * );                      // defined in compare.cc
	void Evaluate();                                                                                                        // defined in eval.cc
	GP* Best();                               // defined in select.cc
	GP* Worst();
	GP* Select();
// Should be defined in your code.....
	GP* SelectBest();
	GP* SelectWorst();
// These can be defined if selection method needs to know previous values
// ie for deme.cc....................
	GP* SelectBest( GP* );
	GP* SelectWorst( GP* );
// This must be defined in selection mechanism as generate.cc uses it though
// it probably calls above functions (see tourn.cc for example)
	GP** SelectParentsAndChild();
	void Generate();                         // defined in generate.cc
	void Mutate();                                                                                                          // defined in mutate.cc
};

#endif
