// mower.hpp

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


#ifndef __MOWER

#define __MOWER


// because I am an OOP man at heart I always reuse my code
// so the mower is a robot as I work in a robotics lab....
typedef struct r_type
{
	unsigned char x,y,Moving;
	signed int Energy;
}Robot;

// The return types in this problem are all vectors (i,j)
typedef struct v_type
{
	unsigned char i,j;
}Vector;

// function procedures..........
extern Vector V8A( Gene *pg );
extern Vector FROG( Gene *pg );
extern Vector PROG2( Gene *pg );

// terminal procedures......
extern Vector MOW();
extern Vector LEFT();

// globals
extern Robot Mower;

#endif

// mower.hpp
