// gpmain.ccc
// By Adam Fraser  16/11/93

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// This block is basically to interpret what population and generation
// size the user asked for on the command line and send these to the
// genetic programming system

#include "gene.hpp" // for exitsystem() and cout def'ns

extern void RunGPS( int, int, char* );

void ErrorPrint( void );
unsigned int str2int( char* );


/* here we go the main bit of code */
main( int argv, char **argc )
{
// if you haven't sent the correct number of inputs print out an error and quit...
	if ( (argv <= 1) || ( argv > 4 ) )
	{
		ErrorPrint();
		ExitSystem( "" );
	}
// else send the values to gpcpp system
	else    RunGPS( str2int( argc[1] ), str2int( argc[2] ), argc[3] );

	return 0;
}


void ErrorPrint( void )
{
 cout << endl;
 cout << "Format is:  gp <PopulationSize> <Number of Generations> <Output File>";
 cout << endl << "Example: gp 500 51" << endl;;
}

// returns the numerical value of a numerical string ie '1000' = 1000
// a bit of homespun rather than including (big??!!??) libraries...
unsigned int str2int( char *str )
{
// len = length of string
	unsigned int i, len = 0, sum = 0, mult = 1;
	char *strtemp = str;

// calculate the length of a string I know I could have used strlen but why include
// another (probably badly granularised) library when it is so easy....
  while ( *strtemp++ != '\0' ) len++;

// work out the largest multiplier and then decrease in next block.....
  for ( i = 0; i < (len-1); i++ ) mult *= 10;

// addup each number value of string
	for ( i = len; i > 0; i-- )
	{
		 sum += ( *str++ - '0') * mult;
		 mult /= 10;
	}

	return (unsigned int)sum;
}

/* gpmain.cc */
