// compare.cc --> compare two gps and return 1 if same, 0 if not

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


// Used to guarantee 100% diversity in population in the beginning of a run

// include pop def'ns ( and also gpv, gp, gene )
#include "pop.hpp"

// RECENT IMPROVEMENTS

// Automatically defined functions as usual....


// MAIN CODE


// Compares each member of the population with a gp up to that member
// of the population.....
unsigned int Population::Compare( GP *pgp )
{
	GP *pgpThis = pgpHeader;

// loop while the pgpThis is not the gp we have just created
	while ( pgpThis != pgp )    

// compare two gps together and return 1 if the same if not continue in loop
		if ( pgpThis++->Compare( pgp ) != 0 ) return 1;
		
	

// if we get to here then all gps must be different and we still have 100%
// diversity in the population
	return 0;
}

// compare two gps together returning a 1 if they are the same
unsigned int GP::Compare( GP *pgp )
{
// if both genetic programs exist then.....
	if ( ( this ) && ( pgp->ppgHeader ) )

	{
// ...check lengths of genetic programs if different immediately return a 0
		if ( iLength != pgp->iLength ) return 0;
		else
		{
// ...else set up starting points for each gp
			Gene **ppg = ppgHeader;
			Gene **ppgCompare = pgp->ppgHeader;   // I dislike ADF's they are hard to code

// loop through all adf trees comparing using Gene::Compare 
// presume that the genetic program is the same by sending a 1
// if a zero returned they are different
			for ( unsigned int i = 0; i < RootandADF; i++, ppg++, ppgCompare++ )
				if ( *ppg )
					{ if (!( (*ppg)->Compare( *ppgCompare, 1)) ) return 0; }
    }
	}
// if we have reached this point then gps must be the same and we should return a 1
	return 1;
}

// comparison of a genetic tree:   initially same = 1
// returns a 0 if different 1 if the same...
unsigned int Gene::Compare( Gene *pg, unsigned int same )
{
// if we have already worked out they're different they will still be different
	if ( same == 0 ) return 0;

// are the values different if they are return 0;
	if ( iValue != pg->iValue )  return 0;

// do you have children.....
	if ( pgChild )
	{
// .. = yes does the other if yes compare if no well they are different return 0
		if ( pg->pgChild ) same = ( pgChild->Compare( pg->pgChild, same ) );
		else               return 0;
	}
// .. = no does the other if yes then different return 0
	else
		if ( pg->pgChild ) return 0;

// do you have next member....
	if ( pgNext )
	{
// .. = yes does the other if yes compare if no well they are different return 0
		if ( pg->pgNext )  same = ( pgNext->Compare( pg->pgNext, same ) );
		else               return 0;
	}
// .. = no does the other if yes then different return 0
	else
		if ( pg->pgNext )  return 0;

// return what we have in same by now
	return same;
}

// compare.cc
